/*
 * KON2 - Kanji ON Console -
 * Copyright (C) 1992-1996 Takashi MANABE (manabe@papilio.tutics.tut.ac.jp)
 *
 * CCE - Console Chinese Environment -
 * Copyright (C) 1998-1999 Rui He (herui@cs.duke.edu)
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE TERRENCE R. LAMBERT BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * 
 */

/* vc -- high-level console driver */

#ifndef VC_H
#define VC_H

#include <vt.h>

#define	ATTR_ULINE	0x80	/* under line */
#define	ATTR_REVERSE	0x40	/* reverse */
#define	ATTR_HIGH	0x20	/* high */

#define	LATCH_S		0x0 /* single byte char */
#define	LATCH_1		0x20 /* double byte char 1st byte */
#define	LATCH_2		0x40 /* double byte char 2nd byte */

#define	CLEAN_S		0x80
#define	CODEIS_1	LATCH_1
#define	CODEIS_2	LATCH_2
#define	LANG_CODE	0x0F
/*
#define	LANG_DCODE	LANG_CODE|CODEIS_1
#define	LANG_SCODE	LANG_CODE
*/

extern void	ConsoleInit();
extern void	ConsoleStart(void);
extern void	ConsoleCleanup();

extern void	TextClearAll(ConInfo *con);
extern void	TextClearEol(ConInfo *con,u_char);
extern void	TextClearEos(ConInfo *con,u_char);

extern void     TextClearChars(ConInfo * con, int len); // Added by Holly Lee

extern void	TextDeleteChar(ConInfo *con,int);
extern void	TextInsertChar(ConInfo *con,int);
extern void	TextMoveDown(ConInfo *con,int top, int btm, int line);
extern void	TextMoveUp(ConInfo *con,int top, int btm, int line);
extern void	TextMode(void);
extern void	GraphMode(void);
extern void	ScrollUp(ConInfo *con,int);
extern void	ScrollDown(ConInfo *con,int);
extern void	TextWput(ConInfo *con,u_char ch1, u_char ch2);
extern void 	TextWput1(ConInfo *con,u_char ch);
extern void	TextWput2(ConInfo *con,u_char ch);
extern void	TextSput(ConInfo *con,u_char ch);
extern void	TextReverse(ConInfo *con,int fx, int fy, int tx, int ty);
extern void	TextRefresh(ConInfo *con);
extern void	TextCopy(ConInfo *con,int fx, int fy, int tx, int ty);
extern void	TextPaste(ConInfo *con);
extern void	PollCursor(bool wakeup); 
        /* Called to wakeup, or every 0.1 sec when idle */
extern void	Beep(void);

extern int 	isPrevW1(ConInfo *con);
extern int 	isPrevW2(ConInfo *con);
extern int	isNextW2(ConInfo *con);

typedef struct _CursorInfo 
{
    short kanji;
    u_int addr;
    bool sw;
    int	interval;	
    int	count;	
    bool shown;
}CursorInfo;

/* video driver interface */
typedef struct _VideoInfo 
{
  //  bool has_hard_scroll;
    void
	(*init)(void),
	(*start)(void),
        (*text_mode)(void),
        (*graph_mode)(void),
        (*wput)(u_char *code, u_char fc, u_char bc),
        (*input_wput)(int x,u_char ch1,u_char ch2,int fg,int bg),
        (*sput)(u_char *code, u_char fc, u_char bc),
 	(*input_sput)(int x,u_char ch,int fg,int bg),
        (*set_cursor_address)(CursorInfo *c, u_int x, u_int y),
        (*set_address)(u_int i),
	(*set_input_address)(u_int p),
        (*cursor)(CursorInfo *),
        (*clear_all)(int color),
	(*clear_input)(int color),
        (*screen_saver)(bool),
        (*detach)(void); //,
        /*
        (*set_start_address)(void),
        (*hard_scroll_up)(int line,int color),
        (*hard_scroll_down)(int line,int color),
 	(*reset_hard_scroll)(void);
        */
}VideoInfo;

typedef struct _DispInfo 
{
    int
        tsize,    // tlineByte * tymax , only text area 
	gsize,    // gydim * glineByte, text and input area
	gxdim,   //640, 800, 1024
	gydim,   //480, 600, 768
	txmax,   // 80
	tymax,   // 25

        tx_avail,
        ty_avail, 

        linegap,  // 2 the gap between lines
        input, // 30, the input area height, from bottom of the screen 

        bpp,  /* bits per pixel */

	glineChar,  // 18
	glineByte,  // line_length 	
	tlineByte;  // glineChar * glineByte

}DispInfo;

extern DispInfo		dispInfo;
extern CursorInfo	cursorInfo;
extern VideoInfo	*pVideoInfo;

#endif
