C******************************************************************
      SUBROUTINE O8HT(ID,INCR,IS1,IS2,M,A,BETA,B,C)
C     APPLICATION OF HOUSEHOLDER TRANSFORMATIONS STORED
C     IN THE LOWER OR STRICT LOWER (IF INCR=0 OR 1 RESP.)
C     TRIANGLE OF A AND IN THE VECTOR BETA ON B GIVING C.
C     ONLY COLUMNS IS1 TO IS2 ARE USED IN FORWARD MANNER
C     IF ID > 0,BACKWARDS OTHERWISE.
C     ROWS IS1 TO M OF C ARE CHANGED ONLY
      IMPLICIT NONE
      DOUBLE PRECISION A,BETA,B,C,SUM,O8SC3
      INTEGER ID,INCR,IS1,IS2,M,I,J,K,IT
      INCLUDE 'O8PARA.INC'
      INCLUDE 'O8CONS.INC'
      DIMENSION A(NX,*),BETA(*),B(*),C(*)
      SAVE
      DO  I=1,M
        C(I)=B(I)
      ENDDO
      IF(IS1 .GT. M)       RETURN
      IF(IS2 .LT. IS1)      RETURN
      DO    I=IS1,IS2
        IT=I
        IF(ID .LT. 0)         IT=IS2-IT+IS1
C       IT=INDEX OF TRANSFORMATION
        J=IT+INCR
        SUM=BETA(IT)*O8SC3(J,M,IT,A,NX,C)
        DO  K=J,M
          C(K)=C(K)-SUM*A(K,IT)
        ENDDO
      ENDDO
      RETURN
      END
