# this program creates a multiplication table, then reads pairs of numbers
# from its standard input (until it receives a zero) and output the product of
# each pair. The loops make use of computed COME FROM in some interesting way.

use Language::INTERCAL;
use Language::INTERCAL::Runtime::Library;

my @range = (0..99);

print "1..", 6 * (2 + @range), "\n";

my %range = map { ($_, 1 + int(rand 65535)) } @range;
my @data = map { (1 + ($_ % 10), 1 + int($_ / 10), $range{$_}) } @range;
push @data, 0;

for (my $i = 0; $i < 10000; $i++) {
    my $a = rand(scalar @range);
    my $b = rand(scalar @range);
    @range[$a, $b] = @range[$b, $a];
}
push @data, map { (1 + ($_ % 10), 1 + int($_ / 10)) } @range;
push @data, 0;
@range = map { $range{$_} } @range;

my @stdin;
my @stdout;

my $prog = '
@@@@@^@L`@{@@{
@@@@@@@M]
@@@@@@@K
@@@@@K@L`@K@@{
@@@@@K@L`@K@@{
@@@@@K@L`@K@@{
@@@@@K@L`@K@@{
M]@@z@L`@K@J@{
M]@@@@
@@@@@@@z
@@@@@@@K
@@@@@@@z
M]@@^@@K@K@L`@z
@@@@@@@M]
@@@@@@@M]
@@@@@@@K
@@@@@K@L`@K@@{
@@@@@K@L`@K@@{
@@@@@K@L`@K@@{
@@@@@K@L`@K@@{
@@@@@z@L`@K@J@{
@@@@@K@L`@z@@{
M]@@z@L`@K@J@{
M]@@@@
@@@@@@@z
@@@@@z@L`@{
@@@@@@@K
@@@@@z@L`@^@@K@K
M]@@@@z
@@@@@@@M]
@@@@@@
';

fiddle Language::INTERCAL 'bug=0', 'ubug=0';

my $testnum = 1;
my $count;

compile Language::INTERCAL 'prog', $prog;
@stdin = @data;
@stdout = ();
eval { prog(\&stdin, \@stdout) };
print STDERR $@;
print $@ ? "not " : "", "ok ", $testnum++, "\n";
print @stdout == @range ? "" : "not ", "ok ", $testnum++, "\n";
@stdin = @range;
while (@stdout && @stdin) {
    my $out = shift @stdout;
    my $in = shift @stdin;
    print $out eq roman($in, 0) . "\n" ? '' : 'not ', "ok ", $testnum++, "\n";
}
while (@stdin) {
    shift @stdin;
    print "not ok ", $testnum++, "\n";
}

compile Language::INTERCAL 'prog_o', $prog, 'opt';
@stdin = @data;
@stdout = ();
eval { prog_o(\&stdin, \@stdout) };
print STDERR $@;
print $@ ? "not " : "", "ok ", $testnum++, "\n";
print @stdout == @range ? "" : "not ", "ok ", $testnum++, "\n";
@stdin = @range;
while (@stdout && @stdin) {
    my $out = shift @stdout;
    my $in = shift @stdin;
    print $out eq roman($in, 0) . "\n" ? '' : 'not ', "ok ", $testnum++, "\n";
}
while (@stdin) {
    shift @stdin;
    print "not ok ", $testnum++, "\n";
}

compile Language::INTERCAL 'prog_q', $prog, 'quantum';
@stdin = @data;
@stdout = ();
eval { prog_q(\&stdin, \@stdout) };
print STDERR $@;
print $@ ? "not " : "", "ok ", $testnum++, "\n";
print @stdout == @range ? "" : "not ", "ok ", $testnum++, "\n";
@stdin = @range;
while (@stdout && @stdin) {
    my $out = shift @stdout;
    my $in = shift @stdin;
    print $out eq roman($in, 0) . "\n" ? '' : 'not ', "ok ", $testnum++, "\n";
}
while (@stdin) {
    shift @stdin;
    print "not ok ", $testnum++, "\n";
}

compile Language::INTERCAL 'prog_p', $prog, 'post';
@stdin = @data;
@stdout = ();
eval { prog_p(\&stdin, \@stdout) };
print STDERR $@;
print $@ ? "not " : "", "ok ", $testnum++, "\n";
print @stdout == @range ? "" : "not ", "ok ", $testnum++, "\n";
@stdin = @range;
while (@stdout && @stdin) {
    my $out = shift @stdout;
    my $in = shift @stdin;
    print $out eq roman($in, 0) . "\n" ? '' : 'not ', "ok ", $testnum++, "\n";
}
while (@stdin) {
    shift @stdin;
    print "not ok ", $testnum++, "\n";
}

compile Language::INTERCAL 'prog_qp', $prog, 'quantum', 'post';
@stdin = @data;
@stdout = ();
eval { prog_qp(\&stdin, \@stdout) };
print STDERR $@;
print $@ ? "not " : "", "ok ", $testnum++, "\n";
print @stdout == @range ? "" : "not ", "ok ", $testnum++, "\n";
@stdin = @range;
while (@stdout && @stdin) {
    my $out = shift @stdout;
    my $in = shift @stdin;
    print $out eq roman($in, 0) . "\n" ? '' : 'not ', "ok ", $testnum++, "\n";
}
while (@stdin) {
    shift @stdin;
    print "not ok ", $testnum++, "\n";
}

compile Language::INTERCAL 'prog_d', $prog, 'dbhook';
@stdin = @data;
@stdout = ();
_run_db(prog_d(\&stdin, \@stdout));
print STDERR $@;
print $@ ? "not " : "", "ok ", $testnum++, "\n";
print @stdout == @range ? "" : "not ", "ok ", $testnum++, "\n";
@stdin = @range;
while (@stdout && @stdin) {
    my $out = shift @stdout;
    my $in = shift @stdin;
    print $out eq roman($in, 0) . "\n" ? '' : 'not ', "ok ", $testnum++, "\n";
}
while (@stdin) {
    shift @stdin;
    print "not ok ", $testnum++, "\n";
}

sub stdin {
    join('@', map { ['',
		     '',
		     '',
		     '',
		     '',
		     '',
		     '',
		     '',
		     '',
		     '' ]->[$_] } split(/ *?/, shift @stdin));
}

