use Language::INTERCAL;
use Language::INTERCAL::Runtime::Library;

my $prog = '
	@@{@@M]@@@|
	@@{@@M]@@@|
	@@{@@M]@@@|
	@@{@@M]@@@|
	@K@L`@{
	@K@L`@{
	@@K@@@{@N@{
	@@K@@@{@N@{
	@K@@{
	@K@@{
	@K@@{
	@K@@{
	@@
M]	@@|@@|
M]	@@|@@|
	@@@M]
	@@@[[|@
	@@|@@[|
	@@
M]	@z@L`@[|@J@{
	@@@z
	@@
M]	@z@L`@[|@J@{
	@@@z
	@@
';

print "1..36\n";

fiddle Language::INTERCAL 'bug=0', 'ubug=0';

my @foo;

compile Language::INTERCAL 'prog', $prog;
@foo= ();
eval { prog(0, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 1\n";
print @foo == 4 ? "" : "not ", "ok 2\n";
print "II\n" eq (shift @foo) ? "" : "not ", "ok 3\n";
print "VIII\n" eq (shift @foo) ? "" : "not ", "ok 4\n";
print "V\n" eq (shift @foo) ? "" : "not ", "ok 5\n";
print "XXXV\n" eq (shift @foo) ? "" : "not ", "ok 6\n";

compile Language::INTERCAL 'prog_o', $prog, 'opt';
@foo= ();
eval { prog_o(0, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 7\n";
print @foo == 4 ? "" : "not ", "ok 8\n";
print "II\n" eq (shift @foo) ? "" : "not ", "ok 9\n";
print "VIII\n" eq (shift @foo) ? "" : "not ", "ok 10\n";
print "V\n" eq (shift @foo) ? "" : "not ", "ok 11\n";
print "XXXV\n" eq (shift @foo) ? "" : "not ", "ok 12\n";

compile Language::INTERCAL 'prog_q', $prog, 'quantum';
@foo= ();
eval { prog_q(0, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 13\n";
print @foo == 4 ? "" : "not ", "ok 14\n";
print "II\n" eq (shift @foo) ? "" : "not ", "ok 15\n";
print "VIII\n" eq (shift @foo) ? "" : "not ", "ok 16\n";
print "V\n" eq (shift @foo) ? "" : "not ", "ok 17\n";
print "XXXV\n" eq (shift @foo) ? "" : "not ", "ok 18\n";

compile Language::INTERCAL 'prog_p', $prog, 'post';
@foo= ();
eval { prog_p(0, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 19\n";
print @foo == 4 ? "" : "not ", "ok 20\n";
print "II\n" eq (shift @foo) ? "" : "not ", "ok 21\n";
print "VIII\n" eq (shift @foo) ? "" : "not ", "ok 22\n";
print "V\n" eq (shift @foo) ? "" : "not ", "ok 23\n";
print "XXXV\n" eq (shift @foo) ? "" : "not ", "ok 24\n";

compile Language::INTERCAL 'prog_qp', $prog, 'quantum', 'post';
@foo= ();
eval { prog_qp(0, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 25\n";
print @foo == 4 ? "" : "not ", "ok 26\n";
print "II\n" eq (shift @foo) ? "" : "not ", "ok 27\n";
print "VIII\n" eq (shift @foo) ? "" : "not ", "ok 28\n";
print "V\n" eq (shift @foo) ? "" : "not ", "ok 29\n";
print "XXXV\n" eq (shift @foo) ? "" : "not ", "ok 30\n";

compile Language::INTERCAL 'prog_d', $prog, 'dbhook';
@foo= ();
_run_db(prog_d(0, \&foo));
print STDERR $@;
print $@ ? "not " : "", "ok 31\n";
print @foo == 4 ? "" : "not ", "ok 32\n";
print "II\n" eq (shift @foo) ? "" : "not ", "ok 33\n";
print "VIII\n" eq (shift @foo) ? "" : "not ", "ok 34\n";
print "V\n" eq (shift @foo) ? "" : "not ", "ok 35\n";
print "XXXV\n" eq (shift @foo) ? "" : "not ", "ok 36\n";

sub foo {
    push @foo, join('', @_);
}

