use Language::INTERCAL;
use Language::INTERCAL::Runtime::Library;

my $prog = '
@@@@@@@@@{@@M]@@@|
@@@@@@@@@{@@M]@@@|
@@@@@@@@@{@@M]@@@|
@@@@@@@@@{@@M]@@@|
@@@@@@@@K@L`@{
@@@@@@@@@K@@@{@N@{
@@@@@@@@@K@@@{@N@{
@@@@@@@@K@@{
@@@@@@@@K@@{
@@@@@@@@K@@{
@@@@@@@@K@
@@@@@@@@@K@@@{@N@{
@@@@@@@@K@@{
@@@@@@@@K@@{
@@@@@@@@@
M]@@@@[|
@@@@@@@@@
M]@@z@L`@[|@J@{
@@@@@@@@@@z
@@@@@@@@@
M]@@z@L`@[|@J@{
@@@@@@@@@@z
@@@@@@@@@
M]@@z@L`@[|@J@{
@@@@@@@@@@z
@@@@@@@@@
';

print "1..42\n";

fiddle Language::INTERCAL 'bug=0', 'ubug=0';

my @foo;

compile Language::INTERCAL 'prog', $prog;
@foo= ();
eval { prog(0, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 1\n";
print @foo == 5 ? "" : "not ", "ok 2\n";
print "II\n" eq (shift @foo) ? "" : "not ", "ok 3\n";
print "VIII\n" eq (shift @foo) ? "" : "not ", "ok 4\n";
print "IX\n" eq (shift @foo) ? "" : "not ", "ok 5\n";
print "XII\n" eq (shift @foo) ? "" : "not ", "ok 6\n";
print "IX\n" eq (shift @foo) ? "" : "not ", "ok 7\n";

compile Language::INTERCAL 'prog_o', $prog, 'opt';
@foo= ();
eval { prog_o(0, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 8\n";
print @foo == 5 ? "" : "not ", "ok 9\n";
print "II\n" eq (shift @foo) ? "" : "not ", "ok 10\n";
print "VIII\n" eq (shift @foo) ? "" : "not ", "ok 11\n";
print "IX\n" eq (shift @foo) ? "" : "not ", "ok 12\n";
print "XII\n" eq (shift @foo) ? "" : "not ", "ok 13\n";
print "IX\n" eq (shift @foo) ? "" : "not ", "ok 14\n";

compile Language::INTERCAL 'prog_q', $prog, 'quantum';
@foo= ();
eval { prog_q(0, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 15\n";
print @foo == 5 ? "" : "not ", "ok 16\n";
print "II\n" eq (shift @foo) ? "" : "not ", "ok 17\n";
print "VIII\n" eq (shift @foo) ? "" : "not ", "ok 18\n";
print "IX\n" eq (shift @foo) ? "" : "not ", "ok 19\n";
print "XII\n" eq (shift @foo) ? "" : "not ", "ok 20\n";
print "IX\n" eq (shift @foo) ? "" : "not ", "ok 21\n";

compile Language::INTERCAL 'prog_p', $prog, 'post';
@foo= ();
eval { prog_p(0, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 22\n";
print @foo == 5 ? "" : "not ", "ok 23\n";
print "II\n" eq (shift @foo) ? "" : "not ", "ok 24\n";
print "VIII\n" eq (shift @foo) ? "" : "not ", "ok 25\n";
print "IX\n" eq (shift @foo) ? "" : "not ", "ok 26\n";
print "XII\n" eq (shift @foo) ? "" : "not ", "ok 27\n";
print "IX\n" eq (shift @foo) ? "" : "not ", "ok 28\n";

compile Language::INTERCAL 'prog_qp', $prog, 'quantum', 'post';
@foo= ();
eval { prog_qp(0, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 29\n";
print @foo == 5 ? "" : "not ", "ok 30\n";
print "II\n" eq (shift @foo) ? "" : "not ", "ok 31\n";
print "VIII\n" eq (shift @foo) ? "" : "not ", "ok 32\n";
print "IX\n" eq (shift @foo) ? "" : "not ", "ok 33\n";
print "XII\n" eq (shift @foo) ? "" : "not ", "ok 34\n";
print "IX\n" eq (shift @foo) ? "" : "not ", "ok 35\n";

compile Language::INTERCAL 'prog_d', $prog, 'dbhook';
@foo= ();
_run_db(prog_d(0, \&foo));
print STDERR $@;
print $@ ? "not " : "", "ok 36\n";
print @foo == 5 ? "" : "not ", "ok 37\n";
print "II\n" eq (shift @foo) ? "" : "not ", "ok 38\n";
print "VIII\n" eq (shift @foo) ? "" : "not ", "ok 39\n";
print "IX\n" eq (shift @foo) ? "" : "not ", "ok 40\n";
print "XII\n" eq (shift @foo) ? "" : "not ", "ok 41\n";
print "IX\n" eq (shift @foo) ? "" : "not ", "ok 42\n";

sub foo {
    push @foo, join('', @_);
}

