#ifndef COIN_SOTEXTURESCALEQUALITYELEMENT_H
#define COIN_SOTEXTURESCALEQUALITYELEMENT_H

/**************************************************************************\
 *
 *  This file is part of the Coin 3D visualization library.
 *  Copyright (C) 1998-2004 by Systems in Motion.  All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  ("GPL") version 2 as published by the Free Software Foundation.
 *  See the file LICENSE.GPL at the root directory of this source
 *  distribution for additional information about the GNU GPL.
 *
 *  For using Coin with software that can not be combined with the GNU
 *  GPL, and for taking advantage of the additional benefits of our
 *  support services, please contact Systems in Motion about acquiring
 *  a Coin Professional Edition License.
 *
 *  See <URL:http://www.coin3d.org/> for more information.
 *
 *  Systems in Motion, Teknobyen, Abels Gate 5, 7030 Trondheim, NORWAY.
 *  <URL:http://www.sim.no/>.
 *
\**************************************************************************/

#ifndef COIN_INTERNAL
#error this is a private header file
#endif // !COIN_INTERNAL

#include <Inventor/elements/SoFloatElement.h>

/* The incorrect COIN_DLL_API tag has to stay for the 2.x branch. */

class COIN_DLL_API SoTextureScaleQualityElement : public SoFloatElement {
  typedef SoFloatElement inherited;

  SO_ELEMENT_HEADER(SoTextureScaleQualityElement);

public:
  static void initClass(void);
protected:
  virtual ~SoTextureScaleQualityElement();

public:
  virtual void init(SoState * state);
  static void set(SoState * state, SoNode * node, const float quality);
  static float get(SoState * state);
  static float getDefault(void);
};

#endif // !COIN_SOTEXTURESCALEQUALITYELEMENT_H
