/*
 * Copyright (c) 2002 Robert Collins.
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     A copy of the GNU General Public License can be found at
 *     http://www.gnu.org/
 *
 * Written by Robert Collins <robertc@hotmail.com>
 *
 */

#ifndef _FILE_H_
#define _FILE_H_

#include "FileSystemComposite.h"
#include "Path.h"
#include <string>
using namespace std;

class File : public FileSystemComposite
{
public:
  static void File::Copy (string const &source, string const& target);
  File (string const &path, bool const isASymlink = false, mode_t const &protection = mode_t());
  void visit (FileSystemVisitor &);
  Path const &path() const { return path_;}
  bool isSymlink() const {return symlink_;}
  mode_t const &mode() const { return mode_;}
private:
  Path path_;
  bool symlink_;
  mode_t mode_;
};

#endif // _FILE_H_
