// variation.h
// this file is part of Context Free
// ---------------------
// Copyright (C) 2005-2008 Mark Lentczner - markl@glyphic.com
// Copyright (C) 2005-2008 John Horigan - john@glyphic.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 
// John Horigan can be contacted at john@glyphic.com or at
// John Horigan, 1209 Villa St., Mountain View, CA 94041-1123, USA
//
// Mark Lentczner can be contacted at markl@glyphic.com or at
// Mark Lentczner, 1209 Villa St., Mountain View, CA 94041-1123, USA
//
//


#ifndef INCLUDED_VARIATION
#define INCLUDED_VARIATION

#ifdef VC6
typedef unsigned short WinTcharType;
#else
typedef wchar_t WinTcharType;
#endif

class Variation {
  public:
    static int  fromString(const char* str);
    static void toString(int var, char* str, bool lowerCase);
    static int  fromString(const WinTcharType* str);
    static void toString(int var, WinTcharType* str, bool lowerCase);

    enum Constants { maxStringLength = 9 }; // including null terminator

    static int recommendedMin();
    static int recommendedMax(int letters = 3);
      // if giving the user an up/down control, cycle between these inclusive

    static int random(int letters = 3);
      // return a random variation, in the recommended range
};

#endif // INCLUDED_VARIATION


