// Description:
//
// Copyright (C) 2001 Frank Becker
//
// This program is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free Software
// Foundation;  either version 2 of the License,  or (at your option) any  later
// version.
//
// This program is distributed in the hope that it will be useful,  but  WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details
//
#include <Constants.hpp>
#include <BaseSurface.hpp>
#include <Enemy.hpp>

void Enemy::Add( void)
{
    maze->AddElement( x>>2, y>>2, ENEMY);
    Character::Add();
}

void Enemy::Remove( void)
{
    Character::Remove();
    maze->RemoveElement( x>>2, y>>2, ENEMY);
}

//enemy either runs towards character or away from it, 
//depending on enemy power and character power.
bool Enemy::Update( int px, int py, int pPower)
{
    bool ret = false;

    int dx = abs( x - px);
    int dy = abs( y - py);

    int tx = x;
    int ty = y;

    //if character stronger than enemy, run away...
    if( pPower > power)
    {
	tx = px;
	ty = py;
	px = x;
	py = y;
    }

    if( ( x & 3) || ( dx > dy))
    {
	if( tx < px)
	{
	    if( !Move( WallRT))
	    {
		dy = dx +1;
	    }
	}
	else
	{
	    if( !Move( WallLT))
	    {
		dy = dx +1;
	    }
	}
    }

    if( ( y & 3) || ( dy >= dx))
    {
	if( ty < py)
	{
	    if( !Move( WallDN))
	    {
		if( tx < px)
		{
		    Move( WallRT);
		}
		else
		{
		    Move( WallLT);
		}
	    }
	}
	else
	{
	    if( !Move( WallUP))
	    {
		if( tx < px)
		{
		    Move( WallRT);
		}
		else
		{
		    Move( WallLT);
		}
	    }
	}
    }

    if( pPower > power)
    {
	px = tx;
	py = ty;
    }               

    dx = abs( x - px);
    dy = abs( y - py);

    if( ( dx < 3) && ( dy < 3))
    {
	ret = true;
    }

    return( ret);
}

void Enemy::Draw( void)
{
    SurfaceS()->SetPixel( x+1, y+1, ENEMYCOLOR);
    //      SurfaceS()->SetPixel( x+2, y+1, ENEMYCOLOR);
    SurfaceS()->SetPixel( x+3, y+1, ENEMYCOLOR);

    //      SurfaceS()->SetPixel( x+1, y+2, ENEMYCOLOR);
    SurfaceS()->SetPixel( x+2, y+2, ENEMYCOLOR);
    //      SurfaceS()->SetPixel( x+3, y+2, ENEMYCOLOR);

    SurfaceS()->SetPixel( x+1, y+3, ENEMYCOLOR);
    //      SurfaceS()->SetPixel( x+2, y+3, ENEMYCOLOR);
    SurfaceS()->SetPixel( x+3, y+3, ENEMYCOLOR);
}

