#################################################################
# Uncomment following lines to enable options using Dev-Cpp IDE #
#################################################################

#CXXOPT += -DIPv6RECV   # Switch to IPv6 mode
#CXXOPT += -DDEBUG=1    # Enable debug mode (debug level may be increased to have more information)
#CXXOPT += -DONOFF      # Enable OnOff traffic types
#CXXOPT += -DMULTIPORT  # Enable multiport support

########################
# Command-line options #
########################

# Enable OnOff traffic types if specified on command line.
ifdef onoff
        CXXOPT += -DONOFF
endif

# Enable multiport if specified on command line.
ifdef multiport
        CXXOPT += -DMULTIPORT
endif

# Switch to IPv6 mode if specified on command line
ifdef ipv6	
	CXXOPT += -DIPv6RECV
endif		

# Set debug level as specified on command line
ifdef debug
	CXXOPT += -DDEBUG=$(debug)
endif

##################
# Static options #
##################

CXXOPT += -DVERSION="\"$(shell cmd /c type ..\\VERSION)\""
CXXOPT += -DREVISION="\"$(shell cmd /c type ..\\REVISION)\""

export DEVDIR=$(SystemDrive)/dev-cpp
export OS = WIN32
export RM = rm -rf
export CP = cmd /c copy
export MV = cmd /c move
export SUFFIX = .exe
export CXXFLAGS = -O2 $(CXXOPT) -Wall -DWIN32 -Wno-deprecated -I$(DEVDIR)/Include/G++ -I$(DEVDIR)/Include/c++ -I$(DEVDIR)/Include/c++/mingw32 -I$(DEVDIR)/Include/c++/backward -I$(DEVDIR)/Include -L$(DEVDIR)/Lib
export LDFLAGS = $(DEVDIR)/Lib/libws2_32.a 
export BASEDIR = $(shell cmd /c cd)
export BIN = $(BASEDIR)\..\bin\\
export COMMON = $(BASEDIR)\common\\
export NRCLEAN = $(BASEDIR)\ITGSend\newran\\
export EXEC_DIR = $(BASEDIR)\..\bin\\
export RANLIB = ranlib

CXX = g++
export THOBJS = common/thread.o
export OBJS = common/ITG.o common/timestamp.o common/serial.o
SUBDIRS = ITGSend ITGRecv ITGLog ITGDec libITG ITGManager

.PHONY: $(SUBDIRS)
all: $(SUBDIRS)
	@ echo '-----------------------------------------------------------------------------------'
	@ echo 'D-ITG executables created in "bin" folder'
ifndef CXXIPV6
	@ echo 'To obtain IPv6 binaries add "ipv6=on" option to make command line'
else
	@ echo 'IPv6 mode enabled'
endif
ifndef CXXDEBUG
	@ echo 'To enable debug mode (verbosity level *) add "debug=*" option to make command line'
else
	@ echo 'Debug mode enabled (verbosity level = '$(debug)')'
endif
	@ echo 'NOTE: Changing previous options requires a "make clean" before'

ITGSend ITGRecv ITGLog ITGDec libITG: $(THOBJS) $(OBJS)
	@ (cd $@ && $(MAKE))

ITGManager: 
	@ (cd $@ && $(MAKE))

install:
	(cd ITGSend && make install) 
	(cd ITGRecv && make install) 
	(cd ITGLog && make install) 
	(cd ITGDec && make install) 
	(cd ITGManager && make install) 

uninstall:
	(cd /usr/local/bin && rm ITGSend ITGRecv ITGLog ITGDec ITGManager)

clean: 
	(cd "$(COMMON)" && $(RM) *.o) 
	(cd ITGSend && make clean) 
	(cd ITGRecv && make clean) 
	(cd ITGLog && make clean) 
	(cd ITGDec && make clean) 
	(cd libITG && make clean) 
	(cd ITGManager && make clean) 

