/*
 * $Id: gnome-pixmap-button.h,v 1.8 2000/11/28 22:39:51 syatskevich Exp $
 *
 * GNOME applet for WebDownloader for X.
 *
 * Author: Sergey N. Yatskevich <syatskevich@mail.ru>
 */

#ifndef __GNOME_PIXMAP_BUTTON_H
#define __GNOME_PIXMAP_BUTTON_H

#include <gdk/gdk.h>
#include <gtk/gtkwidget.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#include <libgnome/gnome-defs.h>

BEGIN_GNOME_DECLS

#define GNOME_TYPE_PIXMAP_BUTTON            (gnome_pixmap_button_get_type ())
#define GNOME_PIXMAP_BUTTON(obj)            (GTK_CHECK_CAST ((obj), GNOME_TYPE_PIXMAP_BUTTON, GnomePixmapButton))
#define GNOME_PIXMAP_BUTTON_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), GNOME_TYPE_PIXMAP_BUTTON, GnomePixmapButtonClass))
#define GNOME_IS_PIXMAP_BUTTON(obj)         (GTK_CHECK_TYPE ((obj), GNOME_TYPE_PIXMAP_BUTTON))
#define GNOME_IS_PIXMAP_BUTTON_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), GNOME_TYPE_PIXMAP_BUTTON))
#define GNOME_PIXMAP_BUTTON_GET_CLASS(obj)  (GTK_CHECK_GET_CLASS ((obj), GNOME_TYPE_PIXMAP_BUTTON, GnomePixmapButtonClass))

typedef struct _GnomePixmapButton GnomePixmapButton;
typedef struct _GnomePixmapButtonClass GnomePixmapButtonClass;

struct _GnomePixmapButton {
	GtkWidget widget;

	gint width;
	gint height;
	gint depth;
	gboolean tiles_enabled : 1;
	gboolean prelight_enabled : 1;

	guint in_button : 1;
	guint button_down : 1;

	gboolean   repaint : 1;
	GdkBitmap *bitmap;
	GdkPixmap *pixmap;
	GdkGC	  *gc;

	GdkPixbuf *im_up, *im_down;
	GdkPixbuf *im_up_p, *im_down_p;

	guint     num_frames;
	guint     current_frame_number;
	GdkPixbuf *im_animation;
	GdkPixbuf *im_animation_p;
};

struct _GnomePixmapButtonClass {
	GtkWidgetClass parent_class;

	void (*pressed)  (GnomePixmapButton *button);
	void (*released) (GnomePixmapButton *button);
	void (*clicked)  (GnomePixmapButton *button);
	void (*enter)    (GnomePixmapButton *button);
	void (*leave)    (GnomePixmapButton *button);
};

GtkType    gnome_pixmap_button_get_type (void);
GtkWidget *gnome_pixmap_button_new_with_size (gint width, gint height);

void       gnome_pixmap_button_set_size (GnomePixmapButton *gpb, gint width, gint height);

gboolean   gnome_pixmap_button_tiles_load_from_pixbuf (GnomePixmapButton *gpb, GdkPixbuf *im_up, GdkPixbuf *im_down);
gboolean   gnome_pixmap_button_tiles_load_from_file   (GnomePixmapButton *gpb, const gchar *file_up, const gchar *file_down);
gboolean   gnome_pixmap_button_tiles_load_from_xpm_d  (GnomePixmapButton *gpb, const gchar **xpm_up, const gchar **xpm_down);

gboolean   gnome_pixmap_button_animation_load_from_pixbuf (GnomePixmapButton *gpb, GdkPixbuf *im);
gboolean   gnome_pixmap_button_animation_load_from_file   (GnomePixmapButton *gpb, const gchar *fname);
gboolean   gnome_pixmap_button_animation_load_from_xpm_d  (GnomePixmapButton *gpb, const gchar **xpm);

void       gnome_pixmap_button_goto_frame (GnomePixmapButton *gpb, guint frame_number);

void       gnome_pixmap_button_repaint (GnomePixmapButton *gpb);

#define    gnome_pixmap_button_get_total_frames(a) \
				((GNOME_IS_PIXMAP_BUTTON (a)) ? \
					(GNOME_PIXMAP_BUTTON (a)->num_frames) : 0)

#define    gnome_pixmap_button_get_current_frame_number(a) \
				((GNOME_IS_PIXMAP_BUTTON (a)) ? \
					(GNOME_PIXMAP_BUTTON (a)->current_frame_number) : 0)

void       gnome_pixmap_button_pressed  (GnomePixmapButton *button);
void       gnome_pixmap_button_released (GnomePixmapButton *button);
void       gnome_pixmap_button_clicked  (GnomePixmapButton *button);
void       gnome_pixmap_button_enter    (GnomePixmapButton *button);
void       gnome_pixmap_button_leave    (GnomePixmapButton *button);

END_GNOME_DECLS

#endif /* __GNOME_PIXMAP_BUTTON_H__ */
