<?php
/**
 * Class to implement a search fonction 
 *
 * daCode http://www.dacode.org/
 * src/phplib/search.php3
 * $Id: search.php3,v 1.63.2.6 2002/05/15 17:27:04 jbcombes Exp $
 *
 * Depends: Config Db Utils
 *
 *@author Paul Gonin
 */
Class Search{

	/**
	 * Database abstraction layer
	 *@var object Db
	 */
	var $db;

	/**
	 * Session handling
	 *@var object Session
	 */
	var $session;

	/**
	 * Utils package
	 *@var object Utils
	 */
	var $utils;

	/**
	 * Rendering package
	 *@var object Html
	 */
	var $html;

	/**
	 * Keywords to search. 
	 *@var string . Set by go_search()
	 */
	var $keywords;

	/**
	 * Topic where to search
	 *@var string . Set by go_search()
	 */
	var $topic;

	/**
	 * Section where to search
	 *@var string . Set by go_search()
	 */
	var $section;

	/**
	 * Whether comments shall be included in search. "on" if they shall.
	 *@var string . Set by go_search()
	 */
	var $comments;

	/**
	 * Search for a post by specified author
	 *@var string . Set by go_search()
	 */
	var $author;
 
	/**
	 * Date to start the search
	 *@var string . Set by go_search()
	 */
	var $from;

	/**
	 *  Enbd of time span
	 *@var string . Set by go_search()
	 */
	var $to;

	/**
	 * Class constructor
	 */
	Function Search() {
		$this->db = LoadClass('Db');
		$this->session = LoadClass('Session');
		$this->utils = LoadClass('Utils');
		$this->html = LoadClass('Html');
	}

	/**
	 * Displays reults
	 *@param integer number of first result to display
	 *@param integer the number of the page of results
	 *@return string search results
	 *@access private
	 */
	Function display_results($pos,$step) {
		global $config;

		$content = '<center><h2>'.lecho("Search results:").
			'</h2></center><br />';

		if ( $this->db->num_rows() > 0 ) {

			$last = min($this->db->num_rows(), $step);
			for ($i=0; $i<$last; $i++) {
				$row = $this->db->fetch_array();
				$regs = $this->utils->stamp2array( $row['timestamp']);

				$id = $row['id'];
				$section = ($row['main_page'] ? "" : $row['section']);

				$content .= '<dl><dt><b><a href="'.
					$this->session->newsurls($id,$section,"",$regs[1],$regs[2],$regs[3]).
					'">'.$row['title'].'</a></b> ('.lecho("Author").': '.$row['name'].
					') @ '.$this->utils->stamp2date($row['timestamp'],"long").
					'</dt><dd>'.nl2br($row['body']).'</dd></dl>'."\n";
			}

			$content .= '<table width="100%"><tr><td align="center"'.
				' width="50%">';
			if($pos > 0) {
				$content .= '<a href="'.$config->basehref.
					'search.'.$config->php.'?keywords='.$this->keywords.
					'&amp;topic='.$this->topic.
					'&amp;section='.$this->section.
					'&amp;comments='.$this->comments.
					'&amp;author='.$this->author.
					'&amp;pos='.($pos-$step).'&amp;step='.$step.'">'.
					htmlentities("<< ").lecho("Previous results").'</a>';
			}
			$content .= '</td>';
			$content .= '<td align="center">';
			if($this->db->num_rows() > $step) {
				$content .= '<a href="'.$config->basehref.
					'search.'.$config->php.'?keywords='.$this->keywords.
					'&amp;topic='.$this->topic.
					'&amp;section='.$this->section.
					'&amp;comments='.$this->comments.
					'&amp;author='.$this->author.
					'&amp;pos='.($pos+$step).'&amp;step='.$step.'">'.
					lecho("Next results").htmlentities(">> ").'</a>';
			}
			$content .= '</td></tr>';
			$content .= '</table>';
		} else {
			$content .= lecho("Sorry, no results.");
		}

		return $this->html->simplebox($content);
	}


	/**
	 * Performs a search
	 *@return string error comment or results to display
	 *@global array $HTTP_GET_VARS
	 *@see Search::display_results()
	 *@access public
	 */
	Function go_search() {
		global $HTTP_GET_VARS;
		global $config;

		$keywords= (isset($HTTP_GET_VARS['keywords'])?
			$HTTP_GET_VARS['keywords']:"");
		$topic	 = (isset($HTTP_GET_VARS['topic'])?$HTTP_GET_VARS['topic']:"");
		$section = (isset($HTTP_GET_VARS['section'])?$HTTP_GET_VARS['section']:"");
		$comments= (isset($HTTP_GET_VARS['comments'])?
			$HTTP_GET_VARS['comments']:"");
		$author	 = (isset($HTTP_GET_VARS['author'])?$HTTP_GET_VARS['author']:"");
		$pos	 = (isset($HTTP_GET_VARS['pos'])?$HTTP_GET_VARS['pos']:"");
		$step	 = (isset($HTTP_GET_VARS['step'])?$HTTP_GET_VARS['step']:"");
		$from	 = (isset($HTTP_GET_VARS['from'])?$HTTP_GET_VARS['from']:"");
		$to		 = (isset($HTTP_GET_VARS['to'])?$HTTP_GET_VARS['to']:"");

		$interval = $config->default_search_interval;

		if (ereg('^[0-9]{8}$',$from)) {
			$from .= "000000";
		} elseif (!$from) {
			$from = date("YmdHis",mktime(0,0,0,date("m")-$interval,
				date("d"),date("Y")));
		}

		if (ereg('^[0-9]{8}$',$to)) {
			$to .= "235959";
		} elseif (!$to) {
			$to = date("YmdHis",mktime(date("H"),date("i"),
				date("s"),date("m"),date("d"),date("Y")));
		}

		$tbl_news = $config->tables['news'];           //sqlchecked: def of tables;
		$tbl_body = $config->tables['news_body'];      //sqlchecked: def of tables;
		$tbl_section = $config->tables['sections'];    //sqlchecked: def of tables;
		$tbl_author = $config->tables['news_author'];  //sqlchecked: def of tables;
		$tbl_comments = $config->tables['comments'];   //sqlchecked: def of tables;

		$this->keywords = $keywords;
		$this->topic = $topic;
		$this->section = $section;
		$this->comments = $comments;
		$this->author = $author;
		$this->from = $from;
		$this->to = $to;

		if (strlen($this->keywords) < 5) {
			return lecho("Sorry, search is too short");
		}
		if (isset($config->highload) &&
				$this->utils->loadis() >= $config->highload) {
			return lecho("Sorry, the load is too high to search something");
		}

		// Construction of request
		$sqlc_q = "SELECT DISTINCT n.id,n.title,n.timestamp,n.main_page,".
			"s.section,a.name,b.body FROM ".$tbl_news." n,".$tbl_body." b,";
		if ($comments == "on") {
			$sqlc_q .=  $tbl_comments." c,";
		}
		$sqlc_q .= $tbl_author." a,".$tbl_section." s WHERE n.state='1'";

		$datefrom = $this->db->timestamp14_to_dbms_stamp($from);
		$dateto = $this->db->timestamp14_to_dbms_stamp($to);
		$sqlc_q .= " AND n.timestamp >= '".addslashes($datefrom).
			"' AND n.timestamp <= '".addslashes($dateto)."'";

		// MySQL is case-insensitive by default
		// ( http://www.mysql.com/doc/C/a/Case_sensitivity.html )
		// PostgreSQL is case-sensitive by default
		// The case-insensitive variant of LIKE is called ILIKE in
		// PostgreSQL 7.1 and later.
		// lower() should work on both.

		if (!empty($keywords)) {
			$sqlkw = ereg_replace('%','\\%',$keywords);
			$sqlc_q .= " AND (lower(n.title) LIKE '%".addslashes($sqlkw)."%'".
				" OR lower(b.body) LIKE '%".addslashes($sqlkw)."%'";
			if ($comments == "on") {
				$sqlc_q .=  " OR lower(c.subject) LIKE '%".addslashes($sqlkw)."%'".
					" OR lower(c.body) LIKE '%".addslashes($sqlkw)."%'";
			}
			$sqlc_q .= ")";
		}
		$sqlc_q .= " AND n.id=b.id AND n.author_id=a.id";
		if ($comments == "on") {
			$sqlc_q .= " AND n.id=c.news_id ";
		}
		$sqlc_q .= " AND n.section_id=s.id";
		if ($topic > -1) {
			$sqlc_q .= " AND n.topic_id='".addslashes($topic)."'";
		}
		if ($section > -1) {
			$sqlc_q .= " AND n.section_id='".addslashes($section)."'";
		}
		if (!empty($author)) {
			$sqlc_q .= " AND lower(a.name) LIKE '%".addslashes($author)."%'";
		}
		$sqlc_q .= " ORDER BY timestamp DESC ".
			$this->db->compat_limit($pos+$step+1,$pos);
		if (!empty($keywords) || !empty($author)
				|| ($topic > -1 ) || ($section > -1) ) {
			// Submission of request
			$ret = $this->db->query($sqlc_q);
			if (!$ret) {
				return '<!-- Search: SQL Request Failed:'.$sqlc_q.' -->'."\n";
			}
			//$content .= $this->db->num_rows()." results for request ".$sqlc_q." :";

			// Display results of request
			$content = $this->display_results($pos,$step);
			return $content;
		}
	}

	/**
	 * Displays the advanced search form
	 *@return string the form
	 *@global array $HTTP_GET_VARS
	 *@access public
	 */
	Function adv_search_form() {
		global $config,$utils,$HTTP_GET_VARS;

		$content = '<!-- ADVANCED SEARCH FORM -->'."\n";

		$content .= '<form method="get" action="'.$config->basehref.
			'search.'.$config->php.'">'."\n".'<table class="searchform" '.
			'border="1" cellspacing="1" cellpadding="1" '.
			'width="75%">'."\n<tr>\n".
			'<td class="searchformheader" colspan="2">'.
			lecho("Advanced Search (case insensitive)")."</td></tr>\n".
			'<tr><td colspan="2">'."\n".'<table align="center" '.
			'border="0" cellspacing="1" cellpadding="1">'."\n".
			'<tr><td class="searchform" colspan="2">'."\n".
			'<input type="text" name="keywords" value="'.
			(isset($HTTP_GET_VARS['keywords']) ? $HTTP_GET_VARS['keywords']:"").
			'" size="50" maxlength="100" />'."\n".
			'</td></tr>'."\n".
			'<tr><td class="searchform">'."\n".
			$this->utils->make_topics_button().
			'</td><td class="searchform">'.lecho("Topic").'</td></tr>'."\n".
			'<tr><td class="searchform">'."\n".
			$this->utils->make_sections_button().'</td>'."\n".
			'<td class="searchform">'.lecho("Section").'</td></tr>'."\n".
			'<tr><td class="searchform">'.
			'<input type="checkbox" name="comments" /></td>'."\n".
			'<td class="searchform">'.lecho("Include comments").'</td>'."\n".
			'</tr></table></td></tr>'."\n".
			'<tr><td colspan="2"><table border="0" align="center"'.
			' cellspacing="1" cellpadding="1">'."\n".
			'<tr><td class="searchform">'.lecho("Author").' : </td>'."\n".
			'<td class="searchform"><input type="text" name="author"'.
			' size="40" maxlength="100" /></td></tr>'."\n".
			'</table></td>'."\n".
			'</tr>'."\n".
			'<tr><td colspan="2"><table border="0" '.
			'align="center" cellspacing="1" cellpadding="1">'."\n".
			'<tr><td class="searchform">'.lecho("From").' : <input type="text"'.
			' name="from" size="8" /></td>'."\n".
			'<td class="searchform">'.lecho("To").
			' : <input type="text" name="to"'.
			' size="8" /></td>'."\n".
			'</tr><tr><td class="searchform" colspan="2"> '.
			lecho("Dates of form").' YYYYMMDD </td>'."\n".
			'</tr></table></td></tr>'."\n".
			'<tr><td class="searchform" align="center">'.
			lecho("Results per page").' : '.
			'<input type="text" name="step" value="25" size="2" /></td>'."\n".
			'<td class="searchform" align="center">'.
			'<input type="submit" name="submit" value="'.
			lecho("Submit").'" />'."\n".
			'<input type="hidden" name="pos" value="0" />'."\n".
			'</td></tr></table></form>'."\n";

		return $content;
	}

}

?>
