#ifndef __HPP_KAV
#define __HPP_KAV

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

//  Written by Nerijus Baliunas
//  adtapted by mad@madness.at
//

#include <time.h>
#include <cerrno>
#include <syslog.h>

#ifdef __cplusplus
extern "C"
{
#include <kavclient.h>
}
#endif

#include "VirusEngine.hpp"
#include "OptionContainer.hpp"


using namespace std;


class KAVEngine:public VirusEngine
{
private:
  string virname;
  string err_str;

public:
    KAVEngine ();
    virtual ~ KAVEngine ();

  virtual int loadEngine ()
  {                             /* nothing to do here */
    return 0;
  }
  virtual int reloadEngine ()
  {                             /* nothing to do here */
    return 0;
  }
  virtual int unloadEngine ()
  {                             /* nothing to do here */
    return 0;
  }

  virtual int scanFile (const char *_fname);

  virtual const char *getVirusName ()
  {
    return virname.c_str ();
  }
  virtual const char *getErrString ()
  {
    return err_str.c_str ();
  }

  virtual void setVirusName (const char *_vname)
  {
    virname = _vname;
  }
  virtual void setErrString (const char *_err_str)
  {
    err_str = _err_str;
  }
};

#endif // __HPP_KAV
