/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Controller;
import net.sf.saxon.event.ReceivingContentHandler;
import net.sf.saxon.event.ResultWrapper;
import net.sf.saxon.om.NamePool;
import org.xml.sax.SAXException;

public class IdentityTransformerHandler
extends ReceivingContentHandler
implements TransformerHandler {
    private Result result;
    private String systemId;
    private Controller controller;

    protected IdentityTransformerHandler(Controller controller) {
        this.controller = controller;
        this.setNamePool(controller.getNamePool());
    }

    public Transformer getTransformer() {
        return this.controller;
    }

    public void setSystemId(String string) {
        this.systemId = string;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setResult(Result result) {
        if (result == null) {
            throw new IllegalArgumentException("Result must not be null");
        }
        this.result = result;
    }

    public Result getResult() {
        return this.result;
    }

    public void startDocument() throws SAXException {
        if (this.result == null) {
            this.result = new StreamResult(System.out);
        }
        try {
            NamePool namePool = this.controller.getNamePool();
            Properties properties = this.controller.getOutputProperties();
            this.setReceiver(ResultWrapper.getReceiver(this.result, this.controller.getConfiguration(), properties, null));
            this.setNamePool(namePool);
        }
        catch (TransformerException transformerException) {
            throw new SAXException(transformerException);
        }
        super.startDocument();
    }
}

