/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public abstract class FunctionCall
extends ComputedExpression {
    protected Expression[] argument;

    public final int getNumberOfArguments() {
        return this.argument.length;
    }

    public void setArguments(Expression[] expressionArray) {
        this.argument = expressionArray;
    }

    public Expression simplify() throws XPathException {
        return this.simplifyArguments();
    }

    protected final Expression simplifyArguments() throws XPathException {
        int n = 0;
        while (n < this.getNumberOfArguments()) {
            this.argument[n] = this.argument[n].simplify();
            ++n;
        }
        return this;
    }

    public Expression analyze(StaticContext staticContext) throws XPathException {
        boolean bl = true;
        int n = 0;
        while (n < this.getNumberOfArguments()) {
            this.argument[n] = this.argument[n].analyze(staticContext);
            if (!(this.argument[n] instanceof Value)) {
                bl = false;
            }
            ++n;
        }
        this.checkArguments(staticContext);
        if (bl) {
            return this.preEvaluate(staticContext);
        }
        return this;
    }

    public Expression preEvaluate(StaticContext staticContext) throws XPathException {
        return ExpressionTool.eagerEvaluate(this, null);
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        Expression expression = promotionOffer.accept(this);
        if (expression != null) {
            return expression;
        }
        if (promotionOffer.action != 13) {
            int n = 0;
            while (n < this.getNumberOfArguments()) {
                this.argument[n] = this.argument[n].promote(promotionOffer);
                ++n;
            }
        }
        return this;
    }

    protected abstract void checkArguments(StaticContext var1) throws XPathException;

    protected int checkArgumentCount(int n, int n2) throws XPathException {
        int n3 = this.getNumberOfArguments();
        if (n == n2 && n3 != n) {
            throw new XPathException.Static("Function " + this.getName() + " must have " + n + FunctionCall.pluralArguments(n), ExpressionTool.getLocator(this));
        }
        if (n3 < n) {
            throw new XPathException.Static("Function " + this.getName() + " must have at least " + n + FunctionCall.pluralArguments(n), ExpressionTool.getLocator(this));
        }
        if (n3 > n2) {
            throw new XPathException.Static("Function " + this.getName() + " must have no more than " + n2 + FunctionCall.pluralArguments(n2), ExpressionTool.getLocator(this));
        }
        return n3;
    }

    private static String pluralArguments(int n) {
        if (n == 1) {
            return " argument";
        }
        return " arguments";
    }

    public Expression[] getSubExpressions() {
        return this.argument;
    }

    public abstract String getName();

    public void display(int n, NamePool namePool) {
        System.err.println(ExpressionTool.indent(n) + "function " + this.getName());
        int n2 = 0;
        while (n2 < this.getNumberOfArguments()) {
            this.argument[n2].display(n + 1, namePool);
            ++n2;
        }
    }
}

