/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.ReversibleIterator;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LookaheadIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.xpath.XPathException;

public class RangeExpression
extends BinaryExpression {
    public RangeExpression(Expression expression, int n, Expression expression2) {
        super(expression, n, expression2);
    }

    public Expression analyze(StaticContext staticContext) throws XPathException {
        this.operands[0] = this.operands[0].analyze(staticContext);
        this.operands[1] = this.operands[1].analyze(staticContext);
        RoleLocator roleLocator = new RoleLocator(1, "to", 0);
        this.operands[0] = TypeChecker.staticTypeCheck(this.operands[0], SequenceType.OPTIONAL_INTEGER, false, roleLocator);
        RoleLocator roleLocator2 = new RoleLocator(1, "to", 1);
        this.operands[1] = TypeChecker.staticTypeCheck(this.operands[1], SequenceType.OPTIONAL_INTEGER, false, roleLocator2);
        return super.simplify();
    }

    public ItemType getItemType() {
        return Type.INTEGER_TYPE;
    }

    public int computeCardinality() {
        return 1792;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        AtomicValue atomicValue = (AtomicValue)this.operands[0].evaluateItem(xPathContext);
        if (atomicValue == null) {
            return new EmptyIterator();
        }
        NumericValue numericValue = (NumericValue)atomicValue.getPrimitiveValue();
        AtomicValue atomicValue2 = (AtomicValue)this.operands[1].evaluateItem(xPathContext);
        if (atomicValue == null) {
            return new EmptyIterator();
        }
        NumericValue numericValue2 = (NumericValue)atomicValue2.getPrimitiveValue();
        if (numericValue.compareTo(numericValue2) > 0) {
            return new EmptyIterator();
        }
        return new RangeIterator(numericValue.asLong(), numericValue2.asLong());
    }

    private static class RangeIterator
    implements SequenceIterator,
    ReversibleIterator,
    LastPositionFinder,
    LookaheadIterator {
        long start;
        long currentValue;
        int increment;
        long limit;

        public RangeIterator(long l, long l2) {
            this.start = l;
            this.increment = l <= l2 ? 1 : -1;
            this.currentValue = l;
            this.limit = l2;
        }

        public boolean hasNext() {
            if (this.increment > 0) {
                return this.currentValue <= this.limit;
            }
            return this.currentValue >= this.limit;
        }

        public Item next() {
            if (!this.hasNext()) {
                return null;
            }
            long l = this.currentValue;
            this.currentValue += (long)this.increment;
            return new IntegerValue(l);
        }

        public Item current() {
            return new IntegerValue(this.currentValue - (long)this.increment);
        }

        public int position() {
            if (this.increment > 0) {
                return (int)(this.currentValue - this.start);
            }
            return (int)(this.start - this.currentValue);
        }

        public int getLastPosition() {
            return (int)((this.limit - this.start) * (long)this.increment + 1L);
        }

        public SequenceIterator getAnother() throws XPathException {
            return new RangeIterator(this.start, this.limit);
        }

        public SequenceIterator getReverseIterator() {
            return new RangeIterator(this.limit, this.start);
        }
    }
}

