/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.Sender;
import net.sf.saxon.event.Stripper;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.XSLTFunction;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.XMLChar;
import net.sf.saxon.sort.DocumentOrderIterator;
import net.sf.saxon.sort.GlobalOrderComparer;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.xpath.XPathException;

public class Document
extends SystemFunction
implements MappingFunction,
XSLTFunction {
    private String expressionBaseURI = null;

    public void checkArguments(StaticContext staticContext) throws XPathException {
        super.checkArguments(staticContext);
        this.expressionBaseURI = staticContext.getBaseURI();
        this.argument[0] = ExpressionTool.unsorted(this.argument[0], false);
    }

    public int computeCardinality() {
        Expression expression = this.argument[0];
        if (!Cardinality.allowsMany(expression.getCardinality())) {
            return 768;
        }
        return 1792;
    }

    public int computeSpecialProperties() {
        return 655360;
    }

    public Expression preEvaluate(StaticContext staticContext) {
        return this;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        Object object;
        int n = this.getNumberOfArguments();
        SequenceIterator sequenceIterator = this.argument[0].iterate(xPathContext);
        String string = null;
        if (n == 2) {
            object = (NodeInfo)this.argument[1].evaluateItem(xPathContext);
            string = object.getBaseURI();
        }
        object = new DocumentMappingInfo();
        ((DocumentMappingInfo)object).baseURI = string;
        ((DocumentMappingInfo)object).styleSheetURI = this.expressionBaseURI;
        MappingIterator mappingIterator = new MappingIterator(sequenceIterator, this, xPathContext, object);
        Expression expression = this.argument[0];
        if (!Cardinality.allowsMany(expression.getCardinality())) {
            return mappingIterator;
        }
        return new DocumentOrderIterator(mappingIterator, GlobalOrderComparer.getInstance());
    }

    public Object map(Item item, XPathContext xPathContext, Object object) throws XPathException {
        DocumentMappingInfo documentMappingInfo = (DocumentMappingInfo)object;
        String string = documentMappingInfo.baseURI;
        if (string == null) {
            string = item instanceof NodeInfo ? ((NodeInfo)item).getBaseURI() : documentMappingInfo.styleSheetURI;
        }
        NodeInfo nodeInfo = Document.makeDoc(item.getStringValue(), string, xPathContext);
        return nodeInfo;
    }

    public static NodeInfo makeDoc(String string, String string2, XPathContext xPathContext) throws XPathException {
        Object object;
        String string3;
        int n = string.indexOf(35);
        String string4 = null;
        if (n >= 0) {
            if (n == string.length() - 1) {
                string = string.substring(0, n);
            } else {
                string4 = string.substring(n + 1);
                string = string.substring(0, n);
            }
        }
        if (string2 == null) {
            try {
                string3 = new URL(string).toString();
            }
            catch (MalformedURLException malformedURLException) {
                string3 = string2 + "/" + string;
                string2 = "";
            }
        } else {
            try {
                object = new URL(new URL(string2), string);
                string3 = ((URL)object).toString();
            }
            catch (MalformedURLException malformedURLException) {
                string3 = string2 + "/../" + string;
            }
        }
        object = xPathContext.getController();
        DocumentInfo documentInfo = ((Controller)object).getDocumentPool().find(string3);
        if (documentInfo != null) {
            return Document.getFragment(documentInfo, string4);
        }
        try {
            DocumentInfo documentInfo2;
            URIResolver uRIResolver = ((Controller)object).getURIResolver();
            Source source = uRIResolver.resolve(string, string2);
            if (source == null) {
                uRIResolver = ((Controller)object).getStandardURIResolver();
                source = uRIResolver.resolve(string, string2);
            }
            if (source instanceof NodeInfo || source instanceof DOMSource) {
                NodeInfo nodeInfo = ((Controller)object).prepareInputTree(source);
                documentInfo2 = nodeInfo.getDocumentRoot();
            } else {
                Builder builder = ((Controller)object).makeBuilder();
                Stripper stripper = ((Controller)object).makeStripper(builder);
                new Sender(((Controller)object).getConfiguration()).send(source, stripper);
                documentInfo2 = builder.getCurrentDocument();
            }
            ((Controller)object).registerDocument(documentInfo2, string3);
            return Document.getFragment(documentInfo2, string4);
        }
        catch (TransformerException transformerException) {
            try {
                ((Controller)object).recoverableError(transformerException);
            }
            catch (TransformerException transformerException2) {
                throw new XPathException.Dynamic(transformerException);
            }
            return null;
        }
    }

    private static NodeInfo getFragment(DocumentInfo documentInfo, String string) {
        if (string == null) {
            return documentInfo;
        }
        if (!XMLChar.isValidNCName(string)) {
            return documentInfo;
        }
        return documentInfo.selectID(string);
    }

    private class DocumentMappingInfo {
        public String baseURI;
        public String styleSheetURI;

        private DocumentMappingInfo() {
        }
    }
}

