/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.ParameterSet;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.instruct.Template;
import net.sf.saxon.instruct.WithParam;

public class ApplyImports
extends Instruction {
    private WithParam[] actualParams = null;
    private WithParam[] tunnelParams = null;

    public ApplyImports(WithParam[] withParamArray, WithParam[] withParamArray2) {
        this.actualParams = withParamArray;
        this.tunnelParams = withParamArray2;
    }

    public String getInstructionName() {
        return "apply-imports";
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws TransformerException {
        Controller controller = xPathContext.getController();
        ParameterSet parameterSet = Instruction.assembleParams(xPathContext, this.actualParams);
        ParameterSet parameterSet2 = Instruction.assembleTunnelParams(xPathContext, this.tunnelParams);
        Template template = xPathContext.getController().getCurrentTemplate();
        if (template == null) {
            throw new TransformerException("There is no current template rule");
        }
        int n = template.getMinImportPrecedence();
        int n2 = template.getPrecedence() - 1;
        controller.applyImports(n, n2, parameterSet, parameterSet2);
        return null;
    }
}

