/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.util.List;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.Err;
import net.sf.saxon.event.NoOpenStartTagException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.DummyNamespaceResolver;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.SimpleNodeConstructor;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.XPathException;

public final class Attribute
extends SimpleNodeConstructor {
    private Expression attributeName;
    private Expression namespace = null;
    private NamespaceResolver nsContext;
    private SimpleType schemaType;
    private int annotation;
    private int validationAction;
    private int options;

    public Attribute(Expression expression, Expression expression2, NamespaceResolver namespaceResolver, int n, SimpleType simpleType, int n2) {
        this.attributeName = expression;
        this.namespace = expression2;
        this.nsContext = namespaceResolver;
        this.schemaType = simpleType;
        this.annotation = n2;
        this.validationAction = n;
        this.options = 0;
    }

    public void setRejectDuplicates() {
        this.options |= 0x20;
    }

    public String getInstructionName() {
        return "attribute";
    }

    public ItemType getItemType() {
        return NodeKindTest.ATTRIBUTE;
    }

    public int getCardinality() {
        return 512;
    }

    public Expression simplify() throws XPathException {
        this.attributeName = this.attributeName.simplify();
        if (this.namespace != null) {
            this.namespace = this.namespace.simplify();
        }
        return super.simplify();
    }

    public void typeCheck(StaticContext staticContext) throws XPathException {
        this.attributeName = this.attributeName.analyze(staticContext);
        RoleLocator roleLocator = new RoleLocator(4, "attribute/name", 0);
        this.attributeName = this.attributeName.getItemType() == Type.QNAME_TYPE ? TypeChecker.staticTypeCheck(this.attributeName, SequenceType.SINGLE_ITEM, false, roleLocator) : TypeChecker.staticTypeCheck(this.attributeName, SequenceType.SINGLE_STRING, false, roleLocator);
        if (this.namespace != null) {
            this.namespace.analyze(staticContext);
            roleLocator = new RoleLocator(4, "attribute/namespace", 0);
            this.namespace = TypeChecker.staticTypeCheck(this.namespace, SequenceType.SINGLE_STRING, false, roleLocator);
        }
    }

    public int getDependencies() {
        int n = 0;
        n |= this.attributeName.getDependencies();
        if (this.namespace != null) {
            n |= this.namespace.getDependencies();
        }
        return n | super.getDependencies();
    }

    public void getXPathExpressions(List list) {
        list.add(this.attributeName);
        if (this.namespace != null) {
            list.add(this.namespace);
        }
        super.getXPathExpressions(list);
    }

    public void promoteInst(PromotionOffer promotionOffer) throws XPathException {
        this.attributeName = this.attributeName.promote(promotionOffer);
        if (this.namespace != null) {
            this.namespace = this.namespace.promote(promotionOffer);
        }
        super.promoteInst(promotionOffer);
    }

    /*
     * Unable to fully structure code
     */
    public TailCall processLeavingTail(XPathContext var1_1) throws TransformerException {
        var2_2 = var1_1.getController();
        var3_3 = this.evaluateNameCode(var1_1);
        if (var3_3 == -1) {
            return null;
        }
        var4_4 = var2_2.getReceiver();
        var5_5 = this.options;
        var6_6 = this.annotation;
        var7_7 = this.expandChildren(var1_1).toString();
        if (this.schemaType != null) {
            try {
                this.schemaType.validateContent(var7_7, DummyNamespaceResolver.getInstance());
                if (!this.schemaType.isNamespaceSensitive()) ** GOTO lbl21
                this.options |= 512;
            }
            catch (ValidationException var8_8) {
                throw new ValidationException("Attribute value " + Err.wrap(var7_7, 4) + " does not match the required type " + this.schemaType.getDescription() + ". " + var8_8.getMessage());
            }
        } else if (this.validationAction == 1 || this.validationAction == 2) {
            var8_9 = var2_2.getConfiguration().validateAttribute(var3_3, var7_7, this.validationAction);
            var6_6 = (int)(var8_9 & -1L);
            var5_5 |= (int)(var8_9 >> 32);
        }
lbl21:
        // 5 sources

        try {
            var4_4.attribute(var3_3, var6_6, var7_7, var5_5);
        }
        catch (NoOpenStartTagException var8_10) {
            Instruction.recoverableError(this, "Cannot write an attribute node when no element start tag is open", var2_2);
        }
        catch (TransformerException var9_11) {
            throw Instruction.dynamicError(this, var9_11, var1_1.getController());
        }
        return null;
    }

    protected int evaluateNameCode(XPathContext xPathContext) throws XPathException, TransformerException {
        String string;
        Controller controller = xPathContext.getController();
        NamePool namePool = controller.getNamePool();
        Item item = this.attributeName.evaluateItem(xPathContext);
        String string2 = null;
        String string3 = null;
        if (item instanceof StringValue) {
            string = item.getStringValue();
            try {
                String[] stringArray = Name.getQNameParts(string);
                string2 = stringArray[0];
                string3 = stringArray[1];
            }
            catch (QNameException qNameException) {
                Instruction.recoverableError(this, "Invalid attribute name: " + string, controller);
                return -1;
            }
            if (string.equals("xmlns") && this.namespace == null) {
                Instruction.recoverableError(this, "Invalid attribute name: " + string, controller);
                return -1;
            }
            if (string2.equals("xmlns")) {
                if (this.namespace == null) {
                    Instruction.recoverableError(this, "Invalid attribute name: " + string, controller);
                    return -1;
                }
                string2 = "";
            }
        } else if (this.attributeName instanceof QNameValue) {
            string3 = ((QNameValue)item).getLocalName();
            string = ((QNameValue)item).getNamespaceURI();
            this.namespace = new StringValue(string);
            if (string.equals("")) {
                string2 = "";
            } else {
                string2 = namePool.suggestPrefixForURI(string);
                if (string2 == null) {
                    string2 = "nsq0";
                }
            }
        }
        if (this.namespace == null) {
            if (string2.equals("")) {
                string = "";
            } else {
                string = this.nsContext.getURIForPrefix(string2, false);
                if (string == null) {
                    Instruction.recoverableError(this, "Undeclared prefix in attribute name: " + string2, controller);
                    return -1;
                }
            }
        } else {
            string = this.namespace.evaluateAsString(xPathContext);
            if ("".equals(string)) {
                string2 = "";
            } else if ("".equals(string2) && (string2 = namePool.suggestPrefixForURI(string)) == null) {
                string2 = "ns0";
            }
        }
        return namePool.allocate(string2, string, string3);
    }

    public void display(int n, NamePool namePool) {
        System.err.println(ExpressionTool.indent(n) + "attribute ");
        System.err.println(ExpressionTool.indent(n + 1) + "name");
        this.attributeName.display(n + 2, namePool);
        super.display(n + 1, namePool);
    }
}

