/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.SimpleNodeConstructor;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.type.ItemType;

public final class Comment
extends SimpleNodeConstructor {
    public String getInstructionName() {
        return "comment";
    }

    public ItemType getItemType() {
        return NodeKindTest.COMMENT;
    }

    public int getCardinality() {
        return 512;
    }

    public void typeCheck(StaticContext staticContext) {
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws TransformerException {
        int n;
        Controller controller = xPathContext.getController();
        String string = this.expandChildren(xPathContext).toString();
        while ((n = string.indexOf("--")) >= 0) {
            Instruction.recoverableError(this, "Invalid characters (--) in comment", controller);
            string = string.substring(0, n + 1) + " " + string.substring(n + 1);
        }
        if (string.length() > 0 && string.charAt(string.length() - 1) == '-') {
            Instruction.recoverableError(this, "Invalid character (-) at end of comment", controller);
            string = string + " ";
        }
        controller.getReceiver().comment(string, 0);
        return null;
    }

    public void display(int n, NamePool namePool) {
        System.err.println(ExpressionTool.indent(n) + "comment");
        super.display(n + 1, namePool);
    }
}

