/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.Serializable;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.ParameterSet;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.Instr;
import net.sf.saxon.instruct.SkipInstructionException;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.instruct.TerminationException;
import net.sf.saxon.instruct.WithParam;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.xpath.XPathException;

public abstract class Instruction
implements Serializable,
SourceLocator,
Instr {
    protected Instr[] children;
    private Executable executable;
    private int sourceLocation;

    public void setExecutable(Executable executable) {
        this.executable = executable;
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public void setChildren(Instr[] instrArray) {
        this.children = instrArray == null || instrArray.length == 0 ? null : instrArray;
    }

    public Instr[] getChildren() {
        return this.children;
    }

    public void setSourceLocation(int n, int n2) {
        this.sourceLocation = n << 20 | n2 & 0x7FFFF;
    }

    public String getSystemId() {
        int n = this.sourceLocation >> 20 & 0x3FF;
        if (this.executable == null) {
            return "*unknown*";
        }
        return this.executable.getSystemId(n);
    }

    public String getPublicId() {
        return null;
    }

    public int getColumnNumber() {
        return -1;
    }

    public int getLineNumber() {
        return this.sourceLocation & 0x7FFFF;
    }

    public abstract String getInstructionName();

    public String getInstructionNamespace() {
        return "http://www.w3.org/1999/XSL/Transform";
    }

    public ItemType getItemType() {
        return Type.ITEM_TYPE;
    }

    public int getCardinality() {
        return 1792;
    }

    public abstract TailCall processLeavingTail(XPathContext var1) throws TransformerException;

    public void process(XPathContext xPathContext) throws TransformerException {
        TailCall tailCall = this.processLeavingTail(xPathContext);
        while (tailCall != null) {
            tailCall = tailCall.processLeavingTail(xPathContext.getController());
        }
    }

    protected void processChildren(XPathContext xPathContext) throws TransformerException {
        if (this.children == null) {
            return;
        }
        Controller controller = xPathContext.getController();
        int n = 0;
        while (n < this.children.length) {
            try {
                this.children[n].process(xPathContext);
            }
            catch (TransformerException transformerException) {
                if (transformerException instanceof SkipInstructionException) {
                    Instruction.recoverableError(this.children[n], transformerException.getMessage(), controller);
                }
                throw Instruction.dynamicError(this.children[n], transformerException, controller);
            }
            ++n;
        }
    }

    protected TailCall processChildrenLeavingTail(XPathContext xPathContext) throws TransformerException {
        if (this.children == null) {
            return null;
        }
        Controller controller = xPathContext.getController();
        TailCall tailCall = null;
        int n = 0;
        while (n < this.children.length) {
            try {
                tailCall = this.children[n].processLeavingTail(xPathContext);
            }
            catch (TransformerException transformerException) {
                if (transformerException instanceof SkipInstructionException) {
                    Instruction.recoverableError(this.children[n], transformerException.getMessage(), controller);
                }
                throw Instruction.dynamicError(this.children[n], transformerException, controller);
            }
            ++n;
        }
        return tailCall;
    }

    public SourceLocator getSourceLocator() {
        return this;
    }

    protected static TransformerException dynamicError(Instr instr, TransformerException transformerException, Controller controller) {
        if (transformerException instanceof TerminationException) {
            return transformerException;
        }
        if (transformerException.getException() instanceof TransformerException) {
            return Instruction.dynamicError(instr, (TransformerException)transformerException.getException(), controller);
        }
        if (transformerException.getLocator() == null || transformerException.getLocator() instanceof ExpressionLocation && controller.getConfiguration().getHostLanguage() != 11 || transformerException.getLocator().getLineNumber() == -1) {
            try {
                return new TransformerException(transformerException.getMessage(), instr.getSourceLocator(), transformerException.getException());
            }
            catch (Exception exception) {
                return transformerException;
            }
        }
        if (transformerException instanceof XPathException) {
            if (controller.getConfiguration().getHostLanguage() == 11) {
                return transformerException;
            }
            if (transformerException.getLocator() != null) {
                return transformerException;
            }
            return new TransformerException(transformerException.getMessage(), instr.getSourceLocator(), transformerException.getException());
        }
        return transformerException;
    }

    protected TransformerException dynamicError(String string, Controller controller) {
        return new TransformerException(string, this.getSourceLocator());
    }

    protected static void recoverableError(Instr instr, String string, Controller controller) throws TransformerException {
        controller.recoverableError(string, instr.getSourceLocator());
    }

    public static void displayChildren(Instr[] instrArray, int n, NamePool namePool) {
        int n2 = 0;
        while (n2 < instrArray.length) {
            if (instrArray[n2] instanceof Expression) {
                ((Expression)((Object)instrArray[n2])).display(n + 1, namePool);
            } else if (instrArray[n2] instanceof Instruction) {
                System.err.println(ExpressionTool.indent(n + 1) + ((Instruction)instrArray[n2]).getInstructionName());
            } else {
                System.err.println(instrArray[n2].toString());
            }
            ++n2;
        }
    }

    protected static ParameterSet assembleParams(XPathContext xPathContext, WithParam[] withParamArray) throws TransformerException {
        if (withParamArray == null || withParamArray.length == 0) {
            return null;
        }
        ParameterSet parameterSet = new ParameterSet();
        int n = 0;
        while (n < withParamArray.length) {
            parameterSet.put(withParamArray[n].getVariableFingerprint(), withParamArray[n].getSelectValue(xPathContext));
            ++n;
        }
        return parameterSet;
    }

    protected static ParameterSet assembleTunnelParams(XPathContext xPathContext, WithParam[] withParamArray) throws TransformerException {
        ParameterSet parameterSet = xPathContext.getController().getBindery().getTunnelParameters();
        if (parameterSet == null) {
            return Instruction.assembleParams(xPathContext, withParamArray);
        }
        ParameterSet parameterSet2 = new ParameterSet(parameterSet);
        if (withParamArray == null || withParamArray.length == 0) {
            return parameterSet2;
        }
        int n = 0;
        while (n < withParamArray.length) {
            parameterSet2.put(withParamArray[n].getVariableFingerprint(), withParamArray[n].getSelectValue(xPathContext));
            ++n;
        }
        return parameterSet2;
    }
}

