/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.ExprInstruction;
import net.sf.saxon.instruct.Instr;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.TraceListener;
import net.sf.saxon.xpath.XPathException;

public class TraceInstruction
extends ExprInstruction {
    private HashMap additionalProperties = new HashMap();

    public TraceInstruction(Instruction instruction) {
        Instr[] instrArray = new Instruction[]{instruction};
        this.setChildren(instrArray);
    }

    public void setProperty(String string, Object object) {
        this.additionalProperties.put(string, object);
    }

    public String getSystemId() {
        return this.children[0].getSourceLocator().getSystemId();
    }

    public int getLineNumber() {
        return this.children[0].getSourceLocator().getLineNumber();
    }

    public String getInstructionName() {
        if (this.children[0] instanceof Instruction) {
            return ((Instruction)this.children[0]).getInstructionName();
        }
        return "";
    }

    public String getInstructionNamespace() {
        if (this.children[0] instanceof Instruction) {
            return ((Instruction)this.children[0]).getInstructionNamespace();
        }
        return "";
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws TransformerException {
        Controller controller = xPathContext.getController();
        InstructionDetails instructionDetails = null;
        TraceListener traceListener = controller.getTraceListener();
        if (controller.isTracing()) {
            instructionDetails = this.makeDetails(controller);
            traceListener.enter(instructionDetails);
        }
        TailCall tailCall = this.children[0].processLeavingTail(xPathContext);
        if (controller.isTracing()) {
            traceListener.leave(instructionDetails);
        }
        return tailCall;
    }

    private InstructionDetails makeDetails(Controller controller) {
        InstructionDetails instructionDetails = new InstructionDetails();
        instructionDetails.setSystemId(this.getSystemId());
        instructionDetails.setLineNumber(this.getLineNumber());
        instructionDetails.setInstructionName(this.getInstructionName());
        instructionDetails.setProperty("instruction-namespace", this.getInstructionNamespace());
        Iterator iterator = this.additionalProperties.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object v = this.additionalProperties.get(string);
            instructionDetails.setProperty(string, v);
        }
        instructionDetails.setProperty("controller", controller);
        return instructionDetails;
    }

    public Expression simplify() throws XPathException {
        if (this.children[0] instanceof ExprInstruction) {
            this.children[0] = (ExprInstruction)((Expression)((Object)this.children[0])).simplify();
        }
        return this;
    }

    public Expression analyze(StaticContext staticContext) throws XPathException {
        if (this.children[0] instanceof ExprInstruction) {
            this.children[0] = (ExprInstruction)((Expression)((Object)this.children[0])).analyze(staticContext);
        }
        return this;
    }

    public int getDependencies() {
        if (this.children[0] instanceof ExprInstruction) {
            return ((ExprInstruction)this.children[0]).getDependencies();
        }
        return 0;
    }

    public int getSpecialProperties() {
        if (this.children[0] instanceof ExprInstruction) {
            return ((ExprInstruction)this.children[0]).getSpecialProperties();
        }
        return 0;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        InstructionDetails instructionDetails = null;
        Controller controller = xPathContext.getController();
        if (controller.isTracing()) {
            instructionDetails = this.makeDetails(controller);
            controller.getTraceListener().enter(instructionDetails);
        }
        Item item = ((Expression)((Object)this.children[0])).evaluateItem(xPathContext);
        if (controller.isTracing()) {
            controller.getTraceListener().leave(instructionDetails);
        }
        return item;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        InstructionDetails instructionDetails = null;
        Controller controller = xPathContext.getController();
        if (controller.isTracing()) {
            instructionDetails = this.makeDetails(controller);
            controller.getTraceListener().enter(instructionDetails);
        }
        SequenceIterator sequenceIterator = ((Expression)((Object)this.children[0])).iterate(xPathContext);
        if (controller.isTracing()) {
            controller.getTraceListener().leave(instructionDetails);
        }
        return sequenceIterator;
    }

    protected void promoteInst(PromotionOffer promotionOffer) throws XPathException {
        if (this.children[0] instanceof ExprInstruction) {
            ((ExprInstruction)this.children[0]).promoteInst(promotionOffer);
        }
    }

    protected void getXPathExpressions(List list) {
        if (this.children[0] instanceof ExprInstruction) {
            ((ExprInstruction)this.children[0]).getXPathExpressions(list);
        }
    }

    public void display(int n, NamePool namePool) {
        if (this.children[0] instanceof ExprInstruction) {
            ((ExprInstruction)this.children[0]).display(n, namePool);
        }
    }
}

