/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.text.Collator;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.ListIterator;
import net.sf.saxon.om.LookaheadIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.AtomicSortComparer;
import net.sf.saxon.sort.GroupIterator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.xpath.XPathException;

public class GroupAdjacentIterator
implements GroupIterator,
LookaheadIterator {
    private SequenceIterator population;
    private Expression keyExpression;
    private Collator collator;
    private AtomicSortComparer comparer;
    private AtomicSortComparer.ComparisonKey currentComparisonKey;
    private XPathContext keyContext;
    private AtomicValue currentKey = null;
    private List currentMembers;
    private AtomicValue nextKey = null;
    private Item next;
    private Item current = null;
    private int position = 0;

    public GroupAdjacentIterator(SequenceIterator sequenceIterator, Expression expression, XPathContext xPathContext, Collator collator) throws XPathException {
        this.population = sequenceIterator;
        this.keyExpression = expression;
        this.keyContext = xPathContext;
        this.collator = collator;
        this.comparer = new AtomicSortComparer(collator);
        this.next = sequenceIterator.next();
        if (this.next != null) {
            this.nextKey = (AtomicValue)expression.evaluateItem(xPathContext);
        }
    }

    private void advance() throws XPathException {
        Item item;
        this.currentMembers = new ArrayList();
        this.currentMembers.add(this.current);
        while ((item = this.population.next()) != null) {
            AtomicValue atomicValue = (AtomicValue)this.keyExpression.evaluateItem(this.keyContext);
            try {
                if (this.currentComparisonKey.equals(this.comparer.getComparisonKey(atomicValue))) {
                    this.currentMembers.add(item);
                    continue;
                }
                this.next = item;
                this.nextKey = atomicValue;
                return;
            }
            catch (ClassCastException classCastException) {
                throw new XPathException.Type("Grouping key values are of non-comparable types (" + this.currentKey.getItemType() + " and " + atomicValue.getItemType() + ")");
            }
        }
        this.next = null;
        this.nextKey = null;
    }

    public AtomicValue getCurrentGroupingKey() {
        return this.currentKey;
    }

    public SequenceIterator iterateCurrentGroup() {
        return new ListIterator(this.currentMembers);
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public Item next() throws XPathException {
        if (this.next == null) {
            return null;
        }
        this.current = this.next;
        this.currentKey = this.nextKey;
        this.currentComparisonKey = this.comparer.getComparisonKey(this.currentKey);
        ++this.position;
        this.advance();
        return this.current;
    }

    public Item current() {
        return this.current;
    }

    public int position() {
        return this.position;
    }

    public SequenceIterator getAnother() throws XPathException {
        return new GroupAdjacentIterator(this.population, this.keyExpression, this.keyContext.newContext(), this.collator);
    }
}

