/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree;

import javax.xml.transform.TransformerException;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.AbstractNode;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tree.AncestorEnumeration;
import net.sf.saxon.tree.AttributeEnumeration;
import net.sf.saxon.tree.DescendantEnumeration;
import net.sf.saxon.tree.DocumentImpl;
import net.sf.saxon.tree.FollowingEnumeration;
import net.sf.saxon.tree.FollowingSiblingEnumeration;
import net.sf.saxon.tree.NamespaceEnumeration;
import net.sf.saxon.tree.ParentNodeImpl;
import net.sf.saxon.tree.PrecedingEnumeration;
import net.sf.saxon.tree.PrecedingOrAncestorEnumeration;
import net.sf.saxon.tree.PrecedingSiblingEnumeration;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class NodeImpl
extends AbstractNode {
    protected ParentNodeImpl parent;
    protected int index;

    public void setSystemId(String string) {
        this.getParent().setSystemId(string);
    }

    public boolean isSameNode(NodeInfo nodeInfo) {
        return this == nodeInfo;
    }

    public int getNameCode() {
        return -1;
    }

    public int getFingerprint() {
        int n = this.getNameCode();
        if (n == -1) {
            return -1;
        }
        return n & 0xFFFFF;
    }

    public String generateId() {
        return this.getDocumentRoot().generateId() + AbstractNode.NODE_LETTER[this.getNodeKind()] + this.getSequenceNumber();
    }

    public Node getOriginatingNode() {
        return this;
    }

    public String getSystemId() {
        return this.parent.getSystemId();
    }

    public String getBaseURI() {
        return this.parent.getBaseURI();
    }

    protected long getSequenceNumber() {
        NodeImpl nodeImpl = this;
        int n = 0;
        while (!(nodeImpl instanceof ParentNodeImpl)) {
            nodeImpl = nodeImpl.getPreviousInDocument();
            ++n;
        }
        return nodeImpl.getSequenceNumber() + 65536L + (long)n;
    }

    public final int compareOrder(NodeInfo nodeInfo) {
        long l;
        long l2 = this.getSequenceNumber();
        if (l2 < (l = ((NodeImpl)nodeInfo).getSequenceNumber())) {
            return -1;
        }
        if (l2 > l) {
            return 1;
        }
        return 0;
    }

    public NamePool getNamePool() {
        return this.getDocumentRoot().getNamePool();
    }

    public String getPrefix() {
        int n = this.getNameCode();
        if (n == -1) {
            return "";
        }
        if ((n >> 20 & 0xFF) == 0) {
            return "";
        }
        return this.getNamePool().getPrefix(n);
    }

    public String getURI() {
        int n = this.getNameCode();
        if (n == -1) {
            return "";
        }
        return this.getNamePool().getURI(n);
    }

    public String getDisplayName() {
        int n = this.getNameCode();
        if (n == -1) {
            return "";
        }
        return this.getNamePool().getDisplayName(n);
    }

    public String getLocalPart() {
        int n = this.getNameCode();
        if (n == -1) {
            return "";
        }
        return this.getNamePool().getLocalName(n);
    }

    public int getLineNumber() {
        return this.parent.getLineNumber();
    }

    public final NodeInfo getParent() {
        return this.parent;
    }

    public Node getPreviousSibling() {
        return this.parent.getNthChild(this.index - 1);
    }

    public Node getNextSibling() {
        return this.parent.getNthChild(this.index + 1);
    }

    public Node getFirstChild() {
        return null;
    }

    public Node getLastChild() {
        return null;
    }

    public AxisIterator iterateAxis(byte by) {
        if (by == 3) {
            if (this instanceof ParentNodeImpl) {
                return ((ParentNodeImpl)this).enumerateChildren(null);
            }
            return EmptyIterator.getInstance();
        }
        return this.iterateAxis(by, AnyNodeTest.getInstance());
    }

    public AxisIterator iterateAxis(byte by, NodeTest nodeTest) {
        switch (by) {
            case 0: {
                return new AncestorEnumeration(this, nodeTest, false);
            }
            case 1: {
                return new AncestorEnumeration(this, nodeTest, true);
            }
            case 2: {
                if (this.getNodeKind() != 1) {
                    return EmptyIterator.getInstance();
                }
                return new AttributeEnumeration(this, nodeTest);
            }
            case 3: {
                if (this instanceof ParentNodeImpl) {
                    return ((ParentNodeImpl)this).enumerateChildren(nodeTest);
                }
                return EmptyIterator.getInstance();
            }
            case 4: {
                if (this.getNodeKind() == 9 && nodeTest instanceof NameTest && nodeTest.getNodeKind() == 1) {
                    return ((DocumentImpl)this).getAllElements(nodeTest.getFingerprint());
                }
                if (this.hasChildNodes()) {
                    return new DescendantEnumeration(this, nodeTest, false);
                }
                return EmptyIterator.getInstance();
            }
            case 5: {
                return new DescendantEnumeration(this, nodeTest, true);
            }
            case 6: {
                return new FollowingEnumeration(this, nodeTest);
            }
            case 7: {
                return new FollowingSiblingEnumeration(this, nodeTest);
            }
            case 8: {
                if (this.getNodeKind() != 1) {
                    return EmptyIterator.getInstance();
                }
                return new NamespaceEnumeration(this, nodeTest);
            }
            case 9: {
                NodeInfo nodeInfo = (NodeInfo)((Object)this.getParentNode());
                if (nodeInfo == null) {
                    return EmptyIterator.getInstance();
                }
                if (nodeTest.matches(nodeInfo.getNodeKind(), nodeInfo.getFingerprint(), nodeInfo.getTypeAnnotation())) {
                    return SingletonIterator.makeIterator(nodeInfo);
                }
                return EmptyIterator.getInstance();
            }
            case 10: {
                return new PrecedingEnumeration(this, nodeTest);
            }
            case 11: {
                return new PrecedingSiblingEnumeration(this, nodeTest);
            }
            case 12: {
                if (nodeTest.matches(this.getNodeKind(), this.getFingerprint(), this.getTypeAnnotation())) {
                    return SingletonIterator.makeIterator(this);
                }
                return EmptyIterator.getInstance();
            }
            case 13: {
                return new PrecedingOrAncestorEnumeration(this, nodeTest);
            }
        }
        throw new IllegalArgumentException("Unknown axis number " + by);
    }

    public boolean hasAttributes() {
        return false;
    }

    public String getAttributeValue(int n) {
        return null;
    }

    public Element getDocumentElement() {
        return ((DocumentImpl)this.getDocumentRoot()).getDocumentElement();
    }

    public NodeInfo getRoot() {
        return this.getDocumentRoot();
    }

    public DocumentInfo getDocumentRoot() {
        return this.getParent().getDocumentRoot();
    }

    public NodeImpl getNextInDocument(NodeImpl nodeImpl) {
        NodeImpl nodeImpl2 = (NodeImpl)this.getFirstChild();
        if (nodeImpl2 != null) {
            return nodeImpl2;
        }
        if (this == nodeImpl) {
            return null;
        }
        nodeImpl2 = (NodeImpl)this.getNextSibling();
        if (nodeImpl2 != null) {
            return nodeImpl2;
        }
        NodeImpl nodeImpl3 = this;
        do {
            if ((nodeImpl3 = (NodeImpl)nodeImpl3.getParent()) == null) {
                return null;
            }
            if (nodeImpl3 != nodeImpl) continue;
            return null;
        } while ((nodeImpl2 = (NodeImpl)nodeImpl3.getNextSibling()) == null);
        return nodeImpl2;
    }

    public NodeImpl getPreviousInDocument() {
        NodeImpl nodeImpl = (NodeImpl)this.getPreviousSibling();
        if (nodeImpl != null) {
            return nodeImpl.getLastDescendantOrSelf();
        }
        return (NodeImpl)this.getParentNode();
    }

    private NodeImpl getLastDescendantOrSelf() {
        NodeImpl nodeImpl = (NodeImpl)this.getLastChild();
        if (nodeImpl == null) {
            return this;
        }
        return nodeImpl.getLastDescendantOrSelf();
    }

    public void outputNamespaceNodes(Receiver receiver, boolean bl) throws TransformerException {
    }

    public final void copy(Receiver receiver, int n, boolean bl) throws TransformerException {
        this.copy(receiver, n);
    }

    public abstract void copy(Receiver var1, int var2) throws TransformerException;

    public boolean hasChildNodes() {
        return this.getFirstChild() != null;
    }
}

