/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.StringTokenizer;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public final class MonthDurationValue
extends DurationValue
implements Comparable {
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$net$sf$saxon$value$DurationValue;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$CharSequence;

    private MonthDurationValue() {
    }

    public MonthDurationValue(CharSequence charSequence) throws XPathException {
        StringTokenizer stringTokenizer = new StringTokenizer(Value.trimWhitespace(charSequence).toString(), "-+PYM", true);
        try {
            String string;
            if (!stringTokenizer.hasMoreElements()) {
                this.badDuration("empty string", charSequence);
            }
            if ((string = (String)stringTokenizer.nextElement()).equals("+")) {
                string = (String)stringTokenizer.nextElement();
            } else if (string.equals("-")) {
                this.negative = true;
                string = (String)stringTokenizer.nextElement();
            }
            if (!string.equals("P")) {
                this.badDuration("missing 'P'", charSequence);
            }
            int n = 0;
            while (stringTokenizer.hasMoreElements()) {
                string = (String)stringTokenizer.nextElement();
                if (string.equals("T")) {
                    n = 4;
                    string = (String)stringTokenizer.nextElement();
                }
                int n2 = Integer.parseInt(string);
                if (!stringTokenizer.hasMoreElements()) {
                    this.badDuration("missing unit letter at end", charSequence);
                }
                char c = ((String)stringTokenizer.nextElement()).charAt(0);
                switch (c) {
                    case 'Y': {
                        if (n > 0) {
                            this.badDuration("Y is out of sequence", charSequence);
                        }
                        this.years = n2;
                        n = 1;
                        break;
                    }
                    case 'M': {
                        if (n == 4 || n == 5) {
                            this.minutes = n2;
                            n = 6;
                            break;
                        }
                        if (n == 0 || n == 1) {
                            this.months = n2;
                            n = 2;
                            break;
                        }
                        this.badDuration("M is out of sequence", charSequence);
                    }
                    default: {
                        this.badDuration("misplaced " + c, charSequence);
                    }
                }
            }
            this.normalize();
        }
        catch (NumberFormatException numberFormatException) {
            this.badDuration("non-numeric component", charSequence);
        }
    }

    public String getStringValue() {
        int n = this.years * 12 + this.months;
        int n2 = n / 12;
        int n3 = n % 12;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.negative) {
            stringBuffer.append('-');
        }
        stringBuffer.append('P');
        if (n2 != 0) {
            stringBuffer.append(n2);
            stringBuffer.append('Y');
        }
        if (n3 != 0 || n2 == 0) {
            stringBuffer.append(n3);
            stringBuffer.append('M');
        }
        return stringBuffer.toString();
    }

    public void normalize() {
        if (this.months >= 12) {
            this.years += this.months / 12;
            this.months %= 12;
        }
    }

    public int getLengthInMonths() {
        return (this.years * 12 + this.months) * (this.negative ? -1 : 1);
    }

    public static MonthDurationValue fromMonths(int n) {
        MonthDurationValue monthDurationValue = new MonthDurationValue();
        monthDurationValue.negative = n < 0;
        monthDurationValue.months = n < 0 ? -n : n;
        monthDurationValue.normalize();
        return monthDurationValue;
    }

    public DurationValue multiply(double d) {
        return MonthDurationValue.fromMonths((int)((double)this.getLengthInMonths() * d));
    }

    public DoubleValue divide(DurationValue durationValue) throws XPathException {
        if (durationValue instanceof MonthDurationValue) {
            return new DoubleValue((double)this.getLengthInMonths() / (double)((MonthDurationValue)durationValue).getLengthInMonths());
        }
        throw new XPathException.Dynamic("Cannot divide two durations of different type");
    }

    public DurationValue add(DurationValue durationValue) throws XPathException {
        if (durationValue instanceof MonthDurationValue) {
            return MonthDurationValue.fromMonths(this.getLengthInMonths() + ((MonthDurationValue)durationValue).getLengthInMonths());
        }
        throw new XPathException.Dynamic("Cannot add two durations of different type");
    }

    public DurationValue subtract(DurationValue durationValue) throws XPathException {
        if (durationValue instanceof MonthDurationValue) {
            return MonthDurationValue.fromMonths(this.getLengthInMonths() - ((MonthDurationValue)durationValue).getLengthInMonths());
        }
        throw new XPathException.Dynamic("Cannot subtract two durations of different type");
    }

    public ItemType getItemType() {
        return Type.YEAR_MONTH_DURATION_TYPE;
    }

    public int conversionPreference(Class clazz, Configuration configuration) {
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = MonthDurationValue.class$("java.lang.Object")) : class$java$lang$Object)) {
            return 50;
        }
        if (clazz.isAssignableFrom(class$net$sf$saxon$value$DurationValue == null ? (class$net$sf$saxon$value$DurationValue = MonthDurationValue.class$("net.sf.saxon.value.DurationValue")) : class$net$sf$saxon$value$DurationValue)) {
            return 0;
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = MonthDurationValue.class$("java.lang.String")) : class$java$lang$String) || clazz == (class$java$lang$CharSequence == null ? (class$java$lang$CharSequence = MonthDurationValue.class$("java.lang.CharSequence")) : class$java$lang$CharSequence)) {
            return 3;
        }
        return Integer.MAX_VALUE;
    }

    public Object convertToJava(Class clazz, Configuration configuration) throws XPathException {
        if (clazz.isAssignableFrom(class$net$sf$saxon$value$DurationValue == null ? (class$net$sf$saxon$value$DurationValue = MonthDurationValue.class$("net.sf.saxon.value.DurationValue")) : class$net$sf$saxon$value$DurationValue)) {
            return this;
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = MonthDurationValue.class$("java.lang.String")) : class$java$lang$String) || clazz == (class$java$lang$CharSequence == null ? (class$java$lang$CharSequence = MonthDurationValue.class$("java.lang.CharSequence")) : class$java$lang$CharSequence)) {
            return this.getStringValue();
        }
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = MonthDurationValue.class$("java.lang.Object")) : class$java$lang$Object)) {
            return this.getStringValue();
        }
        throw new XPathException.Dynamic("Conversion of yearMonthDuration to " + clazz.getName() + " is not supported");
    }

    public int compareTo(Object object) {
        if (object instanceof MonthDurationValue) {
            return this.getLengthInMonths() - ((MonthDurationValue)object).getLengthInMonths();
        }
        return super.compareTo(object);
    }

    public void display(int n, NamePool namePool) {
        System.err.println(ExpressionTool.indent(n) + "yearMonthDuration (" + this.getStringValue() + ")");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

