<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    version="2.0"
    xmlns:lxslt="http://xml.apache.org/xslt">

  <!--
       Use DashboardStamp as a parameter, default to most recent
       The proper flags to Xalan are in the form -PARAM DashboardStamp "string('foo')"
       -->
  <xsl:output method="html"/>
  <xsl:param name="DashboardPath"/>
  <xsl:param name="DashboardStamp" select="string('MostRecentResults-Nightly')"/>
  <xsl:param name="PreviousDashboardStamp" select="string('')"/>
  <xsl:param name="CrossLink">ON</xsl:param>
  <xsl:variable name="DashboardDir" select="concat('../', $DashboardStamp)"/>
  <xsl:variable name="IconDir" select="string('../../Icons')"/>
  <xsl:include href="DashboardConfig.xsl"/>

  <xsl:template match="/">
    TestOverview.html is deliberately empty. Separate TestOverviewByTest.html and TestOverviewByCount.html files are generated as well as a collection of TestDetail pages.
    <xsl:call-template name="TestOverviewByTest"/>
    <xsl:call-template name="TestOverviewByCount"/>
    <xsl:for-each select="/TestOverview/Test">
      <xsl:call-template name="TestDetail"/>
    </xsl:for-each>
  </xsl:template>


  <xsl:template name="TestOverviewByTest">
    <xsl:variable name="uri" select="concat('file:///', $DashboardPath, '/TestOverviewByTest.html' )"/>
    <xsl:result-document href="{$uri}" >
      <xsl:call-template name="DashboardHeader">
        <xsl:with-param name="Title">Test Overview</xsl:with-param>
        <xsl:with-param name="IconDir">../../Icons</xsl:with-param>
        <xsl:with-param name="UseToolTips">1</xsl:with-param>
        <xsl:with-param name="DashboardDir" select="$DashboardDir"/>
      </xsl:call-template>
      <xsl:if test="$CrossLink = 'ON'">
        <xsl:call-template name="BuildCallbacks"/>
      </xsl:if>
      <xsl:call-template name="BuildNameLegend"/>
      <br/><br/>
      <table>
        <tr>
          <th rowspan="2">Test <img border="0"><xsl:attribute name="src"><xsl:value-of select="$IconDir"/>/DownBlack.gif</xsl:attribute></img></th>
          <th>
            <xsl:attribute name="colspan"><xsl:value-of select="4 + count(/TestOverview/Test[1]/Result)"/></xsl:attribute>
            Status ( <a href="TestOverviewByCount.html">sort by</a> )
          </th>
        </tr>
        <tr>
          <xsl:for-each select="/TestOverview/Test[1]/Result">
            <xsl:sort select="BuildName"/>
            <xsl:sort select="SiteName"/>
            <th><xsl:number value="position()" format="1"/></th>
          </xsl:for-each>
          <td></td>
          <td>N</td>
          <td>F</td>
          <td>P</td>
          <td>NA</td>
        </tr>
<xsl:if test="$CrossLink='ON'">
<xsl:text disable-output-escaping="yes"><![CDATA[<script type="text/javascript">]]></xsl:text>
var tests = new Array(); 
var numTests = 1;
<xsl:for-each select="/TestOverview/Test">
  <xsl:sort select="Name"/>
tests[numTests++] = '<xsl:value-of select="Name[position()]"/>';
</xsl:for-each>        
<xsl:text disable-output-escaping="yes"><![CDATA[</script>]]></xsl:text>   
</xsl:if>
        <xsl:for-each select="/TestOverview/Test">
          <xsl:sort select="Name"/>
          <tr>
            <xsl:choose>
              <xsl:when test="$CrossLink='ON'">
                <xsl:call-template name="ColorOverviewRow">
                  <xsl:with-param name="CurrentTest"><xsl:value-of select="position()"/></xsl:with-param>
                </xsl:call-template>
              </xsl:when>
              <xsl:otherwise>
                <xsl:call-template name="ColorOverviewRowNoLinks">
                  <xsl:with-param name="CurrentTest"><xsl:value-of select="position()"/></xsl:with-param>
                </xsl:call-template>
              </xsl:otherwise>
            </xsl:choose>
          </tr>
        </xsl:for-each>
      </table>
      <br/><br/>

      <xsl:call-template name="BuildNameLegend"/>

      <xsl:call-template name="DashboardFooter"/>
    </xsl:result-document>
  </xsl:template>

  <xsl:template name="TestOverviewByCount">
    <xsl:variable name="uri" select="concat('file:///', $DashboardPath, '/TestOverviewByCount.html' )"/>
    <xsl:result-document href="{$uri}" >
      <xsl:call-template name="DashboardHeader">
        <xsl:with-param name="Title">Test Overview</xsl:with-param>
        <xsl:with-param name="IconDir">../../Icons</xsl:with-param>
        <xsl:with-param name="UseToolTips">1</xsl:with-param>
        <xsl:with-param name="DashboardDir" select="$DashboardDir"/>
      </xsl:call-template>
      <xsl:if test="$CrossLink = 'ON'">
        <xsl:call-template name="BuildCallbacks"/>
      </xsl:if>
      <xsl:call-template name="BuildNameLegend"/>
      <br/><br/>
      <table>
        <tr>
          <th rowspan="2">Test ( <a href="TestOverviewByTest.html">sort by</a> )</th>
          <th>
            <xsl:attribute name="colspan"><xsl:value-of select="4 + count(/TestOverview/Test[1]/Result)"/></xsl:attribute>
            Status <img border="0"><xsl:attribute name="src"><xsl:value-of select="$IconDir"/>/DownBlack.gif</xsl:attribute></img>
          </th>
        </tr>
        <tr>
          <xsl:for-each select="/TestOverview/Test[1]/Result">
            <xsl:sort select="BuildName"/>
            <xsl:sort select="SiteName"/>
            <th><xsl:number value="position()" format="1"/></th>
          </xsl:for-each>
          <td></td>
          <td>N</td>
          <td>F</td>
          <td>P</td>
          <td>NA</td>
        </tr>
<xsl:if test="$CrossLink='ON'">
<xsl:text disable-output-escaping="yes"><![CDATA[<script type="text/javascript">]]></xsl:text>
var tests = new Array(); 
var numTests = 1;
<xsl:for-each select="/TestOverview/Test">
  <xsl:sort select="count (Result/Status[node()='notrun'])" data-type="number" order="descending"/>
  <xsl:sort select="count (Result/Status[node()='failed'])" data-type="number" order="descending"/>
tests[numTests++] = '<xsl:value-of select="Name[position()]"/>';
</xsl:for-each>        
<xsl:text disable-output-escaping="yes"><![CDATA[</script>]]></xsl:text>   
</xsl:if>
        <xsl:for-each select="/TestOverview/Test">
          <xsl:sort select="count (Result/Status[node()='notrun'])" data-type="number" order="descending"/>
          <xsl:sort select="count (Result/Status[node()='failed'])" data-type="number" order="descending"/>
          <xsl:sort select="count (Result/Status[node()='passed'])" data-type="number" order="ascending"/>
          <xsl:sort select="Name"/>
          <tr>
            <xsl:choose>
            <xsl:when test="$CrossLink='ON'">
              <xsl:call-template name="ColorOverviewRow">
                <xsl:with-param name="CurrentTest"><xsl:value-of select="position()"/></xsl:with-param>
              </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
              <xsl:call-template name="ColorOverviewRowNoLinks">
                <xsl:with-param name="CurrentTest"><xsl:value-of select="position()"/></xsl:with-param>
              </xsl:call-template>
            </xsl:otherwise>
          </xsl:choose>
          </tr>
        </xsl:for-each>
      </table>
      <br/><br/>

      <xsl:call-template name="BuildNameLegend"/>

      <xsl:call-template name="DashboardFooter"/>
    </xsl:result-document>
  </xsl:template>


  <xsl:template name="ColorOverviewRow">
    <xsl:param name="CurrentTest">0</xsl:param>
    <xsl:if test="position() mod 2 = 0">
      <xsl:attribute name="bgcolor"><xsl:value-of select="$LightBlue"/></xsl:attribute>
    </xsl:if>
    <td>
      <a>
        <xsl:attribute name="href">
            <xsl:call-template name="TranslateTestName">
              <xsl:with-param name="Prefix">TestDetail/</xsl:with-param>
              <xsl:with-param name="TestName"><xsl:value-of select="Name"/></xsl:with-param>
              <xsl:with-param name="Postfix">.html</xsl:with-param>
            </xsl:call-template>
        </xsl:attribute>
        <xsl:call-template name="SoftHyphenStringAtSlash">
           <xsl:with-param name="src">
	      <xsl:value-of select="Name"/>
           </xsl:with-param>
	</xsl:call-template>
        </a>
      </td>
     <xsl:for-each select="Result">
        <xsl:sort select="BuildName"/>
        <xsl:sort select="SiteName"/>
        <xsl:choose>
          <xsl:when test="contains(Status,'passed')">
            <td>
              <xsl:attribute name="class">pass</xsl:attribute>
              <a><xsl:attribute name="class">btip</xsl:attribute>
                <xsl:attribute name="onMouseover">t<xsl:value-of select="position()"/>(this,event)</xsl:attribute>
                <xsl:attribute name="href">javascript:l<xsl:value-of select="position()"/>(tests[<xsl:value-of select="$CurrentTest"/>])</xsl:attribute>
                <xsl:text disable-output-escaping="yes"><![CDATA[&nbsp;&nbsp;&nbsp;]]></xsl:text>
              </a>
            </td>
          </xsl:when>
          <xsl:when test="contains(Status,'failed')">
            <td>
              <xsl:attribute name="class">fail</xsl:attribute>
              <a><xsl:attribute name="class">btip</xsl:attribute>
                <xsl:attribute name="onMouseover">t<xsl:value-of select="position()"/>(this,event)</xsl:attribute>
                <xsl:attribute name="href">javascript:l<xsl:value-of select="position()"/>(tests[<xsl:value-of select="$CurrentTest"/>])</xsl:attribute>
                <xsl:text disable-output-escaping="yes"><![CDATA[&nbsp;&nbsp;&nbsp;]]></xsl:text>
              </a>
            </td>
          </xsl:when>
          <xsl:when test="contains(Status,'notrun')">
            <td>
              <xsl:attribute name="class">nr</xsl:attribute>
              <a href="#"><xsl:attribute name="class">btip</xsl:attribute>
                <xsl:attribute name="onMouseover">t<xsl:value-of select="position()"/>(this,event)</xsl:attribute>
                <xsl:text disable-output-escaping="yes"><![CDATA[&nbsp;&nbsp;&nbsp;]]></xsl:text>
              </a>
            </td>
          </xsl:when>
          <xsl:otherwise>
            <td>
              <xsl:attribute name="class">na</xsl:attribute>
              <a href="#"><xsl:attribute name="class">btip</xsl:attribute>
                <xsl:attribute name="onMouseover">t<xsl:value-of select="position()"/>(this,event)</xsl:attribute>
                <xsl:text disable-output-escaping="yes"><![CDATA[&nbsp;&nbsp;&nbsp;]]></xsl:text>
              </a>
            </td>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:for-each>
      <td><xsl:text disable-output-escaping="yes"><![CDATA[&nbsp;&nbsp;&nbsp;]]></xsl:text></td>
      <td><xsl:value-of select="count (Result/Status[node()='notrun'])"/></td>
      <td><xsl:value-of select="count (Result/Status[node()='failed'])"/></td>
      <td><xsl:value-of select="count (Result/Status[node()='passed'])"/></td>
      <td><xsl:value-of select="count (Result/Status[node()='na'])"/></td>
  </xsl:template>

  <xsl:template name="ColorOverviewRowNoLinks">
    <xsl:param name="CurrentTest">0</xsl:param>
    <xsl:if test="position() mod 2 = 0">
      <xsl:attribute name="bgcolor"><xsl:value-of select="$LightBlue"/></xsl:attribute>
    </xsl:if>
    <td>
      <a>
        <xsl:attribute name="href">
            <xsl:call-template name="TranslateTestName">
              <xsl:with-param name="Prefix">TestDetail/</xsl:with-param>
              <xsl:with-param name="TestName"><xsl:value-of select="Name"/></xsl:with-param>
              <xsl:with-param name="Postfix">.html</xsl:with-param>
            </xsl:call-template>
        </xsl:attribute>
        <xsl:call-template name="SoftHyphenStringAtSlash">
           <xsl:with-param name="src">
	      <xsl:value-of select="Name"/>
           </xsl:with-param>
	</xsl:call-template>
        </a>
      </td>
     <xsl:for-each select="Result">
        <xsl:sort select="BuildName"/>
        <xsl:sort select="SiteName"/>
        <xsl:choose>
          <xsl:when test="contains(Status,'passed')">
            <td>
              <xsl:attribute name="class">pass</xsl:attribute>
                <xsl:text disable-output-escaping="yes"><![CDATA[&nbsp;&nbsp;&nbsp;]]></xsl:text>
            </td>
          </xsl:when>
          <xsl:when test="contains(Status,'failed')">
            <td>
              <xsl:attribute name="class">fail</xsl:attribute>
                <xsl:text disable-output-escaping="yes"><![CDATA[&nbsp;&nbsp;&nbsp;]]></xsl:text>
            </td>
          </xsl:when>
          <xsl:when test="contains(Status,'notrun')">
            <td>
              <xsl:attribute name="class">nr</xsl:attribute>
                <xsl:text disable-output-escaping="yes"><![CDATA[&nbsp;&nbsp;&nbsp;]]></xsl:text>
            </td>
          </xsl:when>
          <xsl:otherwise>
            <td>
              <xsl:attribute name="class">na</xsl:attribute>
                <xsl:text disable-output-escaping="yes"><![CDATA[&nbsp;&nbsp;&nbsp;]]></xsl:text>
            </td>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:for-each>
      <td><xsl:text disable-output-escaping="yes"><![CDATA[&nbsp;&nbsp;&nbsp;]]></xsl:text></td>
      <td><xsl:value-of select="count (Result/Status[node()='notrun'])"/></td>
      <td><xsl:value-of select="count (Result/Status[node()='failed'])"/></td>
      <td><xsl:value-of select="count (Result/Status[node()='passed'])"/></td>
      <td><xsl:value-of select="count (Result/Status[node()='na'])"/></td>
  </xsl:template>

  <xsl:template name="TestDetail">
    <xsl:variable name="uri" select="concat('file:///', $DashboardPath, '/TestDetail/', translate ( Name, '/.', '__' ) , '.html' )"/>
    <xsl:result-document href="{$uri}">
      <xsl:call-template name="DashboardHeader">
        <xsl:with-param name="Title">Test Detail - <xsl:value-of select="Name"/></xsl:with-param>
        <xsl:with-param name="IconDir">../../../Icons</xsl:with-param>
        <xsl:with-param name="DashboardDir">..</xsl:with-param>
      </xsl:call-template>
      <table>
        <tr>
          <th>Site</th>
          <th>Build Name</th>
          <th>Build Stamp</th>
          <th>Status</th>
          <th>Time</th>
          <th>Detail</th>
        </tr>
        <xsl:for-each select="Result">
          <xsl:sort select="BuildName"/>
          <xsl:sort select="SiteName"/>
          <tr>
            <xsl:if test="position() mod 2 = 0">
              <xsl:attribute name="bgcolor"><xsl:value-of select="$LightBlue"/></xsl:attribute>
            </xsl:if>
            <td>
              <xsl:call-template name="SoftHyphenStringAtDot">
		<xsl:with-param name="src">
		   <xsl:value-of select="SiteName"/>
		</xsl:with-param>
	      </xsl:call-template>
            </td>
            <td>
              <a>
                <xsl:attribute name="href">../../../Sites/<xsl:value-of select="SiteName"/>/<xsl:value-of select="BuildName"/>/<xsl:value-of select="BuildStamp"/>/Test.html</xsl:attribute>
                <xsl:value-of select="BuildName"/>
              </a>
              </td>
            <td><xsl:value-of select="BuildStamp"/></td>
            <td>
              <xsl:choose>
                <xsl:when test="Status = 'passed'"><xsl:attribute name="class">pass</xsl:attribute></xsl:when>
                <xsl:when test="Status = 'failed'"><xsl:attribute name="class">fail</xsl:attribute></xsl:when>
                <xsl:when test="Status = 'notrun'"><xsl:attribute name="class">nr</xsl:attribute></xsl:when>
                <xsl:when test="Status = 'na'"><xsl:attribute name="class">na</xsl:attribute></xsl:when>
              </xsl:choose>
              <xsl:choose>
                <xsl:when test="Status = 'passed'">
                  <a>
                    <xsl:attribute name="href">../../../Sites/<xsl:value-of select="SiteName"/>/<xsl:value-of select="BuildName"/>/<xsl:value-of select="BuildStamp"/>/Results/<xsl:value-of select="concat ( translate ( ../Name, '/.', '__' ), '.html' )"/></xsl:attribute>
                    Passed
                  </a>
                </xsl:when>
                <xsl:when test="Status = 'failed'">
                  <a>
                    <xsl:attribute name="href">../../../Sites/<xsl:value-of select="SiteName"/>/<xsl:value-of select="BuildName"/>/<xsl:value-of select="BuildStamp"/>/Results/<xsl:value-of select="concat ( translate ( ../Name, '/.', '__' ), '.html' )"/></xsl:attribute>
                    Failed
                  </a>
                </xsl:when>
                <xsl:when test="Status = 'notrun'">Not Run</xsl:when>
                <xsl:when test="Status = 'na'">NA</xsl:when>
              </xsl:choose>
            </td>
            <td align="right">
              <xsl:choose>
   		<xsl:when test="Status = 'failed'">
                  <xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;&amp;nbsp;</xsl:text>
                  <xsl:value-of select="ExecutionTime"/>
                  <xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;&amp;nbsp;</xsl:text>
	        </xsl:when>
   		<xsl:when test="Status = 'passed'">
                  <xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;&amp;nbsp;</xsl:text>
                  <xsl:value-of select="ExecutionTime"/>
                  <xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;&amp;nbsp;</xsl:text>
	        </xsl:when>
		<xsl:otherwise>
                  <xsl:text disable-output-escaping="yes"><![CDATA[&nbsp;&nbsp;&nbsp;]]></xsl:text>		
		</xsl:otherwise>	
              </xsl:choose>
            </td>
            <td>
              <xsl:choose>
   		<xsl:when test="Status = 'failed'">
                  <xsl:choose>
                    <xsl:when test="CompletionStatus = 'Timeout'">
                      Timeout
                    </xsl:when>
                    <xsl:when test="ExitCode">
                      <xsl:value-of select="ExitCode"/>
                    </xsl:when>
		    <xsl:otherwise>
                       <xsl:text disable-output-escaping="yes"><![CDATA[&nbsp;&nbsp;&nbsp;]]></xsl:text>
		    </xsl:otherwise>
                  </xsl:choose>
	        </xsl:when>
		<xsl:otherwise>
                  <xsl:text disable-output-escaping="yes"><![CDATA[&nbsp;&nbsp;&nbsp;]]></xsl:text>		
		</xsl:otherwise>	
              </xsl:choose>
            </td>
          </tr>
        </xsl:for-each>
      </table>

      <xsl:call-template name="DashboardFooter">
        <xsl:with-param name="IconDir">../../../Icons</xsl:with-param>
      </xsl:call-template>
    </xsl:result-document>
  </xsl:template>

  

  <xsl:template name="BuildNameLegend">
    <table>
      <tr>
        <th>Number</th>
        <th>Site Name</th>
        <th>Build Name</th>
        <th>Build Stamp</th>
      </tr>
        <xsl:for-each select="/TestOverview/Test[1]/Result">
          <xsl:sort select="BuildName"/>
          <xsl:sort select="SiteName"/>
          <tr>
            <xsl:if test="position() mod 2 = 0">
              <xsl:attribute name="bgcolor"><xsl:value-of select="$LightBlue"/></xsl:attribute>
            </xsl:if>
            <td><xsl:number value="position()" format="1"/></td>
            <td><xsl:value-of select="SiteName"/></td>
            <td><xsl:value-of select="BuildName"/></td>
            <td><xsl:value-of select="BuildStamp"/></td>
          </tr>
        </xsl:for-each>
    </table>
    <table>
      <tr>
        <th colspan="4">Color legend</th>
      </tr>
      <tr>
        <td><xsl:attribute name="class">pass</xsl:attribute>Passed</td>
        <td><xsl:attribute name="class">fail</xsl:attribute>Failed</td>
        <td><xsl:attribute name="class">nr</xsl:attribute>Not Run</td>
        <td><xsl:attribute name="class">na</xsl:attribute>Not Applicable</td>
      </tr>
    </table>
  </xsl:template>

  <xsl:template name="BuildCallbacks">
    <xsl:text disable-output-escaping="yes">
<![CDATA[<script type="text/javascript">]]>
    </xsl:text>
    <xsl:for-each select="/TestOverview/Test[1]/Result">
      <xsl:sort select="BuildName"/>
      <xsl:sort select="SiteName"/>
      function t<xsl:value-of select="position()"/>(self,e)
      { 
         showtip(self,e,'<xsl:value-of select="SiteName"/> -- <xsl:value-of select="BuildName"/>');
      }
      function l<xsl:value-of select="position()"/>(testname)
      { 
        var tn = testname;
        tn = tn.replace(/\//g, '_');
        tn = tn.replace(/\./g, '_');

        var newLocation = '../../Sites/<xsl:value-of select="SiteName"/>/<xsl:value-of select="BuildName"/>/<xsl:value-of select="BuildStamp"/>/Results/' + tn + '.html';
        window.location = newLocation;
      }
    </xsl:for-each>
    <xsl:text disable-output-escaping="yes">
<![CDATA[</script>]]>
    </xsl:text>
  </xsl:template>


</xsl:stylesheet>
