<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    version="2.0"
    xmlns:lxslt="http://xml.apache.org/xslt">

  <!--
       Use DashboardStamp as a parameter, default to most recent
       The proper flags to Xalan are in the form -PARAM DashboardStamp "string('foo')"
       -->
  <xsl:output method="html"/>
  <xsl:param name="DashboardPath"/>
  <xsl:param name="DashboardStamp" select="string('MostRecentResults-Nightly')"/>
  <xsl:param name="PreviousDashboardStamp" select="string('')"/>
  <xsl:variable name="DashboardDir" select="concat('../', $DashboardStamp)"/>
  <xsl:variable name="IconDir" select="string('../../Icons')"/>
  <xsl:include href="DashboardConfig.xsl"/>

  <xsl:template match="/">
    <xsl:call-template name="DashboardHeader">
      <xsl:with-param name="Title">Build Overview </xsl:with-param>
      <xsl:with-param name="IconDir">../../Icons</xsl:with-param>
      <xsl:with-param name="UseToolTips">0</xsl:with-param>
      <xsl:with-param name="DashboardDir" select="$DashboardDir"/>
    </xsl:call-template>
    
    <xsl:for-each select="BuildOverview/File">
      <hr>
        <h3><xsl:value-of select="Name"/></h3>
        <h4>Errors:</h4>
        <xsl:for-each select="Comment[Type = 'Error']">
          <b>
            <a>
              <xsl:attribute name="href">../../Sites/<xsl:value-of select="SiteName"/>/<xsl:value-of select="BuildName"/>/<xsl:value-of select="BuildStamp"/>/BuildError.html#<xsl:value-of select="BuildLogLine"/></xsl:attribute>
              <xsl:value-of select="SiteName"/>
            </a>
            <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
          </b>
          <xsl:value-of select="Text"/>
          <br/>
        </xsl:for-each>
        <h4>Warnings:</h4>
        <xsl:for-each select="Comment[Type = 'Warning']">
          <b>
            <a>
              <xsl:attribute name="href">../../Sites/<xsl:value-of select="SiteName"/>/<xsl:value-of select="BuildName"/>/<xsl:value-of select="BuildStamp"/>/BuildWarning.html#<xsl:value-of select="BuildLogLine"/></xsl:attribute>
              <xsl:value-of select="SiteName"/>
            </a>
            <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
          </b>
          <xsl:value-of select="Text"/>
          <br/>
        </xsl:for-each>
      </hr>
    </xsl:for-each>
    <br/>
    <xsl:call-template name="DashboardFooter">
      <xsl:with-param name="IconDir">../../Icons</xsl:with-param>
    </xsl:call-template>
  </xsl:template>


</xsl:stylesheet>
