<?xml version="1.0" encoding="utf-8" ?>
<!-- vim: set sts=2 ai expandtab:

Add tags
 == Table ==
 * title:	added from row[1:1]
 * thead:       added from row[2]
 * tbody:	added from row[3..xx]
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:variable name="uletters">ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789 !#$%()=-~^|\/+*,.?;:@`&quot;&apos;&amp;&gt;&lt;</xsl:variable>
<xsl:variable name="lletters">abcdefghijklmnopqrstuvwxyzabcdefghij</xsl:variable>

<xsl:output method="xml" indent="yes"/>

<!-- xsl:strip-space elements="*"/ -->

<xsl:template match="table">
  <xsl:copy>
    <xsl:attribute name="id">
      <xsl:choose>
        <xsl:when test="string-length(translate(tgroup/tbody/row[1]/entry[1]/para[1],$uletters,$lletters)) &lt;= 32">
          <xsl:value-of select="translate(tgroup/tbody/row[1]/entry[1]/para[1],$uletters,$lletters)"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="concat(substring(translate(tgroup/tbody/row[1]/entry[1]/para[1],$uletters,$lletters),1,16),substring(translate(tgroup/tbody/row[1]/entry[1]/para[1],$uletters,$lletters), string-length(translate(tgroup/tbody/row[1]/entry[1]/para[1],$uletters,$lletters))-15,16))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:attribute>
    <xsl:apply-templates select="@*|node()"/>
  </xsl:copy>
</xsl:template>

<xsl:template match="tgroup">
  <title>
    <xsl:value-of select="tbody/row[1]/entry[1]/para[1]"/>
  </title>
  <xsl:copy>
    <xsl:attribute name="x-pkgname">
      <xsl:value-of select="tbody/row[1]/entry[2]/para[1]"/>
    </xsl:attribute>
    <xsl:attribute name="x-popcon">
      <xsl:value-of select="tbody/row[1]/entry[3]/para[1]"/>
    </xsl:attribute>
    <xsl:attribute name="x-pkgsize">
      <xsl:value-of select="tbody/row[1]/entry[4]/para[1]"/>
    </xsl:attribute>
    <xsl:apply-templates select="@*|node()"/>
  </xsl:copy>
</xsl:template>

<xsl:template match="tbody">
  <thead>
    <xsl:apply-templates select="row[2]"/>
  </thead>
  <xsl:copy>
    <xsl:apply-templates select="row[position() > 2]"/>
  </xsl:copy>
</xsl:template>


<xsl:template match="caption">
</xsl:template>

<xsl:template match="//row[position() > 2]/entry[position() = ../../row[1]/entry[3]/para[1]]">
  <xsl:copy>
    <para>
    <xsl:text disable-output-escaping="yes">&amp;pop-</xsl:text>
    <xsl:value-of select="translate( normalize-space(../entry[position() = ../../row[1]/entry[2]/para[1]]), $uletters, $lletters)"/>
    <xsl:value-of select="';'"/>
    </para>
  </xsl:copy>
</xsl:template>

<xsl:template match="//row[position() > 2]/entry[position() = ../../row[1]/entry[4]/para[1]]">
  <xsl:copy>
    <para>
    <xsl:text disable-output-escaping="yes">&amp;size-</xsl:text>
    <xsl:value-of select="translate( normalize-space(../entry[position() = ../../row[1]/entry[2]/para[1]]), $uletters, $lletters)"/>
    <xsl:value-of select="';'"/>
    </para>
  </xsl:copy>
</xsl:template>

<xsl:template match="@*|node()">
  <xsl:copy>
    <xsl:apply-templates select="@*|node()"/>
  </xsl:copy>
</xsl:template>


</xsl:stylesheet>






