# -*-perl-*-

# $Id: DebianTest.pm,v 1.5 1999/11/14 02:05:08 phil Exp $
# Copyright (c) 1998  Philip Hands <phil@hands.com>
# This file is distributed under the terms of the GPL.

# takes a string and a subroutine reference, mentions that it's running
# the test, runs the function, and prints the result
sub runtest($$) {
  my ($desc, $command) = @_;

  printf "debian-test TESTING: %s\n", $desc ;
  $result = &$command ;
  printf "debian-test RESULT: %s: %s\n", $desc, $result ? "PASSED" : "FAILED" ;
}

sub printmsg {
  ($msg) = @_ ;
  printf "debian-test MESSAGE: %s\n", $_ ;
}

# fails unless permissions exactly match those asked for.
# Can be used thus:  runtest("/tmp", sub { check_perms("/tmp", 041777) } ) ;
sub check_perms($$) {
  my ($target,$perm) = @_; 
  my ($dev,$inode,$mode,@therest) = stat($target) ;
  
  printf "%s's mode = 0%o\n", $target, $mode ;

  return ($perm == $mode)  ;
}

1;

# Local variables:
# perl-indent-level: 2
# End:
__END__
