/**
 * Parse regular expressions and print them in postfix notation.
 * @author Shaun Jackman <sdj@sfu.ca>
 * @copyright Copyright 2004 Shaun Jackman
 */


#include <stdio.h>
#include "regex.h"


/** Maximum length of a token name. */
#define TOKEN_LENGTH 32


/** Name of this program. */
const char* program = "parse-regex";


/** Parse the regular expressions from stdin and print them in postfix
 * notation to stdout. */
int
main()
{
	char token[TOKEN_LENGTH];
	while( fscanf( stdin, "%s ", token) == 1) {
		RegEx* regex = parse_regex( stdin);
		printf( "(%s ", token);
		print_regex( regex);
		puts( ")");
		destroy_regex( regex);
	}
	return 0;
}
