/*
 * Detect a Library for hardware detection
 *
 * Copyright (C) 1998-2000 MandrakeSoft
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  #ifdef HAVE_LIB
 */



#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <sys/ioctl.h>

#include "detect.h"
#include "utils.h"



extern struct soundcard_info *soundcard_detect(struct bus_lst *bus){
  struct pci_info *pci = (struct pci_info *)NULL; 
  struct isa_info *isa = (struct isa_info *)NULL;
  struct soundcard_info *result = (struct soundcard_info *)NULL;
  static struct soundcard_info *first = (struct soundcard_info *)NULL;

  if(first){
    return first;
  }/*endif*/

  if(debug)
    fprintf(stdout, "\nProbing soundcard...\n");

  /********************************************************************/
  /********************** PCI SOUNDCARD DETECTION *********************/
  /********************************************************************/
  if(debug)
    fprintf(stdout, "\tProbing PCI souncardrd...\n");

  if(!kernel_verif(2, 1, 120)){
    for(pci = bus->pci; pci; pci = pci->next){ 
      if(pci->type == SOUNDCARD){
        if(!first){
          first = result = (struct soundcard_info *) 
                               my_malloc(sizeof(struct soundcard_info));
        }else{
          result->next = (struct soundcard_info *) 
                               my_malloc(sizeof(struct soundcard_info));
         result = result->next;
        }/*endif*/
        result->next = (struct soundcard_info *)NULL;
        
        result->vendor = pci->vendor;
        result->model = pci->model;
        result->module = pci->modulename;
        result->long_id = pci->id;
        result->bus = PCI;
        result->options = pci->options;
	if(debug)
	  fprintf(stdout, "\t\tFound %s %s\n", 
		  result->vendor, result->model);
      }/*endif*/
    }/*next pci*/
  }/*endif*/

  /********************************************************************/
  /*********************** ISA SOUNDCARD DETECTION ********************/
  /********************************************************************/
  if(debug)
    fprintf(stdout, "\tProbing ISA PnP soundcard...\n");
  
  for(isa = bus->isa; isa; isa = isa->next){
    if(isa->type == SOUNDCARD){
      if(!first){
        first = result = (struct soundcard_info *) 
          my_malloc(sizeof(struct soundcard_info));
      }else{
        result->next = (struct soundcard_info *) 
          my_malloc(sizeof(struct soundcard_info));
        result = result->next;
      }/*endif*/
      result->next = (struct soundcard_info *)NULL;
      
      result->board_num = isa->board_num;
      result->board_id = isa->board_id;
      result->dev_num = isa->dev_num;
      result->dev_id = isa->dev_id;
      result->vendor = isa->vendor;
      result->model = isa->model;
      result->module = isa->modulename;
      result->bus = ISA;
      result->options = isa->options;
      result->io = isa->io;
      result->irq = isa->irq;
      result->dma8 = isa->dma8;

      if(result->options && HAS_DMA16)
        result->dma16 = isa->dma16;

      if(debug)
	fprintf(stdout, "\t\tFound %s %s\n", 
		result->vendor, result->model);
    }/*endif*/
  }/*next isa*/
  
  return first;
}/*endfunc soundcard_detect*/
