#!/usr/bin/perl
# 
# ddns.pl
# The procedure here is simple.   
#  If a record has been added since the last change, delte any previous
#  mentions and add a new record. This can lead to expired records but this
#  should not be a problem.
#
# Copyright (C) 1999 Stephen Carville
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# use inverse time functions
use Time::Local;
use strict;

my $DEBUG = 0;
my $version="0.50";

# these are the only valid character for a machine name -- used in checkname()
my $NAMECHARS="[a-zA-Z0-9\\-]";

# define the extra filters to apply for machine names -- in checkname()
# these filters allow for extra name filtering if needed. For example, this
# filter only allows "legitimate" names into my employers's DNS 
my $CYPFILTER="cy(pci|pca|hpr|sun)t\\d{2}|\\d{3}";
# these are the active filters -- set this to "" if you don't need any extra
# filters.
my(@filters)=("");

# filter for a bogus ethernet address (look for seven octets :-)
#my $ETHER="\\w\\w:\\w\\w:\\w\\w:\\w\\w:\\w\\w:\\w\\w:\\w\\w";
# lets try filtering on the first two octets of the bogus address this may 
# cause a legitimate address to choke but all the info I can find indicates
# the 52:41 sequence has never been issued to any manufacturer
my $ETHER="\^52:41:";

# nsupdate command strings
my $IFEXIST="prereq yxdomain";
my $IFNOTEXIST="prereq nxdomain";
my $ADD="update add";
my $DELETE="update delete";

# use a default time to live of one hour
my $TTL="3600";

my $LEASE_TEMP="dhcpd.leases.last";
# my $UPDATE="nsupdate.data";

my (%new,%old,$entry,$host,$address,%oldarpa);
my ($nowtime,$lastime,$host);
my ($home,$dhcpd,$update,$dhcpd_temp,$domain);
my (@ddnscommand,@OUTPUT);
my ($dev,$ino,$mode,$nlink,$uid,$gid,$rdev,$size,$atime,$mtime,$ctime,
    $blksize,$blocks);

# get the program environment variables
$home = $ENV{DDNSHOME};
$dhcpd = $ENV{DHCPD};
$update = $ENV{UPDATE};
$dhcpd_temp = $ENV{DHCPD_TEMP};
$domain = $ENV{DNS_DOMAIN};

# get the current GMT
$nowtime=time();
# get last update time;
if (-e "$home/$LEASE_TEMP") {
    ($dev,$ino,$mode,$nlink,$uid,$gid,$rdev,$size,$atime,$mtime,$ctime,
     $blksize,$blocks)=stat("$home/$LEASE_TEMP");
    $lastime=$mtime;
}
else {
    $lastime=0;
}

# now copy the dhcpd.leases file over to DDNSHOME

`cp $dhcpd $dhcpd_temp`;

# get the new data.
%new=load_new_data($nowtime,$lastime);

unless (open OUTPUT, ">$update") {
    print STDERR "Unable to open $update\n";
    die;
}
if ($DEBUG == 1) {
    *OUTPUT=*STDERR;
}

# do the deletes first
foreach $host (keys(%old)) {
  unless (checkname($host)) {
    next;
  }
  @ddnscommand=delete_record($host,$old{$host});
  print OUTPUT @ddnscommand;
}

#foreach $entry (@old) {
#  ($host,$address)=split / / ,$entry;
#  unless (checkname($host)) {
#    next;
#  }
#  @ddnscommand=delete_record($host,$address);
#  print OUTPUT @ddnscommand;
#}

# now do the adds
foreach $host (keys(%new)) {
  unless (checkname($host)) {
    notify($host);
    next;
  }
  @ddnscommand=add_record($host,$new{$host});
  print OUTPUT @ddnscommand;
}

#
# notify someone of an error -- customize this for your own needs
#
sub notify {
  return;
}

#
# check an ethernet id 
# Windows will try to grab multiple addresses.  I can't stop DHCP from 
# granting them but I can make sure only addresses granted to valid 
# ethernet addresses get into the DNS
#
sub checkethid {
  my ($ether)=@_;

  if ($ether =~m/$ETHER/) {
    return 1;
  }
return 0;
}

#
# release an ip address (not done yet)
#
sub releaseip {
  my ($ip)=@_;
}

#
# check a name to see if it is a valid name
# first check the name is FQDN valid then does it fit our
# internal naming policy.  I may add an exception list here later.
# 
sub checkname {
  my ($name)=@_;
  my (@array,$letter,$filter);

  @array=split(//,$name);

  foreach $letter(@array) {
    unless ($letter=~m/$NAMECHARS/) {
      return 0;
    }
  }
  foreach $filter (@filters) {
    unless ($name=~m/$filter/) {
      return 0;
    }
  }
  return 1;
}

# 
# delete a record
#
sub delete_record {
  my ($machine,$address) = @_;
  my ($xaddress,@c,$arpa);

  $machine="$machine.$domain";

# get reverse lookup for the new address
  $arpa=get_arpa($address);
# first delete any existing forward lookup
  push @c, "$IFEXIST $machine\n";
  push @c, "$DELETE $machine\n\n";
# then delete any existing backward lookup
  push @c, "$IFEXIST $arpa\n";
  push @c, "$DELETE $arpa\n\n";

  return @c;
}

#
# add a record
#
sub add_record {
    my ($machine,$address) = @_;
    my ($xaddress,@c,$arpa);

$machine="$machine.$domain";

# get reverse lookup for the new address
    $arpa=get_arpa($address);
# first delete any existing forward lookup
    push @c, "$IFEXIST $machine\n";
    push @c, "$DELETE $machine\n\n";
# then delete any existing backward lookup
    push @c, "$IFEXIST $arpa\n";
    push @c, "$DELETE $arpa\n\n";
# add the new forward record
    push @c, "$ADD $machine $TTL IN A $address\n\n";
# add the new reverse record
    push @c, "$ADD $arpa $TTL IN PTR $machine\n\n";
    return @c;
}

#
# get the reverse lookup value for an address
#
sub get_arpa {
    my ($address) = @_;
    my ($arpa,$a,$b,$c,$d);

   ($a,$b,$c,$d) = split /\./, $address;
    $arpa = "$d.$c.$b.$a.in-addr.arpa";
    return $arpa;
}

# 
# get an address for an existing machine
# 
sub get_address {
    my ($machine) = @_;
    my ($address,$a,$b,$c,$d);

    ($a,$b,$c,$d)= unpack('C4', gethostbyname($machine));
    $address = "$a.$b.$c.$d";
    return $address;
}
#
# load the current dhcpd.leases file
# here we look at the hostname, the lease start time and the lease end time.
# if a hostname does not exist, there will be no entry made in DNS.
sub load_new_data{
    my ($nowtime,$lastime)=@_;
    my(%records,@DATA,$hn,$ip,$startime,$endtime,@date,@time,@a,$bogus);

    unless (open DATA,"$dhcpd_temp") {
	print STDERR "ddns.pl $version: can't open $dhcpd_temp\n";
	die;
    }

# set the bogus ethernet id flag to 0
    $bogus=0;

# parse each line in the file
    while (<DATA>) {

# get rid of semicolons and quote marks
	$_=~s/\"//g;
	$_=~s/\;//g;

	@a=split(" ",$_);
	
# get IP address
	if ($a[0] eq "lease") {
# start of a new entry so reset bogus
	  $bogus=0;
	  $ip= $a[1];
	}

# no point in wasting more time on a bogus entry
#      if ($bogus) {
#	next;
#      }

# get the starting GMT for the lease
	if ($a[0] eq "starts") {
	  @date=split("/",$a[2]);
	  @time=split(":",$a[3]);
	  $startime=timegm($time[2],$time[1],$time[0],$date[2],$date[1]-1,$date[0]);
	}

# get the ending GMT for the lease
	if ($a[0] eq "ends") {
	    @date=split("/",$a[2]);	
	    @time=split(":",$a[3]);
	    $endtime=timegm($time[2],$time[1],$time[0],$date[2],$date[1]-1,$date[0]);
	}

# check if the Ethernet address is legit.  Some Win boxen will request
# multiple addresses using bogus ethernet id's (yuck!)

	if ($a[0] eq "hardware") {
# if it is a bogus address go to the next entry 
	  if (checkethid($a[2])) {
	    $bogus=$a[2];
	    next;
	  }
	}

# since dhcpd adds new leases to the end of the file, it is assumed that 
# a later entry is the most likely to be correct.  Therefore just overwrite 
# any duplicate hostnames found

	if ($a[0] eq "client-hostname") {
	    $hn=lc($a[1]);
# is this lease new and valid? (is it worthwhile here to check for bogosity?)
	    if ($startime > $lastime && $endtime >= $nowtime) {
	      unless ($bogus) {
		$records{$hn} = $ip;
	      }
#	      else {
#		print "$hn, $ip, $bogus\n";
#	      }
	    }

# is it an expired lease? was it deleted on the last update? (probably should 
# fix this to not use a global variable -- someday :-)
	    if ($endtime < $nowtime && $endtime > $lastime) {
	      $old{$hn}=$ip;
	    }
	}
    }
    close DATA;
    return %records;
}
