/*
   (c) Copyright 2000-2002  convergence integrated media GmbH.
   (c) Copyright 2002       convergence GmbH.
   
   All rights reserved.

   Written by Denis Oliver Kropp <dok@directfb.org>,
              Andreas Hundt <andi@fischlustig.de> and
              Sven Neumann <sven@convergence.de>.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef __FUSION_H__
#define __FUSION_H__

#ifdef __cplusplus
extern "C"
{
#endif

#include "fusion_types.h"


/*
 * Initializes fusion and returns the fusion id or -1 on failure.
 */
int fusion_init( int world, int *world_ret );

/*
 * Deinitializes fusion.
 */
void fusion_exit();

/*
 * Return the current Fusion ID.
 */
int fusion_id();

/*
 * Sends a signal to one or more fusionees and optionally waits
 * for their processes to terminate.
 *
 * A fusion_id of zero means all fusionees but the calling one.
 * A timeout of zero means infinite waiting while a negative value
 * means no waiting at all.
 */
FusionResult fusion_kill( int fusion_id, int signal, int timeout_ms );

/*
 * Get the number of milliseconds passed after the start of the master.
 */
long long fusion_get_millis();


#ifdef __cplusplus
}
#endif

#endif /* __FUSION_H__ */

