/*
   (c) Copyright 2001-2007  The DirectFB Organization (directfb.org)
   (c) Copyright 2000-2004  Convergence (integrated media) GmbH

   All rights reserved.

   Written by Denis Oliver Kropp <dok@directfb.org>,
              Andreas Hundt <andi@fischlustig.de>,
              Sven Neumann <neo@directfb.org>,
              Ville Syrjälä <syrjala@sci.fi> and
              Claudio Ciccani <klan@users.sf.net>.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef __IDIRECTFB_H__
#define __IDIRECTFB_H__

#include <directfb.h>

#include <fusion/reactor.h>

#include <core/coretypes.h>

/*
 * private data struct of IDirectFB
 */
typedef struct {
     int                         ref;      /* reference counter */
     CoreDFB                    *core;

     DFBCooperativeLevel         level;    /* current cooperative level */

     CoreLayer                  *layer;    /* primary display layer */
     CoreLayerContext           *context;  /* shared context of primary layer */
     CoreWindowStack            *stack;    /* window stack of primary layer */

     struct {
          int                    width;    /* IDirectFB stores window width    */
          int                    height;   /* and height and the pixel depth   */
          DFBSurfacePixelFormat  format;   /* from SetVideoMode() parameters.  */

          CoreWindow            *window;   /* implicitly created window */
          Reaction               reaction; /* for the focus listener */
          bool                   focused;  /* primary's window has the focus */

          CoreLayerContext      *context;  /* context for fullscreen primary */
     } primary;                            /* Used for DFSCL_NORMAL's primary. */

     bool                        app_focus;
} IDirectFB_data;

/*
 * IDirectFB constructor/destructor
 */
DFBResult IDirectFB_Construct  ( IDirectFB  *thiz,
                                 CoreDFB    *core );

void      IDirectFB_Destruct   ( IDirectFB  *thiz );

DFBResult IDirectFB_SetAppFocus( IDirectFB  *thiz,
                                 DFBBoolean  focused );


extern IDirectFB *idirectfb_singleton;

#endif
