#
# mountnfs.sh	Now that TCP/IP is configured, mount the NFS file
#		systems in /etc/fstab if needed. If possible,
#		start the portmapper before mounting (this is needed for
#		Linux 2.1.x and up).
#
# Version:	@(#)mountnfs.sh  1.11  05-Oct-1998  miquels@cistron.nl
#

# modified for diskless-image, secure mode, 1999-09-20

. /etc/default/rcS

#
#	Run in a subshell because of I/O redirection.
#
test -f /etc/fstab && (

#
#	Read through fstab line by line. If it is NFS, set the flag
#	for mounting NFS file systems. If any NFS partition is found and it
#	not mounted with the nolock option, we start the portmapper.
#
portmap=no
mount_nfs=no
while read device mountpt fstype options
do
	if [ "$fstype" = nfs ]
	then
		mount_nfs=yes
		case "$options" in
			*nolock*)
				;;
			*)
				portmap=yes
				;;
		esac
	fi
done

exec 0>&1

if [ "$portmap" = yes ]
then
	if [ -x /sbin/portmap ]
	then
		echo -n "Starting portmapper... "
		start-stop-daemon --start --quiet --exec /sbin/portmap
		sleep 2
	fi
fi

if [ "$mount_nfs" = yes ]
then
	echo "Mounting remote filesystems..."
	mount -a -t nfs
	# DON'T MOUNT RW YET!!! IT WILL MAKE /DEV UNACCESSIBLE!!!
	umount /rw
fi

) < /etc/fstab

