#ifndef _CDDA_STREAM_SOURCE_H_INCLUDED
#define _CDDA_STREAM_SOURCE_H_INCLUDED

#include "config.h"

#ifdef HAVE_LIBCDDA_PARANOIA

#include "jack.h"
#include <pthread.h>
extern "C" {
#include <cdda_interface.h>
#include <cdda_paranoia.h>
}

#define PREBUFFER 256

class CDDAStreamSource : public StreamSource
{
Q_OBJECT

public:
	CDDAStreamSource(QWidget *dest);
	~CDDAStreamSource();

	int attach(QString name);
	int get_buffer(char *, int);
	int play(unsigned long start_frame, unsigned long samples, bool loop=false);
	int stop(void);
	void exit_loop(void);
	StreamSource *get_source(void);
	void prefetch();
	virtual void generate_wave(void);
	virtual void get_wave_pixmap(QPixmap *pm, int display_width);
	virtual bool can_do_multiple_reads();
private:
	void bumpCDRom();
	static pthread_mutex_t cdlock;
	void fillBuffer(void);
	cdrom_drive *drive;
	cdrom_paranoia *p;
	int track;
	int sector;
	int offset;
	int buffer_first_sector;
	int secs_in_buffer;
	short buffer[CD_FRAMESAMPLES * PREBUFFER * 2];
	unsigned sample_pos;
	QString device;
};
#endif /* HAVE_LIBCDDA_PARANOIA */
#endif
