/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/

#include "config.h"
#include <qdir.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <stdlib.h>
#include <unistd.h>
#include "cfgfile.h"
#include <qrangecontrol.h>
#include <qspinbox.h>
#include "newconfigdlg.h"
#include <qlistbox.h>
#include <qmessagebox.h>

#ifdef HAVE_LIBXML2
#include <libxml/xmlmemory.h>
#include <libxml/parser.h>

xmlNodePtr root;
xmlNodePtr background_node;
xmlNodePtr logpath_node;
xmlNodePtr logfile_node;
xmlNodePtr loglevel_node;
xmlNodePtr consolelog_node;
xmlNodePtr stream_node;
xmlNodePtr stream_metadata_node;
xmlNodePtr stream_input_node;
xmlNodePtr stream_input_module_node;
xmlNodePtr stream_input_metadata_node;
xmlNodePtr stream_input_metadatafilename_node;
xmlNodePtr stream_input_rate_node;
xmlNodePtr stream_input_channels_node;
xmlNodePtr stream_instance_node;
xmlNodePtr stream_metadata_name_node;
xmlNodePtr stream_metadata_genre_node;
xmlNodePtr stream_metadata_description_node;
xmlNodePtr stream_instance_hostname_node;
xmlNodePtr stream_instance_port_node;
xmlNodePtr stream_instance_password_node;
xmlNodePtr stream_instance_mount_node;
xmlNodePtr stream_instance_yp_node;
xmlNodePtr stream_instance_downmix_node;
xmlNodePtr stream_instance_encode_node;
xmlNodePtr stream_instance_resample_node;
xmlNodePtr stream_instance_encode_quality_node;
xmlNodePtr stream_instance_encode_samplerate_node;
xmlNodePtr stream_instance_encode_channels_node;
xmlNodePtr stream_instance_encode_managed_node;
xmlNodePtr stream_instance_encode_nominalbitrate_node;
xmlNodePtr stream_instance_encode_minimumbitrate_node;
xmlNodePtr stream_instance_encode_maximumbitrate_node;
xmlNodePtr stream_instance_resample_inrate_node;
xmlNodePtr stream_instance_resample_outrate_node;
#endif

void IceDlg::init()
{
    subdlg=new AdvancedIcecastDlg(this, 0, true);
    cfg=0;
    readConfigNames();
    if(ConfigName->count() < 1)
	Details->setEnabled(false);
    else
    {
	parseConfig();
	showData();
    }
}



void IceDlg::readConfigNames()
{
#ifdef HAVE_LIBXML2
    char *home=getenv("HOME");
    if(!home)
	return;
    QString dirname=(QString)home + "/" + "icesconfig";
    mkdir(dirname, 0700);
    QDir confdir(dirname, "*.xml", QDir::Name | QDir::IgnoreCase, QDir::Files);
    QStringList filelist=confdir.entryList();
    ConfigName->insertStringList(filelist);
#endif
}


void IceDlg::parseConfig()
{
#ifdef HAVE_LIBXML2
    root=0;
    background_node=0;
    logpath_node=0;
    logfile_node=0;
    loglevel_node=0;
    consolelog_node=0;
    stream_node=0;
    stream_metadata_node=0;
    stream_metadata_name_node=0;
    stream_metadata_genre_node=0;
    stream_metadata_description_node=0;
    stream_input_node=0;
    stream_input_module_node=0;
    stream_input_metadata_node=0;
    stream_input_metadatafilename_node=0;
    stream_input_rate_node=0;
    stream_input_channels_node=0;
    stream_instance_node=0;
    stream_instance_hostname_node=0;
    stream_instance_port_node=0;
    stream_instance_password_node=0;
    stream_instance_mount_node=0;
    stream_instance_yp_node=0;
    stream_instance_downmix_node=0;
    stream_instance_encode_node=0;
    stream_instance_encode_quality_node=0;
    stream_instance_encode_samplerate_node=0;
    stream_instance_encode_channels_node=0;
    stream_instance_encode_managed_node=0;
    stream_instance_encode_nominalbitrate_node=0;
    stream_instance_encode_minimumbitrate_node=0;
    stream_instance_encode_maximumbitrate_node=0;
    stream_instance_resample_node=0;
    stream_instance_resample_inrate_node=0;
    stream_instance_resample_outrate_node=0;
    
    char *home=getenv("HOME");
    if(!home)
	return;
    QString fname=(QString)home + "/" + "icesconfig/"+ConfigName->currentText();
    
    xmlDocPtr doc;
    xmlInitParser();
    doc=xmlParseFile(fname);
    if(!doc)
    {
	Details->setEnabled(false);
	return;
    }
    cfg=(void *)doc;
    
    root=xmlDocGetRootElement(doc);
    if(!root || strcmp((char *)root->name, "ices"))
    {
	xmlFreeDoc(doc);
	cfg=0;
	Details->setEnabled(false);
	return;
    }
    
    active_file=fname;
    
    xmlNodePtr node=root->xmlChildrenNode;
    
    for(;node;node=node->next)
    {
	if(xmlIsBlankNode(node))
	    continue;
	if(!strcmp((char *)node->name, "background"))
	    background_node=node;
	if(!strcmp((char *)node->name, "logpath"))
	    logpath_node=node;
	if(!strcmp((char *)node->name, "logfile"))
	    logfile_node=node;
	if(!strcmp((char *)node->name, "loglevel"))
	    loglevel_node=node;
	if(!strcmp((char *)node->name, "consolelog"))
	    consolelog_node=node;
	if(!strcmp((char *)node->name, "stream") && stream_node == 0)
	{
	    stream_node=node;
	    parseStream((void *)node->xmlChildrenNode);
	}
    }
    fixupConfig();
#endif    
}


void IceDlg::destroy()
{
#ifdef HAVE_LIBXML2
    if(cfg)
    {
	saveData();
	xmlDocPtr doc=(xmlDocPtr)cfg;
	xmlSaveFile(active_file, doc);
	xmlFreeDoc(doc);
    }
    cfg=0;
    if(subdlg)
	delete subdlg;
    subdlg=0;
#endif    
}


void IceDlg::parseStream( void *p )
{
#ifdef HAVE_LIBXML2
    xmlNodePtr node=(xmlNodePtr)p;
    
    for(;node;node=node->next)
    {
	if(xmlIsBlankNode(node))
	    continue;
	if(!strcmp((char *)node->name, "metadata") && !stream_metadata_node)
	{
	    stream_metadata_node=node;
	    parseMetadata((void *)node->xmlChildrenNode);
	}
	if(!strcmp((char *)node->name, "input") && !stream_input_node)
	{
	    stream_input_node=node;
	    parseInput((void *)node->xmlChildrenNode);
	}
	if(!strcmp((char *)node->name, "instance") && !stream_instance_node)
	{
	    stream_instance_node=node;
	    parseInstance((void *)node->xmlChildrenNode);
	}
    }
#endif
}


void IceDlg::parseMetadata( void *p )
{
#ifdef HAVE_LIBXML2
    xmlNodePtr node=(xmlNodePtr)p;
    
    for(;node;node=node->next)
    {
	if(xmlIsBlankNode(node))
	    continue;
	if(!strcmp((char *)node->name, "name"))
	    stream_metadata_name_node=node;
	if(!strcmp((char *)node->name, "genre"))
	    stream_metadata_genre_node=node;
	if(!strcmp((char *)node->name, "description"))
	    stream_metadata_description_node=node;
    }
#endif
}


void IceDlg::parseInput( void *p )
{
#ifdef HAVE_LIBXML2
    xmlNodePtr node=(xmlNodePtr)p;
    
    for(;node;node=node->next)
    {
	if(xmlIsBlankNode(node))
	    continue;
	if(!strcmp((char *)node->name, "module"))
	    stream_input_module_node=node;
	if(!strcmp((char *)node->name, "param"))
	{
	    char *name=(char *)xmlGetProp(node, (xmlChar *)"name");
	    if(!name)
		continue;
	    if(!strcmp(name, "metadata"))
		stream_input_metadata_node=node;
	    if(!strcmp(name, "metadatafilename"))
		stream_input_metadatafilename_node=node;
	    if(!strcmp(name, "rate"))
		stream_input_rate_node=node;
	    if(!strcmp(name, "channels"))
		stream_input_channels_node=node;
	    xmlFree((xmlChar *)name);
	}
    }
#endif
}


void IceDlg::parseInstance( void *p )
{
#ifdef HAVE_LIBXML2
    xmlNodePtr node=(xmlNodePtr)p;
    
    for(;node;node=node->next)
    {
	if(xmlIsBlankNode(node))
	    continue;
	if(!strcmp((char *)node->name, "hostname"))
	    stream_instance_hostname_node=node;
	if(!strcmp((char *)node->name, "port"))
	    stream_instance_port_node=node;
	if(!strcmp((char *)node->name, "password"))
	    stream_instance_password_node=node;
	if(!strcmp((char *)node->name, "mount"))
	    stream_instance_mount_node=node;
	if(!strcmp((char *)node->name, "yp"))
	    stream_instance_yp_node=node;
	if(!strcmp((char *)node->name, "downmix"))
	    stream_instance_downmix_node=node;
	if(!strcmp((char *)node->name, "encode") && !stream_instance_encode_node)
	{
	    stream_instance_encode_node=node;
	    parseEncode((void *)node->xmlChildrenNode);
	}
	if(!strcmp((char *)node->name, "resample") && !stream_instance_resample_node)
	{
	    stream_instance_resample_node=node;
	    parseResample((void *)node->xmlChildrenNode);
	}
    }
#endif
}


void IceDlg::parseEncode( void *p )
{
#ifdef HAVE_LIBXML2
    xmlNodePtr node=(xmlNodePtr)p;
    
    for(;node;node=node->next)
    {
	if(xmlIsBlankNode(node))
	    continue;
	if(!strcmp((char *)node->name, "quality"))
	    stream_instance_encode_quality_node=node;
	if(!strcmp((char *)node->name, "samplerate"))
	    stream_instance_encode_samplerate_node=node;
	if(!strcmp((char *)node->name, "channels"))
	    stream_instance_encode_channels_node=node;
	if(!strcmp((char *)node->name, "managed"))
	    stream_instance_encode_managed_node=node;
	if(!strcmp((char *)node->name, "nominal-bitrate"))
	    stream_instance_encode_nominalbitrate_node=node;
	if(!strcmp((char *)node->name, "minimum-bitrate"))
	    stream_instance_encode_minimumbitrate_node=node;
	if(!strcmp((char *)node->name, "maximum-bitrate"))
	    stream_instance_encode_maximumbitrate_node=node;
    }
#endif
}



void IceDlg::parseResample( void * p)
{
#ifdef HAVE_LIBXML2
    xmlNodePtr node=(xmlNodePtr)p;
    
    for(;node;node=node->next)
    {
	if(xmlIsBlankNode(node))
	    continue;
	if(!strcmp((char *)node->name, "in-rate"))
	    stream_instance_resample_inrate_node=node;
	if(!strcmp((char *)node->name, "out-rate"))
	    stream_instance_resample_outrate_node=node;
    }
#endif
}


void IceDlg::fixupConfig()
{
#ifdef HAVE_LIBXML2
    xmlDocPtr doc=(xmlDocPtr)cfg;
    
    if(!background_node)
	background_node=xmlNewTextChild(root, NULL, (xmlChar *)"background", (xmlChar *)"0");
    if(!logpath_node)
	logpath_node=xmlNewTextChild(root, NULL, (xmlChar *)"logpath", (xmlChar *)"/tmp");
    if(!logfile_node)
	logfile_node=xmlNewTextChild(root, NULL, (xmlChar *)"logfile", (xmlChar *)"ices.log");
    if(!loglevel_node)
	loglevel_node=xmlNewTextChild(root, NULL, (xmlChar *)"loglevel", (xmlChar *)"4");
    if(!consolelog_node)
	consolelog_node=xmlNewTextChild(root, NULL, (xmlChar *)"consolelog", (xmlChar *)"1");

    if(!stream_node)
	stream_node=xmlNewTextChild(root, NULL, (xmlChar *)"stream", (xmlChar *)"");
    
    if(!stream_metadata_node)
	stream_metadata_node=xmlNewTextChild(stream_node, NULL, (xmlChar *)"metadata", (xmlChar *)"");
    
    if(!stream_metadata_name_node)
	stream_metadata_name_node=xmlNewTextChild(stream_metadata_node, NULL, (xmlChar *)"name", (xmlChar *)"");
    if(!stream_metadata_genre_node)
	stream_metadata_genre_node=xmlNewTextChild(stream_metadata_node, NULL, (xmlChar *)"genre", (xmlChar *)"");
    if(!stream_metadata_description_node)
	stream_metadata_description_node=xmlNewTextChild(stream_metadata_node, NULL, (xmlChar *)"description", (xmlChar *)"");
    
    if(!stream_input_node)
	stream_input_node=xmlNewTextChild(stream_node, NULL, (xmlChar *)"input", (xmlChar *)"");
    
    if(!stream_input_module_node)
	stream_input_module_node=xmlNewTextChild(stream_input_node, NULL, (xmlChar *)"module", (xmlChar *)"stdinpcm");
    else
	xmlNodeSetContent(stream_input_module_node, (xmlChar *)"stdinpcm");
    
    if(!stream_input_metadata_node)
    {
	stream_input_metadata_node=xmlNewTextChild(stream_input_node, NULL, (xmlChar *)"param", (xmlChar *)"");
	xmlNewProp(stream_input_metadata_node, (xmlChar *)"name", (xmlChar *)"metadata");
    }
    xmlNodeSetContent(stream_input_metadata_node, (xmlChar *)"1");
    
    if(!stream_input_metadatafilename_node)
    {
	stream_input_metadatafilename_node=xmlNewTextChild(stream_input_node, NULL, (xmlChar *)"param", (xmlChar *)"");
	xmlNewProp(stream_input_metadatafilename_node, (xmlChar *)"name", (xmlChar *)"metadatafilename");
    }
    QString val=config->getValue("MetadataFile", "");
    xmlNodeSetContent(stream_input_metadatafilename_node, (const xmlChar *)(const char *)val);
    
    if(!stream_input_rate_node)
    {
	stream_input_rate_node=xmlNewTextChild(stream_input_node, NULL, (xmlChar *)"param", (xmlChar *)"");
	xmlNewProp(stream_input_rate_node, (xmlChar *)"name", (xmlChar *)"rate");
    }
    xmlNodeSetContent(stream_input_rate_node, (xmlChar *)"44100");
    
    if(!stream_input_channels_node)
    {
	stream_input_channels_node=xmlNewTextChild(stream_input_node, NULL, (xmlChar *)"param", (xmlChar *)"");
	xmlNewProp(stream_input_channels_node, (xmlChar *)"name", (xmlChar *)"channels");
    }
    xmlNodeSetContent(stream_input_channels_node, (xmlChar *)"2");
    
    if(!stream_instance_node)
	stream_instance_node=xmlNewTextChild(stream_node, NULL, (xmlChar *)"instance", (xmlChar *)"");
    
    if(!stream_instance_hostname_node)
	stream_instance_hostname_node=xmlNewTextChild(stream_instance_node, NULL, (xmlChar *)"hostname", (xmlChar *)"localhost");
    
    if(!stream_instance_port_node)
	stream_instance_port_node=xmlNewTextChild(stream_instance_node, NULL, (xmlChar *)"port", (xmlChar *)"8000");
    
    if(!stream_instance_password_node)
	stream_instance_password_node=xmlNewTextChild(stream_instance_node, NULL, (xmlChar *)"password", (xmlChar *)"");
    
    if(!stream_instance_mount_node)
	stream_instance_mount_node=xmlNewTextChild(stream_instance_node, NULL, (xmlChar *)"mount", (xmlChar *)"");
    
    if(!stream_instance_yp_node)
	stream_instance_yp_node=xmlNewTextChild(stream_instance_node, NULL, (xmlChar *)"yp", (xmlChar *)"0");
    
    if(!stream_instance_downmix_node)
	stream_instance_downmix_node=xmlNewTextChild(stream_instance_node, NULL, (xmlChar *)"downmix", (xmlChar *)"0");
    
    if(!stream_instance_encode_node)
	stream_instance_encode_node=xmlNewTextChild(stream_instance_node, NULL, (xmlChar *)"encode", (xmlChar *)"");
    
    if(!stream_instance_encode_quality_node)
	stream_instance_encode_quality_node=xmlNewTextChild(stream_instance_encode_node, NULL, (xmlChar *)"quality", (xmlChar *)"0");
    
    if(!stream_instance_encode_samplerate_node)
	stream_instance_encode_samplerate_node=xmlNewTextChild(stream_instance_encode_node, NULL, (xmlChar *)"samplerate", (xmlChar *)"44100");
    
    if(!stream_instance_encode_channels_node)
	stream_instance_encode_channels_node=xmlNewTextChild(stream_instance_encode_node, NULL, (xmlChar *)"channels", (xmlChar *)"2");
    
    if(!stream_instance_encode_managed_node)
	stream_instance_encode_managed_node=xmlNewTextChild(stream_instance_encode_node, NULL, (xmlChar *)"managed", (xmlChar *)"0");
    
    if(!stream_instance_encode_nominalbitrate_node)
	stream_instance_encode_nominalbitrate_node=xmlNewTextChild(stream_instance_encode_node, NULL, (xmlChar *)"nominal-bitrate", (xmlChar *)"");
    
    if(!stream_instance_encode_minimumbitrate_node)
	stream_instance_encode_minimumbitrate_node=xmlNewTextChild(stream_instance_encode_node, NULL, (xmlChar *)"minimum-bitrate", (xmlChar *)"");
    
    if(!stream_instance_encode_maximumbitrate_node)
	stream_instance_encode_maximumbitrate_node=xmlNewTextChild(stream_instance_encode_node, NULL, (xmlChar *)"maximum-bitrate", (xmlChar *)"");
    
    if(!stream_instance_resample_node)
	stream_instance_resample_node=xmlNewTextChild(stream_instance_node, NULL, (xmlChar *)"resample", (xmlChar *)"");
    
    if(!stream_instance_resample_inrate_node)
	stream_instance_resample_inrate_node=xmlNewTextChild(stream_instance_resample_node, NULL, (xmlChar *)"in-rate", (xmlChar *)"0");
    
    if(!stream_instance_resample_outrate_node)
	stream_instance_resample_outrate_node=xmlNewTextChild(stream_instance_resample_node, NULL, (xmlChar *)"out-rate", (xmlChar *)"0");
    
#endif
}


void IceDlg::showData()
{
#ifdef HAVE_LIBXML2
    showText(Title, stream_metadata_name_node);
    showText(Genre, stream_metadata_genre_node);
    showText(subdlg->Description, stream_metadata_description_node);
    showText(ServerHost, stream_instance_hostname_node);
    showText(ServerPort, stream_instance_port_node);
    showText(ServerMount, stream_instance_mount_node);
    showText(Password, stream_instance_password_node);
    showText(subdlg->MinimumBitrate, stream_instance_encode_minimumbitrate_node);
    showText(subdlg->MaximumBitrate, stream_instance_encode_maximumbitrate_node);
    showText(subdlg->NominalBitrate, stream_instance_encode_nominalbitrate_node);
    showText(subdlg->Samplerate, stream_instance_encode_samplerate_node);
    showNumber(subdlg->Quality, stream_instance_encode_quality_node);
    showNumber(subdlg->Channels, stream_instance_encode_channels_node);
    showCheck(Public, stream_instance_yp_node);
    showCheck(subdlg->Managed, stream_instance_encode_managed_node);
#endif
}


void IceDlg::showText( QLineEdit *edit, void *p )
{
#ifdef HAVE_LIBXML2
    xmlNodePtr node=(xmlNodePtr)p;
    xmlChar *text=xmlNodeGetContent(node);
    if(text)
    {
	edit->setText((char *)text);
	xmlFree(text);
    }
    else
	edit->setText("");
#endif
}


void IceDlg::saveData()
{
#ifdef HAVE_LIBXML2
    setNodeText(stream_metadata_name_node, Title->text(), false);
    setNodeText(stream_metadata_genre_node, Genre->text(), false);
    setNodeText(stream_instance_hostname_node, ServerHost->text(), false);
    setNodeText(stream_instance_port_node, ServerPort->text(), false);
    setNodeText(stream_instance_mount_node, ServerMount->text(), false);
    setNodeText(stream_instance_password_node, Password->text(), false);
    setNodeText(stream_instance_encode_nominalbitrate_node, subdlg->NominalBitrate->text(), true);
    setNodeText(stream_instance_encode_minimumbitrate_node, subdlg->MinimumBitrate->text(), true);
    setNodeText(stream_instance_encode_maximumbitrate_node, subdlg->MaximumBitrate->text(), true);
    setNodeText(stream_metadata_description_node, subdlg->Description->text(), false);
    setNodeText(stream_instance_encode_samplerate_node, subdlg->Samplerate->text(), false);
    setNodeText(stream_instance_encode_quality_node, subdlg->Quality->cleanText(), false);
    setNodeText(stream_instance_encode_channels_node, subdlg->Channels->cleanText(), false);
    if(subdlg->Managed->isChecked())
	setNodeText(stream_instance_encode_managed_node, "1", false);
    else
	setNodeText(stream_instance_encode_managed_node, "0", false);
    if(Public->isChecked())
	setNodeText(stream_instance_yp_node, "1", false);
    else
	setNodeText(stream_instance_yp_node, "0", false);
    if(subdlg->Samplerate->text() != "44100")
    {
	setNodeText(stream_instance_resample_inrate_node, "44100", false);
	setNodeText(stream_instance_resample_outrate_node, subdlg->Samplerate->text(), false);
    }
    else
    {
	setNodeText(stream_instance_resample_inrate_node, "0", false);
	setNodeText(stream_instance_resample_outrate_node, "0", false);
    }
    if(subdlg->Channels->value() != 2)
	setNodeText(stream_instance_downmix_node, "1", false);
    else
	setNodeText(stream_instance_downmix_node, "0", false);
#endif
}


void IceDlg::setNodeText( void *p, const char *text, bool unlink )
{
#ifdef HAVE_LIBXML2
    xmlNodePtr node=(xmlNodePtr)p;
    xmlNodeSetContent(node, (const xmlChar *)text);
    if(!(*text) && unlink)
    {
	xmlUnlinkNode(node);
	xmlFreeNode(node);
    }
#endif
}


void IceDlg::ADvanced_clicked()
{
    subdlg->exec();
}


void IceDlg::showNumber( QRangeControl *c, void *p )
{
#ifdef HAVE_LIBXML2
    xmlNodePtr node=(xmlNodePtr)p;
    xmlChar *text=xmlNodeGetContent(node);
    if(text)
    {
	c->setValue(atoi((char *)text));
	xmlFree(text);
    }
    else
	c->setValue(0);
#endif
}


void IceDlg::showCheck( QCheckBox *box, void *p )
{
#ifdef HAVE_LIBXML2
    xmlNodePtr node=(xmlNodePtr)p;
    xmlChar *text=xmlNodeGetContent(node);
    if(text)
    {
	box->setChecked(atoi((char *)text));
	xmlFree(text);
    }
    else
	box->setChecked(false);
#endif

}


void IceDlg::ConfigName_activated( const QString & conf)
{
#ifdef HAVE_LIBXML2
    if(cfg)
    {
	saveData();
	xmlDocPtr doc=(xmlDocPtr)cfg;
	xmlSaveFile(active_file, doc);
	xmlFreeDoc(doc);
    }
    cfg=0;
    Details->setEnabled(true);
    parseConfig();
    showData();
#endif
}


void IceDlg::Add_clicked()
{
#ifdef HAVE_LIBXML2
    NewConfigDlg dlg(this, 0, true);
    
    if(!dlg.exec())
	return;
    QString name=dlg.Name->text();
    if(name.find(".xml") == -1)
	name+=".xml";
    ConfigName->insertItem(name);
    if(cfg)
    {
	saveData();
	xmlDocPtr doc=(xmlDocPtr)cfg;
	xmlSaveFile(active_file, doc);
	xmlFreeDoc(doc);
    }
    cfg=0;
    xmlDocPtr doc=xmlNewDoc((xmlChar *)"1.0");
    xmlDocSetRootElement(doc, xmlNewNode(NULL, (xmlChar *)"ices"));
    char *home=getenv("HOME");
    if(!home)
	return;
    QString fname=(QString)home + "/" + "icesconfig/"+name;
    xmlSaveFile(fname, doc);
    xmlFree(doc);
    ConfigName->setCurrentItem(ConfigName->listBox()->index(ConfigName->listBox()->findItem(name)));
    Details->setEnabled(true);
    parseConfig();
    showData();
#endif
}


void IceDlg::Remove_clicked()
{
#ifdef HAVE_LIBXML2
    QString name=ConfigName->currentText();
    
    if(name == "" || name == QString::null)
	return;
    
    if(QMessageBox::warning(this, "Confirm delete", "Do you really want to delete the selected configuration?", "Yes", "No", 0, 0, 1) != 0)
	return;
    
    if(cfg)
    {
	saveData();
	xmlDocPtr doc=(xmlDocPtr)cfg;
	xmlSaveFile(active_file, doc);
	xmlFreeDoc(doc);
    }
    cfg=0;
    
    char *home=getenv("HOME");
    if(!home)
	return;
    QString fname=(QString)home + "/" + "icesconfig/"+name;
    unlink(fname);
    
    ConfigName->removeItem(ConfigName->listBox()->index(ConfigName->listBox()->findItem(name)));
    if(ConfigName->currentText() == "" || ConfigName->currentText() == QString::null)
	Details->setEnabled(false);
    else
    {
	Details->setEnabled(true);
	parseConfig();
	showData();
    }
#endif    
}


void IceDlg::setStreamDlg( StreamDlg *d )
{
    sd=d;
}


void IceDlg::StreamSetup_clicked()
{
#ifdef HAVE_LIBXML2
    QString name=ConfigName->currentText();
    
    if(name == "" || name == QString::null)
	return;
    
    char *home=getenv("HOME");
    if(!home)
	return;
    QString fname=(QString)home + "/" + "icesconfig/"+name;
    QString cmd=(QString)"ices "+fname;
    
    sd->BroadcastPipeline->setText(cmd);
#endif    
}
