/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename slots use Qt Designer which will
** update this file, preserving your code. Create an init() slot in place of
** a constructor, and a destroy() slot in place of a destructor.
*****************************************************************************/

#include <stdio.h>
#include <time.h>
#include <string.h>
#include "mixer-background.xpm"
#include "cfgfile.h"
#include <qlineedit.h>
#include <qcheckbox.h>
#include "plugins/bitmapbutton/bitmapbutton.h" 
#include "plugins/bitmapslider/bitmapslider.h" 
#include "jacklow.h"
#include "config.h"
#ifdef HAVE_LIBXML2
#include "icedlg.h"
#endif

void Mixer::init()
{
    background=new QPixmap((const char **)mixer_background_xpm);
    Frame *frame=(Frame*)parent();
    connect(frame->player(0), SIGNAL(timeWarning(int)), this, SLOT(timeWarning(int)));
    connect(frame->player(1), SIGNAL(timeWarning(int)), this, SLOT(timeWarning(int)));
    
    xfadeMode=0;
    xfadeTime=config->getValue("XFadeTime", "50").toInt();
    xfadePreRoll=config->getValue("XFadePreRoll", "5").toInt();
    xfadePostRoll=config->getValue("XFadePostRoll", "20").toInt();
    xfadeRandom=false;
    
    frame->player(0)->setWarnTime(xfadePostRoll+xfadePreRoll);
    frame->player(1)->setWarnTime(xfadePostRoll+xfadePreRoll);
    
    xfadeTimer=new QTimer(this);
    connect(xfadeTimer, SIGNAL(timeout()), this, SLOT(xfadeTimeout()));
    XFader->setValue(100);
    VideoXFader->setValue(50);
    
    preRollTimer=new QTimer(this);
    connect(preRollTimer, SIGNAL(timeout()), this, SLOT(preRollTimeout()));
}

void Mixer::destroy()
{
    delete background;
}

void Mixer::closeEvent(QCloseEvent *e)
{
    e->ignore();
}


void Mixer::XFader_valueChanged( int val )
{
    Frame *frame=(Frame*)parent();
    frame->player(0)->setAttenuation((double)xfadeTranslate(val)/100.0);
    frame->player(1)->setAttenuation((double)xfadeTranslate(200-val)/100.0);
    if(AudioXFaderOn->isOn())
		VideoXFader->setValue(val/2);
}

void Mixer::timeWarning(int p)
{
    if(!Auto->isOn())
	return;
    --p;
    int o=1-p;
    Frame *frame=(Frame*)parent();
    frame->player(o)->PlayMeta_clicked();
    preRollTimer->start(xfadePreRoll*1000, true);
    xfadeFrom=p;
}

void Mixer::xfadeTimeout()
{
    int val=VideoXFader->value();
    
    val+=xfadeStep;
    if(val < 0)
	val=0;
    if(val > 100)
	val=100;
    if(val == 0 || val == 100)
    {
	xfadeTimer->stop();
	if(Auto->isOn())
	{
	    frame->player(xfadeFrom)->CueButton_clicked();
	    if(!frame->player(xfadeFrom)->load_next(xfadeRandom))
		Auto->toggle();
	}
    }
    if(AudioXFaderOn->isOn())
	XFader->setValue(val*2);
    VideoXFader->setValue(val);
}


void Mixer::FadeNow_clicked()
{
    int val=VideoXFader->value();
    if(Auto->isOn())
    {
	if(preRollTimer->isActive() || xfadeTimer->isActive())
	    return;
	if(val < 100)
	    timeWarning(1);
	else
	    timeWarning(2);
	return;
    }
	else
	{
		Frame *frame=(Frame*)parent();
		if(val < 50)
			frame->player(1)->PlayMeta_clicked();
		else
			frame->player(0)->PlayMeta_clicked();
	}
    if(val < 50)
	xfadeStep=1;
    else
	xfadeStep=-1;
    if(xfadeTime < 1)
	xfadeTime=1;
    xfadeTimer->start((xfadeTime*200)/100);
}

int Mixer::xfadeTranslate(int value)
{
    int val;
    
    switch(xfadeMode)
    {
    case 0:
	if(value < 100)
	    return 100;
	val=value-100;
	if(val > 100)
	    val=100;
	return 100-val;
    case 1:
	if(value < 75)
	    return 100;
	val=value-75;
	if(val > 100)
	    val=100;
	return 100-val;
    case 2:
	if(value < 25)
	    return 100;
	val=value-25;
	if(val > 100)
	    val=100;
	return 100-val;
    case 3:
	val=value;
	if(val > 100)
	    val=100;
	return 100-val;
    case 4:
	if(value < 100)
	    return 100;
	return 0;
    }
    return 100;
}

void Mixer::Profile0_toggled(bool on)
{
    if(on)
	setProfile(0);
}

void Mixer::Profile1_toggled(bool on)
{
    if(on)
	setProfile(1);
}

void Mixer::Profile2_toggled(bool on)
{
    if(on)
	setProfile(2);
}

void Mixer::Profile3_toggled(bool on)
{
    if(on)
	setProfile(3);
}

void Mixer::Profile4_toggled(bool on)
{
    if(on)
	setProfile(4);
}

void Mixer::setProfile(int p)
{
    BitmapButton *profile_buttons[]={Profile0, Profile1, Profile2, Profile3, Profile4};
    int i;
    
    for(i=0;i<5;++i)
	if(i != p && profile_buttons[i]->isOn())
	    profile_buttons[i]->toggle();
    xfadeMode=p;
    XFader_valueChanged(XFader->value());
}


void Mixer::Reset_clicked()
{
printf("Reset clicked\n");
    XFader->setValue(100);
    VideoXFader->setValue(50);
    if(AudioXFaderOn->isOn())
	xfadeTimer->stop();
}


void Mixer::Setup_clicked()
{
    QTabDialog d(this, 0, true);
    XFadeSettings dlg(&d);
 
    dlg.PreRoll->setValue(xfadePreRoll);
    dlg.PostRoll->setValue(xfadePostRoll);
    dlg.XFadeTime->setValue(xfadeTime);
    
    StreamDlg stream(&d);
    
    stream.BroadcastPipeline->setText(out_pipe);
    stream.BroadcastRelaunch->setChecked(out_relaunch);
    stream.RecordDestination->setText(config->getValue("RecordPipeline", ""));
    if(stream.RecordDestination->text() == "")
	stream.RecordDestination->setText(config->getValue("RecordFile", ""));
    else
	stream.RecordPipeline->setChecked(true);
    stream.MetadataFile->setText(config->getValue("MetadataFile", ""));
    stream.MetadataCommand->setText(config->getValue("MetadataCommand", ""));
    
    MicDlg mic(&d);
    
    mic.TalkoverLevel->setValue(100-talk_level);
    int mic_channel=config->getValue("MicInput", "0").toInt();
    if(mic_channel == 0)
	mic.MicNone->setChecked(true);
    if(mic_channel == 1)
	mic.MicLine1->setChecked(true);
    if(mic_channel == 2)
	mic.MicLine2->setChecked(true);
    mic.LeftPlayer->setChecked(config->getValue("AttLeftPlayer", "1").toInt() ? 1 : 0);
    mic.RightPlayer->setChecked(config->getValue("AttRightPlayer", "1").toInt() ? 1 : 0);
    mic.Line1->setChecked(config->getValue("AttLine1", "1").toInt() ? 1 : 0);
    mic.Line2->setChecked(config->getValue("AttLine2", "1").toInt() ? 1 : 0);
    
    PortDlg ports(&d);
    
    MiscDlg misc(&d);
    
    misc.InitialDir->setText(config->getValue("InitialDir", "/"));
    misc.VideoDisplay->setText(config->getValue("VideoDisplay", ""));
    misc.StartVideo->setChecked(config->getValue("StartVideo", "0").toInt());
	
    misc.DoCheck->setChecked(config->getValue("DoCheck", "1").toInt());
    misc.QuickCheck->setChecked(config->getValue("QuickCheck", "0").toInt());
    misc.AutoBPM->setChecked(config->getValue("AutoBPM", "1").toInt());
    
#ifdef HAVE_LIBXML2
    IceDlg ice(&d);
    ice.setStreamDlg(&stream);
#endif
    
    d.setOkButton();
    d.setCancelButton();
    d.addTab(&dlg, "Crossfader");
    d.addTab(&stream, "Streaming and recording");
    d.addTab(&mic, "Mic");
    d.addTab(&ports, "Ports");
    d.addTab(&misc, "Misc");
#ifdef HAVE_LIBXML2
    d.addTab(&ice, "Icecast");
#endif    
    int cc=!d.exec();
    if(cc)
	return;
    
    ports.outputStoreSetup();
    frame->client()->clearPortConnections();
    *config=ports.cfg;
    
    frame->client()->checkPortConnections();
    
    QString cf;
    
    xfadeTime=dlg.XFadeTime->value();
    cf.sprintf("%d", xfadeTime);
    config->setValue("XFadeTime", cf);
    
    xfadePreRoll=dlg.PreRoll->value();
    cf.sprintf("%d", xfadePreRoll);
    config->setValue("XFadePreRoll", cf);
    
    xfadePostRoll=dlg.PostRoll->value();
    cf.sprintf("%d", xfadePostRoll);
    config->setValue("XFadePostRoll", cf);
    
    Frame *frame=(Frame*)parent();
    frame->player(0)->setWarnTime(xfadePostRoll+xfadePreRoll);
    frame->player(1)->setWarnTime(xfadePostRoll+xfadePreRoll);
    
    cf.sprintf("%d", stream.BroadcastRelaunch->isChecked() ? 1 : 0);
    config->setValue("BroadcastRelaunch", cf);
    out_relaunch=stream.BroadcastRelaunch->isChecked() ? 1 : 0;
    
    config->setValue("BroadcastPipeline", stream.BroadcastPipeline->text());
    strcpy(out_pipe, (const char *)stream.BroadcastPipeline->text());
    
    if(stream.RecordPipeline->isChecked())
    {
	config->setValue("RecordPipeline", stream.RecordDestination->text());
	config->setValue("RecordFile", "");
    }
    else
    {
	config->setValue("RecordPipeline", "");
	config->setValue("RecordFile", stream.RecordDestination->text());
    }
    config->setValue("MetadataFile", stream.MetadataFile->text());
    config->setValue("MetadataCommand", stream.MetadataCommand->text());
    
    talk_level=100-mic.TalkoverLevel->value();
    cf.sprintf("%d", 100-mic.TalkoverLevel->value());
    config->setValue("TalkLevel", cf);
    
    if(mic.MicLine1->isChecked())
    {
	mic_channel=0;
	pfl->setMicChannel(0);
    }
    if(mic.MicLine1->isChecked())
    {
	mic_channel=1;
	pfl->setMicChannel(line1);
    }
    if(mic.MicLine2->isChecked())
    {
	mic_channel=2;
	pfl->setMicChannel(line2);
    }
    cf.sprintf("%d", mic_channel);
    config->setValue("MicInput", cf);
    cf.sprintf("%d", mic.LeftPlayer->isChecked() ? 1 : 0);
    config->setValue("AttLeftPlayer", cf);
    cf.sprintf("%d", mic.RightPlayer->isChecked() ? 1 : 0);
    config->setValue("AttRightPlayer", cf);
    cf.sprintf("%d", mic.Line1->isChecked() ? 1 : 0);
    config->setValue("AttLine1", cf);
    cf.sprintf("%d", mic.Line2->isChecked() ? 1 : 0);
    config->setValue("AttLine2", cf);
    
    config->setValue("InitialDir", misc.InitialDir->text());
    config->setValue("VideoDisplay", misc.VideoDisplay->text());
    cf.sprintf("%d", misc.StartVideo->isChecked() ? 1 : 0);
    config->setValue("StartVideo", cf);
    cf.sprintf("%d", misc.DoCheck->isChecked() ? 1 : 0);
    config->setValue("DoCheck", cf);
    cf.sprintf("%d", misc.QuickCheck->isChecked() ? 1 : 0);
    config->setValue("QuickCheck", cf);
    cf.sprintf("%d", misc.AutoBPM->isChecked() ? 1 : 0);
    config->setValue("AutoBPM", cf);
}

void Mixer::preRollTimeout()
{
    if(xfadeFrom == 0)
    {
	xfadeStep=2;
    }
    else
    {
	xfadeStep=-2;
    }
    if(xfadeTime < 1)
	xfadeTime=1;
    xfadeTimer->start((xfadeTime*200)/100);
}


void Mixer::Auto_toggled( bool on )
{
    Frame *frame=(Frame*)parent();
    MainWnd *player;
    if(on)
    {
	player=frame->player(0);
	if(!player->is_loaded())
	    if(!player->load_next(xfadeRandom))
	    {
	             Auto->toggle();
		return;
	    }
	time_t now=time(0);
	while(time(0)-now < 20)
	{
	    app->processEvents();
	    if(player->is_loaded())
		break;
	}
	if(!player->is_loaded())
	{
	    Auto->toggle();
	    return;
	}
	player=frame->player(1);
	if(!player->is_loaded())
	    if(!player->load_next(xfadeRandom))
	    {
	             Auto->toggle();
		return;
	    }
	now=time(0);
	while(time(0)-now < 20)
	{
	    app->processEvents();
	    if(player->is_loaded())
		break;
	}
	if(!player->is_loaded())
	{
	    Auto->toggle();
	    return;
	}
	
	int playing=-1;
	if(frame->player(1)->isPlaying())
	    playing=1;
	else if(frame->player(0)->isPlaying())
	    playing=0;
	if(playing == -1)
	{
	    playing=0;
	    frame->player(0)->PlayMeta_clicked();
	}
	if(!AudioXFaderOn->isOn())
	    AudioXFaderOn->toggle();
	XFader->setValue(200*playing);
	VideoXFader->setValue(100*playing);
    }
}


void Mixer::Random_toggled( bool on )
{
    xfadeRandom=on;
}


void Mixer::paintEvent( QPaintEvent *e )
{
    bitBlt(this, 0, 0, background);
}


bool Mixer::random()
{
    return xfadeRandom;
}


void Mixer::VideoXFader_valueChanged( int val )
{
    Frame *frame=(Frame*)parent();
    frame->VideoXFader_valueChanged(val);
    if(AudioXFaderOn->isOn())
		XFader->setValue(val*2);
}


void Mixer::LeftVideoOn_toggled( bool on )
{
    Frame *frame=(Frame*)parent();
    frame->enableLeftVideo(on);
}


void Mixer::RightVideoOn_toggled( bool on )
{
    Frame *frame=(Frame*)parent();
    frame->enableRightVideo(on);
}
