#include "bitmapslider.h"
#include <qpainter.h>
#include <qpixmap.h>

#include <stdio.h>

BitmapSlider::BitmapSlider(QWidget *parent, const char *name) : QSlider(parent, name)
{
	commonConstruct();
}

BitmapSlider::BitmapSlider(Orientation o, QWidget *parent, const char *name) : QSlider(o, parent, name)
{
	setOrientation(o);
	commonConstruct();
}

BitmapSlider::BitmapSlider(int min, int max, int page, int val, Orientation o, QWidget *parent, const char *name) : QSlider(min, max, page, val, o, parent, name)
{
	setOrientation(o);
	setMinValue(min);
	setMaxValue(max);
	setPageStep(page);
	setValue(val);
	commonConstruct();
}

void BitmapSlider::commonConstruct()
{
	s_handleOffset=0;
	s_backgroundPixmap=0;
	s_handlePixmap=0;

	connect(this, SIGNAL(valueChanged(int)), this, SLOT(parentValueChanged(int)));
}

BitmapSlider::~BitmapSlider()
{
	if(s_backgroundPixmap)
		delete s_backgroundPixmap;
	if(s_handlePixmap)
		delete s_handlePixmap;
}

void BitmapSlider::setBackgroundPixmap(const QPixmap& pix)
{
	if(s_backgroundPixmap)
		delete s_backgroundPixmap;
	s_backgroundPixmap=new QPixmap(pix);
}

QPixmap *BitmapSlider::backgroundPixmap() const
{
	return s_backgroundPixmap;
}

void BitmapSlider::setHandlePixmap(const QPixmap& pix)
{
	if(s_handlePixmap)
		delete s_handlePixmap;
	s_handlePixmap=new QPixmap(pix);
}

QPixmap *BitmapSlider::handlePixmap() const
{
	return s_handlePixmap;
}

void BitmapSlider::setHandleOffset(int len)
{
	s_handleOffset=len;
}

int BitmapSlider::handleOffset() const
{
	return s_handleOffset;
}

void BitmapSlider::paintEvent(QPaintEvent *e)
{
	if(!s_backgroundPixmap || !s_handlePixmap)
	{
		QSlider::paintEvent(e);
		return;
	}

	QPixmap pm(size());
	QPainter p;
	p.begin(&pm, this);

	QPen bgp(QColor(192, 192, 192));
	QBrush bgb(QColor(192, 192, 192));

	p.setBrush(bgb);
	p.setPen(bgp);

	p.drawRect(0, 0, size().width(), size().height());

	p.drawPixmap(0, 0, *s_backgroundPixmap);

//	int tl = style().pixelMetric( QStyle::PM_SliderLength, this );
	int tl;
	QPoint tp;
	if(orientation() == Horizontal)
	{
		tl=width()-s_handlePixmap->width();
		tp=QPoint(0, height()/2);
	}
	else
	{
		tl=height()-s_handlePixmap->height();
		tp=QPoint(width()/2, 0);
	}
	int off=0;
	
	
	int slp=(int)((double)(value()-minValue())/(double)(maxValue()-minValue())*(double)tl);
	
	if(orientation() == Horizontal)
	{
		QPoint handleOffset=QPoint(0, -(s_handlePixmap->height()/2)+s_handleOffset);

		QPoint sp=tp+handleOffset+QPoint(slp, 0);

		p.drawPixmap(sp.x()+off, sp.y(), *s_handlePixmap);
	}
	else
	{
		QPoint handleOffset=QPoint(-(s_handlePixmap->width()/2)+s_handleOffset, 0);

		QPoint sp=tp+handleOffset+QPoint(0, slp);

		p.drawPixmap(sp.x(), sp.y()+off, *s_handlePixmap);
	}
	bitBlt(this, 0, 0, &pm);
}

void BitmapSlider::parentValueChanged(int)
{
	repaint(false);
}
