#ifndef _WAVELET_H_INCLUDED
#define _WAVELET_H_INCLUDED
#include <qobject.h>
#include "jack.h"

class StreamSource;

class Wavelet : public QObject
{
Q_OBJECT;

public:
	Wavelet();
	Wavelet(StreamSource *source, unsigned long start_position, int count=4096);
	~Wavelet();

	unsigned long start;
	int count;
	char *pixmap;
	int max_wavelet_value;
	StreamSource *source;

public slots:
	void load();
	void loadBuffer(char *buf, int real);
};
#endif
