/*
 * Decompiled with CFR 0.152.
 */
package com.nwalsh.saxon;

import com.icl.saxon.om.ElementInfo;
import com.icl.saxon.om.NamePool;
import com.icl.saxon.output.Emitter;
import com.nwalsh.saxon.Callout;
import com.nwalsh.saxon.FormatCallout;
import javax.xml.transform.TransformerException;

public class FormatUnicodeCallout
extends FormatCallout {
    int unicodeMax = 0;
    int unicodeStart = 0;

    public FormatUnicodeCallout(NamePool nPool, int start, int max, boolean fo) {
        super(nPool, fo);
        this.unicodeMax = max;
        this.unicodeStart = start;
    }

    public void formatCallout(Emitter rtfEmitter, Callout callout) {
        ElementInfo area = callout.getArea();
        int num = callout.getCallout();
        String label = this.areaLabel(area);
        try {
            if (label == null && num <= this.unicodeMax) {
                char[] chars = new char[]{(char)(this.unicodeStart + num - 1)};
                this.startSpan(rtfEmitter);
                rtfEmitter.characters(chars, 0, 1);
                this.endSpan(rtfEmitter);
            } else {
                this.formatTextCallout(rtfEmitter, callout);
            }
        }
        catch (TransformerException transformerException) {
            System.out.println("Transformer Exception in graphic formatCallout");
        }
    }
}

