/*
 * Decompiled with CFR 0.152.
 */
package com.nwalsh.saxon;

import com.icl.saxon.AttributeCollection;
import com.icl.saxon.om.ElementInfo;
import com.icl.saxon.om.Name;
import com.icl.saxon.output.Emitter;
import com.nwalsh.saxon.Callout;
import com.nwalsh.saxon.FormatCallout;
import org.xml.sax.SAXException;

public class FormatGraphicCallout
extends FormatCallout {
    String graphicsPath = "";
    String graphicsExt = "";
    int graphicsMax = 0;

    public FormatGraphicCallout(String path, String ext, int max, boolean fo) {
        super(fo);
        this.graphicsPath = path;
        this.graphicsExt = ext;
        this.graphicsMax = max;
    }

    public void formatCallout(Emitter rtfEmitter, Callout callout) {
        ElementInfo area = callout.getArea();
        int num = callout.getCallout();
        String userLabel = this.areaLabel(area);
        String label = "(" + num + ")";
        if (userLabel != null) {
            label = userLabel;
        }
        try {
            if (userLabel == null && num <= this.graphicsMax) {
                Name imgName = null;
                AttributeCollection imgAttr = null;
                if (this.foStylesheet) {
                    imgName = new Name("fo", "http://www.w3.org/1999/XSL/Format", "external-graphic");
                    imgAttr = new AttributeCollection();
                    imgAttr.addAttribute(new Name("src"), "CDATA", String.valueOf(this.graphicsPath) + num + this.graphicsExt);
                    imgAttr.addAttribute(new Name("alt"), "CDATA", label);
                } else {
                    imgName = new Name("img");
                    imgAttr = new AttributeCollection();
                    imgAttr.addAttribute(new Name("src"), "CDATA", String.valueOf(this.graphicsPath) + num + this.graphicsExt);
                    imgAttr.addAttribute(new Name("alt"), "CDATA", label);
                }
                this.startSpan(rtfEmitter);
                rtfEmitter.startElement(imgName, imgAttr);
                rtfEmitter.endElement(imgName);
                this.endSpan(rtfEmitter);
            } else {
                this.formatTextCallout(rtfEmitter, callout);
            }
        }
        catch (SAXException sAXException) {
            System.out.println("SAX Exception in graphic formatCallout");
        }
    }
}

