<?xml version='1.0'?>
<!-- vim: sw=2 sta et
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:doc="http://nwalsh.com/xsl/documentation/1.0"
                xmlns:gt="http://docbook2x.sourceforge.net/xsl/gentext"
                exclude-result-prefixes="doc gt"
                version='1.0'
                xml:lang="en">

<!-- ********************************************************************
     $Id: synop.xsl,v 1.25 2004/07/16 02:47:02 stevecheng Exp $
     ********************************************************************

     &copy; 2000 Steve Cheng <stevecheng@users.sourceforge.net>

     This file is part of the docbook2X XSLT stylesheets for
     converting DocBook to Texinfo.

     Derived from files in Norman Walsh's XSL DocBook Stylesheet
     Distribution and Mark Burton's dbtotexi stylesheets.

     ******************************************************************** -->

<!-- ==================================================================== -->

<doc:mode mode="no-inline-markup" xmlns="">
<refpurpose>Plain text synopses</refpurpose>
<refdescription>
<para>
Info uses decorations to represent semantic markup, which
is undesirable in a verbatim synopsis.  So we use
<function>verbatim</function> to not use Texinfo's semantic markup. 
</para>
<para>
However, we lose the ability to make links :(
</para>
</refdescription>
</doc:mode>

<xsl:template match="synopsis">
  <example>
    <xsl:call-template name="anchor" />
    <xsl:apply-templates mode="no-inline-markup" />
  </example>
</xsl:template>

<xsl:template match="*" mode="no-inline-markup">
  <xsl:apply-templates mode="no-inline-markup" />
</xsl:template>

<xsl:template match="text()" mode="no-inline-markup">
  <xsl:value-of select="." />
</xsl:template>




<!-- ==================================================================== -->

<xsl:template match="cmdsynopsis">
  <quotation> 
    <xsl:call-template name="anchor" />
    <para><t>
        <xsl:apply-templates mode="cmdsynopsis" />
    </t></para>
  </quotation>
</xsl:template>

<xsl:template match="*" mode="cmdsynopsis">
  <xsl:value-of select="." />
</xsl:template>

<xsl:template match="sbr" mode="cmdsynopsis">
  <sp n="1" />
</xsl:template>

<xsl:template match="command" mode="cmdsynopsis">
  <xsl:if test="preceding-sibling::*">
    <xsl:call-template name="cmdsynopsis-gentext-sepchar" />
  </xsl:if>

  <xsl:apply-templates mode="cmdsynopsis" />
</xsl:template>

<xsl:template match="group|arg" mode="cmdsynopsis">
  <xsl:if test="preceding-sibling::* and not(parent::arg)">
    <xsl:call-template name="cmdsynopsis-gentext-sepchar" />
  </xsl:if>

  <xsl:call-template name="arg-gentext-choice-start" />
  <xsl:apply-templates mode="cmdsynopsis" />
  <xsl:call-template name="arg-gentext-choice-end" />
  <xsl:call-template name="arg-gentext-rep" />
</xsl:template>

<!-- Member of groups -->

<xsl:template match="group/*" mode="cmdsynopsis" priority="2.0">
  <xsl:if test="position()>1">
    <xsl:call-template name="arg-gentext-or-separator" />
  </xsl:if>
  <xsl:apply-templates mode="cmdsynopsis" />
</xsl:template>

<xsl:template match="group/group" mode="cmdsynopsis" priority="2.5">
  <xsl:if test="position()>1">
    <xsl:call-template name="arg-gentext-or-separator" />
  </xsl:if>

  <xsl:call-template name="arg-gentext-choice-start" />
  <xsl:apply-templates mode="cmdsynopsis" />
  <xsl:call-template name="arg-gentext-choice-end" />
  <xsl:call-template name="arg-gentext-rep" />
</xsl:template>

<xsl:template match="group/arg" mode="cmdsynopsis" priority="2.5">
  <xsl:if test="position()>1">
    <xsl:call-template name="arg-gentext-or-separator" />
  </xsl:if>

  <xsl:apply-templates mode="cmdsynopsis" />
  <xsl:call-template name="arg-gentext-rep" />
</xsl:template>

<!-- ==================================================================== -->

<xsl:template match="synopfragment|synopfragmentref" mode="cmdsynopsis">
  <xsl:call-template name="gentext-label">
    <xsl:with-param name="content">
      <xsl:for-each select="key('id', @linkend)">
        <xsl:number format="1" />
      </xsl:for-each>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<!-- ==================================================================== -->

<xsl:template match="funcsynopsis">
  <quotation>
    <xsl:call-template name="anchor" />
    <xsl:apply-templates />
  </quotation>
</xsl:template>

<xsl:template match="*" mode="funcverbatim">
  <xsl:value-of select="." />
</xsl:template>

<xsl:template match="funcsynopsisinfo">
  <!-- format rather than example is used to avoid indenting the
       funcsynopsisinfo block -->
  <format><t>
    <xsl:apply-templates mode="funcverbatim" />
  </t></format>
</xsl:template>

<xsl:template match="funcprototype">
  <para>
    <t>  
      <xsl:apply-templates />
    </t>

    <xsl:if test="$funcsynopsis-style='kr'">
      <sp n="1" />
      <xsl:apply-templates select="./paramdef" mode="kr-funcsynopsis-mode"/>
    </xsl:if>
  </para>
</xsl:template>

<xsl:template match="funcdef">
  <xsl:apply-templates mode="funcverbatim" />
</xsl:template>

<xsl:template match="function" mode="funcverbatim">
  <xsl:choose>
    <xsl:when test="$funcsynopsis-decoration">
      <b><xsl:apply-templates mode="funcverbatim" /></b>
    </xsl:when>
    <xsl:otherwise>
      <xsl:apply-templates mode="funcverbatim" />
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="void">
  <xsl:choose>
    <xsl:when test="$funcsynopsis-style='ansi'">
      <xsl:text>(void);</xsl:text>
    </xsl:when>
    <xsl:otherwise>
      <xsl:text>();</xsl:text>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="varargs">
  <xsl:text>(...);</xsl:text>
</xsl:template>

<xsl:template match="paramdef">
  <xsl:choose>
    <xsl:when test="preceding-sibling::*[position()=1 and local-name() = 'paramdef']">
      <xsl:text>, </xsl:text>
    </xsl:when>
    <xsl:otherwise>
      <xsl:text>(</xsl:text>
    </xsl:otherwise>
  </xsl:choose>
  
  <xsl:choose>
    <xsl:when test="$funcsynopsis-style='kr'">
      <xsl:apply-templates select="./parameter" mode="funcverbatim" />
    </xsl:when>
    <xsl:otherwise>
      <xsl:apply-templates mode="funcverbatim" />
    </xsl:otherwise>
  </xsl:choose>
  
  <xsl:if test="not(following-sibling::*[position()=1 and local-name() = 'paramdef'])">
    <xsl:text>);</xsl:text>
  </xsl:if>
</xsl:template>

<xsl:template match="paramdef/parameter" mode="funcverbatim">
  <xsl:choose>
    <xsl:when test="$funcsynopsis-decoration">
      <i><xsl:apply-templates mode="funcverbatim" /></i>
    </xsl:when>
    <xsl:otherwise>
      <xsl:apply-templates mode="funcverbatim" />
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="paramdef" mode="kr-funcsynopsis-mode">
  <xsl:apply-templates mode="funcverbatim" />
  <xsl:text>;</xsl:text>
</xsl:template>

<xsl:template match="funcparams">
  <xsl:text>(</xsl:text>
  <xsl:apply-templates/>
  <xsl:text>)</xsl:text>
</xsl:template>

<!-- ==================================================================== -->
<!-- FIXME: bring back classsynopsis stuff ! -->

</xsl:stylesheet>
