import cpp

class UFCFunctionSpace(cpp.FunctionSpace):
    def __init__(self, mesh, ufc_finite_element, ufc_dof_map):
        self._mesh = mesh
        self._finite_element     = cpp.FiniteElement(ufc_finite_element)
        self._dof_map            = cpp.DofMap(ufc_dof_map, mesh)
        self._ufc_finite_element = ufc_finite_element
        self._ufc_dof_map        = ufc_dof_map
        cpp.FunctionSpace.__init__(self, mesh, finite_element, dof_map)

def create_ufc_function_spaces(mesh, ufc_form, cache=None):
    functionspaces = []
    if cache is None:
        cache = {}
    for i in range(ufc_form.rank() + ufc_form.num_coefficients()):
        fe = ufc_form.create_finite_element(i)
        fesig = fe.signature()
        
        V = cache.get(fesig)
        if V is None:
            dm = ufc_form.create_dof_map(i)

            V = UFCFunctionSpace(mesh, fe, dm)
            cache[fesig] = V

        functionspaces.append(V)
    return functionspaces, cache

#mesh = ...
#ufc_form = ...
#fs, c = create_ufc_function_spaces(mesh, ufc_form)
#fs, c = create_ufc_function_spaces(mesh, ufc_form, c)

