// This code conforms with the UFC specification version 2.0.5
// and was automatically generated by FFC version 1.0.0.
//
// This code was generated with the option '-l dolfin' and
// contains DOLFIN-specific wrappers that depend on DOLFIN.
// 
// This code was generated with the following parameters:
// 
//   cache_dir:                      ''
//   convert_exceptions_to_warnings: False
//   cpp_optimize:                   False
//   cpp_optimize_flags:             '-O2'
//   epsilon:                        1e-14
//   error_control:                  True
//   form_postfix:                   True
//   format:                         'dolfin'
//   log_level:                      10
//   log_prefix:                     ''
//   no_ferari:                      True
//   optimize:                       True
//   output_dir:                     '.'
//   precision:                      15
//   quadrature_degree:              'auto'
//   quadrature_rule:                'auto'
//   representation:                 'auto'
//   split:                          False
//   swig_binary:                    'swig'
//   swig_path:                      ''

#ifndef __ADAPTIVEPOISSON_H
#define __ADAPTIVEPOISSON_H

#include <cmath>
#include <stdexcept>
#include <fstream>
#include <ufc.h>

/// This class defines the interface for a finite element.

class adaptivepoisson_finite_element_0: public ufc::finite_element
{
public:

  /// Constructor
  adaptivepoisson_finite_element_0() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~adaptivepoisson_finite_element_0()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Discontinuous Lagrange', Cell('triangle', Space(2)), 0, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::triangle;
  }

  /// Return the topological dimension of the cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 1;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    
    // Compute Jacobian of affine map from reference cell
    
    // Compute determinant of Jacobian
    
    // Compute inverse of Jacobian
    
    // Compute constants
    
    // Get coordinates and map to the reference (FIAT) element
    
    // Reset values.
    *values = 0.0;
    
    // Array of basisvalues.
    double basisvalues[1] = {0.0};
    
    // Declare helper variables.
    
    // Compute basisvalues.
    basisvalues[0] = 1.0;
    
    // Table(s) of coefficients.
    static const double coefficients0[1] = \
    {1.0};
    
    // Compute value(s).
    for (unsigned int r = 0; r < 1; r++)
    {
      *values += coefficients0[r]*basisvalues[r];
    }// end loop over 'r'
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Element is constant, calling evaluate_basis.
    evaluate_basis(0, values, coordinates, c);
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Compute constants
    
    // Get coordinates and map to the reference (FIAT) element
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K_00, K_01}, {K_10, K_11}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    
    // Array of basisvalues.
    double basisvalues[1] = {0.0};
    
    // Declare helper variables.
    
    // Compute basisvalues.
    basisvalues[0] = 1.0;
    
    // Table(s) of coefficients.
    static const double coefficients0[1] = \
    {1.0};
    
    // Tables of derivatives of the polynomial base (transpose).
    static const double dmats0[1][1] = \
    {{0.0}};
    
    static const double dmats1[1][1] = \
    {{0.0}};
    
    // Compute reference derivatives.
    // Declare pointer to array of derivatives on FIAT element.
    double *derivatives = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      derivatives[r] = 0.0;
    }// end loop over 'r'
    
    // Declare derivative matrix (of polynomial basis).
    double dmats[1][1] = \
    {{1.0}};
    
    // Declare (auxiliary) derivative matrix (of polynomial basis).
    double dmats_old[1][1] = \
    {{1.0}};
    
    // Loop possible derivatives.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      // Resetting dmats values to compute next derivative.
      for (unsigned int t = 0; t < 1; t++)
      {
        for (unsigned int u = 0; u < 1; u++)
        {
          dmats[t][u] = 0.0;
          if (t == u)
          {
          dmats[t][u] = 1.0;
          }
          
        }// end loop over 'u'
      }// end loop over 't'
      
      // Looping derivative order to generate dmats.
      for (unsigned int s = 0; s < n; s++)
      {
        // Updating dmats_old with new values and resetting dmats.
        for (unsigned int t = 0; t < 1; t++)
        {
          for (unsigned int u = 0; u < 1; u++)
          {
            dmats_old[t][u] = dmats[t][u];
            dmats[t][u] = 0.0;
          }// end loop over 'u'
        }// end loop over 't'
        
        // Update dmats using an inner product.
        if (combinations[r][s] == 0)
        {
        for (unsigned int t = 0; t < 1; t++)
        {
          for (unsigned int u = 0; u < 1; u++)
          {
            for (unsigned int tu = 0; tu < 1; tu++)
            {
              dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
            }// end loop over 'tu'
          }// end loop over 'u'
        }// end loop over 't'
        }
        
        if (combinations[r][s] == 1)
        {
        for (unsigned int t = 0; t < 1; t++)
        {
          for (unsigned int u = 0; u < 1; u++)
          {
            for (unsigned int tu = 0; tu < 1; tu++)
            {
              dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
            }// end loop over 'tu'
          }// end loop over 'u'
        }// end loop over 't'
        }
        
      }// end loop over 's'
      for (unsigned int s = 0; s < 1; s++)
      {
        for (unsigned int t = 0; t < 1; t++)
        {
          derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
        }// end loop over 't'
      }// end loop over 's'
    }// end loop over 'r'
    
    // Transform derivatives back to physical element
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r] += transform[r][s]*derivatives[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer to array of derivatives on FIAT element
    delete [] derivatives;
    
    // Delete pointer to array of combinations of derivatives and transform
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      delete [] combinations[r];
    }// end loop over 'r'
    delete [] combinations;
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      delete [] transform[r];
    }// end loop over 'r'
    delete [] transform;
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Element is constant, calling evaluate_basis_derivatives.
    evaluate_basis_derivatives(0, n, values, coordinates, c);
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0];
      y[1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    y[0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0];
    y[1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[0];
    vertex_values[2] = dof_values[0];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    throw std::runtime_error("map_from_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    throw std::runtime_error("map_to_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new adaptivepoisson_finite_element_0();
  }

};

/// This class defines the interface for a finite element.

class adaptivepoisson_finite_element_1: public ufc::finite_element
{
public:

  /// Constructor
  adaptivepoisson_finite_element_1() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~adaptivepoisson_finite_element_1()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Discontinuous Lagrange', Cell('triangle', Space(2)), 2, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::triangle;
  }

  /// Return the topological dimension of the cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 6;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Reset values.
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, -0.173205080756888, -0.1, 0.121716123890037, 0.0942809041582064, 0.0544331053951817};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, 0.173205080756888, -0.1, 0.121716123890037, -0.0942809041582063, 0.0544331053951818};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, 0.0, 0.2, 0.0, 0.0, 0.163299316185545};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.471404520791032, 0.23094010767585, 0.133333333333333, 0.0, 0.188561808316413, -0.163299316185545};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.471404520791032, -0.23094010767585, 0.133333333333333, 0.0, -0.188561808316413, -0.163299316185545};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.471404520791032, 0.0, -0.266666666666667, -0.243432247780074, 0.0, 0.0544331053951817};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 6; r++)
    {
      evaluate_basis(r, &dof_values, coordinates, c);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K_00, K_01}, {K_10, K_11}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, -0.173205080756888, -0.1, 0.121716123890037, 0.0942809041582064, 0.0544331053951817};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, 0.173205080756888, -0.1, 0.121716123890037, -0.0942809041582063, 0.0544331053951818};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, 0.0, 0.2, 0.0, 0.0, 0.163299316185545};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.471404520791032, 0.23094010767585, 0.133333333333333, 0.0, 0.188561808316413, -0.163299316185545};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.471404520791032, -0.23094010767585, 0.133333333333333, 0.0, -0.188561808316413, -0.163299316185545};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.471404520791032, 0.0, -0.266666666666667, -0.243432247780074, 0.0, 0.0544331053951817};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      dof_values[r] = 0.0;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 6; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = 0.5*x[1][0] + 0.5*x[2][0];
      y[1] = 0.5*x[1][1] + 0.5*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = 0.5*x[0][0] + 0.5*x[2][0];
      y[1] = 0.5*x[0][1] + 0.5*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 5:
      {
        y[0] = 0.5*x[0][0] + 0.5*x[1][0];
      y[1] = 0.5*x[0][1] + 0.5*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    y[0] = x[0][0];
    y[1] = x[0][1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = x[1][0];
    y[1] = x[1][1];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = x[2][0];
    y[1] = x[2][1];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = 0.5*x[1][0] + 0.5*x[2][0];
    y[1] = 0.5*x[1][1] + 0.5*x[2][1];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = 0.5*x[0][0] + 0.5*x[2][0];
    y[1] = 0.5*x[0][1] + 0.5*x[2][1];
    f.evaluate(vals, y, c);
    values[4] = vals[0];
    y[0] = 0.5*x[0][0] + 0.5*x[1][0];
    y[1] = 0.5*x[0][1] + 0.5*x[1][1];
    f.evaluate(vals, y, c);
    values[5] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    throw std::runtime_error("map_from_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    throw std::runtime_error("map_to_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new adaptivepoisson_finite_element_1();
  }

};

/// This class defines the interface for a finite element.

class adaptivepoisson_finite_element_2: public ufc::finite_element
{
public:

  /// Constructor
  adaptivepoisson_finite_element_2() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~adaptivepoisson_finite_element_2()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Bubble', Cell('triangle', Space(2)), 3, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::triangle;
  }

  /// Return the topological dimension of the cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 1;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Reset values.
    *values = 0.0;
    
    // Array of basisvalues.
    double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    
    // Declare helper variables.
    double tmp0 = (1.0 + Y + 2.0*X)/2.0;
    double tmp1 = (1.0 - Y)/2.0;
    double tmp2 = tmp1*tmp1;
    
    // Compute basisvalues.
    basisvalues[0] = 1.0;
    basisvalues[1] = tmp0;
    basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
    basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
    basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
    basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
    basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
    basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
    basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
    basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
    basisvalues[0] *= std::sqrt(0.5);
    basisvalues[2] *= std::sqrt(1.0);
    basisvalues[5] *= std::sqrt(1.5);
    basisvalues[9] *= std::sqrt(2.0);
    basisvalues[1] *= std::sqrt(3.0);
    basisvalues[4] *= std::sqrt(4.5);
    basisvalues[8] *= std::sqrt(6.0);
    basisvalues[3] *= std::sqrt(7.5);
    basisvalues[7] *= std::sqrt(10.0);
    basisvalues[6] *= std::sqrt(14.0);
    
    // Table(s) of coefficients.
    static const double coefficients0[10] = \
    {0.636396103067893, 0.0, 0.0, -0.234738238930786, 0.0, -0.262445329583912, 0.0, -0.203289278153682, 0.0, 0.0909137290096989};
    
    // Compute value(s).
    for (unsigned int r = 0; r < 10; r++)
    {
      *values += coefficients0[r]*basisvalues[r];
    }// end loop over 'r'
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Element is constant, calling evaluate_basis.
    evaluate_basis(0, values, coordinates, c);
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K_00, K_01}, {K_10, K_11}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    
    // Array of basisvalues.
    double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    
    // Declare helper variables.
    double tmp0 = (1.0 + Y + 2.0*X)/2.0;
    double tmp1 = (1.0 - Y)/2.0;
    double tmp2 = tmp1*tmp1;
    
    // Compute basisvalues.
    basisvalues[0] = 1.0;
    basisvalues[1] = tmp0;
    basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
    basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
    basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
    basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
    basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
    basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
    basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
    basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
    basisvalues[0] *= std::sqrt(0.5);
    basisvalues[2] *= std::sqrt(1.0);
    basisvalues[5] *= std::sqrt(1.5);
    basisvalues[9] *= std::sqrt(2.0);
    basisvalues[1] *= std::sqrt(3.0);
    basisvalues[4] *= std::sqrt(4.5);
    basisvalues[8] *= std::sqrt(6.0);
    basisvalues[3] *= std::sqrt(7.5);
    basisvalues[7] *= std::sqrt(10.0);
    basisvalues[6] *= std::sqrt(14.0);
    
    // Table(s) of coefficients.
    static const double coefficients0[10] = \
    {0.636396103067893, 0.0, 0.0, -0.234738238930786, 0.0, -0.262445329583912, 0.0, -0.203289278153682, 0.0, 0.0909137290096989};
    
    // Tables of derivatives of the polynomial base (transpose).
    static const double dmats0[10][10] = \
    {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
    {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
    {3.46410161513775, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
    
    static const double dmats1[10][10] = \
    {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {2.58198889747161, 4.74341649025257, -0.912870929175277, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.30550504633039, 0.0, 0.0, 0.0, 0.0},
    {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
    {1.73205080756888, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
    {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
    
    // Compute reference derivatives.
    // Declare pointer to array of derivatives on FIAT element.
    double *derivatives = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      derivatives[r] = 0.0;
    }// end loop over 'r'
    
    // Declare derivative matrix (of polynomial basis).
    double dmats[10][10] = \
    {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
    
    // Declare (auxiliary) derivative matrix (of polynomial basis).
    double dmats_old[10][10] = \
    {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
    
    // Loop possible derivatives.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      // Resetting dmats values to compute next derivative.
      for (unsigned int t = 0; t < 10; t++)
      {
        for (unsigned int u = 0; u < 10; u++)
        {
          dmats[t][u] = 0.0;
          if (t == u)
          {
          dmats[t][u] = 1.0;
          }
          
        }// end loop over 'u'
      }// end loop over 't'
      
      // Looping derivative order to generate dmats.
      for (unsigned int s = 0; s < n; s++)
      {
        // Updating dmats_old with new values and resetting dmats.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats_old[t][u] = dmats[t][u];
            dmats[t][u] = 0.0;
          }// end loop over 'u'
        }// end loop over 't'
        
        // Update dmats using an inner product.
        if (combinations[r][s] == 0)
        {
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            for (unsigned int tu = 0; tu < 10; tu++)
            {
              dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
            }// end loop over 'tu'
          }// end loop over 'u'
        }// end loop over 't'
        }
        
        if (combinations[r][s] == 1)
        {
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            for (unsigned int tu = 0; tu < 10; tu++)
            {
              dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
            }// end loop over 'tu'
          }// end loop over 'u'
        }// end loop over 't'
        }
        
      }// end loop over 's'
      for (unsigned int s = 0; s < 10; s++)
      {
        for (unsigned int t = 0; t < 10; t++)
        {
          derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
        }// end loop over 't'
      }// end loop over 's'
    }// end loop over 'r'
    
    // Transform derivatives back to physical element
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r] += transform[r][s]*derivatives[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer to array of derivatives on FIAT element
    delete [] derivatives;
    
    // Delete pointer to array of combinations of derivatives and transform
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      delete [] combinations[r];
    }// end loop over 'r'
    delete [] combinations;
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      delete [] transform[r];
    }// end loop over 'r'
    delete [] transform;
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Element is constant, calling evaluate_basis_derivatives.
    evaluate_basis_derivatives(0, n, values, coordinates, c);
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0];
      y[1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    y[0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0];
    y[1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = 0;
    vertex_values[1] = 0;
    vertex_values[2] = 0;
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    throw std::runtime_error("map_from_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    throw std::runtime_error("map_to_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new adaptivepoisson_finite_element_2();
  }

};

/// This class defines the interface for a finite element.

class adaptivepoisson_finite_element_3: public ufc::finite_element
{
public:

  /// Constructor
  adaptivepoisson_finite_element_3() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~adaptivepoisson_finite_element_3()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Discontinuous Lagrange', Cell('triangle', Space(2)), 1, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::triangle;
  }

  /// Return the topological dimension of the cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 3;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Reset values.
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[3] = \
      {0.471404520791032, -0.288675134594813, -0.166666666666667};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 3; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[3] = \
      {0.471404520791032, 0.288675134594813, -0.166666666666667};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 3; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[3] = \
      {0.471404520791032, 0.0, 0.333333333333333};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 3; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 3; r++)
    {
      evaluate_basis(r, &dof_values, coordinates, c);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K_00, K_01}, {K_10, K_11}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[3] = \
      {0.471404520791032, -0.288675134594813, -0.166666666666667};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[3] = \
      {0.471404520791032, 0.288675134594813, -0.166666666666667};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[3] = \
      {0.471404520791032, 0.0, 0.333333333333333};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      dof_values[r] = 0.0;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 3; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    y[0] = x[0][0];
    y[1] = x[0][1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = x[1][0];
    y[1] = x[1][1];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = x[2][0];
    y[1] = x[2][1];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    throw std::runtime_error("map_from_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    throw std::runtime_error("map_to_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new adaptivepoisson_finite_element_3();
  }

};

/// This class defines the interface for a finite element.

class adaptivepoisson_finite_element_4: public ufc::finite_element
{
public:

  /// Constructor
  adaptivepoisson_finite_element_4() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~adaptivepoisson_finite_element_4()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Lagrange', Cell('triangle', Space(2)), 2, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::triangle;
  }

  /// Return the topological dimension of the cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 6;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Reset values.
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, -0.173205080756888, -0.1, 0.121716123890037, 0.0942809041582064, 0.0544331053951817};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, 0.173205080756888, -0.1, 0.121716123890037, -0.0942809041582063, 0.0544331053951818};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, 0.0, 0.2, 0.0, 0.0, 0.163299316185545};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.471404520791032, 0.23094010767585, 0.133333333333333, 0.0, 0.188561808316413, -0.163299316185545};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.471404520791032, -0.23094010767585, 0.133333333333333, 0.0, -0.188561808316413, -0.163299316185545};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.471404520791032, 0.0, -0.266666666666667, -0.243432247780074, 0.0, 0.0544331053951817};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 6; r++)
    {
      evaluate_basis(r, &dof_values, coordinates, c);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K_00, K_01}, {K_10, K_11}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, -0.173205080756888, -0.1, 0.121716123890037, 0.0942809041582064, 0.0544331053951817};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, 0.173205080756888, -0.1, 0.121716123890037, -0.0942809041582063, 0.0544331053951818};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, 0.0, 0.2, 0.0, 0.0, 0.163299316185545};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.471404520791032, 0.23094010767585, 0.133333333333333, 0.0, 0.188561808316413, -0.163299316185545};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.471404520791032, -0.23094010767585, 0.133333333333333, 0.0, -0.188561808316413, -0.163299316185545};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.471404520791032, 0.0, -0.266666666666667, -0.243432247780074, 0.0, 0.0544331053951817};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0},
      {2, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      dof_values[r] = 0.0;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 6; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = 0.5*x[1][0] + 0.5*x[2][0];
      y[1] = 0.5*x[1][1] + 0.5*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = 0.5*x[0][0] + 0.5*x[2][0];
      y[1] = 0.5*x[0][1] + 0.5*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 5:
      {
        y[0] = 0.5*x[0][0] + 0.5*x[1][0];
      y[1] = 0.5*x[0][1] + 0.5*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    y[0] = x[0][0];
    y[1] = x[0][1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = x[1][0];
    y[1] = x[1][1];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = x[2][0];
    y[1] = x[2][1];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = 0.5*x[1][0] + 0.5*x[2][0];
    y[1] = 0.5*x[1][1] + 0.5*x[2][1];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = 0.5*x[0][0] + 0.5*x[2][0];
    y[1] = 0.5*x[0][1] + 0.5*x[2][1];
    f.evaluate(vals, y, c);
    values[4] = vals[0];
    y[0] = 0.5*x[0][0] + 0.5*x[1][0];
    y[1] = 0.5*x[0][1] + 0.5*x[1][1];
    f.evaluate(vals, y, c);
    values[5] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    throw std::runtime_error("map_from_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    throw std::runtime_error("map_to_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new adaptivepoisson_finite_element_4();
  }

};

/// This class defines the interface for a finite element.

class adaptivepoisson_finite_element_5: public ufc::finite_element
{
public:

  /// Constructor
  adaptivepoisson_finite_element_5() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~adaptivepoisson_finite_element_5()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Lagrange', Cell('triangle', Space(2)), 1, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::triangle;
  }

  /// Return the topological dimension of the cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 3;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Reset values.
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[3] = \
      {0.471404520791032, -0.288675134594813, -0.166666666666667};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 3; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[3] = \
      {0.471404520791032, 0.288675134594813, -0.166666666666667};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 3; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[3] = \
      {0.471404520791032, 0.0, 0.333333333333333};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 3; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 3; r++)
    {
      evaluate_basis(r, &dof_values, coordinates, c);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K_00, K_01}, {K_10, K_11}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[3] = \
      {0.471404520791032, -0.288675134594813, -0.166666666666667};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[3] = \
      {0.471404520791032, 0.288675134594813, -0.166666666666667};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[3] = \
      {0.471404520791032, 0.0, 0.333333333333333};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      dof_values[r] = 0.0;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 3; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    y[0] = x[0][0];
    y[1] = x[0][1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = x[1][0];
    y[1] = x[1][1];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = x[2][0];
    y[1] = x[2][1];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    throw std::runtime_error("map_from_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    throw std::runtime_error("map_to_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new adaptivepoisson_finite_element_5();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class adaptivepoisson_dofmap_0: public ufc::dofmap
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  adaptivepoisson_dofmap_0() : ufc::dofmap()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~adaptivepoisson_dofmap_0()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Discontinuous Lagrange', Cell('triangle', Space(2)), 0, None)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return false;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return true;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dofmap for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = m.num_entities[2];
    return false;
  }

  /// Initialize dofmap for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dofmap for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the topological dimension of the associated cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 1;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 1;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 0;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 0;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 1;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    dofs[0] = c.entity_indices[2][0];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 0;
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0];
    coordinates[0][1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1];
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual unsigned int num_sub_dofmaps() const
  {
    return 0;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new adaptivepoisson_dofmap_0();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class adaptivepoisson_dofmap_1: public ufc::dofmap
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  adaptivepoisson_dofmap_1() : ufc::dofmap()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~adaptivepoisson_dofmap_1()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Discontinuous Lagrange', Cell('triangle', Space(2)), 2, None)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return false;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return true;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dofmap for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = 6*m.num_entities[2];
    return false;
  }

  /// Initialize dofmap for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dofmap for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the topological dimension of the associated cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 6;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 6;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 0;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 0;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 6;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    dofs[0] = 6*c.entity_indices[2][0];
    dofs[1] = 6*c.entity_indices[2][0] + 1;
    dofs[2] = 6*c.entity_indices[2][0] + 2;
    dofs[3] = 6*c.entity_indices[2][0] + 3;
    dofs[4] = 6*c.entity_indices[2][0] + 4;
    dofs[5] = 6*c.entity_indices[2][0] + 5;
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
      dofs[3] = 3;
      dofs[4] = 4;
      dofs[5] = 5;
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = x[0][0];
    coordinates[0][1] = x[0][1];
    coordinates[1][0] = x[1][0];
    coordinates[1][1] = x[1][1];
    coordinates[2][0] = x[2][0];
    coordinates[2][1] = x[2][1];
    coordinates[3][0] = 0.5*x[1][0] + 0.5*x[2][0];
    coordinates[3][1] = 0.5*x[1][1] + 0.5*x[2][1];
    coordinates[4][0] = 0.5*x[0][0] + 0.5*x[2][0];
    coordinates[4][1] = 0.5*x[0][1] + 0.5*x[2][1];
    coordinates[5][0] = 0.5*x[0][0] + 0.5*x[1][0];
    coordinates[5][1] = 0.5*x[0][1] + 0.5*x[1][1];
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual unsigned int num_sub_dofmaps() const
  {
    return 0;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new adaptivepoisson_dofmap_1();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class adaptivepoisson_dofmap_2: public ufc::dofmap
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  adaptivepoisson_dofmap_2() : ufc::dofmap()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~adaptivepoisson_dofmap_2()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Bubble', Cell('triangle', Space(2)), 3, None)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return false;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return true;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dofmap for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = m.num_entities[2];
    return false;
  }

  /// Initialize dofmap for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dofmap for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the topological dimension of the associated cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 1;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 1;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 0;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 0;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 1;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    dofs[0] = c.entity_indices[2][0];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 0;
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0];
    coordinates[0][1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1];
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual unsigned int num_sub_dofmaps() const
  {
    return 0;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new adaptivepoisson_dofmap_2();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class adaptivepoisson_dofmap_3: public ufc::dofmap
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  adaptivepoisson_dofmap_3() : ufc::dofmap()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~adaptivepoisson_dofmap_3()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Discontinuous Lagrange', Cell('triangle', Space(2)), 1, None)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return false;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return true;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dofmap for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = 3*m.num_entities[2];
    return false;
  }

  /// Initialize dofmap for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dofmap for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the topological dimension of the associated cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 3;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 3;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 0;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 0;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 3;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    dofs[0] = 3*c.entity_indices[2][0];
    dofs[1] = 3*c.entity_indices[2][0] + 1;
    dofs[2] = 3*c.entity_indices[2][0] + 2;
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = x[0][0];
    coordinates[0][1] = x[0][1];
    coordinates[1][0] = x[1][0];
    coordinates[1][1] = x[1][1];
    coordinates[2][0] = x[2][0];
    coordinates[2][1] = x[2][1];
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual unsigned int num_sub_dofmaps() const
  {
    return 0;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new adaptivepoisson_dofmap_3();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class adaptivepoisson_dofmap_4: public ufc::dofmap
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  adaptivepoisson_dofmap_4() : ufc::dofmap()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~adaptivepoisson_dofmap_4()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Lagrange', Cell('triangle', Space(2)), 2, None)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return true;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dofmap for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = m.num_entities[0] + m.num_entities[1];
    return false;
  }

  /// Initialize dofmap for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dofmap for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the topological dimension of the associated cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 6;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 6;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 3;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 1;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    unsigned int offset = 0;
    dofs[0] = offset + c.entity_indices[0][0];
    dofs[1] = offset + c.entity_indices[0][1];
    dofs[2] = offset + c.entity_indices[0][2];
    offset += m.num_entities[0];
    dofs[3] = offset + c.entity_indices[1][0];
    dofs[4] = offset + c.entity_indices[1][1];
    dofs[5] = offset + c.entity_indices[1][2];
    offset += m.num_entities[1];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 4;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 5;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 3;
          break;
        }
      case 1:
        {
          dofs[0] = 4;
          break;
        }
      case 2:
        {
          dofs[0] = 5;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = x[0][0];
    coordinates[0][1] = x[0][1];
    coordinates[1][0] = x[1][0];
    coordinates[1][1] = x[1][1];
    coordinates[2][0] = x[2][0];
    coordinates[2][1] = x[2][1];
    coordinates[3][0] = 0.5*x[1][0] + 0.5*x[2][0];
    coordinates[3][1] = 0.5*x[1][1] + 0.5*x[2][1];
    coordinates[4][0] = 0.5*x[0][0] + 0.5*x[2][0];
    coordinates[4][1] = 0.5*x[0][1] + 0.5*x[2][1];
    coordinates[5][0] = 0.5*x[0][0] + 0.5*x[1][0];
    coordinates[5][1] = 0.5*x[0][1] + 0.5*x[1][1];
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual unsigned int num_sub_dofmaps() const
  {
    return 0;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new adaptivepoisson_dofmap_4();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class adaptivepoisson_dofmap_5: public ufc::dofmap
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  adaptivepoisson_dofmap_5() : ufc::dofmap()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~adaptivepoisson_dofmap_5()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Lagrange', Cell('triangle', Space(2)), 1, None)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dofmap for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = m.num_entities[0];
    return false;
  }

  /// Initialize dofmap for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dofmap for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the topological dimension of the associated cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 3;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 3;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 2;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    dofs[0] = c.entity_indices[0][0];
    dofs[1] = c.entity_indices[0][1];
    dofs[2] = c.entity_indices[0][2];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = x[0][0];
    coordinates[0][1] = x[0][1];
    coordinates[1][0] = x[1][0];
    coordinates[1][1] = x[1][1];
    coordinates[2][0] = x[2][0];
    coordinates[2][1] = x[2][1];
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual unsigned int num_sub_dofmaps() const
  {
    return 0;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new adaptivepoisson_dofmap_5();
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class adaptivepoisson_cell_integral_0_0: public ufc::cell_integral
{
public:

  /// Constructor
  adaptivepoisson_cell_integral_0_0() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~adaptivepoisson_cell_integral_0_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c) const
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      11
    // Number of operations (multiply-add pairs) for geometry tensor:    8
    // Number of operations (multiply-add pairs) for tensor contraction: 11
    // Total number of operations (multiply-add pairs):                  30
    
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_0_0 = det*(K_00*K_00 + K_01*K_01);
    const double G0_0_1 = det*(K_00*K_10 + K_01*K_11);
    const double G0_1_0 = det*(K_10*K_00 + K_11*K_01);
    const double G0_1_1 = det*(K_10*K_10 + K_11*K_11);
    
    // Compute element tensor
    A[0] = 0.5*G0_0_0 + 0.5*G0_0_1 + 0.5*G0_1_0 + 0.5*G0_1_1;
    A[1] = -0.5*G0_0_0 - 0.5*G0_1_0;
    A[2] = -0.5*G0_0_1 - 0.5*G0_1_1;
    A[3] = -0.5*G0_0_0 - 0.5*G0_0_1;
    A[4] = 0.5*G0_0_0;
    A[5] = 0.5*G0_0_1;
    A[6] = -0.5*G0_1_0 - 0.5*G0_1_1;
    A[7] = 0.5*G0_1_0;
    A[8] = 0.5*G0_1_1;
  }

  /// Tabulate the tensor for the contribution from a local cell
  /// using the specified reference cell quadrature points/weights
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c,
                               unsigned int num_quadrature_points,
                               const double * const * quadrature_points,
                               const double* quadrature_weights) const
  {
    throw std::runtime_error("Quadrature version of tabulate_tensor not available when using the FFC tensor representation.");
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class adaptivepoisson_cell_integral_1_0: public ufc::cell_integral
{
public:

  /// Constructor
  adaptivepoisson_cell_integral_1_0() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~adaptivepoisson_cell_integral_1_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c) const
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      9
    // Number of operations (multiply-add pairs) for geometry tensor:    0
    // Number of operations (multiply-add pairs) for tensor contraction: 1
    // Total number of operations (multiply-add pairs):                  10
    
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_ = det;
    
    // Compute element tensor
    A[0] = 0.166666666666667*G0_;
    A[1] = 0.166666666666667*G0_;
    A[2] = 0.166666666666667*G0_;
  }

  /// Tabulate the tensor for the contribution from a local cell
  /// using the specified reference cell quadrature points/weights
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c,
                               unsigned int num_quadrature_points,
                               const double * const * quadrature_points,
                               const double* quadrature_weights) const
  {
    throw std::runtime_error("Quadrature version of tabulate_tensor not available when using the FFC tensor representation.");
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class adaptivepoisson_cell_integral_2_0: public ufc::cell_integral
{
public:

  /// Constructor
  adaptivepoisson_cell_integral_2_0() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~adaptivepoisson_cell_integral_2_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Cell Volume.
    
    // Compute circumradius, assuming triangle is embedded in 2D.
    
    
    // Facet Area.
    
    // Array of quadrature weights.
    static const double W6[6] = {0.0833333333333333, 0.0833333333333333, 0.0833333333333333, 0.0833333333333333, 0.0833333333333333, 0.0833333333333333};
    // Quadrature points on the UFC reference element: (0.659027622374092, 0.231933368553031), (0.659027622374092, 0.109039009072877), (0.231933368553031, 0.659027622374092), (0.231933368553031, 0.109039009072877), (0.109039009072877, 0.659027622374092), (0.109039009072877, 0.231933368553031)
    
    // Value of basis functions at quadrature points.
    static const double FE0[6][3] = \
    {{0.109039009072877, 0.659027622374092, 0.231933368553031},
    {0.231933368553031, 0.659027622374092, 0.109039009072877},
    {0.109039009072877, 0.231933368553031, 0.659027622374092},
    {0.659027622374092, 0.231933368553031, 0.109039009072877},
    {0.231933368553031, 0.109039009072877, 0.659027622374092},
    {0.659027622374092, 0.109039009072877, 0.231933368553031}};
    
    static const double FE0_D01[6][2] = \
    {{-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0}};
    
    // Array of non-zero columns
    static const unsigned int nzc1[2] = {0, 1};
    
    // Array of non-zero columns
    static const unsigned int nzc0[2] = {0, 2};
    
    static const double FE1[6][6] = \
    {{-0.0852599980736871, 0.209607191730006, -0.124347193656319, 0.611401985706872, 0.101159138711827, 0.287438875581301},
    {-0.124347193656319, 0.209607191730006, -0.0852599980736871, 0.287438875581301, 0.101159138711827, 0.611401985706872},
    {-0.0852599980736871, -0.124347193656319, 0.209607191730006, 0.611401985706872, 0.287438875581301, 0.101159138711827},
    {0.209607191730006, -0.124347193656319, -0.0852599980736871, 0.101159138711828, 0.287438875581301, 0.611401985706872},
    {-0.124347193656319, -0.0852599980736871, 0.209607191730006, 0.287438875581301, 0.611401985706872, 0.101159138711827},
    {0.209607191730006, -0.0852599980736871, -0.124347193656319, 0.101159138711828, 0.611401985706872, 0.287438875581301}};
    
    static const double FE1_D01[6][5] = \
    {{0.563843963708492, -0.0722665257878755, 2.63611048949637, -0.491577437920616, -2.63611048949637},
    {0.0722665257878759, -0.563843963708492, 2.63611048949637, 0.491577437920617, -2.63611048949637},
    {0.563843963708492, 1.63611048949637, 0.927733474212124, -2.19995445320486, -0.927733474212123},
    {-1.63611048949637, -0.563843963708492, 0.927733474212123, 2.19995445320486, -0.927733474212124},
    {0.0722665257878758, 1.63611048949637, 0.436156036291507, -1.70837701528424, -0.436156036291508},
    {-1.63611048949637, -0.0722665257878758, 0.436156036291508, 1.70837701528424, -0.436156036291508}};
    
    // Array of non-zero columns
    static const unsigned int nzc2[5] = {0, 2, 3, 4, 5};
    
    static const double FE1_D10[6][5] = \
    {{0.563843963708492, 1.63611048949637, 0.927733474212124, -0.927733474212124, -2.19995445320486},
    {0.0722665257878758, 1.63611048949637, 0.436156036291508, -0.436156036291508, -1.70837701528424},
    {0.563843963708492, -0.0722665257878762, 2.63611048949637, -2.63611048949637, -0.491577437920616},
    {-1.63611048949637, -0.0722665257878759, 0.436156036291508, -0.436156036291508, 1.70837701528424},
    {0.0722665257878761, -0.563843963708492, 2.63611048949637, -2.63611048949637, 0.491577437920616},
    {-1.63611048949637, -0.563843963708492, 0.927733474212124, -0.927733474212124, 2.19995445320486}};
    
    // Array of non-zero columns
    static const unsigned int nzc3[5] = {0, 1, 3, 4, 5};
    
    // Reset values in the element tensor.
    A[0] = 0.0;
    // Number of operations to compute geometry constants: 12.
    double G[3];
    G[0] =  - det*(K_00*K_00 + K_01*K_01);
    G[1] =  - det*(K_00*K_10 + K_01*K_11);
    G[2] =  - det*(K_10*K_10 + K_11*K_11);
    
    // Compute element tensor using UFL quadrature representation
    // Optimisations: ('eliminate zeros', True), ('ignore ones', True), ('ignore zero tables', True), ('optimisation', 'simplify_expressions'), ('remove zero terms', True)
    
    // Loop quadrature points for integral.
    // Number of operations to compute element tensor for following IP loop = 366
    for (unsigned int ip = 0; ip < 6; ip++)
    {
      
      // Coefficient declarations.
      double F0 = 0.0;
      double F1 = 0.0;
      double F2 = 0.0;
      double F3 = 0.0;
      double F4 = 0.0;
      double F5 = 0.0;
      
      // Total number of operations to compute function values = 8
      for (unsigned int r = 0; r < 2; r++)
      {
        F2 += FE0_D01[ip][r]*w[2][nzc1[r]];
        F3 += FE0_D01[ip][r]*w[2][nzc0[r]];
      }// end loop over 'r'
      
      // Total number of operations to compute function values = 6
      for (unsigned int r = 0; r < 3; r++)
      {
        F0 += FE0[ip][r]*w[0][r];
      }// end loop over 'r'
      
      // Total number of operations to compute function values = 20
      for (unsigned int r = 0; r < 5; r++)
      {
        F4 += FE1_D10[ip][r]*w[3][nzc3[r]];
        F5 += FE1_D01[ip][r]*w[3][nzc2[r]];
      }// end loop over 'r'
      
      // Total number of operations to compute function values = 12
      for (unsigned int r = 0; r < 6; r++)
      {
        F1 += FE1[ip][r]*w[3][r];
      }// end loop over 'r'
      
      // Number of operations to compute ip constants: 14
      double I[1];
      // Number of operations: 14
      I[0] = W6[ip]*(F0*F1*det + F2*F4*G[0] + F3*F5*G[2] + G[1]*(F2*F5 + F3*F4));
      
      
      // Number of operations for primary indices: 1
      // Number of operations to compute entry: 1
      A[0] += I[0];
    }// end loop over 'ip'
  }

  /// Tabulate the tensor for the contribution from a local cell
  /// using the specified reference cell quadrature points/weights
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c,
                               unsigned int num_quadrature_points,
                               const double * const * quadrature_points,
                               const double* quadrature_weights) const
  {
    throw std::runtime_error("Quadrature version of tabulate_tensor not yet implemented (introduced in UFC 2.0).");
  }

};

/// This class defines the interface for the tabulation of the
/// exterior facet tensor corresponding to the local contribution to
/// a form from the integral over an exterior facet.

class adaptivepoisson_exterior_facet_integral_2_0: public ufc::exterior_facet_integral
{
public:

  /// Constructor
  adaptivepoisson_exterior_facet_integral_2_0() : ufc::exterior_facet_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~adaptivepoisson_exterior_facet_integral_2_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local exterior facet
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c,
                               unsigned int facet) const
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      9
    // Number of operations (multiply-add pairs) for geometry tensor:    13
    // Number of operations (multiply-add pairs) for tensor contraction: 10
    // Total number of operations (multiply-add pairs):                  32
    
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    
    // Compute determinant of Jacobian
    
    // Compute inverse of Jacobian
    
    // Get vertices on edge
    static unsigned int edge_vertices[3][2] = {{1, 2}, {0, 2}, {0, 1}};
    const unsigned int v0 = edge_vertices[facet][0];
    const unsigned int v1 = edge_vertices[facet][1];
    
    // Compute scale factor (length of edge scaled by length of reference interval)
    const double dx0 = x[v1][0] - x[v0][0];
    const double dx1 = x[v1][1] - x[v0][1];
    const double det = std::sqrt(dx0*dx0 + dx1*dx1);
    
    // Compute geometry tensor
    const double G0_0_0 = det*w[1][0]*w[3][0]*(1.0);
    const double G0_0_4 = det*w[1][0]*w[3][4]*(1.0);
    const double G0_0_5 = det*w[1][0]*w[3][5]*(1.0);
    const double G0_1_1 = det*w[1][1]*w[3][1]*(1.0);
    const double G0_1_3 = det*w[1][1]*w[3][3]*(1.0);
    const double G0_1_5 = det*w[1][1]*w[3][5]*(1.0);
    const double G0_2_2 = det*w[1][2]*w[3][2]*(1.0);
    const double G0_2_3 = det*w[1][2]*w[3][3]*(1.0);
    const double G0_2_4 = det*w[1][2]*w[3][4]*(1.0);
    
    // Compute element tensor
    switch (facet)
    {
    case 0:
      {
        A[0] = 0.166666666666666*G0_1_1 + 0.333333333333333*G0_1_3 + 0.166666666666666*G0_2_2 + 0.333333333333333*G0_2_3;
        break;
      }
    case 1:
      {
        A[0] = 0.166666666666667*G0_0_0 + 0.333333333333333*G0_0_4 + 0.166666666666666*G0_2_2 + 0.333333333333333*G0_2_4;
        break;
      }
    case 2:
      {
        A[0] = 0.166666666666666*G0_0_0 + 0.333333333333333*G0_0_5 + 0.166666666666667*G0_1_1 + 0.333333333333333*G0_1_5;
        break;
      }
    }
    
  }

  /// Tabulate the tensor for the contribution from a local exterior facet
  /// using the specified reference cell quadrature points/weights
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c,
                               unsigned int num_quadrature_points,
                               const double * const * quadrature_points,
                               const double* quadrature_weights) const
  {
    throw std::runtime_error("Quadrature version of tabulate_tensor not available when using the FFC tensor representation.");
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class adaptivepoisson_cell_integral_3_0: public ufc::cell_integral
{
public:

  /// Constructor
  adaptivepoisson_cell_integral_3_0() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~adaptivepoisson_cell_integral_3_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c) const
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      9
    // Number of operations (multiply-add pairs) for geometry tensor:    1
    // Number of operations (multiply-add pairs) for tensor contraction: 4
    // Total number of operations (multiply-add pairs):                  14
    
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_0 = det*w[0][0]*(1.0);
    
    // Compute element tensor
    A[0] = 0.0321428571428571*G0_0;
    A[1] = 0.0214285714285714*G0_0;
    A[2] = 0.0214285714285714*G0_0;
    A[3] = 0.0214285714285714*G0_0;
    A[4] = 0.0321428571428572*G0_0;
    A[5] = 0.0214285714285714*G0_0;
    A[6] = 0.0214285714285714*G0_0;
    A[7] = 0.0214285714285714*G0_0;
    A[8] = 0.0321428571428572*G0_0;
  }

  /// Tabulate the tensor for the contribution from a local cell
  /// using the specified reference cell quadrature points/weights
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c,
                               unsigned int num_quadrature_points,
                               const double * const * quadrature_points,
                               const double* quadrature_weights) const
  {
    throw std::runtime_error("Quadrature version of tabulate_tensor not available when using the FFC tensor representation.");
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class adaptivepoisson_cell_integral_4_0: public ufc::cell_integral
{
public:

  /// Constructor
  adaptivepoisson_cell_integral_4_0() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~adaptivepoisson_cell_integral_4_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Cell Volume.
    
    // Compute circumradius, assuming triangle is embedded in 2D.
    
    
    // Facet Area.
    
    // Array of quadrature weights.
    static const double W7[7] = {0.1125, 0.0629695902724136, 0.0629695902724136, 0.0629695902724136, 0.0661970763942531, 0.0661970763942531, 0.0661970763942531};
    // Quadrature points on the UFC reference element: (0.333333333333333, 0.333333333333333), (0.797426985353087, 0.101286507323456), (0.101286507323456, 0.797426985353087), (0.101286507323456, 0.101286507323456), (0.0597158717897698, 0.470142064105115), (0.470142064105115, 0.0597158717897698), (0.470142064105115, 0.470142064105115)
    
    // Value of basis functions at quadrature points.
    static const double FE0[7][1] = \
    {{1.0},
    {0.22088075779229},
    {0.22088075779229},
    {0.22088075779229},
    {0.356378717426369},
    {0.356378717426369},
    {0.356378717426369}};
    
    static const double FE0_D01[7][1] = \
    {{0.0},
    {0.0},
    {-1.90376021590477},
    {1.90376021590477},
    {0.0},
    {5.20988266488437},
    {-5.20988266488436}};
    
    static const double FE0_D10[7][1] = \
    {{0.0},
    {-1.90376021590477},
    {0.0},
    {1.90376021590477},
    {5.20988266488436},
    {0.0},
    {-5.20988266488436}};
    
    static const double FE1[7][3] = \
    {{0.333333333333333, 0.333333333333333, 0.333333333333333},
    {0.101286507323456, 0.797426985353087, 0.101286507323456},
    {0.101286507323456, 0.101286507323456, 0.797426985353087},
    {0.797426985353087, 0.101286507323456, 0.101286507323456},
    {0.470142064105115, 0.0597158717897698, 0.470142064105115},
    {0.470142064105115, 0.470142064105115, 0.0597158717897697},
    {0.0597158717897699, 0.470142064105115, 0.470142064105115}};
    
    static const double FE1_D01[7][2] = \
    {{-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0}};
    
    // Array of non-zero columns
    static const unsigned int nzc0[2] = {0, 2};
    
    // Array of non-zero columns
    static const unsigned int nzc1[2] = {0, 1};
    
    // Reset values in the element tensor.
    for (unsigned int r = 0; r < 3; r++)
    {
      A[r] = 0.0;
    }// end loop over 'r'
    // Number of operations to compute geometry constants: 12.
    double G[3];
    G[0] =  - det*(K_00*K_10 + K_01*K_11);
    G[1] =  - det*(K_10*K_10 + K_11*K_11);
    G[2] =  - det*(K_00*K_00 + K_01*K_01);
    
    // Compute element tensor using UFL quadrature representation
    // Optimisations: ('eliminate zeros', True), ('ignore ones', True), ('ignore zero tables', True), ('optimisation', 'simplify_expressions'), ('remove zero terms', True)
    
    // Loop quadrature points for integral.
    // Number of operations to compute element tensor for following IP loop = 406
    for (unsigned int ip = 0; ip < 7; ip++)
    {
      
      // Coefficient declarations.
      double F0 = 0.0;
      double F1 = 0.0;
      double F2 = 0.0;
      double F3 = 0.0;
      double F4 = 0.0;
      double F5 = 0.0;
      
      // Total number of operations to compute function values = 6
      for (unsigned int r = 0; r < 1; r++)
      {
        F1 += FE0[ip][r]*w[3][r];
        F4 += FE0_D10[ip][r]*w[3][r];
        F5 += FE0_D01[ip][r]*w[3][r];
      }// end loop over 'r'
      
      // Total number of operations to compute function values = 8
      for (unsigned int r = 0; r < 2; r++)
      {
        F2 += FE1_D01[ip][r]*w[2][nzc1[r]];
        F3 += FE1_D01[ip][r]*w[2][nzc0[r]];
      }// end loop over 'r'
      
      // Total number of operations to compute function values = 6
      for (unsigned int r = 0; r < 3; r++)
      {
        F0 += FE1[ip][r]*w[0][r];
      }// end loop over 'r'
      
      // Number of operations to compute ip constants: 24
      double I[3];
      // Number of operations: 5
      I[0] = F1*W7[ip]*(F2*G[0] + F3*G[1]);
      
      // Number of operations: 5
      I[1] = F1*W7[ip]*(F2*G[2] + F3*G[0]);
      
      // Number of operations: 14
      I[2] = W7[ip]*(F0*F1*det + F2*F4*G[2] + F3*F5*G[1] + G[0]*(F2*F5 + F3*F4));
      
      
      // Number of operations for primary indices: 6
      for (unsigned int j = 0; j < 3; j++)
      {
        // Number of operations to compute entry: 2
        A[j] += FE1[ip][j]*I[2];
      }// end loop over 'j'
      
      // Number of operations for primary indices: 8
      for (unsigned int j = 0; j < 2; j++)
      {
        // Number of operations to compute entry: 2
        A[nzc0[j]] += FE1_D01[ip][j]*I[0];
        // Number of operations to compute entry: 2
        A[nzc1[j]] += FE1_D01[ip][j]*I[1];
      }// end loop over 'j'
    }// end loop over 'ip'
  }

  /// Tabulate the tensor for the contribution from a local cell
  /// using the specified reference cell quadrature points/weights
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c,
                               unsigned int num_quadrature_points,
                               const double * const * quadrature_points,
                               const double* quadrature_weights) const
  {
    throw std::runtime_error("Quadrature version of tabulate_tensor not yet implemented (introduced in UFC 2.0).");
  }

};

/// This class defines the interface for the tabulation of the
/// exterior facet tensor corresponding to the local contribution to
/// a form from the integral over an exterior facet.

class adaptivepoisson_exterior_facet_integral_4_0: public ufc::exterior_facet_integral
{
public:

  /// Constructor
  adaptivepoisson_exterior_facet_integral_4_0() : ufc::exterior_facet_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~adaptivepoisson_exterior_facet_integral_4_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local exterior facet
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c,
                               unsigned int facet) const
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      6
    // Number of operations (multiply-add pairs) for geometry tensor:    0
    // Number of operations (multiply-add pairs) for tensor contraction: 0
    // Total number of operations (multiply-add pairs):                  6
    
    // Extract vertex coordinates
    
    // Compute Jacobian of affine map from reference cell
    
    // Compute determinant of Jacobian
    
    // Compute inverse of Jacobian
    
    // Get vertices on edge
    
    // Compute scale factor (length of edge scaled by length of reference interval)
    
    // Compute geometry tensor
    
    
    // Compute element tensor
    switch (facet)
    {
    case 0:
      {
        A[0] = 0.0;
      A[1] = 0.0;
      A[2] = 0.0;
        break;
      }
    case 1:
      {
        A[0] = 0.0;
      A[1] = 0.0;
      A[2] = 0.0;
        break;
      }
    case 2:
      {
        A[0] = 0.0;
      A[1] = 0.0;
      A[2] = 0.0;
        break;
      }
    }
    
  }

  /// Tabulate the tensor for the contribution from a local exterior facet
  /// using the specified reference cell quadrature points/weights
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c,
                               unsigned int num_quadrature_points,
                               const double * const * quadrature_points,
                               const double* quadrature_weights) const
  {
    throw std::runtime_error("Quadrature version of tabulate_tensor not available when using the FFC tensor representation.");
  }

};

/// This class defines the interface for the tabulation of the
/// exterior facet tensor corresponding to the local contribution to
/// a form from the integral over an exterior facet.

class adaptivepoisson_exterior_facet_integral_5_0: public ufc::exterior_facet_integral
{
public:

  /// Constructor
  adaptivepoisson_exterior_facet_integral_5_0() : ufc::exterior_facet_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~adaptivepoisson_exterior_facet_integral_5_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local exterior facet
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c,
                               unsigned int facet) const
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      9
    // Number of operations (multiply-add pairs) for geometry tensor:    6
    // Number of operations (multiply-add pairs) for tensor contraction: 30
    // Total number of operations (multiply-add pairs):                  45
    
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    
    // Compute determinant of Jacobian
    
    // Compute inverse of Jacobian
    
    // Get vertices on edge
    static unsigned int edge_vertices[3][2] = {{1, 2}, {0, 2}, {0, 1}};
    const unsigned int v0 = edge_vertices[facet][0];
    const unsigned int v1 = edge_vertices[facet][1];
    
    // Compute scale factor (length of edge scaled by length of reference interval)
    const double dx0 = x[v1][0] - x[v0][0];
    const double dx1 = x[v1][1] - x[v0][1];
    const double det = std::sqrt(dx0*dx0 + dx1*dx1);
    
    // Compute geometry tensor
    const double G0_0 = det*w[0][0]*(1.0);
    const double G0_1 = det*w[0][1]*(1.0);
    const double G0_2 = det*w[0][2]*(1.0);
    const double G0_3 = det*w[0][3]*(1.0);
    const double G0_4 = det*w[0][4]*(1.0);
    const double G0_5 = det*w[0][5]*(1.0);
    
    // Compute element tensor
    switch (facet)
    {
    case 0:
      {
        A[0] = 0.0;
      A[1] = 0.0;
      A[2] = 0.0;
      A[3] = 0.0;
      A[4] = 0.15*G0_1 - 0.0166666666666667*G0_2 + 0.2*G0_3;
      A[5] = 0.0166666666666666*G0_1 + 0.0166666666666667*G0_2 + 0.133333333333333*G0_3;
      A[6] = 0.0;
      A[7] = 0.0166666666666667*G0_1 + 0.0166666666666667*G0_2 + 0.133333333333333*G0_3;
      A[8] = -0.0166666666666666*G0_1 + 0.15*G0_2 + 0.2*G0_3;
        break;
      }
    case 1:
      {
        A[0] = 0.15*G0_0 - 0.0166666666666667*G0_2 + 0.2*G0_4;
      A[1] = 0.0;
      A[2] = 0.0166666666666666*G0_0 + 0.0166666666666667*G0_2 + 0.133333333333333*G0_4;
      A[3] = 0.0;
      A[4] = 0.0;
      A[5] = 0.0;
      A[6] = 0.0166666666666666*G0_0 + 0.0166666666666666*G0_2 + 0.133333333333333*G0_4;
      A[7] = 0.0;
      A[8] = -0.0166666666666667*G0_0 + 0.15*G0_2 + 0.2*G0_4;
        break;
      }
    case 2:
      {
        A[0] = 0.15*G0_0 - 0.0166666666666666*G0_1 + 0.2*G0_5;
      A[1] = 0.0166666666666666*G0_0 + 0.0166666666666666*G0_1 + 0.133333333333333*G0_5;
      A[2] = 0.0;
      A[3] = 0.0166666666666666*G0_0 + 0.0166666666666666*G0_1 + 0.133333333333333*G0_5;
      A[4] = -0.0166666666666667*G0_0 + 0.15*G0_1 + 0.2*G0_5;
      A[5] = 0.0;
      A[6] = 0.0;
      A[7] = 0.0;
      A[8] = 0.0;
        break;
      }
    }
    
  }

  /// Tabulate the tensor for the contribution from a local exterior facet
  /// using the specified reference cell quadrature points/weights
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c,
                               unsigned int num_quadrature_points,
                               const double * const * quadrature_points,
                               const double* quadrature_weights) const
  {
    throw std::runtime_error("Quadrature version of tabulate_tensor not available when using the FFC tensor representation.");
  }

};

/// This class defines the interface for the tabulation of the
/// interior facet tensor corresponding to the local contribution to
/// a form from the integral over an interior facet.

class adaptivepoisson_interior_facet_integral_5_0: public ufc::interior_facet_integral
{
public:

  /// Constructor
  adaptivepoisson_interior_facet_integral_5_0() : ufc::interior_facet_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~adaptivepoisson_interior_facet_integral_5_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local interior facet
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c0,
                               const ufc::cell& c1,
                               unsigned int facet0,
                               unsigned int facet1) const
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      12
    // Number of operations (multiply-add pairs) for geometry tensor:    12
    // Number of operations (multiply-add pairs) for tensor contraction: 180
    // Total number of operations (multiply-add pairs):                  204
    
    // Extract vertex coordinates
    const double * const * x0 = c0.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    
    // Compute determinant of Jacobian
    
    // Compute inverse of Jacobian
    
    // Compute Jacobian of affine map from reference cell
    
    // Compute determinant of Jacobian
    
    // Compute inverse of Jacobian
    
    // Get vertices on edge
    static unsigned int edge_vertices[3][2] = {{1, 2}, {0, 2}, {0, 1}};
    const unsigned int v0 = edge_vertices[facet0][0];
    const unsigned int v1 = edge_vertices[facet0][1];
    
    // Compute scale factor (length of edge scaled by length of reference interval)
    const double dx0 = x0[v1][0] - x0[v0][0];
    const double dx1 = x0[v1][1] - x0[v0][1];
    const double det = std::sqrt(dx0*dx0 + dx1*dx1);
    
    // Compute geometry tensor
    const double G0_6 = det*w[0][6]*(1.0);
    const double G0_7 = det*w[0][7]*(1.0);
    const double G0_8 = det*w[0][8]*(1.0);
    const double G0_9 = det*w[0][9]*(1.0);
    const double G0_10 = det*w[0][10]*(1.0);
    const double G0_11 = det*w[0][11]*(1.0);
    const double G1_0 = det*w[0][0]*(1.0);
    const double G1_1 = det*w[0][1]*(1.0);
    const double G1_2 = det*w[0][2]*(1.0);
    const double G1_3 = det*w[0][3]*(1.0);
    const double G1_4 = det*w[0][4]*(1.0);
    const double G1_5 = det*w[0][5]*(1.0);
    
    // Compute element tensor
    switch (facet0)
    {
    case 0:
      {
        switch (facet1)
      {
      case 0:
        {
          A[0] = 0.0;
        A[1] = 0.0;
        A[2] = 0.0;
        A[3] = 0.0;
        A[4] = 0.0;
        A[5] = 0.0;
        A[6] = 0.0;
        A[7] = 0.15*G1_1 - 0.0166666666666667*G1_2 + 0.2*G1_3;
        A[8] = 0.0166666666666666*G1_1 + 0.0166666666666667*G1_2 + 0.133333333333333*G1_3;
        A[9] = 0.0;
        A[10] = 0.0;
        A[11] = 0.0;
        A[12] = 0.0;
        A[13] = 0.0166666666666667*G1_1 + 0.0166666666666667*G1_2 + 0.133333333333333*G1_3;
        A[14] = -0.0166666666666666*G1_1 + 0.15*G1_2 + 0.2*G1_3;
        A[15] = 0.0;
        A[16] = 0.0;
        A[17] = 0.0;
        A[18] = 0.0;
        A[19] = 0.0;
        A[20] = 0.0;
        A[21] = 0.0;
        A[22] = 0.0;
        A[23] = 0.0;
        A[24] = 0.0;
        A[25] = 0.0;
        A[26] = 0.0;
        A[27] = 0.0;
        A[28] = 0.15*G0_7 - 0.0166666666666667*G0_8 + 0.2*G0_9;
        A[29] = 0.0166666666666666*G0_7 + 0.0166666666666667*G0_8 + 0.133333333333333*G0_9;
        A[30] = 0.0;
        A[31] = 0.0;
        A[32] = 0.0;
        A[33] = 0.0;
        A[34] = 0.0166666666666667*G0_7 + 0.0166666666666667*G0_8 + 0.133333333333333*G0_9;
        A[35] = -0.0166666666666666*G0_7 + 0.15*G0_8 + 0.2*G0_9;
          break;
        }
      case 1:
        {
          A[0] = 0.0;
        A[1] = 0.0;
        A[2] = 0.0;
        A[3] = 0.0;
        A[4] = 0.0;
        A[5] = 0.0;
        A[6] = 0.0;
        A[7] = 0.15*G1_1 - 0.0166666666666667*G1_2 + 0.2*G1_3;
        A[8] = 0.0166666666666666*G1_1 + 0.0166666666666667*G1_2 + 0.133333333333333*G1_3;
        A[9] = 0.0;
        A[10] = 0.0;
        A[11] = 0.0;
        A[12] = 0.0;
        A[13] = 0.0166666666666667*G1_1 + 0.0166666666666667*G1_2 + 0.133333333333333*G1_3;
        A[14] = -0.0166666666666666*G1_1 + 0.15*G1_2 + 0.2*G1_3;
        A[15] = 0.0;
        A[16] = 0.0;
        A[17] = 0.0;
        A[18] = 0.0;
        A[19] = 0.0;
        A[20] = 0.0;
        A[21] = 0.15*G0_6 - 0.0166666666666667*G0_8 + 0.2*G0_10;
        A[22] = 0.0;
        A[23] = 0.0166666666666666*G0_6 + 0.0166666666666667*G0_8 + 0.133333333333333*G0_10;
        A[24] = 0.0;
        A[25] = 0.0;
        A[26] = 0.0;
        A[27] = 0.0;
        A[28] = 0.0;
        A[29] = 0.0;
        A[30] = 0.0;
        A[31] = 0.0;
        A[32] = 0.0;
        A[33] = 0.0166666666666666*G0_6 + 0.0166666666666666*G0_8 + 0.133333333333333*G0_10;
        A[34] = 0.0;
        A[35] = -0.0166666666666667*G0_6 + 0.15*G0_8 + 0.2*G0_10;
          break;
        }
      case 2:
        {
          A[0] = 0.0;
        A[1] = 0.0;
        A[2] = 0.0;
        A[3] = 0.0;
        A[4] = 0.0;
        A[5] = 0.0;
        A[6] = 0.0;
        A[7] = 0.15*G1_1 - 0.0166666666666667*G1_2 + 0.2*G1_3;
        A[8] = 0.0166666666666666*G1_1 + 0.0166666666666667*G1_2 + 0.133333333333333*G1_3;
        A[9] = 0.0;
        A[10] = 0.0;
        A[11] = 0.0;
        A[12] = 0.0;
        A[13] = 0.0166666666666667*G1_1 + 0.0166666666666667*G1_2 + 0.133333333333333*G1_3;
        A[14] = -0.0166666666666666*G1_1 + 0.15*G1_2 + 0.2*G1_3;
        A[15] = 0.0;
        A[16] = 0.0;
        A[17] = 0.0;
        A[18] = 0.0;
        A[19] = 0.0;
        A[20] = 0.0;
        A[21] = 0.15*G0_6 - 0.0166666666666666*G0_7 + 0.2*G0_11;
        A[22] = 0.0166666666666666*G0_6 + 0.0166666666666666*G0_7 + 0.133333333333333*G0_11;
        A[23] = 0.0;
        A[24] = 0.0;
        A[25] = 0.0;
        A[26] = 0.0;
        A[27] = 0.0166666666666666*G0_6 + 0.0166666666666666*G0_7 + 0.133333333333333*G0_11;
        A[28] = -0.0166666666666667*G0_6 + 0.15*G0_7 + 0.2*G0_11;
        A[29] = 0.0;
        A[30] = 0.0;
        A[31] = 0.0;
        A[32] = 0.0;
        A[33] = 0.0;
        A[34] = 0.0;
        A[35] = 0.0;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        switch (facet1)
      {
      case 0:
        {
          A[0] = 0.15*G1_0 - 0.0166666666666667*G1_2 + 0.2*G1_4;
        A[1] = 0.0;
        A[2] = 0.0166666666666666*G1_0 + 0.0166666666666667*G1_2 + 0.133333333333333*G1_4;
        A[3] = 0.0;
        A[4] = 0.0;
        A[5] = 0.0;
        A[6] = 0.0;
        A[7] = 0.0;
        A[8] = 0.0;
        A[9] = 0.0;
        A[10] = 0.0;
        A[11] = 0.0;
        A[12] = 0.0166666666666666*G1_0 + 0.0166666666666666*G1_2 + 0.133333333333333*G1_4;
        A[13] = 0.0;
        A[14] = -0.0166666666666667*G1_0 + 0.15*G1_2 + 0.2*G1_4;
        A[15] = 0.0;
        A[16] = 0.0;
        A[17] = 0.0;
        A[18] = 0.0;
        A[19] = 0.0;
        A[20] = 0.0;
        A[21] = 0.0;
        A[22] = 0.0;
        A[23] = 0.0;
        A[24] = 0.0;
        A[25] = 0.0;
        A[26] = 0.0;
        A[27] = 0.0;
        A[28] = 0.15*G0_7 - 0.0166666666666667*G0_8 + 0.2*G0_9;
        A[29] = 0.0166666666666666*G0_7 + 0.0166666666666667*G0_8 + 0.133333333333333*G0_9;
        A[30] = 0.0;
        A[31] = 0.0;
        A[32] = 0.0;
        A[33] = 0.0;
        A[34] = 0.0166666666666667*G0_7 + 0.0166666666666667*G0_8 + 0.133333333333333*G0_9;
        A[35] = -0.0166666666666666*G0_7 + 0.15*G0_8 + 0.2*G0_9;
          break;
        }
      case 1:
        {
          A[0] = 0.15*G1_0 - 0.0166666666666667*G1_2 + 0.2*G1_4;
        A[1] = 0.0;
        A[2] = 0.0166666666666666*G1_0 + 0.0166666666666667*G1_2 + 0.133333333333333*G1_4;
        A[3] = 0.0;
        A[4] = 0.0;
        A[5] = 0.0;
        A[6] = 0.0;
        A[7] = 0.0;
        A[8] = 0.0;
        A[9] = 0.0;
        A[10] = 0.0;
        A[11] = 0.0;
        A[12] = 0.0166666666666666*G1_0 + 0.0166666666666666*G1_2 + 0.133333333333333*G1_4;
        A[13] = 0.0;
        A[14] = -0.0166666666666667*G1_0 + 0.15*G1_2 + 0.2*G1_4;
        A[15] = 0.0;
        A[16] = 0.0;
        A[17] = 0.0;
        A[18] = 0.0;
        A[19] = 0.0;
        A[20] = 0.0;
        A[21] = 0.15*G0_6 - 0.0166666666666667*G0_8 + 0.2*G0_10;
        A[22] = 0.0;
        A[23] = 0.0166666666666666*G0_6 + 0.0166666666666667*G0_8 + 0.133333333333333*G0_10;
        A[24] = 0.0;
        A[25] = 0.0;
        A[26] = 0.0;
        A[27] = 0.0;
        A[28] = 0.0;
        A[29] = 0.0;
        A[30] = 0.0;
        A[31] = 0.0;
        A[32] = 0.0;
        A[33] = 0.0166666666666666*G0_6 + 0.0166666666666666*G0_8 + 0.133333333333333*G0_10;
        A[34] = 0.0;
        A[35] = -0.0166666666666667*G0_6 + 0.15*G0_8 + 0.2*G0_10;
          break;
        }
      case 2:
        {
          A[0] = 0.15*G1_0 - 0.0166666666666667*G1_2 + 0.2*G1_4;
        A[1] = 0.0;
        A[2] = 0.0166666666666666*G1_0 + 0.0166666666666667*G1_2 + 0.133333333333333*G1_4;
        A[3] = 0.0;
        A[4] = 0.0;
        A[5] = 0.0;
        A[6] = 0.0;
        A[7] = 0.0;
        A[8] = 0.0;
        A[9] = 0.0;
        A[10] = 0.0;
        A[11] = 0.0;
        A[12] = 0.0166666666666666*G1_0 + 0.0166666666666666*G1_2 + 0.133333333333333*G1_4;
        A[13] = 0.0;
        A[14] = -0.0166666666666667*G1_0 + 0.15*G1_2 + 0.2*G1_4;
        A[15] = 0.0;
        A[16] = 0.0;
        A[17] = 0.0;
        A[18] = 0.0;
        A[19] = 0.0;
        A[20] = 0.0;
        A[21] = 0.15*G0_6 - 0.0166666666666666*G0_7 + 0.2*G0_11;
        A[22] = 0.0166666666666666*G0_6 + 0.0166666666666666*G0_7 + 0.133333333333333*G0_11;
        A[23] = 0.0;
        A[24] = 0.0;
        A[25] = 0.0;
        A[26] = 0.0;
        A[27] = 0.0166666666666666*G0_6 + 0.0166666666666666*G0_7 + 0.133333333333333*G0_11;
        A[28] = -0.0166666666666667*G0_6 + 0.15*G0_7 + 0.2*G0_11;
        A[29] = 0.0;
        A[30] = 0.0;
        A[31] = 0.0;
        A[32] = 0.0;
        A[33] = 0.0;
        A[34] = 0.0;
        A[35] = 0.0;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        switch (facet1)
      {
      case 0:
        {
          A[0] = 0.15*G1_0 - 0.0166666666666666*G1_1 + 0.2*G1_5;
        A[1] = 0.0166666666666666*G1_0 + 0.0166666666666666*G1_1 + 0.133333333333333*G1_5;
        A[2] = 0.0;
        A[3] = 0.0;
        A[4] = 0.0;
        A[5] = 0.0;
        A[6] = 0.0166666666666666*G1_0 + 0.0166666666666666*G1_1 + 0.133333333333333*G1_5;
        A[7] = -0.0166666666666667*G1_0 + 0.15*G1_1 + 0.2*G1_5;
        A[8] = 0.0;
        A[9] = 0.0;
        A[10] = 0.0;
        A[11] = 0.0;
        A[12] = 0.0;
        A[13] = 0.0;
        A[14] = 0.0;
        A[15] = 0.0;
        A[16] = 0.0;
        A[17] = 0.0;
        A[18] = 0.0;
        A[19] = 0.0;
        A[20] = 0.0;
        A[21] = 0.0;
        A[22] = 0.0;
        A[23] = 0.0;
        A[24] = 0.0;
        A[25] = 0.0;
        A[26] = 0.0;
        A[27] = 0.0;
        A[28] = 0.15*G0_7 - 0.0166666666666667*G0_8 + 0.2*G0_9;
        A[29] = 0.0166666666666666*G0_7 + 0.0166666666666667*G0_8 + 0.133333333333333*G0_9;
        A[30] = 0.0;
        A[31] = 0.0;
        A[32] = 0.0;
        A[33] = 0.0;
        A[34] = 0.0166666666666667*G0_7 + 0.0166666666666667*G0_8 + 0.133333333333333*G0_9;
        A[35] = -0.0166666666666666*G0_7 + 0.15*G0_8 + 0.2*G0_9;
          break;
        }
      case 1:
        {
          A[0] = 0.15*G1_0 - 0.0166666666666666*G1_1 + 0.2*G1_5;
        A[1] = 0.0166666666666666*G1_0 + 0.0166666666666666*G1_1 + 0.133333333333333*G1_5;
        A[2] = 0.0;
        A[3] = 0.0;
        A[4] = 0.0;
        A[5] = 0.0;
        A[6] = 0.0166666666666666*G1_0 + 0.0166666666666666*G1_1 + 0.133333333333333*G1_5;
        A[7] = -0.0166666666666667*G1_0 + 0.15*G1_1 + 0.2*G1_5;
        A[8] = 0.0;
        A[9] = 0.0;
        A[10] = 0.0;
        A[11] = 0.0;
        A[12] = 0.0;
        A[13] = 0.0;
        A[14] = 0.0;
        A[15] = 0.0;
        A[16] = 0.0;
        A[17] = 0.0;
        A[18] = 0.0;
        A[19] = 0.0;
        A[20] = 0.0;
        A[21] = 0.15*G0_6 - 0.0166666666666667*G0_8 + 0.2*G0_10;
        A[22] = 0.0;
        A[23] = 0.0166666666666666*G0_6 + 0.0166666666666667*G0_8 + 0.133333333333333*G0_10;
        A[24] = 0.0;
        A[25] = 0.0;
        A[26] = 0.0;
        A[27] = 0.0;
        A[28] = 0.0;
        A[29] = 0.0;
        A[30] = 0.0;
        A[31] = 0.0;
        A[32] = 0.0;
        A[33] = 0.0166666666666666*G0_6 + 0.0166666666666666*G0_8 + 0.133333333333333*G0_10;
        A[34] = 0.0;
        A[35] = -0.0166666666666667*G0_6 + 0.15*G0_8 + 0.2*G0_10;
          break;
        }
      case 2:
        {
          A[0] = 0.15*G1_0 - 0.0166666666666666*G1_1 + 0.2*G1_5;
        A[1] = 0.0166666666666666*G1_0 + 0.0166666666666666*G1_1 + 0.133333333333333*G1_5;
        A[2] = 0.0;
        A[3] = 0.0;
        A[4] = 0.0;
        A[5] = 0.0;
        A[6] = 0.0166666666666666*G1_0 + 0.0166666666666666*G1_1 + 0.133333333333333*G1_5;
        A[7] = -0.0166666666666667*G1_0 + 0.15*G1_1 + 0.2*G1_5;
        A[8] = 0.0;
        A[9] = 0.0;
        A[10] = 0.0;
        A[11] = 0.0;
        A[12] = 0.0;
        A[13] = 0.0;
        A[14] = 0.0;
        A[15] = 0.0;
        A[16] = 0.0;
        A[17] = 0.0;
        A[18] = 0.0;
        A[19] = 0.0;
        A[20] = 0.0;
        A[21] = 0.15*G0_6 - 0.0166666666666666*G0_7 + 0.2*G0_11;
        A[22] = 0.0166666666666666*G0_6 + 0.0166666666666666*G0_7 + 0.133333333333333*G0_11;
        A[23] = 0.0;
        A[24] = 0.0;
        A[25] = 0.0;
        A[26] = 0.0;
        A[27] = 0.0166666666666666*G0_6 + 0.0166666666666666*G0_7 + 0.133333333333333*G0_11;
        A[28] = -0.0166666666666667*G0_6 + 0.15*G0_7 + 0.2*G0_11;
        A[29] = 0.0;
        A[30] = 0.0;
        A[31] = 0.0;
        A[32] = 0.0;
        A[33] = 0.0;
        A[34] = 0.0;
        A[35] = 0.0;
          break;
        }
      }
      
        break;
      }
    }
    
  }

  /// Tabulate the tensor for the contribution from a local interior facet
  /// using the specified reference cell quadrature points/weights
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c,
                               unsigned int num_quadrature_points,
                               const double * const * quadrature_points,
                               const double* quadrature_weights) const
  {
    throw std::runtime_error("Quadrature version of tabulate_tensor not available when using the FFC tensor representation.");
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class adaptivepoisson_cell_integral_6_0: public ufc::cell_integral
{
public:

  /// Constructor
  adaptivepoisson_cell_integral_6_0() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~adaptivepoisson_cell_integral_6_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Cell Volume.
    
    // Compute circumradius, assuming triangle is embedded in 2D.
    
    
    // Facet Area.
    
    // Array of quadrature weights.
    static const double W6[6] = {0.054975871827661, 0.054975871827661, 0.054975871827661, 0.111690794839005, 0.111690794839005, 0.111690794839005};
    // Quadrature points on the UFC reference element: (0.816847572980459, 0.091576213509771), (0.091576213509771, 0.816847572980459), (0.091576213509771, 0.091576213509771), (0.10810301816807, 0.445948490915965), (0.445948490915965, 0.10810301816807), (0.445948490915965, 0.445948490915965)
    
    // Value of basis functions at quadrature points.
    static const double FE0[6][3] = \
    {{0.09157621350977, 0.816847572980459, 0.091576213509771},
    {0.09157621350977, 0.0915762135097711, 0.816847572980459},
    {0.816847572980458, 0.091576213509771, 0.091576213509771},
    {0.445948490915965, 0.10810301816807, 0.445948490915965},
    {0.445948490915965, 0.445948490915965, 0.10810301816807},
    {0.10810301816807, 0.445948490915965, 0.445948490915965}};
    
    static const double FE0_D01[6][2] = \
    {{-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0}};
    
    // Array of non-zero columns
    static const unsigned int nzc1[2] = {0, 1};
    
    // Array of non-zero columns
    static const unsigned int nzc0[2] = {0, 2};
    
    static const double FE2[6][6] = \
    {{-0.0748038077481961, 0.517632341987674, -0.0748038077481967, 0.299215230992787, 0.0335448115231483, 0.299215230992784},
    {-0.074803807748196, -0.0748038077481966, 0.517632341987673, 0.299215230992787, 0.299215230992784, 0.0335448115231483},
    {0.517632341987671, -0.0748038077481967, -0.0748038077481967, 0.0335448115231487, 0.299215230992787, 0.299215230992787},
    {-0.048208377815512, -0.0847304930939778, -0.048208377815512, 0.192833511262048, 0.795480226200906, 0.192833511262048},
    {-0.048208377815512, -0.0482083778155119, -0.0847304930939778, 0.192833511262048, 0.192833511262048, 0.795480226200906},
    {-0.0847304930939778, -0.048208377815512, -0.048208377815512, 0.795480226200906, 0.192833511262048, 0.192833511262048}};
    
    static const double FE2_D01[6][5] = \
    {{0.63369514596092, -0.633695145960915, 3.26739029192183, 0.0, -3.26739029192184},
    {0.63369514596092, 2.26739029192184, 0.366304854039083, -2.90108543788276, -0.366304854039083},
    {-2.26739029192183, -0.633695145960916, 0.366304854039084, 2.90108543788275, -0.366304854039083},
    {-0.78379396366386, 0.78379396366386, 0.43241207267228, 0.0, -0.43241207267228},
    {-0.78379396366386, -0.56758792732772, 1.78379396366386, 1.35138189099158, -1.78379396366386},
    {0.56758792732772, 0.78379396366386, 1.78379396366386, -1.35138189099158, -1.78379396366386}};
    
    // Array of non-zero columns
    static const unsigned int nzc2[5] = {0, 2, 3, 4, 5};
    
    static const double FE2_D10[6][5] = \
    {{0.63369514596092, 2.26739029192184, 0.366304854039083, -0.366304854039084, -2.90108543788276},
    {0.63369514596092, -0.633695145960916, 3.26739029192183, -3.26739029192183, 0.0},
    {-2.26739029192183, -0.633695145960916, 0.366304854039083, -0.366304854039084, 2.90108543788275},
    {-0.78379396366386, -0.56758792732772, 1.78379396366386, -1.78379396366386, 1.35138189099158},
    {-0.78379396366386, 0.78379396366386, 0.43241207267228, -0.43241207267228, 0.0},
    {0.56758792732772, 0.78379396366386, 1.78379396366386, -1.78379396366386, -1.35138189099158}};
    
    // Array of non-zero columns
    static const unsigned int nzc3[5] = {0, 1, 3, 4, 5};
    
    // Reset values in the element tensor.
    for (unsigned int r = 0; r < 3; r++)
    {
      A[r] = 0.0;
    }// end loop over 'r'
    // Number of operations to compute geometry constants: 12.
    double G[3];
    G[0] =  - det*(K_00*K_10 + K_01*K_11);
    G[1] =  - det*(K_10*K_10 + K_11*K_11);
    G[2] =  - det*(K_00*K_00 + K_01*K_01);
    
    // Compute element tensor using UFL quadrature representation
    // Optimisations: ('eliminate zeros', True), ('ignore ones', True), ('ignore zero tables', True), ('optimisation', 'simplify_expressions'), ('remove zero terms', True)
    
    // Loop quadrature points for integral.
    // Number of operations to compute element tensor for following IP loop = 546
    for (unsigned int ip = 0; ip < 6; ip++)
    {
      
      // Coefficient declarations.
      double F0 = 0.0;
      double F1 = 0.0;
      double F2 = 0.0;
      double F3 = 0.0;
      double F4 = 0.0;
      double F5 = 0.0;
      double F6 = 0.0;
      
      // Total number of operations to compute function values = 8
      for (unsigned int r = 0; r < 2; r++)
      {
        F3 += FE0_D01[ip][r]*w[2][nzc1[r]];
        F4 += FE0_D01[ip][r]*w[2][nzc0[r]];
      }// end loop over 'r'
      
      // Total number of operations to compute function values = 12
      for (unsigned int r = 0; r < 3; r++)
      {
        F0 += FE0[ip][r]*w[3][r];
        F2 += FE0[ip][r]*w[0][r];
      }// end loop over 'r'
      
      // Total number of operations to compute function values = 20
      for (unsigned int r = 0; r < 5; r++)
      {
        F5 += FE2_D10[ip][r]*w[4][nzc3[r]];
        F6 += FE2_D01[ip][r]*w[4][nzc2[r]];
      }// end loop over 'r'
      
      // Total number of operations to compute function values = 12
      for (unsigned int r = 0; r < 6; r++)
      {
        F1 += FE2[ip][r]*w[4][r];
      }// end loop over 'r'
      
      // Number of operations to compute ip constants: 25
      double I[3];
      // Number of operations: 5
      I[0] = F1*W6[ip]*(F3*G[0] + F4*G[1]);
      
      // Number of operations: 5
      I[1] = F1*W6[ip]*(F3*G[2] + F4*G[0]);
      
      // Number of operations: 15
      I[2] = W6[ip]*(F1*det*(F2 - F0) + F3*F5*G[2] + F4*F6*G[1] + G[0]*(F3*F6 + F4*F5));
      
      
      // Number of operations for primary indices: 6
      for (unsigned int j = 0; j < 3; j++)
      {
        // Number of operations to compute entry: 2
        A[j] += FE0[ip][j]*I[2];
      }// end loop over 'j'
      
      // Number of operations for primary indices: 8
      for (unsigned int j = 0; j < 2; j++)
      {
        // Number of operations to compute entry: 2
        A[nzc0[j]] += FE0_D01[ip][j]*I[0];
        // Number of operations to compute entry: 2
        A[nzc1[j]] += FE0_D01[ip][j]*I[1];
      }// end loop over 'j'
    }// end loop over 'ip'
  }

  /// Tabulate the tensor for the contribution from a local cell
  /// using the specified reference cell quadrature points/weights
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c,
                               unsigned int num_quadrature_points,
                               const double * const * quadrature_points,
                               const double* quadrature_weights) const
  {
    throw std::runtime_error("Quadrature version of tabulate_tensor not yet implemented (introduced in UFC 2.0).");
  }

};

/// This class defines the interface for the tabulation of the
/// exterior facet tensor corresponding to the local contribution to
/// a form from the integral over an exterior facet.

class adaptivepoisson_exterior_facet_integral_6_0: public ufc::exterior_facet_integral
{
public:

  /// Constructor
  adaptivepoisson_exterior_facet_integral_6_0() : ufc::exterior_facet_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~adaptivepoisson_exterior_facet_integral_6_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local exterior facet
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c,
                               unsigned int facet) const
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      9
    // Number of operations (multiply-add pairs) for geometry tensor:    22
    // Number of operations (multiply-add pairs) for tensor contraction: 33
    // Total number of operations (multiply-add pairs):                  64
    
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    
    // Compute determinant of Jacobian
    
    // Compute inverse of Jacobian
    
    // Get vertices on edge
    static unsigned int edge_vertices[3][2] = {{1, 2}, {0, 2}, {0, 1}};
    const unsigned int v0 = edge_vertices[facet][0];
    const unsigned int v1 = edge_vertices[facet][1];
    
    // Compute scale factor (length of edge scaled by length of reference interval)
    const double dx0 = x[v1][0] - x[v0][0];
    const double dx1 = x[v1][1] - x[v0][1];
    const double det = std::sqrt(dx0*dx0 + dx1*dx1);
    
    // Compute geometry tensor
    const double G0_0_0 = det*w[1][0]*w[4][0]*(1.0);
    const double G0_0_1 = det*w[1][0]*w[4][1]*(1.0);
    const double G0_0_2 = det*w[1][0]*w[4][2]*(1.0);
    const double G0_0_4 = det*w[1][0]*w[4][4]*(1.0);
    const double G0_0_5 = det*w[1][0]*w[4][5]*(1.0);
    const double G0_1_0 = det*w[1][1]*w[4][0]*(1.0);
    const double G0_1_1 = det*w[1][1]*w[4][1]*(1.0);
    const double G0_1_2 = det*w[1][1]*w[4][2]*(1.0);
    const double G0_1_3 = det*w[1][1]*w[4][3]*(1.0);
    const double G0_1_5 = det*w[1][1]*w[4][5]*(1.0);
    const double G0_2_0 = det*w[1][2]*w[4][0]*(1.0);
    const double G0_2_1 = det*w[1][2]*w[4][1]*(1.0);
    const double G0_2_2 = det*w[1][2]*w[4][2]*(1.0);
    const double G0_2_3 = det*w[1][2]*w[4][3]*(1.0);
    const double G0_2_4 = det*w[1][2]*w[4][4]*(1.0);
    
    // Compute element tensor
    switch (facet)
    {
    case 0:
      {
        A[0] = 0.0;
      A[1] = 0.15*G0_1_1 - 0.0166666666666667*G0_1_2 + 0.2*G0_1_3 + 0.0166666666666666*G0_2_1 + 0.0166666666666667*G0_2_2 + 0.133333333333333*G0_2_3;
      A[2] = 0.0166666666666667*G0_1_1 + 0.0166666666666667*G0_1_2 + 0.133333333333333*G0_1_3 - 0.0166666666666666*G0_2_1 + 0.15*G0_2_2 + 0.2*G0_2_3;
        break;
      }
    case 1:
      {
        A[0] = 0.15*G0_0_0 - 0.0166666666666667*G0_0_2 + 0.2*G0_0_4 + 0.0166666666666666*G0_2_0 + 0.0166666666666667*G0_2_2 + 0.133333333333333*G0_2_4;
      A[1] = 0.0;
      A[2] = 0.0166666666666666*G0_0_0 + 0.0166666666666666*G0_0_2 + 0.133333333333333*G0_0_4 - 0.0166666666666667*G0_2_0 + 0.15*G0_2_2 + 0.2*G0_2_4;
        break;
      }
    case 2:
      {
        A[0] = 0.15*G0_0_0 - 0.0166666666666666*G0_0_1 + 0.2*G0_0_5 + 0.0166666666666666*G0_1_0 + 0.0166666666666666*G0_1_1 + 0.133333333333333*G0_1_5;
      A[1] = 0.0166666666666666*G0_0_0 + 0.0166666666666666*G0_0_1 + 0.133333333333333*G0_0_5 - 0.0166666666666667*G0_1_0 + 0.15*G0_1_1 + 0.2*G0_1_5;
      A[2] = 0.0;
        break;
      }
    }
    
  }

  /// Tabulate the tensor for the contribution from a local exterior facet
  /// using the specified reference cell quadrature points/weights
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c,
                               unsigned int num_quadrature_points,
                               const double * const * quadrature_points,
                               const double* quadrature_weights) const
  {
    throw std::runtime_error("Quadrature version of tabulate_tensor not available when using the FFC tensor representation.");
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class adaptivepoisson_cell_integral_7_0: public ufc::cell_integral
{
public:

  /// Constructor
  adaptivepoisson_cell_integral_7_0() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~adaptivepoisson_cell_integral_7_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c) const
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      9
    // Number of operations (multiply-add pairs) for geometry tensor:    40
    // Number of operations (multiply-add pairs) for tensor contraction: 26
    // Total number of operations (multiply-add pairs):                  75
    
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_0_0 = det*w[1][0]*w[0][0]*(1.0);
    const double G0_0_1 = det*w[1][0]*w[0][1]*(1.0);
    const double G0_0_2 = det*w[1][0]*w[0][2]*(1.0);
    const double G0_0_3 = det*w[1][0]*w[0][3]*(1.0);
    const double G0_0_4 = det*w[1][0]*w[0][4]*(1.0);
    const double G0_0_5 = det*w[1][0]*w[0][5]*(1.0);
    const double G0_1_0 = det*w[1][1]*w[0][0]*(1.0);
    const double G0_1_1 = det*w[1][1]*w[0][1]*(1.0);
    const double G0_1_2 = det*w[1][1]*w[0][2]*(1.0);
    const double G0_1_3 = det*w[1][1]*w[0][3]*(1.0);
    const double G0_1_4 = det*w[1][1]*w[0][4]*(1.0);
    const double G0_1_5 = det*w[1][1]*w[0][5]*(1.0);
    const double G0_2_0 = det*w[1][2]*w[0][0]*(1.0);
    const double G0_2_1 = det*w[1][2]*w[0][1]*(1.0);
    const double G0_2_2 = det*w[1][2]*w[0][2]*(1.0);
    const double G0_2_3 = det*w[1][2]*w[0][3]*(1.0);
    const double G0_2_4 = det*w[1][2]*w[0][4]*(1.0);
    const double G0_2_5 = det*w[1][2]*w[0][5]*(1.0);
    const double G1_0_0 = det*w[1][0]*w[3][0]*(1.0);
    const double G1_0_1 = det*w[1][0]*w[3][1]*(1.0);
    const double G1_0_2 = det*w[1][0]*w[3][2]*(1.0);
    const double G1_1_0 = det*w[1][1]*w[3][0]*(1.0);
    const double G1_1_1 = det*w[1][1]*w[3][1]*(1.0);
    const double G1_1_2 = det*w[1][1]*w[3][2]*(1.0);
    const double G1_2_0 = det*w[1][2]*w[3][0]*(1.0);
    const double G1_2_1 = det*w[1][2]*w[3][1]*(1.0);
    const double G1_2_2 = det*w[1][2]*w[3][2]*(1.0);
    
    // Compute element tensor
    A[0] = 0.0166666666666666*G0_0_0 - 0.00833333333333333*G0_0_1 - 0.00833333333333333*G0_0_2 + 0.0333333333333333*G0_0_3 + 0.0666666666666667*G0_0_4 + 0.0666666666666667*G0_0_5 - 0.00833333333333333*G0_1_0 + 0.0166666666666666*G0_1_1 - 0.00833333333333332*G0_1_2 + 0.0666666666666667*G0_1_3 + 0.0333333333333333*G0_1_4 + 0.0666666666666667*G0_1_5 - 0.00833333333333333*G0_2_0 - 0.00833333333333333*G0_2_1 + 0.0166666666666666*G0_2_2 + 0.0666666666666667*G0_2_3 + 0.0666666666666667*G0_2_4 + 0.0333333333333333*G0_2_5 - 0.0833333333333333*G1_0_0 - 0.0416666666666667*G1_0_1 - 0.0416666666666667*G1_0_2 - 0.0416666666666667*G1_1_0 - 0.0833333333333333*G1_1_1 - 0.0416666666666667*G1_1_2 - 0.0416666666666667*G1_2_0 - 0.0416666666666667*G1_2_1 - 0.0833333333333333*G1_2_2;
  }

  /// Tabulate the tensor for the contribution from a local cell
  /// using the specified reference cell quadrature points/weights
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c,
                               unsigned int num_quadrature_points,
                               const double * const * quadrature_points,
                               const double* quadrature_weights) const
  {
    throw std::runtime_error("Quadrature version of tabulate_tensor not available when using the FFC tensor representation.");
  }

};

/// This class defines the interface for the tabulation of the
/// exterior facet tensor corresponding to the local contribution to
/// a form from the integral over an exterior facet.

class adaptivepoisson_exterior_facet_integral_7_0: public ufc::exterior_facet_integral
{
public:

  /// Constructor
  adaptivepoisson_exterior_facet_integral_7_0() : ufc::exterior_facet_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~adaptivepoisson_exterior_facet_integral_7_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local exterior facet
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c,
                               unsigned int facet) const
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      9
    // Number of operations (multiply-add pairs) for geometry tensor:    27
    // Number of operations (multiply-add pairs) for tensor contraction: 22
    // Total number of operations (multiply-add pairs):                  58
    
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    
    // Compute determinant of Jacobian
    
    // Compute inverse of Jacobian
    
    // Get vertices on edge
    static unsigned int edge_vertices[3][2] = {{1, 2}, {0, 2}, {0, 1}};
    const unsigned int v0 = edge_vertices[facet][0];
    const unsigned int v1 = edge_vertices[facet][1];
    
    // Compute scale factor (length of edge scaled by length of reference interval)
    const double dx0 = x[v1][0] - x[v0][0];
    const double dx1 = x[v1][1] - x[v0][1];
    const double det = std::sqrt(dx0*dx0 + dx1*dx1);
    
    // Compute geometry tensor
    const double G0_0_0 = det*w[2][0]*w[0][0]*(1.0);
    const double G0_0_4 = det*w[2][0]*w[0][4]*(1.0);
    const double G0_0_5 = det*w[2][0]*w[0][5]*(1.0);
    const double G0_1_1 = det*w[2][1]*w[0][1]*(1.0);
    const double G0_1_3 = det*w[2][1]*w[0][3]*(1.0);
    const double G0_1_5 = det*w[2][1]*w[0][5]*(1.0);
    const double G0_2_2 = det*w[2][2]*w[0][2]*(1.0);
    const double G0_2_3 = det*w[2][2]*w[0][3]*(1.0);
    const double G0_2_4 = det*w[2][2]*w[0][4]*(1.0);
    const double G1_0_0 = det*w[2][0]*w[3][0]*(1.0);
    const double G1_0_1 = det*w[2][0]*w[3][1]*(1.0);
    const double G1_0_2 = det*w[2][0]*w[3][2]*(1.0);
    const double G1_1_0 = det*w[2][1]*w[3][0]*(1.0);
    const double G1_1_1 = det*w[2][1]*w[3][1]*(1.0);
    const double G1_1_2 = det*w[2][1]*w[3][2]*(1.0);
    const double G1_2_0 = det*w[2][2]*w[3][0]*(1.0);
    const double G1_2_1 = det*w[2][2]*w[3][1]*(1.0);
    const double G1_2_2 = det*w[2][2]*w[3][2]*(1.0);
    
    // Compute element tensor
    switch (facet)
    {
    case 0:
      {
        A[0] = 0.166666666666666*G0_1_1 + 0.333333333333333*G0_1_3 + 0.166666666666666*G0_2_2 + 0.333333333333333*G0_2_3 - 0.333333333333333*G1_1_1 - 0.166666666666667*G1_1_2 - 0.166666666666667*G1_2_1 - 0.333333333333333*G1_2_2;
        break;
      }
    case 1:
      {
        A[0] = 0.166666666666667*G0_0_0 + 0.333333333333333*G0_0_4 + 0.166666666666666*G0_2_2 + 0.333333333333333*G0_2_4 - 0.333333333333333*G1_0_0 - 0.166666666666667*G1_0_2 - 0.166666666666667*G1_2_0 - 0.333333333333333*G1_2_2;
        break;
      }
    case 2:
      {
        A[0] = 0.166666666666666*G0_0_0 + 0.333333333333333*G0_0_5 + 0.166666666666667*G0_1_1 + 0.333333333333333*G0_1_5 - 0.333333333333333*G1_0_0 - 0.166666666666667*G1_0_1 - 0.166666666666667*G1_1_0 - 0.333333333333333*G1_1_1;
        break;
      }
    }
    
  }

  /// Tabulate the tensor for the contribution from a local exterior facet
  /// using the specified reference cell quadrature points/weights
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c,
                               unsigned int num_quadrature_points,
                               const double * const * quadrature_points,
                               const double* quadrature_weights) const
  {
    throw std::runtime_error("Quadrature version of tabulate_tensor not available when using the FFC tensor representation.");
  }

};

/// This class defines the interface for the tabulation of the
/// interior facet tensor corresponding to the local contribution to
/// a form from the integral over an interior facet.

class adaptivepoisson_interior_facet_integral_7_0: public ufc::interior_facet_integral
{
public:

  /// Constructor
  adaptivepoisson_interior_facet_integral_7_0() : ufc::interior_facet_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~adaptivepoisson_interior_facet_integral_7_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local interior facet
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c0,
                               const ufc::cell& c1,
                               unsigned int facet0,
                               unsigned int facet1) const
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      12
    // Number of operations (multiply-add pairs) for geometry tensor:    108
    // Number of operations (multiply-add pairs) for tensor contraction: 279
    // Total number of operations (multiply-add pairs):                  399
    
    // Extract vertex coordinates
    const double * const * x0 = c0.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    
    // Compute determinant of Jacobian
    
    // Compute inverse of Jacobian
    
    // Compute Jacobian of affine map from reference cell
    
    // Compute determinant of Jacobian
    
    // Compute inverse of Jacobian
    
    // Get vertices on edge
    static unsigned int edge_vertices[3][2] = {{1, 2}, {0, 2}, {0, 1}};
    const unsigned int v0 = edge_vertices[facet0][0];
    const unsigned int v1 = edge_vertices[facet0][1];
    
    // Compute scale factor (length of edge scaled by length of reference interval)
    const double dx0 = x0[v1][0] - x0[v0][0];
    const double dx1 = x0[v1][1] - x0[v0][1];
    const double det = std::sqrt(dx0*dx0 + dx1*dx1);
    
    // Compute geometry tensor
    const double G0_3_6 = det*w[2][3]*w[0][6]*(1.0);
    const double G0_3_10 = det*w[2][3]*w[0][10]*(1.0);
    const double G0_3_11 = det*w[2][3]*w[0][11]*(1.0);
    const double G0_4_7 = det*w[2][4]*w[0][7]*(1.0);
    const double G0_4_9 = det*w[2][4]*w[0][9]*(1.0);
    const double G0_4_11 = det*w[2][4]*w[0][11]*(1.0);
    const double G0_5_8 = det*w[2][5]*w[0][8]*(1.0);
    const double G0_5_9 = det*w[2][5]*w[0][9]*(1.0);
    const double G0_5_10 = det*w[2][5]*w[0][10]*(1.0);
    const double G1_3_3 = det*w[2][3]*w[3][3]*(1.0);
    const double G1_3_4 = det*w[2][3]*w[3][4]*(1.0);
    const double G1_3_5 = det*w[2][3]*w[3][5]*(1.0);
    const double G1_4_3 = det*w[2][4]*w[3][3]*(1.0);
    const double G1_4_4 = det*w[2][4]*w[3][4]*(1.0);
    const double G1_4_5 = det*w[2][4]*w[3][5]*(1.0);
    const double G1_5_3 = det*w[2][5]*w[3][3]*(1.0);
    const double G1_5_4 = det*w[2][5]*w[3][4]*(1.0);
    const double G1_5_5 = det*w[2][5]*w[3][5]*(1.0);
    const double G2_0_0 = det*w[2][0]*w[0][0]*(1.0);
    const double G2_0_4 = det*w[2][0]*w[0][4]*(1.0);
    const double G2_0_5 = det*w[2][0]*w[0][5]*(1.0);
    const double G2_1_1 = det*w[2][1]*w[0][1]*(1.0);
    const double G2_1_3 = det*w[2][1]*w[0][3]*(1.0);
    const double G2_1_5 = det*w[2][1]*w[0][5]*(1.0);
    const double G2_2_2 = det*w[2][2]*w[0][2]*(1.0);
    const double G2_2_3 = det*w[2][2]*w[0][3]*(1.0);
    const double G2_2_4 = det*w[2][2]*w[0][4]*(1.0);
    const double G3_0_0 = det*w[2][0]*w[3][0]*(1.0);
    const double G3_0_1 = det*w[2][0]*w[3][1]*(1.0);
    const double G3_0_2 = det*w[2][0]*w[3][2]*(1.0);
    const double G3_1_0 = det*w[2][1]*w[3][0]*(1.0);
    const double G3_1_1 = det*w[2][1]*w[3][1]*(1.0);
    const double G3_1_2 = det*w[2][1]*w[3][2]*(1.0);
    const double G3_2_0 = det*w[2][2]*w[3][0]*(1.0);
    const double G3_2_1 = det*w[2][2]*w[3][1]*(1.0);
    const double G3_2_2 = det*w[2][2]*w[3][2]*(1.0);
    const double G4_3_6 = det*w[2][3]*w[0][6]*(1.0);
    const double G4_3_10 = det*w[2][3]*w[0][10]*(1.0);
    const double G4_3_11 = det*w[2][3]*w[0][11]*(1.0);
    const double G4_4_7 = det*w[2][4]*w[0][7]*(1.0);
    const double G4_4_9 = det*w[2][4]*w[0][9]*(1.0);
    const double G4_4_11 = det*w[2][4]*w[0][11]*(1.0);
    const double G4_5_8 = det*w[2][5]*w[0][8]*(1.0);
    const double G4_5_9 = det*w[2][5]*w[0][9]*(1.0);
    const double G4_5_10 = det*w[2][5]*w[0][10]*(1.0);
    const double G5_3_3 = det*w[2][3]*w[3][3]*(1.0);
    const double G5_3_4 = det*w[2][3]*w[3][4]*(1.0);
    const double G5_3_5 = det*w[2][3]*w[3][5]*(1.0);
    const double G5_4_3 = det*w[2][4]*w[3][3]*(1.0);
    const double G5_4_4 = det*w[2][4]*w[3][4]*(1.0);
    const double G5_4_5 = det*w[2][4]*w[3][5]*(1.0);
    const double G5_5_3 = det*w[2][5]*w[3][3]*(1.0);
    const double G5_5_4 = det*w[2][5]*w[3][4]*(1.0);
    const double G5_5_5 = det*w[2][5]*w[3][5]*(1.0);
    const double G6_0_0 = det*w[2][0]*w[0][0]*(1.0);
    const double G6_0_4 = det*w[2][0]*w[0][4]*(1.0);
    const double G6_0_5 = det*w[2][0]*w[0][5]*(1.0);
    const double G6_1_1 = det*w[2][1]*w[0][1]*(1.0);
    const double G6_1_3 = det*w[2][1]*w[0][3]*(1.0);
    const double G6_1_5 = det*w[2][1]*w[0][5]*(1.0);
    const double G6_2_2 = det*w[2][2]*w[0][2]*(1.0);
    const double G6_2_3 = det*w[2][2]*w[0][3]*(1.0);
    const double G6_2_4 = det*w[2][2]*w[0][4]*(1.0);
    const double G7_0_0 = det*w[2][0]*w[3][0]*(1.0);
    const double G7_0_1 = det*w[2][0]*w[3][1]*(1.0);
    const double G7_0_2 = det*w[2][0]*w[3][2]*(1.0);
    const double G7_1_0 = det*w[2][1]*w[3][0]*(1.0);
    const double G7_1_1 = det*w[2][1]*w[3][1]*(1.0);
    const double G7_1_2 = det*w[2][1]*w[3][2]*(1.0);
    const double G7_2_0 = det*w[2][2]*w[3][0]*(1.0);
    const double G7_2_1 = det*w[2][2]*w[3][1]*(1.0);
    const double G7_2_2 = det*w[2][2]*w[3][2]*(1.0);
    
    // Compute element tensor
    switch (facet0)
    {
    case 0:
      {
        switch (facet1)
      {
      case 0:
        {
          A[0] = 0.0833333333333332*G4_4_7 + 0.166666666666667*G4_4_9 + 0.0833333333333332*G4_5_8 + 0.166666666666667*G4_5_9 - 0.166666666666667*G5_4_4 - 0.0833333333333333*G5_4_5 - 0.0833333333333333*G5_5_4 - 0.166666666666667*G5_5_5 + 0.0833333333333332*G6_1_1 + 0.166666666666667*G6_1_3 + 0.0833333333333332*G6_2_2 + 0.166666666666667*G6_2_3 - 0.166666666666667*G7_1_1 - 0.0833333333333333*G7_1_2 - 0.0833333333333333*G7_2_1 - 0.166666666666667*G7_2_2;
        A[1] = 0.0833333333333332*G0_4_7 + 0.166666666666667*G0_4_9 + 0.0833333333333332*G0_5_8 + 0.166666666666667*G0_5_9 - 0.166666666666667*G1_4_4 - 0.0833333333333333*G1_4_5 - 0.0833333333333333*G1_5_4 - 0.166666666666667*G1_5_5 + 0.0833333333333332*G2_1_1 + 0.166666666666667*G2_1_3 + 0.0833333333333332*G2_2_2 + 0.166666666666667*G2_2_3 - 0.166666666666667*G3_1_1 - 0.0833333333333333*G3_1_2 - 0.0833333333333333*G3_2_1 - 0.166666666666667*G3_2_2;
          break;
        }
      case 1:
        {
          A[0] = 0.0833333333333333*G4_3_6 + 0.166666666666667*G4_3_10 + 0.0833333333333332*G4_5_8 + 0.166666666666667*G4_5_10 - 0.166666666666667*G5_3_3 - 0.0833333333333333*G5_3_5 - 0.0833333333333333*G5_5_3 - 0.166666666666667*G5_5_5 + 0.0833333333333332*G6_1_1 + 0.166666666666667*G6_1_3 + 0.0833333333333332*G6_2_2 + 0.166666666666667*G6_2_3 - 0.166666666666667*G7_1_1 - 0.0833333333333333*G7_1_2 - 0.0833333333333333*G7_2_1 - 0.166666666666667*G7_2_2;
        A[1] = 0.0833333333333333*G0_3_6 + 0.166666666666667*G0_3_10 + 0.0833333333333332*G0_5_8 + 0.166666666666667*G0_5_10 - 0.166666666666667*G1_3_3 - 0.0833333333333333*G1_3_5 - 0.0833333333333333*G1_5_3 - 0.166666666666667*G1_5_5 + 0.0833333333333332*G2_1_1 + 0.166666666666667*G2_1_3 + 0.0833333333333332*G2_2_2 + 0.166666666666667*G2_2_3 - 0.166666666666667*G3_1_1 - 0.0833333333333333*G3_1_2 - 0.0833333333333333*G3_2_1 - 0.166666666666667*G3_2_2;
          break;
        }
      case 2:
        {
          A[0] = 0.0833333333333332*G4_3_6 + 0.166666666666667*G4_3_11 + 0.0833333333333333*G4_4_7 + 0.166666666666667*G4_4_11 - 0.166666666666666*G5_3_3 - 0.0833333333333333*G5_3_4 - 0.0833333333333333*G5_4_3 - 0.166666666666667*G5_4_4 + 0.0833333333333332*G6_1_1 + 0.166666666666667*G6_1_3 + 0.0833333333333332*G6_2_2 + 0.166666666666667*G6_2_3 - 0.166666666666667*G7_1_1 - 0.0833333333333333*G7_1_2 - 0.0833333333333333*G7_2_1 - 0.166666666666667*G7_2_2;
        A[1] = 0.0833333333333332*G0_3_6 + 0.166666666666667*G0_3_11 + 0.0833333333333333*G0_4_7 + 0.166666666666667*G0_4_11 - 0.166666666666666*G1_3_3 - 0.0833333333333333*G1_3_4 - 0.0833333333333333*G1_4_3 - 0.166666666666667*G1_4_4 + 0.0833333333333332*G2_1_1 + 0.166666666666667*G2_1_3 + 0.0833333333333332*G2_2_2 + 0.166666666666667*G2_2_3 - 0.166666666666667*G3_1_1 - 0.0833333333333333*G3_1_2 - 0.0833333333333333*G3_2_1 - 0.166666666666667*G3_2_2;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        switch (facet1)
      {
      case 0:
        {
          A[0] = 0.0833333333333332*G4_4_7 + 0.166666666666667*G4_4_9 + 0.0833333333333332*G4_5_8 + 0.166666666666667*G4_5_9 - 0.166666666666667*G5_4_4 - 0.0833333333333333*G5_4_5 - 0.0833333333333333*G5_5_4 - 0.166666666666667*G5_5_5 + 0.0833333333333333*G6_0_0 + 0.166666666666667*G6_0_4 + 0.0833333333333332*G6_2_2 + 0.166666666666667*G6_2_4 - 0.166666666666667*G7_0_0 - 0.0833333333333333*G7_0_2 - 0.0833333333333333*G7_2_0 - 0.166666666666667*G7_2_2;
        A[1] = 0.0833333333333332*G0_4_7 + 0.166666666666667*G0_4_9 + 0.0833333333333332*G0_5_8 + 0.166666666666667*G0_5_9 - 0.166666666666667*G1_4_4 - 0.0833333333333333*G1_4_5 - 0.0833333333333333*G1_5_4 - 0.166666666666667*G1_5_5 + 0.0833333333333333*G2_0_0 + 0.166666666666667*G2_0_4 + 0.0833333333333332*G2_2_2 + 0.166666666666667*G2_2_4 - 0.166666666666667*G3_0_0 - 0.0833333333333333*G3_0_2 - 0.0833333333333333*G3_2_0 - 0.166666666666667*G3_2_2;
          break;
        }
      case 1:
        {
          A[0] = 0.0833333333333333*G4_3_6 + 0.166666666666667*G4_3_10 + 0.0833333333333332*G4_5_8 + 0.166666666666667*G4_5_10 - 0.166666666666667*G5_3_3 - 0.0833333333333333*G5_3_5 - 0.0833333333333333*G5_5_3 - 0.166666666666667*G5_5_5 + 0.0833333333333333*G6_0_0 + 0.166666666666667*G6_0_4 + 0.0833333333333332*G6_2_2 + 0.166666666666667*G6_2_4 - 0.166666666666667*G7_0_0 - 0.0833333333333333*G7_0_2 - 0.0833333333333333*G7_2_0 - 0.166666666666667*G7_2_2;
        A[1] = 0.0833333333333333*G0_3_6 + 0.166666666666667*G0_3_10 + 0.0833333333333332*G0_5_8 + 0.166666666666667*G0_5_10 - 0.166666666666667*G1_3_3 - 0.0833333333333333*G1_3_5 - 0.0833333333333333*G1_5_3 - 0.166666666666667*G1_5_5 + 0.0833333333333333*G2_0_0 + 0.166666666666667*G2_0_4 + 0.0833333333333332*G2_2_2 + 0.166666666666667*G2_2_4 - 0.166666666666667*G3_0_0 - 0.0833333333333333*G3_0_2 - 0.0833333333333333*G3_2_0 - 0.166666666666667*G3_2_2;
          break;
        }
      case 2:
        {
          A[0] = 0.0833333333333332*G4_3_6 + 0.166666666666667*G4_3_11 + 0.0833333333333333*G4_4_7 + 0.166666666666667*G4_4_11 - 0.166666666666666*G5_3_3 - 0.0833333333333333*G5_3_4 - 0.0833333333333333*G5_4_3 - 0.166666666666667*G5_4_4 + 0.0833333333333333*G6_0_0 + 0.166666666666667*G6_0_4 + 0.0833333333333332*G6_2_2 + 0.166666666666667*G6_2_4 - 0.166666666666667*G7_0_0 - 0.0833333333333333*G7_0_2 - 0.0833333333333333*G7_2_0 - 0.166666666666667*G7_2_2;
        A[1] = 0.0833333333333332*G0_3_6 + 0.166666666666667*G0_3_11 + 0.0833333333333333*G0_4_7 + 0.166666666666667*G0_4_11 - 0.166666666666666*G1_3_3 - 0.0833333333333333*G1_3_4 - 0.0833333333333333*G1_4_3 - 0.166666666666667*G1_4_4 + 0.0833333333333333*G2_0_0 + 0.166666666666667*G2_0_4 + 0.0833333333333332*G2_2_2 + 0.166666666666667*G2_2_4 - 0.166666666666667*G3_0_0 - 0.0833333333333333*G3_0_2 - 0.0833333333333333*G3_2_0 - 0.166666666666667*G3_2_2;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        switch (facet1)
      {
      case 0:
        {
          A[0] = 0.0833333333333332*G4_4_7 + 0.166666666666667*G4_4_9 + 0.0833333333333332*G4_5_8 + 0.166666666666667*G4_5_9 - 0.166666666666667*G5_4_4 - 0.0833333333333333*G5_4_5 - 0.0833333333333333*G5_5_4 - 0.166666666666667*G5_5_5 + 0.0833333333333332*G6_0_0 + 0.166666666666667*G6_0_5 + 0.0833333333333333*G6_1_1 + 0.166666666666667*G6_1_5 - 0.166666666666666*G7_0_0 - 0.0833333333333333*G7_0_1 - 0.0833333333333333*G7_1_0 - 0.166666666666667*G7_1_1;
        A[1] = 0.0833333333333332*G0_4_7 + 0.166666666666667*G0_4_9 + 0.0833333333333332*G0_5_8 + 0.166666666666667*G0_5_9 - 0.166666666666667*G1_4_4 - 0.0833333333333333*G1_4_5 - 0.0833333333333333*G1_5_4 - 0.166666666666667*G1_5_5 + 0.0833333333333332*G2_0_0 + 0.166666666666667*G2_0_5 + 0.0833333333333333*G2_1_1 + 0.166666666666667*G2_1_5 - 0.166666666666666*G3_0_0 - 0.0833333333333333*G3_0_1 - 0.0833333333333333*G3_1_0 - 0.166666666666667*G3_1_1;
          break;
        }
      case 1:
        {
          A[0] = 0.0833333333333333*G4_3_6 + 0.166666666666667*G4_3_10 + 0.0833333333333332*G4_5_8 + 0.166666666666667*G4_5_10 - 0.166666666666667*G5_3_3 - 0.0833333333333333*G5_3_5 - 0.0833333333333333*G5_5_3 - 0.166666666666667*G5_5_5 + 0.0833333333333332*G6_0_0 + 0.166666666666667*G6_0_5 + 0.0833333333333333*G6_1_1 + 0.166666666666667*G6_1_5 - 0.166666666666666*G7_0_0 - 0.0833333333333333*G7_0_1 - 0.0833333333333333*G7_1_0 - 0.166666666666667*G7_1_1;
        A[1] = 0.0833333333333333*G0_3_6 + 0.166666666666667*G0_3_10 + 0.0833333333333332*G0_5_8 + 0.166666666666667*G0_5_10 - 0.166666666666667*G1_3_3 - 0.0833333333333333*G1_3_5 - 0.0833333333333333*G1_5_3 - 0.166666666666667*G1_5_5 + 0.0833333333333332*G2_0_0 + 0.166666666666667*G2_0_5 + 0.0833333333333333*G2_1_1 + 0.166666666666667*G2_1_5 - 0.166666666666666*G3_0_0 - 0.0833333333333333*G3_0_1 - 0.0833333333333333*G3_1_0 - 0.166666666666667*G3_1_1;
          break;
        }
      case 2:
        {
          A[0] = 0.0833333333333332*G4_3_6 + 0.166666666666667*G4_3_11 + 0.0833333333333333*G4_4_7 + 0.166666666666667*G4_4_11 - 0.166666666666666*G5_3_3 - 0.0833333333333333*G5_3_4 - 0.0833333333333333*G5_4_3 - 0.166666666666667*G5_4_4 + 0.0833333333333332*G6_0_0 + 0.166666666666667*G6_0_5 + 0.0833333333333333*G6_1_1 + 0.166666666666667*G6_1_5 - 0.166666666666666*G7_0_0 - 0.0833333333333333*G7_0_1 - 0.0833333333333333*G7_1_0 - 0.166666666666667*G7_1_1;
        A[1] = 0.0833333333333332*G0_3_6 + 0.166666666666667*G0_3_11 + 0.0833333333333333*G0_4_7 + 0.166666666666667*G0_4_11 - 0.166666666666666*G1_3_3 - 0.0833333333333333*G1_3_4 - 0.0833333333333333*G1_4_3 - 0.166666666666667*G1_4_4 + 0.0833333333333332*G2_0_0 + 0.166666666666667*G2_0_5 + 0.0833333333333333*G2_1_1 + 0.166666666666667*G2_1_5 - 0.166666666666666*G3_0_0 - 0.0833333333333333*G3_0_1 - 0.0833333333333333*G3_1_0 - 0.166666666666667*G3_1_1;
          break;
        }
      }
      
        break;
      }
    }
    
  }

  /// Tabulate the tensor for the contribution from a local interior facet
  /// using the specified reference cell quadrature points/weights
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c,
                               unsigned int num_quadrature_points,
                               const double * const * quadrature_points,
                               const double* quadrature_weights) const
  {
    throw std::runtime_error("Quadrature version of tabulate_tensor not available when using the FFC tensor representation.");
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class adaptivepoisson_cell_integral_8_0: public ufc::cell_integral
{
public:

  /// Constructor
  adaptivepoisson_cell_integral_8_0() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~adaptivepoisson_cell_integral_8_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c) const
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      11
    // Number of operations (multiply-add pairs) for geometry tensor:    8
    // Number of operations (multiply-add pairs) for tensor contraction: 11
    // Total number of operations (multiply-add pairs):                  30
    
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_0_0 = det*(K_00*K_00 + K_01*K_01);
    const double G0_0_1 = det*(K_00*K_10 + K_01*K_11);
    const double G0_1_0 = det*(K_10*K_00 + K_11*K_01);
    const double G0_1_1 = det*(K_10*K_10 + K_11*K_11);
    
    // Compute element tensor
    A[0] = 0.5*G0_0_0 + 0.5*G0_0_1 + 0.5*G0_1_0 + 0.5*G0_1_1;
    A[1] = -0.5*G0_0_0 - 0.5*G0_1_0;
    A[2] = -0.5*G0_0_1 - 0.5*G0_1_1;
    A[3] = -0.5*G0_0_0 - 0.5*G0_0_1;
    A[4] = 0.5*G0_0_0;
    A[5] = 0.5*G0_0_1;
    A[6] = -0.5*G0_1_0 - 0.5*G0_1_1;
    A[7] = 0.5*G0_1_0;
    A[8] = 0.5*G0_1_1;
  }

  /// Tabulate the tensor for the contribution from a local cell
  /// using the specified reference cell quadrature points/weights
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c,
                               unsigned int num_quadrature_points,
                               const double * const * quadrature_points,
                               const double* quadrature_weights) const
  {
    throw std::runtime_error("Quadrature version of tabulate_tensor not available when using the FFC tensor representation.");
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class adaptivepoisson_cell_integral_9_0: public ufc::cell_integral
{
public:

  /// Constructor
  adaptivepoisson_cell_integral_9_0() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~adaptivepoisson_cell_integral_9_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c) const
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      9
    // Number of operations (multiply-add pairs) for geometry tensor:    3
    // Number of operations (multiply-add pairs) for tensor contraction: 7
    // Total number of operations (multiply-add pairs):                  19
    
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_0 = det*w[0][0]*(1.0);
    const double G0_1 = det*w[0][1]*(1.0);
    const double G0_2 = det*w[0][2]*(1.0);
    
    // Compute element tensor
    A[0] = 0.0833333333333333*G0_0 + 0.0416666666666667*G0_1 + 0.0416666666666667*G0_2;
    A[1] = 0.0416666666666667*G0_0 + 0.0833333333333333*G0_1 + 0.0416666666666666*G0_2;
    A[2] = 0.0416666666666667*G0_0 + 0.0416666666666666*G0_1 + 0.0833333333333333*G0_2;
  }

  /// Tabulate the tensor for the contribution from a local cell
  /// using the specified reference cell quadrature points/weights
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c,
                               unsigned int num_quadrature_points,
                               const double * const * quadrature_points,
                               const double* quadrature_weights) const
  {
    throw std::runtime_error("Quadrature version of tabulate_tensor not available when using the FFC tensor representation.");
  }

};

/// This class defines the interface for the tabulation of the
/// exterior facet tensor corresponding to the local contribution to
/// a form from the integral over an exterior facet.

class adaptivepoisson_exterior_facet_integral_9_0: public ufc::exterior_facet_integral
{
public:

  /// Constructor
  adaptivepoisson_exterior_facet_integral_9_0() : ufc::exterior_facet_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~adaptivepoisson_exterior_facet_integral_9_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local exterior facet
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c,
                               unsigned int facet) const
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      9
    // Number of operations (multiply-add pairs) for geometry tensor:    3
    // Number of operations (multiply-add pairs) for tensor contraction: 9
    // Total number of operations (multiply-add pairs):                  21
    
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    
    // Compute determinant of Jacobian
    
    // Compute inverse of Jacobian
    
    // Get vertices on edge
    static unsigned int edge_vertices[3][2] = {{1, 2}, {0, 2}, {0, 1}};
    const unsigned int v0 = edge_vertices[facet][0];
    const unsigned int v1 = edge_vertices[facet][1];
    
    // Compute scale factor (length of edge scaled by length of reference interval)
    const double dx0 = x[v1][0] - x[v0][0];
    const double dx1 = x[v1][1] - x[v0][1];
    const double det = std::sqrt(dx0*dx0 + dx1*dx1);
    
    // Compute geometry tensor
    const double G0_0 = det*w[1][0]*(1.0);
    const double G0_1 = det*w[1][1]*(1.0);
    const double G0_2 = det*w[1][2]*(1.0);
    
    // Compute element tensor
    switch (facet)
    {
    case 0:
      {
        A[0] = 0.0;
      A[1] = 0.333333333333333*G0_1 + 0.166666666666667*G0_2;
      A[2] = 0.166666666666667*G0_1 + 0.333333333333333*G0_2;
        break;
      }
    case 1:
      {
        A[0] = 0.333333333333333*G0_0 + 0.166666666666667*G0_2;
      A[1] = 0.0;
      A[2] = 0.166666666666667*G0_0 + 0.333333333333333*G0_2;
        break;
      }
    case 2:
      {
        A[0] = 0.333333333333333*G0_0 + 0.166666666666667*G0_1;
      A[1] = 0.166666666666667*G0_0 + 0.333333333333333*G0_1;
      A[2] = 0.0;
        break;
      }
    }
    
  }

  /// Tabulate the tensor for the contribution from a local exterior facet
  /// using the specified reference cell quadrature points/weights
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c,
                               unsigned int num_quadrature_points,
                               const double * const * quadrature_points,
                               const double* quadrature_weights) const
  {
    throw std::runtime_error("Quadrature version of tabulate_tensor not available when using the FFC tensor representation.");
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class adaptivepoisson_cell_integral_10_0: public ufc::cell_integral
{
public:

  /// Constructor
  adaptivepoisson_cell_integral_10_0() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~adaptivepoisson_cell_integral_10_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c) const
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      9
    // Number of operations (multiply-add pairs) for geometry tensor:    3
    // Number of operations (multiply-add pairs) for tensor contraction: 2
    // Total number of operations (multiply-add pairs):                  14
    
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_0 = det*w[0][0]*(1.0);
    const double G0_1 = det*w[0][1]*(1.0);
    const double G0_2 = det*w[0][2]*(1.0);
    
    // Compute element tensor
    A[0] = 0.166666666666667*G0_0 + 0.166666666666667*G0_1 + 0.166666666666667*G0_2;
  }

  /// Tabulate the tensor for the contribution from a local cell
  /// using the specified reference cell quadrature points/weights
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c,
                               unsigned int num_quadrature_points,
                               const double * const * quadrature_points,
                               const double* quadrature_weights) const
  {
    throw std::runtime_error("Quadrature version of tabulate_tensor not available when using the FFC tensor representation.");
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class adaptivepoisson_form_0: public ufc::form
{
public:

  /// Constructor
  adaptivepoisson_form_0() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~adaptivepoisson_form_0()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "Form([Integral(IndexSum(Product(Indexed(ComponentTensor(SpatialDerivative(Argument(FiniteElement('Lagrange', Cell('triangle', Space(2)), 1, None), 0), MultiIndex((Index(0),), {Index(0): 2})), MultiIndex((Index(0),), {Index(0): 2})), MultiIndex((Index(1),), {Index(1): 2})), Indexed(ComponentTensor(SpatialDerivative(Argument(FiniteElement('Lagrange', Cell('triangle', Space(2)), 1, None), 1), MultiIndex((Index(2),), {Index(2): 2})), MultiIndex((Index(2),), {Index(2): 2})), MultiIndex((Index(1),), {Index(1): 2}))), MultiIndex((Index(1),), {Index(1): 2})), Measure('cell', 0, None))])";
  }

  /// Return the rank of the global tensor (r)
  virtual unsigned int rank() const
  {
    return 2;
  }

  /// Return the number of coefficients (n)
  virtual unsigned int num_coefficients() const
  {
    return 0;
  }

  /// Return the number of cell domains
  virtual unsigned int num_cell_domains() const
  {
    return 1;
  }

  /// Return the number of exterior facet domains
  virtual unsigned int num_exterior_facet_domains() const
  {
    return 0;
  }

  /// Return the number of interior facet domains
  virtual unsigned int num_interior_facet_domains() const
  {
    return 0;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_finite_element_5();
        break;
      }
    case 1:
      {
        return new adaptivepoisson_finite_element_5();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dofmap for argument function i
  virtual ufc::dofmap* create_dofmap(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_dofmap_5();
        break;
      }
    case 1:
      {
        return new adaptivepoisson_dofmap_5();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_cell_integral_0_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(unsigned int i) const
  {
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(unsigned int i) const
  {
    return 0;
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class adaptivepoisson_form_1: public ufc::form
{
public:

  /// Constructor
  adaptivepoisson_form_1() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~adaptivepoisson_form_1()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "Form([Integral(Argument(FiniteElement('Lagrange', Cell('triangle', Space(2)), 1, None), 0), Measure('cell', 0, None))])";
  }

  /// Return the rank of the global tensor (r)
  virtual unsigned int rank() const
  {
    return 1;
  }

  /// Return the number of coefficients (n)
  virtual unsigned int num_coefficients() const
  {
    return 0;
  }

  /// Return the number of cell domains
  virtual unsigned int num_cell_domains() const
  {
    return 1;
  }

  /// Return the number of exterior facet domains
  virtual unsigned int num_exterior_facet_domains() const
  {
    return 0;
  }

  /// Return the number of interior facet domains
  virtual unsigned int num_interior_facet_domains() const
  {
    return 0;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_finite_element_5();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dofmap for argument function i
  virtual ufc::dofmap* create_dofmap(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_dofmap_5();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_cell_integral_1_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(unsigned int i) const
  {
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(unsigned int i) const
  {
    return 0;
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class adaptivepoisson_form_2: public ufc::form
{
public:

  /// Constructor
  adaptivepoisson_form_2() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~adaptivepoisson_form_2()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "Form([Integral(Sum(Product(Coefficient(FiniteElement('Lagrange', Cell('triangle', Space(2)), 1, None), 0), Coefficient(FiniteElement('Lagrange', Cell('triangle', Space(2)), 2, None), 3)), Product(IntValue(-1, (), (), {}), IndexSum(Product(Indexed(ComponentTensor(SpatialDerivative(Coefficient(FiniteElement('Lagrange', Cell('triangle', Space(2)), 1, None), 2), MultiIndex((Index(0),), {Index(0): 2})), MultiIndex((Index(0),), {Index(0): 2})), MultiIndex((Index(1),), {Index(1): 2})), Indexed(ComponentTensor(SpatialDerivative(Coefficient(FiniteElement('Lagrange', Cell('triangle', Space(2)), 2, None), 3), MultiIndex((Index(2),), {Index(2): 2})), MultiIndex((Index(2),), {Index(2): 2})), MultiIndex((Index(1),), {Index(1): 2}))), MultiIndex((Index(1),), {Index(1): 2})))), Measure('cell', 0, None)), Integral(Product(Coefficient(FiniteElement('Lagrange', Cell('triangle', Space(2)), 1, None), 1), Coefficient(FiniteElement('Lagrange', Cell('triangle', Space(2)), 2, None), 3)), Measure('exterior_facet', 0, None))])";
  }

  /// Return the rank of the global tensor (r)
  virtual unsigned int rank() const
  {
    return 0;
  }

  /// Return the number of coefficients (n)
  virtual unsigned int num_coefficients() const
  {
    return 4;
  }

  /// Return the number of cell domains
  virtual unsigned int num_cell_domains() const
  {
    return 1;
  }

  /// Return the number of exterior facet domains
  virtual unsigned int num_exterior_facet_domains() const
  {
    return 1;
  }

  /// Return the number of interior facet domains
  virtual unsigned int num_interior_facet_domains() const
  {
    return 0;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_finite_element_5();
        break;
      }
    case 1:
      {
        return new adaptivepoisson_finite_element_5();
        break;
      }
    case 2:
      {
        return new adaptivepoisson_finite_element_5();
        break;
      }
    case 3:
      {
        return new adaptivepoisson_finite_element_4();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dofmap for argument function i
  virtual ufc::dofmap* create_dofmap(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_dofmap_5();
        break;
      }
    case 1:
      {
        return new adaptivepoisson_dofmap_5();
        break;
      }
    case 2:
      {
        return new adaptivepoisson_dofmap_5();
        break;
      }
    case 3:
      {
        return new adaptivepoisson_dofmap_4();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_cell_integral_2_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_exterior_facet_integral_2_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(unsigned int i) const
  {
    return 0;
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class adaptivepoisson_form_3: public ufc::form
{
public:

  /// Constructor
  adaptivepoisson_form_3() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~adaptivepoisson_form_3()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "Form([Integral(Product(Argument(FiniteElement('Discontinuous Lagrange', Cell('triangle', Space(2)), 1, None), 1), Product(Argument(FiniteElement('Discontinuous Lagrange', Cell('triangle', Space(2)), 1, None), 0), Coefficient(FiniteElement('Bubble', Cell('triangle', Space(2)), 3, None), 0))), Measure('cell', 0, None))])";
  }

  /// Return the rank of the global tensor (r)
  virtual unsigned int rank() const
  {
    return 2;
  }

  /// Return the number of coefficients (n)
  virtual unsigned int num_coefficients() const
  {
    return 1;
  }

  /// Return the number of cell domains
  virtual unsigned int num_cell_domains() const
  {
    return 1;
  }

  /// Return the number of exterior facet domains
  virtual unsigned int num_exterior_facet_domains() const
  {
    return 0;
  }

  /// Return the number of interior facet domains
  virtual unsigned int num_interior_facet_domains() const
  {
    return 0;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_finite_element_3();
        break;
      }
    case 1:
      {
        return new adaptivepoisson_finite_element_3();
        break;
      }
    case 2:
      {
        return new adaptivepoisson_finite_element_2();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dofmap for argument function i
  virtual ufc::dofmap* create_dofmap(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_dofmap_3();
        break;
      }
    case 1:
      {
        return new adaptivepoisson_dofmap_3();
        break;
      }
    case 2:
      {
        return new adaptivepoisson_dofmap_2();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_cell_integral_3_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(unsigned int i) const
  {
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(unsigned int i) const
  {
    return 0;
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class adaptivepoisson_form_4: public ufc::form
{
public:

  /// Constructor
  adaptivepoisson_form_4() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~adaptivepoisson_form_4()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "Form([Integral(Sum(Product(Coefficient(FiniteElement('Lagrange', Cell('triangle', Space(2)), 1, None), 0), Product(Argument(FiniteElement('Discontinuous Lagrange', Cell('triangle', Space(2)), 1, None), 0), Coefficient(FiniteElement('Bubble', Cell('triangle', Space(2)), 3, None), 3))), Product(IntValue(-1, (), (), {}), IndexSum(Product(Indexed(ComponentTensor(SpatialDerivative(Coefficient(FiniteElement('Lagrange', Cell('triangle', Space(2)), 1, None), 2), MultiIndex((Index(0),), {Index(0): 2})), MultiIndex((Index(0),), {Index(0): 2})), MultiIndex((Index(1),), {Index(1): 2})), Indexed(ComponentTensor(Sum(Product(Argument(FiniteElement('Discontinuous Lagrange', Cell('triangle', Space(2)), 1, None), 0), SpatialDerivative(Coefficient(FiniteElement('Bubble', Cell('triangle', Space(2)), 3, None), 3), MultiIndex((Index(2),), {Index(2): 2}))), Product(Coefficient(FiniteElement('Bubble', Cell('triangle', Space(2)), 3, None), 3), SpatialDerivative(Argument(FiniteElement('Discontinuous Lagrange', Cell('triangle', Space(2)), 1, None), 0), MultiIndex((Index(2),), {Index(2): 2})))), MultiIndex((Index(2),), {Index(2): 2})), MultiIndex((Index(1),), {Index(1): 2}))), MultiIndex((Index(1),), {Index(1): 2})))), Measure('cell', 0, None)), Integral(Product(Coefficient(FiniteElement('Lagrange', Cell('triangle', Space(2)), 1, None), 1), Product(Argument(FiniteElement('Discontinuous Lagrange', Cell('triangle', Space(2)), 1, None), 0), Coefficient(FiniteElement('Bubble', Cell('triangle', Space(2)), 3, None), 3))), Measure('exterior_facet', 0, None))])";
  }

  /// Return the rank of the global tensor (r)
  virtual unsigned int rank() const
  {
    return 1;
  }

  /// Return the number of coefficients (n)
  virtual unsigned int num_coefficients() const
  {
    return 4;
  }

  /// Return the number of cell domains
  virtual unsigned int num_cell_domains() const
  {
    return 1;
  }

  /// Return the number of exterior facet domains
  virtual unsigned int num_exterior_facet_domains() const
  {
    return 1;
  }

  /// Return the number of interior facet domains
  virtual unsigned int num_interior_facet_domains() const
  {
    return 0;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_finite_element_3();
        break;
      }
    case 1:
      {
        return new adaptivepoisson_finite_element_5();
        break;
      }
    case 2:
      {
        return new adaptivepoisson_finite_element_5();
        break;
      }
    case 3:
      {
        return new adaptivepoisson_finite_element_5();
        break;
      }
    case 4:
      {
        return new adaptivepoisson_finite_element_2();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dofmap for argument function i
  virtual ufc::dofmap* create_dofmap(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_dofmap_3();
        break;
      }
    case 1:
      {
        return new adaptivepoisson_dofmap_5();
        break;
      }
    case 2:
      {
        return new adaptivepoisson_dofmap_5();
        break;
      }
    case 3:
      {
        return new adaptivepoisson_dofmap_5();
        break;
      }
    case 4:
      {
        return new adaptivepoisson_dofmap_2();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_cell_integral_4_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_exterior_facet_integral_4_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(unsigned int i) const
  {
    return 0;
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class adaptivepoisson_form_5: public ufc::form
{
public:

  /// Constructor
  adaptivepoisson_form_5() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~adaptivepoisson_form_5()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "Form([Integral(Sum(Product(NegativeRestricted(Argument(FiniteElement('Discontinuous Lagrange', Cell('triangle', Space(2)), 1, None), 1)), NegativeRestricted(Product(Argument(FiniteElement('Discontinuous Lagrange', Cell('triangle', Space(2)), 1, None), 0), Coefficient(FiniteElement('Discontinuous Lagrange', Cell('triangle', Space(2)), 2, None), 0)))), Product(PositiveRestricted(Argument(FiniteElement('Discontinuous Lagrange', Cell('triangle', Space(2)), 1, None), 1)), PositiveRestricted(Product(Argument(FiniteElement('Discontinuous Lagrange', Cell('triangle', Space(2)), 1, None), 0), Coefficient(FiniteElement('Discontinuous Lagrange', Cell('triangle', Space(2)), 2, None), 0))))), Measure('interior_facet', 0, None)), Integral(Product(Argument(FiniteElement('Discontinuous Lagrange', Cell('triangle', Space(2)), 1, None), 1), Product(Argument(FiniteElement('Discontinuous Lagrange', Cell('triangle', Space(2)), 1, None), 0), Coefficient(FiniteElement('Discontinuous Lagrange', Cell('triangle', Space(2)), 2, None), 0))), Measure('exterior_facet', 0, None))])";
  }

  /// Return the rank of the global tensor (r)
  virtual unsigned int rank() const
  {
    return 2;
  }

  /// Return the number of coefficients (n)
  virtual unsigned int num_coefficients() const
  {
    return 1;
  }

  /// Return the number of cell domains
  virtual unsigned int num_cell_domains() const
  {
    return 0;
  }

  /// Return the number of exterior facet domains
  virtual unsigned int num_exterior_facet_domains() const
  {
    return 1;
  }

  /// Return the number of interior facet domains
  virtual unsigned int num_interior_facet_domains() const
  {
    return 1;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_finite_element_3();
        break;
      }
    case 1:
      {
        return new adaptivepoisson_finite_element_3();
        break;
      }
    case 2:
      {
        return new adaptivepoisson_finite_element_1();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dofmap for argument function i
  virtual ufc::dofmap* create_dofmap(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_dofmap_3();
        break;
      }
    case 1:
      {
        return new adaptivepoisson_dofmap_3();
        break;
      }
    case 2:
      {
        return new adaptivepoisson_dofmap_1();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(unsigned int i) const
  {
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_exterior_facet_integral_5_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_interior_facet_integral_5_0();
        break;
      }
    }
    
    return 0;
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class adaptivepoisson_form_6: public ufc::form
{
public:

  /// Constructor
  adaptivepoisson_form_6() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~adaptivepoisson_form_6()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "Form([Integral(Sum(Product(IntValue(-1, (), (), {}), Product(Coefficient(FiniteElement('Discontinuous Lagrange', Cell('triangle', Space(2)), 1, None), 3), Product(Argument(FiniteElement('Discontinuous Lagrange', Cell('triangle', Space(2)), 1, None), 0), Coefficient(FiniteElement('Discontinuous Lagrange', Cell('triangle', Space(2)), 2, None), 4)))), Sum(Product(Coefficient(FiniteElement('Lagrange', Cell('triangle', Space(2)), 1, None), 0), Product(Argument(FiniteElement('Discontinuous Lagrange', Cell('triangle', Space(2)), 1, None), 0), Coefficient(FiniteElement('Discontinuous Lagrange', Cell('triangle', Space(2)), 2, None), 4))), Product(IntValue(-1, (), (), {}), IndexSum(Product(Indexed(ComponentTensor(SpatialDerivative(Coefficient(FiniteElement('Lagrange', Cell('triangle', Space(2)), 1, None), 2), MultiIndex((Index(0),), {Index(0): 2})), MultiIndex((Index(0),), {Index(0): 2})), MultiIndex((Index(1),), {Index(1): 2})), Indexed(ComponentTensor(Sum(Product(Argument(FiniteElement('Discontinuous Lagrange', Cell('triangle', Space(2)), 1, None), 0), SpatialDerivative(Coefficient(FiniteElement('Discontinuous Lagrange', Cell('triangle', Space(2)), 2, None), 4), MultiIndex((Index(2),), {Index(2): 2}))), Product(Coefficient(FiniteElement('Discontinuous Lagrange', Cell('triangle', Space(2)), 2, None), 4), SpatialDerivative(Argument(FiniteElement('Discontinuous Lagrange', Cell('triangle', Space(2)), 1, None), 0), MultiIndex((Index(2),), {Index(2): 2})))), MultiIndex((Index(2),), {Index(2): 2})), MultiIndex((Index(1),), {Index(1): 2}))), MultiIndex((Index(1),), {Index(1): 2}))))), Measure('cell', 0, None)), Integral(Product(Coefficient(FiniteElement('Lagrange', Cell('triangle', Space(2)), 1, None), 1), Product(Argument(FiniteElement('Discontinuous Lagrange', Cell('triangle', Space(2)), 1, None), 0), Coefficient(FiniteElement('Discontinuous Lagrange', Cell('triangle', Space(2)), 2, None), 4))), Measure('exterior_facet', 0, None))])";
  }

  /// Return the rank of the global tensor (r)
  virtual unsigned int rank() const
  {
    return 1;
  }

  /// Return the number of coefficients (n)
  virtual unsigned int num_coefficients() const
  {
    return 5;
  }

  /// Return the number of cell domains
  virtual unsigned int num_cell_domains() const
  {
    return 1;
  }

  /// Return the number of exterior facet domains
  virtual unsigned int num_exterior_facet_domains() const
  {
    return 1;
  }

  /// Return the number of interior facet domains
  virtual unsigned int num_interior_facet_domains() const
  {
    return 0;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_finite_element_3();
        break;
      }
    case 1:
      {
        return new adaptivepoisson_finite_element_5();
        break;
      }
    case 2:
      {
        return new adaptivepoisson_finite_element_5();
        break;
      }
    case 3:
      {
        return new adaptivepoisson_finite_element_5();
        break;
      }
    case 4:
      {
        return new adaptivepoisson_finite_element_3();
        break;
      }
    case 5:
      {
        return new adaptivepoisson_finite_element_1();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dofmap for argument function i
  virtual ufc::dofmap* create_dofmap(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_dofmap_3();
        break;
      }
    case 1:
      {
        return new adaptivepoisson_dofmap_5();
        break;
      }
    case 2:
      {
        return new adaptivepoisson_dofmap_5();
        break;
      }
    case 3:
      {
        return new adaptivepoisson_dofmap_5();
        break;
      }
    case 4:
      {
        return new adaptivepoisson_dofmap_3();
        break;
      }
    case 5:
      {
        return new adaptivepoisson_dofmap_1();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_cell_integral_6_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_exterior_facet_integral_6_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(unsigned int i) const
  {
    return 0;
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class adaptivepoisson_form_7: public ufc::form
{
public:

  /// Constructor
  adaptivepoisson_form_7() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~adaptivepoisson_form_7()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "Form([Integral(Product(Argument(FiniteElement('Discontinuous Lagrange', Cell('triangle', Space(2)), 0, None), 0), Product(Coefficient(FiniteElement('Discontinuous Lagrange', Cell('triangle', Space(2)), 1, None), 1), Sum(Coefficient(FiniteElement('Lagrange', Cell('triangle', Space(2)), 2, None), 0), Product(IntValue(-1, (), (), {}), Coefficient(FiniteElement('Lagrange', Cell('triangle', Space(2)), 1, None), 3))))), Measure('cell', 0, None)), Integral(Product(Product(FloatValue(0.5, (), (), {}), Sum(NegativeRestricted(Argument(FiniteElement('Discontinuous Lagrange', Cell('triangle', Space(2)), 0, None), 0)), PositiveRestricted(Argument(FiniteElement('Discontinuous Lagrange', Cell('triangle', Space(2)), 0, None), 0)))), Sum(Product(NegativeRestricted(Coefficient(FiniteElement('Discontinuous Lagrange', Cell('triangle', Space(2)), 1, None), 2)), NegativeRestricted(Sum(Coefficient(FiniteElement('Lagrange', Cell('triangle', Space(2)), 2, None), 0), Product(IntValue(-1, (), (), {}), Coefficient(FiniteElement('Lagrange', Cell('triangle', Space(2)), 1, None), 3))))), Product(PositiveRestricted(Coefficient(FiniteElement('Discontinuous Lagrange', Cell('triangle', Space(2)), 1, None), 2)), PositiveRestricted(Sum(Coefficient(FiniteElement('Lagrange', Cell('triangle', Space(2)), 2, None), 0), Product(IntValue(-1, (), (), {}), Coefficient(FiniteElement('Lagrange', Cell('triangle', Space(2)), 1, None), 3))))))), Measure('interior_facet', 0, None)), Integral(Product(Argument(FiniteElement('Discontinuous Lagrange', Cell('triangle', Space(2)), 0, None), 0), Product(Coefficient(FiniteElement('Discontinuous Lagrange', Cell('triangle', Space(2)), 1, None), 2), Sum(Coefficient(FiniteElement('Lagrange', Cell('triangle', Space(2)), 2, None), 0), Product(IntValue(-1, (), (), {}), Coefficient(FiniteElement('Lagrange', Cell('triangle', Space(2)), 1, None), 3))))), Measure('exterior_facet', 0, None))])";
  }

  /// Return the rank of the global tensor (r)
  virtual unsigned int rank() const
  {
    return 1;
  }

  /// Return the number of coefficients (n)
  virtual unsigned int num_coefficients() const
  {
    return 4;
  }

  /// Return the number of cell domains
  virtual unsigned int num_cell_domains() const
  {
    return 1;
  }

  /// Return the number of exterior facet domains
  virtual unsigned int num_exterior_facet_domains() const
  {
    return 1;
  }

  /// Return the number of interior facet domains
  virtual unsigned int num_interior_facet_domains() const
  {
    return 1;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_finite_element_0();
        break;
      }
    case 1:
      {
        return new adaptivepoisson_finite_element_4();
        break;
      }
    case 2:
      {
        return new adaptivepoisson_finite_element_3();
        break;
      }
    case 3:
      {
        return new adaptivepoisson_finite_element_3();
        break;
      }
    case 4:
      {
        return new adaptivepoisson_finite_element_5();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dofmap for argument function i
  virtual ufc::dofmap* create_dofmap(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_dofmap_0();
        break;
      }
    case 1:
      {
        return new adaptivepoisson_dofmap_4();
        break;
      }
    case 2:
      {
        return new adaptivepoisson_dofmap_3();
        break;
      }
    case 3:
      {
        return new adaptivepoisson_dofmap_3();
        break;
      }
    case 4:
      {
        return new adaptivepoisson_dofmap_5();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_cell_integral_7_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_exterior_facet_integral_7_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_interior_facet_integral_7_0();
        break;
      }
    }
    
    return 0;
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class adaptivepoisson_form_8: public ufc::form
{
public:

  /// Constructor
  adaptivepoisson_form_8() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~adaptivepoisson_form_8()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "Form([Integral(IndexSum(Product(Indexed(ComponentTensor(SpatialDerivative(Argument(FiniteElement('Lagrange', Cell('triangle', Space(2)), 1, None), 0), MultiIndex((Index(0),), {Index(0): 2})), MultiIndex((Index(0),), {Index(0): 2})), MultiIndex((Index(1),), {Index(1): 2})), Indexed(ComponentTensor(SpatialDerivative(Argument(FiniteElement('Lagrange', Cell('triangle', Space(2)), 1, None), 1), MultiIndex((Index(2),), {Index(2): 2})), MultiIndex((Index(2),), {Index(2): 2})), MultiIndex((Index(1),), {Index(1): 2}))), MultiIndex((Index(1),), {Index(1): 2})), Measure('cell', 0, None))])";
  }

  /// Return the rank of the global tensor (r)
  virtual unsigned int rank() const
  {
    return 2;
  }

  /// Return the number of coefficients (n)
  virtual unsigned int num_coefficients() const
  {
    return 0;
  }

  /// Return the number of cell domains
  virtual unsigned int num_cell_domains() const
  {
    return 1;
  }

  /// Return the number of exterior facet domains
  virtual unsigned int num_exterior_facet_domains() const
  {
    return 0;
  }

  /// Return the number of interior facet domains
  virtual unsigned int num_interior_facet_domains() const
  {
    return 0;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_finite_element_5();
        break;
      }
    case 1:
      {
        return new adaptivepoisson_finite_element_5();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dofmap for argument function i
  virtual ufc::dofmap* create_dofmap(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_dofmap_5();
        break;
      }
    case 1:
      {
        return new adaptivepoisson_dofmap_5();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_cell_integral_8_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(unsigned int i) const
  {
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(unsigned int i) const
  {
    return 0;
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class adaptivepoisson_form_9: public ufc::form
{
public:

  /// Constructor
  adaptivepoisson_form_9() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~adaptivepoisson_form_9()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "Form([Integral(Product(Argument(FiniteElement('Lagrange', Cell('triangle', Space(2)), 1, None), 0), Coefficient(FiniteElement('Lagrange', Cell('triangle', Space(2)), 1, None), 0)), Measure('cell', 0, None)), Integral(Product(Argument(FiniteElement('Lagrange', Cell('triangle', Space(2)), 1, None), 0), Coefficient(FiniteElement('Lagrange', Cell('triangle', Space(2)), 1, None), 1)), Measure('exterior_facet', 0, None))])";
  }

  /// Return the rank of the global tensor (r)
  virtual unsigned int rank() const
  {
    return 1;
  }

  /// Return the number of coefficients (n)
  virtual unsigned int num_coefficients() const
  {
    return 2;
  }

  /// Return the number of cell domains
  virtual unsigned int num_cell_domains() const
  {
    return 1;
  }

  /// Return the number of exterior facet domains
  virtual unsigned int num_exterior_facet_domains() const
  {
    return 1;
  }

  /// Return the number of interior facet domains
  virtual unsigned int num_interior_facet_domains() const
  {
    return 0;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_finite_element_5();
        break;
      }
    case 1:
      {
        return new adaptivepoisson_finite_element_5();
        break;
      }
    case 2:
      {
        return new adaptivepoisson_finite_element_5();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dofmap for argument function i
  virtual ufc::dofmap* create_dofmap(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_dofmap_5();
        break;
      }
    case 1:
      {
        return new adaptivepoisson_dofmap_5();
        break;
      }
    case 2:
      {
        return new adaptivepoisson_dofmap_5();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_cell_integral_9_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_exterior_facet_integral_9_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(unsigned int i) const
  {
    return 0;
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class adaptivepoisson_form_10: public ufc::form
{
public:

  /// Constructor
  adaptivepoisson_form_10() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~adaptivepoisson_form_10()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "Form([Integral(Coefficient(FiniteElement('Lagrange', Cell('triangle', Space(2)), 1, None), 0), Measure('cell', 0, None))])";
  }

  /// Return the rank of the global tensor (r)
  virtual unsigned int rank() const
  {
    return 0;
  }

  /// Return the number of coefficients (n)
  virtual unsigned int num_coefficients() const
  {
    return 1;
  }

  /// Return the number of cell domains
  virtual unsigned int num_cell_domains() const
  {
    return 1;
  }

  /// Return the number of exterior facet domains
  virtual unsigned int num_exterior_facet_domains() const
  {
    return 0;
  }

  /// Return the number of interior facet domains
  virtual unsigned int num_interior_facet_domains() const
  {
    return 0;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_finite_element_5();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dofmap for argument function i
  virtual ufc::dofmap* create_dofmap(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_dofmap_5();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_cell_integral_10_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(unsigned int i) const
  {
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(unsigned int i) const
  {
    return 0;
  }

};

// DOLFIN wrappers

// Standard library includes
#include <string>

// DOLFIN includes
#include <dolfin/common/NoDeleter.h>
#include <dolfin/fem/FiniteElement.h>
#include <dolfin/fem/DofMap.h>
#include <dolfin/fem/Form.h>
#include <dolfin/function/FunctionSpace.h>
#include <dolfin/function/GenericFunction.h>
#include <dolfin/function/CoefficientAssigner.h>
#include <dolfin/adaptivity/ErrorControl.h>
#include <dolfin/adaptivity/GoalFunctional.h>

namespace AdaptivePoisson
{

class CoefficientSpace___cell_bubble: public dolfin::FunctionSpace
{
public:

  CoefficientSpace___cell_bubble(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_2()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_2()), mesh)))
  {
    // Do nothing
  }

  CoefficientSpace___cell_bubble(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_2()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_2()), mesh)))
  {
    // Do nothing
  }

  CoefficientSpace___cell_bubble(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_2()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_2()), *mesh)))
  {
      // Do nothing
  }

  CoefficientSpace___cell_bubble(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_2()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_2()), *mesh)))
  {
      // Do nothing
  }

  ~CoefficientSpace___cell_bubble()
  {
  }

};

class CoefficientSpace___cell_cone: public dolfin::FunctionSpace
{
public:

  CoefficientSpace___cell_cone(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_1()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_1()), mesh)))
  {
    // Do nothing
  }

  CoefficientSpace___cell_cone(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_1()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_1()), mesh)))
  {
    // Do nothing
  }

  CoefficientSpace___cell_cone(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_1()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_1()), *mesh)))
  {
      // Do nothing
  }

  CoefficientSpace___cell_cone(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_1()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_1()), *mesh)))
  {
      // Do nothing
  }

  ~CoefficientSpace___cell_cone()
  {
  }

};

class CoefficientSpace___cell_residual: public dolfin::FunctionSpace
{
public:

  CoefficientSpace___cell_residual(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_3()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_3()), mesh)))
  {
    // Do nothing
  }

  CoefficientSpace___cell_residual(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_3()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_3()), mesh)))
  {
    // Do nothing
  }

  CoefficientSpace___cell_residual(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_3()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_3()), *mesh)))
  {
      // Do nothing
  }

  CoefficientSpace___cell_residual(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_3()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_3()), *mesh)))
  {
      // Do nothing
  }

  ~CoefficientSpace___cell_residual()
  {
  }

};

class CoefficientSpace___discrete_dual_solution: public dolfin::FunctionSpace
{
public:

  CoefficientSpace___discrete_dual_solution(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_5()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_5()), mesh)))
  {
    // Do nothing
  }

  CoefficientSpace___discrete_dual_solution(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_5()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_5()), mesh)))
  {
    // Do nothing
  }

  CoefficientSpace___discrete_dual_solution(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_5()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_5()), *mesh)))
  {
      // Do nothing
  }

  CoefficientSpace___discrete_dual_solution(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_5()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_5()), *mesh)))
  {
      // Do nothing
  }

  ~CoefficientSpace___discrete_dual_solution()
  {
  }

};

class CoefficientSpace___discrete_primal_solution: public dolfin::FunctionSpace
{
public:

  CoefficientSpace___discrete_primal_solution(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_5()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_5()), mesh)))
  {
    // Do nothing
  }

  CoefficientSpace___discrete_primal_solution(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_5()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_5()), mesh)))
  {
    // Do nothing
  }

  CoefficientSpace___discrete_primal_solution(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_5()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_5()), *mesh)))
  {
      // Do nothing
  }

  CoefficientSpace___discrete_primal_solution(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_5()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_5()), *mesh)))
  {
      // Do nothing
  }

  ~CoefficientSpace___discrete_primal_solution()
  {
  }

};

class CoefficientSpace___facet_residual: public dolfin::FunctionSpace
{
public:

  CoefficientSpace___facet_residual(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_3()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_3()), mesh)))
  {
    // Do nothing
  }

  CoefficientSpace___facet_residual(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_3()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_3()), mesh)))
  {
    // Do nothing
  }

  CoefficientSpace___facet_residual(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_3()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_3()), *mesh)))
  {
      // Do nothing
  }

  CoefficientSpace___facet_residual(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_3()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_3()), *mesh)))
  {
      // Do nothing
  }

  ~CoefficientSpace___facet_residual()
  {
  }

};

class CoefficientSpace___improved_dual: public dolfin::FunctionSpace
{
public:

  CoefficientSpace___improved_dual(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_4()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_4()), mesh)))
  {
    // Do nothing
  }

  CoefficientSpace___improved_dual(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_4()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_4()), mesh)))
  {
    // Do nothing
  }

  CoefficientSpace___improved_dual(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_4()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_4()), *mesh)))
  {
      // Do nothing
  }

  CoefficientSpace___improved_dual(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_4()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_4()), *mesh)))
  {
      // Do nothing
  }

  ~CoefficientSpace___improved_dual()
  {
  }

};

class CoefficientSpace_f: public dolfin::FunctionSpace
{
public:

  CoefficientSpace_f(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_5()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_5()), mesh)))
  {
    // Do nothing
  }

  CoefficientSpace_f(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_5()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_5()), mesh)))
  {
    // Do nothing
  }

  CoefficientSpace_f(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_5()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_5()), *mesh)))
  {
      // Do nothing
  }

  CoefficientSpace_f(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_5()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_5()), *mesh)))
  {
      // Do nothing
  }

  ~CoefficientSpace_f()
  {
  }

};

class CoefficientSpace_g: public dolfin::FunctionSpace
{
public:

  CoefficientSpace_g(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_5()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_5()), mesh)))
  {
    // Do nothing
  }

  CoefficientSpace_g(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_5()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_5()), mesh)))
  {
    // Do nothing
  }

  CoefficientSpace_g(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_5()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_5()), *mesh)))
  {
      // Do nothing
  }

  CoefficientSpace_g(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_5()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_5()), *mesh)))
  {
      // Do nothing
  }

  ~CoefficientSpace_g()
  {
  }

};

class Form_0_FunctionSpace_0: public dolfin::FunctionSpace
{
public:

  Form_0_FunctionSpace_0(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_5()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_5()), mesh)))
  {
    // Do nothing
  }

  Form_0_FunctionSpace_0(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_5()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_5()), mesh)))
  {
    // Do nothing
  }

  Form_0_FunctionSpace_0(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_5()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_5()), *mesh)))
  {
      // Do nothing
  }

  Form_0_FunctionSpace_0(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_5()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_5()), *mesh)))
  {
      // Do nothing
  }

  ~Form_0_FunctionSpace_0()
  {
  }

};

class Form_0_FunctionSpace_1: public dolfin::FunctionSpace
{
public:

  Form_0_FunctionSpace_1(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_5()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_5()), mesh)))
  {
    // Do nothing
  }

  Form_0_FunctionSpace_1(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_5()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_5()), mesh)))
  {
    // Do nothing
  }

  Form_0_FunctionSpace_1(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_5()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_5()), *mesh)))
  {
      // Do nothing
  }

  Form_0_FunctionSpace_1(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_5()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_5()), *mesh)))
  {
      // Do nothing
  }

  ~Form_0_FunctionSpace_1()
  {
  }

};

class Form_0: public dolfin::Form
{
public:

  // Constructor
  Form_0(const dolfin::FunctionSpace& V1, const dolfin::FunctionSpace& V0):
    dolfin::Form(2, 0)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);
    _function_spaces[1] = reference_to_no_delete_pointer(V1);

    _ufc_form = boost::shared_ptr<const ufc::form>(new adaptivepoisson_form_0());
  }

  // Constructor
  Form_0(boost::shared_ptr<const dolfin::FunctionSpace> V1, boost::shared_ptr<const dolfin::FunctionSpace> V0):
    dolfin::Form(2, 0)
  {
    _function_spaces[0] = V0;
    _function_spaces[1] = V1;

    _ufc_form = boost::shared_ptr<const ufc::form>(new adaptivepoisson_form_0());
  }

  // Destructor
  ~Form_0()
  {}

  /// Return the number of the coefficient with this name
  virtual dolfin::uint coefficient_number(const std::string& name) const
  {

    dolfin::dolfin_error("generated code for class Form",
                         "access coeficient data",
                         "There are no coefficients");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(dolfin::uint i) const
  {

    dolfin::dolfin_error("generated code for class Form",
                         "access coeficient data",
                         "There are no coefficients");
    return "unnamed";
  }

  // Typedefs
  typedef Form_0_FunctionSpace_0 TestSpace;
  typedef Form_0_FunctionSpace_1 TrialSpace;

  // Coefficients
};

class Form_1_FunctionSpace_0: public dolfin::FunctionSpace
{
public:

  Form_1_FunctionSpace_0(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_5()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_5()), mesh)))
  {
    // Do nothing
  }

  Form_1_FunctionSpace_0(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_5()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_5()), mesh)))
  {
    // Do nothing
  }

  Form_1_FunctionSpace_0(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_5()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_5()), *mesh)))
  {
      // Do nothing
  }

  Form_1_FunctionSpace_0(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_5()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_5()), *mesh)))
  {
      // Do nothing
  }

  ~Form_1_FunctionSpace_0()
  {
  }

};

class Form_1: public dolfin::Form
{
public:

  // Constructor
  Form_1(const dolfin::FunctionSpace& V0):
    dolfin::Form(1, 0)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);

    _ufc_form = boost::shared_ptr<const ufc::form>(new adaptivepoisson_form_1());
  }

  // Constructor
  Form_1(boost::shared_ptr<const dolfin::FunctionSpace> V0):
    dolfin::Form(1, 0)
  {
    _function_spaces[0] = V0;

    _ufc_form = boost::shared_ptr<const ufc::form>(new adaptivepoisson_form_1());
  }

  // Destructor
  ~Form_1()
  {}

  /// Return the number of the coefficient with this name
  virtual dolfin::uint coefficient_number(const std::string& name) const
  {

    dolfin::dolfin_error("generated code for class Form",
                         "access coeficient data",
                         "There are no coefficients");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(dolfin::uint i) const
  {

    dolfin::dolfin_error("generated code for class Form",
                         "access coeficient data",
                         "There are no coefficients");
    return "unnamed";
  }

  // Typedefs
  typedef Form_1_FunctionSpace_0 TestSpace;

  // Coefficients
};

typedef CoefficientSpace_f Form_2_FunctionSpace_0;

typedef CoefficientSpace_g Form_2_FunctionSpace_1;

typedef CoefficientSpace___discrete_primal_solution Form_2_FunctionSpace_2;

typedef CoefficientSpace___improved_dual Form_2_FunctionSpace_3;

class Form_2: public dolfin::Form
{
public:

  // Constructor
  Form_2(const dolfin::Mesh& mesh):
    dolfin::Form(0, 4), f(*this, 0), g(*this, 1), __discrete_primal_solution(*this, 2), __improved_dual(*this, 3)
  {
    _mesh = reference_to_no_delete_pointer(mesh);
    _ufc_form = boost::shared_ptr<const ufc::form>(new adaptivepoisson_form_2());
  }

  // Constructor
  Form_2(const dolfin::Mesh& mesh, const dolfin::GenericFunction& f, const dolfin::GenericFunction& g, const dolfin::GenericFunction& __discrete_primal_solution, const dolfin::GenericFunction& __improved_dual):
    dolfin::Form(0, 4), f(*this, 0), g(*this, 1), __discrete_primal_solution(*this, 2), __improved_dual(*this, 3)
  {
    _mesh = reference_to_no_delete_pointer(mesh);
    this->f = f;
    this->g = g;
    this->__discrete_primal_solution = __discrete_primal_solution;
    this->__improved_dual = __improved_dual;

    _ufc_form = boost::shared_ptr<const ufc::form>(new adaptivepoisson_form_2());
  }

  // Constructor
  Form_2(const dolfin::Mesh& mesh, boost::shared_ptr<const dolfin::GenericFunction> f, boost::shared_ptr<const dolfin::GenericFunction> g, boost::shared_ptr<const dolfin::GenericFunction> __discrete_primal_solution, boost::shared_ptr<const dolfin::GenericFunction> __improved_dual):
    dolfin::Form(0, 4), f(*this, 0), g(*this, 1), __discrete_primal_solution(*this, 2), __improved_dual(*this, 3)
  {
    _mesh = reference_to_no_delete_pointer(mesh);
    this->f = *f;
    this->g = *g;
    this->__discrete_primal_solution = *__discrete_primal_solution;
    this->__improved_dual = *__improved_dual;

    _ufc_form = boost::shared_ptr<const ufc::form>(new adaptivepoisson_form_2());
  }

  // Constructor
  Form_2(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::Form(0, 4), f(*this, 0), g(*this, 1), __discrete_primal_solution(*this, 2), __improved_dual(*this, 3)
  {
    _mesh = mesh;
    _ufc_form = boost::shared_ptr<const ufc::form>(new adaptivepoisson_form_2());
  }

  // Constructor
  Form_2(boost::shared_ptr<const dolfin::Mesh> mesh, const dolfin::GenericFunction& f, const dolfin::GenericFunction& g, const dolfin::GenericFunction& __discrete_primal_solution, const dolfin::GenericFunction& __improved_dual):
    dolfin::Form(0, 4), f(*this, 0), g(*this, 1), __discrete_primal_solution(*this, 2), __improved_dual(*this, 3)
  {
    _mesh = mesh;
    this->f = f;
    this->g = g;
    this->__discrete_primal_solution = __discrete_primal_solution;
    this->__improved_dual = __improved_dual;

    _ufc_form = boost::shared_ptr<const ufc::form>(new adaptivepoisson_form_2());
  }

  // Constructor
  Form_2(boost::shared_ptr<const dolfin::Mesh> mesh, boost::shared_ptr<const dolfin::GenericFunction> f, boost::shared_ptr<const dolfin::GenericFunction> g, boost::shared_ptr<const dolfin::GenericFunction> __discrete_primal_solution, boost::shared_ptr<const dolfin::GenericFunction> __improved_dual):
    dolfin::Form(0, 4), f(*this, 0), g(*this, 1), __discrete_primal_solution(*this, 2), __improved_dual(*this, 3)
  {
    _mesh = mesh;
    this->f = *f;
    this->g = *g;
    this->__discrete_primal_solution = *__discrete_primal_solution;
    this->__improved_dual = *__improved_dual;

    _ufc_form = boost::shared_ptr<const ufc::form>(new adaptivepoisson_form_2());
  }

  // Destructor
  ~Form_2()
  {}

  /// Return the number of the coefficient with this name
  virtual dolfin::uint coefficient_number(const std::string& name) const
  {
    if (name == "f")
      return 0;
    else if (name == "g")
      return 1;
    else if (name == "__discrete_primal_solution")
      return 2;
    else if (name == "__improved_dual")
      return 3;

    dolfin::dolfin_error("generated code for class Form",
                         "access coeficient data",
                         "Invalid coeficient");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(dolfin::uint i) const
  {
    switch (i)
    {
    case 0:
      return "f";
    case 1:
      return "g";
    case 2:
      return "__discrete_primal_solution";
    case 3:
      return "__improved_dual";
    }

    dolfin::dolfin_error("generated code for class Form",
                         "access coeficient data",
                         "Invalid coeficient");
    return "unnamed";
  }

  // Typedefs
  typedef Form_2_FunctionSpace_0 CoefficientSpace_f;
  typedef Form_2_FunctionSpace_1 CoefficientSpace_g;
  typedef Form_2_FunctionSpace_2 CoefficientSpace___discrete_primal_solution;
  typedef Form_2_FunctionSpace_3 CoefficientSpace___improved_dual;

  // Coefficients
  dolfin::CoefficientAssigner f;
  dolfin::CoefficientAssigner g;
  dolfin::CoefficientAssigner __discrete_primal_solution;
  dolfin::CoefficientAssigner __improved_dual;
};

class Form_3_FunctionSpace_0: public dolfin::FunctionSpace
{
public:

  Form_3_FunctionSpace_0(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_3()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_3()), mesh)))
  {
    // Do nothing
  }

  Form_3_FunctionSpace_0(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_3()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_3()), mesh)))
  {
    // Do nothing
  }

  Form_3_FunctionSpace_0(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_3()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_3()), *mesh)))
  {
      // Do nothing
  }

  Form_3_FunctionSpace_0(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_3()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_3()), *mesh)))
  {
      // Do nothing
  }

  ~Form_3_FunctionSpace_0()
  {
  }

};

class Form_3_FunctionSpace_1: public dolfin::FunctionSpace
{
public:

  Form_3_FunctionSpace_1(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_3()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_3()), mesh)))
  {
    // Do nothing
  }

  Form_3_FunctionSpace_1(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_3()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_3()), mesh)))
  {
    // Do nothing
  }

  Form_3_FunctionSpace_1(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_3()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_3()), *mesh)))
  {
      // Do nothing
  }

  Form_3_FunctionSpace_1(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_3()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_3()), *mesh)))
  {
      // Do nothing
  }

  ~Form_3_FunctionSpace_1()
  {
  }

};

typedef CoefficientSpace___cell_bubble Form_3_FunctionSpace_2;

class Form_3: public dolfin::Form
{
public:

  // Constructor
  Form_3(const dolfin::FunctionSpace& V1, const dolfin::FunctionSpace& V0):
    dolfin::Form(2, 1), __cell_bubble(*this, 0)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);
    _function_spaces[1] = reference_to_no_delete_pointer(V1);

    _ufc_form = boost::shared_ptr<const ufc::form>(new adaptivepoisson_form_3());
  }

  // Constructor
  Form_3(const dolfin::FunctionSpace& V1, const dolfin::FunctionSpace& V0, const dolfin::GenericFunction& __cell_bubble):
    dolfin::Form(2, 1), __cell_bubble(*this, 0)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);
    _function_spaces[1] = reference_to_no_delete_pointer(V1);

    this->__cell_bubble = __cell_bubble;

    _ufc_form = boost::shared_ptr<const ufc::form>(new adaptivepoisson_form_3());
  }

  // Constructor
  Form_3(const dolfin::FunctionSpace& V1, const dolfin::FunctionSpace& V0, boost::shared_ptr<const dolfin::GenericFunction> __cell_bubble):
    dolfin::Form(2, 1), __cell_bubble(*this, 0)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);
    _function_spaces[1] = reference_to_no_delete_pointer(V1);

    this->__cell_bubble = *__cell_bubble;

    _ufc_form = boost::shared_ptr<const ufc::form>(new adaptivepoisson_form_3());
  }

  // Constructor
  Form_3(boost::shared_ptr<const dolfin::FunctionSpace> V1, boost::shared_ptr<const dolfin::FunctionSpace> V0):
    dolfin::Form(2, 1), __cell_bubble(*this, 0)
  {
    _function_spaces[0] = V0;
    _function_spaces[1] = V1;

    _ufc_form = boost::shared_ptr<const ufc::form>(new adaptivepoisson_form_3());
  }

  // Constructor
  Form_3(boost::shared_ptr<const dolfin::FunctionSpace> V1, boost::shared_ptr<const dolfin::FunctionSpace> V0, const dolfin::GenericFunction& __cell_bubble):
    dolfin::Form(2, 1), __cell_bubble(*this, 0)
  {
    _function_spaces[0] = V0;
    _function_spaces[1] = V1;

    this->__cell_bubble = __cell_bubble;

    _ufc_form = boost::shared_ptr<const ufc::form>(new adaptivepoisson_form_3());
  }

  // Constructor
  Form_3(boost::shared_ptr<const dolfin::FunctionSpace> V1, boost::shared_ptr<const dolfin::FunctionSpace> V0, boost::shared_ptr<const dolfin::GenericFunction> __cell_bubble):
    dolfin::Form(2, 1), __cell_bubble(*this, 0)
  {
    _function_spaces[0] = V0;
    _function_spaces[1] = V1;

    this->__cell_bubble = *__cell_bubble;

    _ufc_form = boost::shared_ptr<const ufc::form>(new adaptivepoisson_form_3());
  }

  // Destructor
  ~Form_3()
  {}

  /// Return the number of the coefficient with this name
  virtual dolfin::uint coefficient_number(const std::string& name) const
  {
    if (name == "__cell_bubble")
      return 0;

    dolfin::dolfin_error("generated code for class Form",
                         "access coeficient data",
                         "Invalid coeficient");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(dolfin::uint i) const
  {
    switch (i)
    {
    case 0:
      return "__cell_bubble";
    }

    dolfin::dolfin_error("generated code for class Form",
                         "access coeficient data",
                         "Invalid coeficient");
    return "unnamed";
  }

  // Typedefs
  typedef Form_3_FunctionSpace_0 TestSpace;
  typedef Form_3_FunctionSpace_1 TrialSpace;
  typedef Form_3_FunctionSpace_2 CoefficientSpace___cell_bubble;

  // Coefficients
  dolfin::CoefficientAssigner __cell_bubble;
};

class Form_4_FunctionSpace_0: public dolfin::FunctionSpace
{
public:

  Form_4_FunctionSpace_0(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_3()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_3()), mesh)))
  {
    // Do nothing
  }

  Form_4_FunctionSpace_0(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_3()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_3()), mesh)))
  {
    // Do nothing
  }

  Form_4_FunctionSpace_0(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_3()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_3()), *mesh)))
  {
      // Do nothing
  }

  Form_4_FunctionSpace_0(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_3()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_3()), *mesh)))
  {
      // Do nothing
  }

  ~Form_4_FunctionSpace_0()
  {
  }

};

typedef CoefficientSpace_f Form_4_FunctionSpace_1;

typedef CoefficientSpace_g Form_4_FunctionSpace_2;

typedef CoefficientSpace___discrete_primal_solution Form_4_FunctionSpace_3;

typedef CoefficientSpace___cell_bubble Form_4_FunctionSpace_4;

class Form_4: public dolfin::Form
{
public:

  // Constructor
  Form_4(const dolfin::FunctionSpace& V0):
    dolfin::Form(1, 4), f(*this, 0), g(*this, 1), __discrete_primal_solution(*this, 2), __cell_bubble(*this, 3)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);

    _ufc_form = boost::shared_ptr<const ufc::form>(new adaptivepoisson_form_4());
  }

  // Constructor
  Form_4(const dolfin::FunctionSpace& V0, const dolfin::GenericFunction& f, const dolfin::GenericFunction& g, const dolfin::GenericFunction& __discrete_primal_solution, const dolfin::GenericFunction& __cell_bubble):
    dolfin::Form(1, 4), f(*this, 0), g(*this, 1), __discrete_primal_solution(*this, 2), __cell_bubble(*this, 3)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);

    this->f = f;
    this->g = g;
    this->__discrete_primal_solution = __discrete_primal_solution;
    this->__cell_bubble = __cell_bubble;

    _ufc_form = boost::shared_ptr<const ufc::form>(new adaptivepoisson_form_4());
  }

  // Constructor
  Form_4(const dolfin::FunctionSpace& V0, boost::shared_ptr<const dolfin::GenericFunction> f, boost::shared_ptr<const dolfin::GenericFunction> g, boost::shared_ptr<const dolfin::GenericFunction> __discrete_primal_solution, boost::shared_ptr<const dolfin::GenericFunction> __cell_bubble):
    dolfin::Form(1, 4), f(*this, 0), g(*this, 1), __discrete_primal_solution(*this, 2), __cell_bubble(*this, 3)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);

    this->f = *f;
    this->g = *g;
    this->__discrete_primal_solution = *__discrete_primal_solution;
    this->__cell_bubble = *__cell_bubble;

    _ufc_form = boost::shared_ptr<const ufc::form>(new adaptivepoisson_form_4());
  }

  // Constructor
  Form_4(boost::shared_ptr<const dolfin::FunctionSpace> V0):
    dolfin::Form(1, 4), f(*this, 0), g(*this, 1), __discrete_primal_solution(*this, 2), __cell_bubble(*this, 3)
  {
    _function_spaces[0] = V0;

    _ufc_form = boost::shared_ptr<const ufc::form>(new adaptivepoisson_form_4());
  }

  // Constructor
  Form_4(boost::shared_ptr<const dolfin::FunctionSpace> V0, const dolfin::GenericFunction& f, const dolfin::GenericFunction& g, const dolfin::GenericFunction& __discrete_primal_solution, const dolfin::GenericFunction& __cell_bubble):
    dolfin::Form(1, 4), f(*this, 0), g(*this, 1), __discrete_primal_solution(*this, 2), __cell_bubble(*this, 3)
  {
    _function_spaces[0] = V0;

    this->f = f;
    this->g = g;
    this->__discrete_primal_solution = __discrete_primal_solution;
    this->__cell_bubble = __cell_bubble;

    _ufc_form = boost::shared_ptr<const ufc::form>(new adaptivepoisson_form_4());
  }

  // Constructor
  Form_4(boost::shared_ptr<const dolfin::FunctionSpace> V0, boost::shared_ptr<const dolfin::GenericFunction> f, boost::shared_ptr<const dolfin::GenericFunction> g, boost::shared_ptr<const dolfin::GenericFunction> __discrete_primal_solution, boost::shared_ptr<const dolfin::GenericFunction> __cell_bubble):
    dolfin::Form(1, 4), f(*this, 0), g(*this, 1), __discrete_primal_solution(*this, 2), __cell_bubble(*this, 3)
  {
    _function_spaces[0] = V0;

    this->f = *f;
    this->g = *g;
    this->__discrete_primal_solution = *__discrete_primal_solution;
    this->__cell_bubble = *__cell_bubble;

    _ufc_form = boost::shared_ptr<const ufc::form>(new adaptivepoisson_form_4());
  }

  // Destructor
  ~Form_4()
  {}

  /// Return the number of the coefficient with this name
  virtual dolfin::uint coefficient_number(const std::string& name) const
  {
    if (name == "f")
      return 0;
    else if (name == "g")
      return 1;
    else if (name == "__discrete_primal_solution")
      return 2;
    else if (name == "__cell_bubble")
      return 3;

    dolfin::dolfin_error("generated code for class Form",
                         "access coeficient data",
                         "Invalid coeficient");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(dolfin::uint i) const
  {
    switch (i)
    {
    case 0:
      return "f";
    case 1:
      return "g";
    case 2:
      return "__discrete_primal_solution";
    case 3:
      return "__cell_bubble";
    }

    dolfin::dolfin_error("generated code for class Form",
                         "access coeficient data",
                         "Invalid coeficient");
    return "unnamed";
  }

  // Typedefs
  typedef Form_4_FunctionSpace_0 TestSpace;
  typedef Form_4_FunctionSpace_1 CoefficientSpace_f;
  typedef Form_4_FunctionSpace_2 CoefficientSpace_g;
  typedef Form_4_FunctionSpace_3 CoefficientSpace___discrete_primal_solution;
  typedef Form_4_FunctionSpace_4 CoefficientSpace___cell_bubble;

  // Coefficients
  dolfin::CoefficientAssigner f;
  dolfin::CoefficientAssigner g;
  dolfin::CoefficientAssigner __discrete_primal_solution;
  dolfin::CoefficientAssigner __cell_bubble;
};

class Form_5_FunctionSpace_0: public dolfin::FunctionSpace
{
public:

  Form_5_FunctionSpace_0(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_3()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_3()), mesh)))
  {
    // Do nothing
  }

  Form_5_FunctionSpace_0(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_3()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_3()), mesh)))
  {
    // Do nothing
  }

  Form_5_FunctionSpace_0(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_3()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_3()), *mesh)))
  {
      // Do nothing
  }

  Form_5_FunctionSpace_0(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_3()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_3()), *mesh)))
  {
      // Do nothing
  }

  ~Form_5_FunctionSpace_0()
  {
  }

};

class Form_5_FunctionSpace_1: public dolfin::FunctionSpace
{
public:

  Form_5_FunctionSpace_1(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_3()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_3()), mesh)))
  {
    // Do nothing
  }

  Form_5_FunctionSpace_1(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_3()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_3()), mesh)))
  {
    // Do nothing
  }

  Form_5_FunctionSpace_1(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_3()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_3()), *mesh)))
  {
      // Do nothing
  }

  Form_5_FunctionSpace_1(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_3()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_3()), *mesh)))
  {
      // Do nothing
  }

  ~Form_5_FunctionSpace_1()
  {
  }

};

typedef CoefficientSpace___cell_cone Form_5_FunctionSpace_2;

class Form_5: public dolfin::Form
{
public:

  // Constructor
  Form_5(const dolfin::FunctionSpace& V1, const dolfin::FunctionSpace& V0):
    dolfin::Form(2, 1), __cell_cone(*this, 0)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);
    _function_spaces[1] = reference_to_no_delete_pointer(V1);

    _ufc_form = boost::shared_ptr<const ufc::form>(new adaptivepoisson_form_5());
  }

  // Constructor
  Form_5(const dolfin::FunctionSpace& V1, const dolfin::FunctionSpace& V0, const dolfin::GenericFunction& __cell_cone):
    dolfin::Form(2, 1), __cell_cone(*this, 0)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);
    _function_spaces[1] = reference_to_no_delete_pointer(V1);

    this->__cell_cone = __cell_cone;

    _ufc_form = boost::shared_ptr<const ufc::form>(new adaptivepoisson_form_5());
  }

  // Constructor
  Form_5(const dolfin::FunctionSpace& V1, const dolfin::FunctionSpace& V0, boost::shared_ptr<const dolfin::GenericFunction> __cell_cone):
    dolfin::Form(2, 1), __cell_cone(*this, 0)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);
    _function_spaces[1] = reference_to_no_delete_pointer(V1);

    this->__cell_cone = *__cell_cone;

    _ufc_form = boost::shared_ptr<const ufc::form>(new adaptivepoisson_form_5());
  }

  // Constructor
  Form_5(boost::shared_ptr<const dolfin::FunctionSpace> V1, boost::shared_ptr<const dolfin::FunctionSpace> V0):
    dolfin::Form(2, 1), __cell_cone(*this, 0)
  {
    _function_spaces[0] = V0;
    _function_spaces[1] = V1;

    _ufc_form = boost::shared_ptr<const ufc::form>(new adaptivepoisson_form_5());
  }

  // Constructor
  Form_5(boost::shared_ptr<const dolfin::FunctionSpace> V1, boost::shared_ptr<const dolfin::FunctionSpace> V0, const dolfin::GenericFunction& __cell_cone):
    dolfin::Form(2, 1), __cell_cone(*this, 0)
  {
    _function_spaces[0] = V0;
    _function_spaces[1] = V1;

    this->__cell_cone = __cell_cone;

    _ufc_form = boost::shared_ptr<const ufc::form>(new adaptivepoisson_form_5());
  }

  // Constructor
  Form_5(boost::shared_ptr<const dolfin::FunctionSpace> V1, boost::shared_ptr<const dolfin::FunctionSpace> V0, boost::shared_ptr<const dolfin::GenericFunction> __cell_cone):
    dolfin::Form(2, 1), __cell_cone(*this, 0)
  {
    _function_spaces[0] = V0;
    _function_spaces[1] = V1;

    this->__cell_cone = *__cell_cone;

    _ufc_form = boost::shared_ptr<const ufc::form>(new adaptivepoisson_form_5());
  }

  // Destructor
  ~Form_5()
  {}

  /// Return the number of the coefficient with this name
  virtual dolfin::uint coefficient_number(const std::string& name) const
  {
    if (name == "__cell_cone")
      return 0;

    dolfin::dolfin_error("generated code for class Form",
                         "access coeficient data",
                         "Invalid coeficient");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(dolfin::uint i) const
  {
    switch (i)
    {
    case 0:
      return "__cell_cone";
    }

    dolfin::dolfin_error("generated code for class Form",
                         "access coeficient data",
                         "Invalid coeficient");
    return "unnamed";
  }

  // Typedefs
  typedef Form_5_FunctionSpace_0 TestSpace;
  typedef Form_5_FunctionSpace_1 TrialSpace;
  typedef Form_5_FunctionSpace_2 CoefficientSpace___cell_cone;

  // Coefficients
  dolfin::CoefficientAssigner __cell_cone;
};

class Form_6_FunctionSpace_0: public dolfin::FunctionSpace
{
public:

  Form_6_FunctionSpace_0(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_3()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_3()), mesh)))
  {
    // Do nothing
  }

  Form_6_FunctionSpace_0(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_3()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_3()), mesh)))
  {
    // Do nothing
  }

  Form_6_FunctionSpace_0(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_3()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_3()), *mesh)))
  {
      // Do nothing
  }

  Form_6_FunctionSpace_0(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_3()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_3()), *mesh)))
  {
      // Do nothing
  }

  ~Form_6_FunctionSpace_0()
  {
  }

};

typedef CoefficientSpace_f Form_6_FunctionSpace_1;

typedef CoefficientSpace_g Form_6_FunctionSpace_2;

typedef CoefficientSpace___discrete_primal_solution Form_6_FunctionSpace_3;

typedef CoefficientSpace___cell_residual Form_6_FunctionSpace_4;

typedef CoefficientSpace___cell_cone Form_6_FunctionSpace_5;

class Form_6: public dolfin::Form
{
public:

  // Constructor
  Form_6(const dolfin::FunctionSpace& V0):
    dolfin::Form(1, 5), f(*this, 0), g(*this, 1), __discrete_primal_solution(*this, 2), __cell_residual(*this, 3), __cell_cone(*this, 4)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);

    _ufc_form = boost::shared_ptr<const ufc::form>(new adaptivepoisson_form_6());
  }

  // Constructor
  Form_6(const dolfin::FunctionSpace& V0, const dolfin::GenericFunction& f, const dolfin::GenericFunction& g, const dolfin::GenericFunction& __discrete_primal_solution, const dolfin::GenericFunction& __cell_residual, const dolfin::GenericFunction& __cell_cone):
    dolfin::Form(1, 5), f(*this, 0), g(*this, 1), __discrete_primal_solution(*this, 2), __cell_residual(*this, 3), __cell_cone(*this, 4)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);

    this->f = f;
    this->g = g;
    this->__discrete_primal_solution = __discrete_primal_solution;
    this->__cell_residual = __cell_residual;
    this->__cell_cone = __cell_cone;

    _ufc_form = boost::shared_ptr<const ufc::form>(new adaptivepoisson_form_6());
  }

  // Constructor
  Form_6(const dolfin::FunctionSpace& V0, boost::shared_ptr<const dolfin::GenericFunction> f, boost::shared_ptr<const dolfin::GenericFunction> g, boost::shared_ptr<const dolfin::GenericFunction> __discrete_primal_solution, boost::shared_ptr<const dolfin::GenericFunction> __cell_residual, boost::shared_ptr<const dolfin::GenericFunction> __cell_cone):
    dolfin::Form(1, 5), f(*this, 0), g(*this, 1), __discrete_primal_solution(*this, 2), __cell_residual(*this, 3), __cell_cone(*this, 4)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);

    this->f = *f;
    this->g = *g;
    this->__discrete_primal_solution = *__discrete_primal_solution;
    this->__cell_residual = *__cell_residual;
    this->__cell_cone = *__cell_cone;

    _ufc_form = boost::shared_ptr<const ufc::form>(new adaptivepoisson_form_6());
  }

  // Constructor
  Form_6(boost::shared_ptr<const dolfin::FunctionSpace> V0):
    dolfin::Form(1, 5), f(*this, 0), g(*this, 1), __discrete_primal_solution(*this, 2), __cell_residual(*this, 3), __cell_cone(*this, 4)
  {
    _function_spaces[0] = V0;

    _ufc_form = boost::shared_ptr<const ufc::form>(new adaptivepoisson_form_6());
  }

  // Constructor
  Form_6(boost::shared_ptr<const dolfin::FunctionSpace> V0, const dolfin::GenericFunction& f, const dolfin::GenericFunction& g, const dolfin::GenericFunction& __discrete_primal_solution, const dolfin::GenericFunction& __cell_residual, const dolfin::GenericFunction& __cell_cone):
    dolfin::Form(1, 5), f(*this, 0), g(*this, 1), __discrete_primal_solution(*this, 2), __cell_residual(*this, 3), __cell_cone(*this, 4)
  {
    _function_spaces[0] = V0;

    this->f = f;
    this->g = g;
    this->__discrete_primal_solution = __discrete_primal_solution;
    this->__cell_residual = __cell_residual;
    this->__cell_cone = __cell_cone;

    _ufc_form = boost::shared_ptr<const ufc::form>(new adaptivepoisson_form_6());
  }

  // Constructor
  Form_6(boost::shared_ptr<const dolfin::FunctionSpace> V0, boost::shared_ptr<const dolfin::GenericFunction> f, boost::shared_ptr<const dolfin::GenericFunction> g, boost::shared_ptr<const dolfin::GenericFunction> __discrete_primal_solution, boost::shared_ptr<const dolfin::GenericFunction> __cell_residual, boost::shared_ptr<const dolfin::GenericFunction> __cell_cone):
    dolfin::Form(1, 5), f(*this, 0), g(*this, 1), __discrete_primal_solution(*this, 2), __cell_residual(*this, 3), __cell_cone(*this, 4)
  {
    _function_spaces[0] = V0;

    this->f = *f;
    this->g = *g;
    this->__discrete_primal_solution = *__discrete_primal_solution;
    this->__cell_residual = *__cell_residual;
    this->__cell_cone = *__cell_cone;

    _ufc_form = boost::shared_ptr<const ufc::form>(new adaptivepoisson_form_6());
  }

  // Destructor
  ~Form_6()
  {}

  /// Return the number of the coefficient with this name
  virtual dolfin::uint coefficient_number(const std::string& name) const
  {
    if (name == "f")
      return 0;
    else if (name == "g")
      return 1;
    else if (name == "__discrete_primal_solution")
      return 2;
    else if (name == "__cell_residual")
      return 3;
    else if (name == "__cell_cone")
      return 4;

    dolfin::dolfin_error("generated code for class Form",
                         "access coeficient data",
                         "Invalid coeficient");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(dolfin::uint i) const
  {
    switch (i)
    {
    case 0:
      return "f";
    case 1:
      return "g";
    case 2:
      return "__discrete_primal_solution";
    case 3:
      return "__cell_residual";
    case 4:
      return "__cell_cone";
    }

    dolfin::dolfin_error("generated code for class Form",
                         "access coeficient data",
                         "Invalid coeficient");
    return "unnamed";
  }

  // Typedefs
  typedef Form_6_FunctionSpace_0 TestSpace;
  typedef Form_6_FunctionSpace_1 CoefficientSpace_f;
  typedef Form_6_FunctionSpace_2 CoefficientSpace_g;
  typedef Form_6_FunctionSpace_3 CoefficientSpace___discrete_primal_solution;
  typedef Form_6_FunctionSpace_4 CoefficientSpace___cell_residual;
  typedef Form_6_FunctionSpace_5 CoefficientSpace___cell_cone;

  // Coefficients
  dolfin::CoefficientAssigner f;
  dolfin::CoefficientAssigner g;
  dolfin::CoefficientAssigner __discrete_primal_solution;
  dolfin::CoefficientAssigner __cell_residual;
  dolfin::CoefficientAssigner __cell_cone;
};

class Form_7_FunctionSpace_0: public dolfin::FunctionSpace
{
public:

  Form_7_FunctionSpace_0(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_0()), mesh)))
  {
    // Do nothing
  }

  Form_7_FunctionSpace_0(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_0()), mesh)))
  {
    // Do nothing
  }

  Form_7_FunctionSpace_0(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_0()), *mesh)))
  {
      // Do nothing
  }

  Form_7_FunctionSpace_0(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_0()), *mesh)))
  {
      // Do nothing
  }

  ~Form_7_FunctionSpace_0()
  {
  }

};

typedef CoefficientSpace___improved_dual Form_7_FunctionSpace_1;

typedef CoefficientSpace___cell_residual Form_7_FunctionSpace_2;

typedef CoefficientSpace___facet_residual Form_7_FunctionSpace_3;

typedef CoefficientSpace___discrete_dual_solution Form_7_FunctionSpace_4;

class Form_7: public dolfin::Form
{
public:

  // Constructor
  Form_7(const dolfin::FunctionSpace& V0):
    dolfin::Form(1, 4), __improved_dual(*this, 0), __cell_residual(*this, 1), __facet_residual(*this, 2), __discrete_dual_solution(*this, 3)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);

    _ufc_form = boost::shared_ptr<const ufc::form>(new adaptivepoisson_form_7());
  }

  // Constructor
  Form_7(const dolfin::FunctionSpace& V0, const dolfin::GenericFunction& __improved_dual, const dolfin::GenericFunction& __cell_residual, const dolfin::GenericFunction& __facet_residual, const dolfin::GenericFunction& __discrete_dual_solution):
    dolfin::Form(1, 4), __improved_dual(*this, 0), __cell_residual(*this, 1), __facet_residual(*this, 2), __discrete_dual_solution(*this, 3)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);

    this->__improved_dual = __improved_dual;
    this->__cell_residual = __cell_residual;
    this->__facet_residual = __facet_residual;
    this->__discrete_dual_solution = __discrete_dual_solution;

    _ufc_form = boost::shared_ptr<const ufc::form>(new adaptivepoisson_form_7());
  }

  // Constructor
  Form_7(const dolfin::FunctionSpace& V0, boost::shared_ptr<const dolfin::GenericFunction> __improved_dual, boost::shared_ptr<const dolfin::GenericFunction> __cell_residual, boost::shared_ptr<const dolfin::GenericFunction> __facet_residual, boost::shared_ptr<const dolfin::GenericFunction> __discrete_dual_solution):
    dolfin::Form(1, 4), __improved_dual(*this, 0), __cell_residual(*this, 1), __facet_residual(*this, 2), __discrete_dual_solution(*this, 3)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);

    this->__improved_dual = *__improved_dual;
    this->__cell_residual = *__cell_residual;
    this->__facet_residual = *__facet_residual;
    this->__discrete_dual_solution = *__discrete_dual_solution;

    _ufc_form = boost::shared_ptr<const ufc::form>(new adaptivepoisson_form_7());
  }

  // Constructor
  Form_7(boost::shared_ptr<const dolfin::FunctionSpace> V0):
    dolfin::Form(1, 4), __improved_dual(*this, 0), __cell_residual(*this, 1), __facet_residual(*this, 2), __discrete_dual_solution(*this, 3)
  {
    _function_spaces[0] = V0;

    _ufc_form = boost::shared_ptr<const ufc::form>(new adaptivepoisson_form_7());
  }

  // Constructor
  Form_7(boost::shared_ptr<const dolfin::FunctionSpace> V0, const dolfin::GenericFunction& __improved_dual, const dolfin::GenericFunction& __cell_residual, const dolfin::GenericFunction& __facet_residual, const dolfin::GenericFunction& __discrete_dual_solution):
    dolfin::Form(1, 4), __improved_dual(*this, 0), __cell_residual(*this, 1), __facet_residual(*this, 2), __discrete_dual_solution(*this, 3)
  {
    _function_spaces[0] = V0;

    this->__improved_dual = __improved_dual;
    this->__cell_residual = __cell_residual;
    this->__facet_residual = __facet_residual;
    this->__discrete_dual_solution = __discrete_dual_solution;

    _ufc_form = boost::shared_ptr<const ufc::form>(new adaptivepoisson_form_7());
  }

  // Constructor
  Form_7(boost::shared_ptr<const dolfin::FunctionSpace> V0, boost::shared_ptr<const dolfin::GenericFunction> __improved_dual, boost::shared_ptr<const dolfin::GenericFunction> __cell_residual, boost::shared_ptr<const dolfin::GenericFunction> __facet_residual, boost::shared_ptr<const dolfin::GenericFunction> __discrete_dual_solution):
    dolfin::Form(1, 4), __improved_dual(*this, 0), __cell_residual(*this, 1), __facet_residual(*this, 2), __discrete_dual_solution(*this, 3)
  {
    _function_spaces[0] = V0;

    this->__improved_dual = *__improved_dual;
    this->__cell_residual = *__cell_residual;
    this->__facet_residual = *__facet_residual;
    this->__discrete_dual_solution = *__discrete_dual_solution;

    _ufc_form = boost::shared_ptr<const ufc::form>(new adaptivepoisson_form_7());
  }

  // Destructor
  ~Form_7()
  {}

  /// Return the number of the coefficient with this name
  virtual dolfin::uint coefficient_number(const std::string& name) const
  {
    if (name == "__improved_dual")
      return 0;
    else if (name == "__cell_residual")
      return 1;
    else if (name == "__facet_residual")
      return 2;
    else if (name == "__discrete_dual_solution")
      return 3;

    dolfin::dolfin_error("generated code for class Form",
                         "access coeficient data",
                         "Invalid coeficient");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(dolfin::uint i) const
  {
    switch (i)
    {
    case 0:
      return "__improved_dual";
    case 1:
      return "__cell_residual";
    case 2:
      return "__facet_residual";
    case 3:
      return "__discrete_dual_solution";
    }

    dolfin::dolfin_error("generated code for class Form",
                         "access coeficient data",
                         "Invalid coeficient");
    return "unnamed";
  }

  // Typedefs
  typedef Form_7_FunctionSpace_0 TestSpace;
  typedef Form_7_FunctionSpace_1 CoefficientSpace___improved_dual;
  typedef Form_7_FunctionSpace_2 CoefficientSpace___cell_residual;
  typedef Form_7_FunctionSpace_3 CoefficientSpace___facet_residual;
  typedef Form_7_FunctionSpace_4 CoefficientSpace___discrete_dual_solution;

  // Coefficients
  dolfin::CoefficientAssigner __improved_dual;
  dolfin::CoefficientAssigner __cell_residual;
  dolfin::CoefficientAssigner __facet_residual;
  dolfin::CoefficientAssigner __discrete_dual_solution;
};

class Form_8_FunctionSpace_0: public dolfin::FunctionSpace
{
public:

  Form_8_FunctionSpace_0(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_5()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_5()), mesh)))
  {
    // Do nothing
  }

  Form_8_FunctionSpace_0(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_5()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_5()), mesh)))
  {
    // Do nothing
  }

  Form_8_FunctionSpace_0(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_5()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_5()), *mesh)))
  {
      // Do nothing
  }

  Form_8_FunctionSpace_0(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_5()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_5()), *mesh)))
  {
      // Do nothing
  }

  ~Form_8_FunctionSpace_0()
  {
  }

};

class Form_8_FunctionSpace_1: public dolfin::FunctionSpace
{
public:

  Form_8_FunctionSpace_1(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_5()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_5()), mesh)))
  {
    // Do nothing
  }

  Form_8_FunctionSpace_1(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_5()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_5()), mesh)))
  {
    // Do nothing
  }

  Form_8_FunctionSpace_1(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_5()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_5()), *mesh)))
  {
      // Do nothing
  }

  Form_8_FunctionSpace_1(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_5()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_5()), *mesh)))
  {
      // Do nothing
  }

  ~Form_8_FunctionSpace_1()
  {
  }

};

class Form_8: public dolfin::Form
{
public:

  // Constructor
  Form_8(const dolfin::FunctionSpace& V1, const dolfin::FunctionSpace& V0):
    dolfin::Form(2, 0)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);
    _function_spaces[1] = reference_to_no_delete_pointer(V1);

    _ufc_form = boost::shared_ptr<const ufc::form>(new adaptivepoisson_form_8());
  }

  // Constructor
  Form_8(boost::shared_ptr<const dolfin::FunctionSpace> V1, boost::shared_ptr<const dolfin::FunctionSpace> V0):
    dolfin::Form(2, 0)
  {
    _function_spaces[0] = V0;
    _function_spaces[1] = V1;

    _ufc_form = boost::shared_ptr<const ufc::form>(new adaptivepoisson_form_8());
  }

  // Destructor
  ~Form_8()
  {}

  /// Return the number of the coefficient with this name
  virtual dolfin::uint coefficient_number(const std::string& name) const
  {

    dolfin::dolfin_error("generated code for class Form",
                         "access coeficient data",
                         "There are no coefficients");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(dolfin::uint i) const
  {

    dolfin::dolfin_error("generated code for class Form",
                         "access coeficient data",
                         "There are no coefficients");
    return "unnamed";
  }

  // Typedefs
  typedef Form_8_FunctionSpace_0 TestSpace;
  typedef Form_8_FunctionSpace_1 TrialSpace;

  // Coefficients
};

class Form_9_FunctionSpace_0: public dolfin::FunctionSpace
{
public:

  Form_9_FunctionSpace_0(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_5()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_5()), mesh)))
  {
    // Do nothing
  }

  Form_9_FunctionSpace_0(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_5()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_5()), mesh)))
  {
    // Do nothing
  }

  Form_9_FunctionSpace_0(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_5()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_5()), *mesh)))
  {
      // Do nothing
  }

  Form_9_FunctionSpace_0(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new adaptivepoisson_finite_element_5()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new adaptivepoisson_dofmap_5()), *mesh)))
  {
      // Do nothing
  }

  ~Form_9_FunctionSpace_0()
  {
  }

};

typedef CoefficientSpace_f Form_9_FunctionSpace_1;

typedef CoefficientSpace_g Form_9_FunctionSpace_2;

class Form_9: public dolfin::Form
{
public:

  // Constructor
  Form_9(const dolfin::FunctionSpace& V0):
    dolfin::Form(1, 2), f(*this, 0), g(*this, 1)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);

    _ufc_form = boost::shared_ptr<const ufc::form>(new adaptivepoisson_form_9());
  }

  // Constructor
  Form_9(const dolfin::FunctionSpace& V0, const dolfin::GenericFunction& f, const dolfin::GenericFunction& g):
    dolfin::Form(1, 2), f(*this, 0), g(*this, 1)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);

    this->f = f;
    this->g = g;

    _ufc_form = boost::shared_ptr<const ufc::form>(new adaptivepoisson_form_9());
  }

  // Constructor
  Form_9(const dolfin::FunctionSpace& V0, boost::shared_ptr<const dolfin::GenericFunction> f, boost::shared_ptr<const dolfin::GenericFunction> g):
    dolfin::Form(1, 2), f(*this, 0), g(*this, 1)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);

    this->f = *f;
    this->g = *g;

    _ufc_form = boost::shared_ptr<const ufc::form>(new adaptivepoisson_form_9());
  }

  // Constructor
  Form_9(boost::shared_ptr<const dolfin::FunctionSpace> V0):
    dolfin::Form(1, 2), f(*this, 0), g(*this, 1)
  {
    _function_spaces[0] = V0;

    _ufc_form = boost::shared_ptr<const ufc::form>(new adaptivepoisson_form_9());
  }

  // Constructor
  Form_9(boost::shared_ptr<const dolfin::FunctionSpace> V0, const dolfin::GenericFunction& f, const dolfin::GenericFunction& g):
    dolfin::Form(1, 2), f(*this, 0), g(*this, 1)
  {
    _function_spaces[0] = V0;

    this->f = f;
    this->g = g;

    _ufc_form = boost::shared_ptr<const ufc::form>(new adaptivepoisson_form_9());
  }

  // Constructor
  Form_9(boost::shared_ptr<const dolfin::FunctionSpace> V0, boost::shared_ptr<const dolfin::GenericFunction> f, boost::shared_ptr<const dolfin::GenericFunction> g):
    dolfin::Form(1, 2), f(*this, 0), g(*this, 1)
  {
    _function_spaces[0] = V0;

    this->f = *f;
    this->g = *g;

    _ufc_form = boost::shared_ptr<const ufc::form>(new adaptivepoisson_form_9());
  }

  // Destructor
  ~Form_9()
  {}

  /// Return the number of the coefficient with this name
  virtual dolfin::uint coefficient_number(const std::string& name) const
  {
    if (name == "f")
      return 0;
    else if (name == "g")
      return 1;

    dolfin::dolfin_error("generated code for class Form",
                         "access coeficient data",
                         "Invalid coeficient");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(dolfin::uint i) const
  {
    switch (i)
    {
    case 0:
      return "f";
    case 1:
      return "g";
    }

    dolfin::dolfin_error("generated code for class Form",
                         "access coeficient data",
                         "Invalid coeficient");
    return "unnamed";
  }

  // Typedefs
  typedef Form_9_FunctionSpace_0 TestSpace;
  typedef Form_9_FunctionSpace_1 CoefficientSpace_f;
  typedef Form_9_FunctionSpace_2 CoefficientSpace_g;

  // Coefficients
  dolfin::CoefficientAssigner f;
  dolfin::CoefficientAssigner g;
};

typedef CoefficientSpace___discrete_primal_solution Form_10_FunctionSpace_0;

class Form_10: public dolfin::GoalFunctional
{
public:

  // Constructor
  Form_10(const dolfin::Mesh& mesh):
    dolfin::GoalFunctional(0, 1), __discrete_primal_solution(*this, 0)
  {
    _mesh = reference_to_no_delete_pointer(mesh);
    _ufc_form = boost::shared_ptr<const ufc::form>(new adaptivepoisson_form_10());
  }

  // Constructor
  Form_10(const dolfin::Mesh& mesh, const dolfin::GenericFunction& __discrete_primal_solution):
    dolfin::GoalFunctional(0, 1), __discrete_primal_solution(*this, 0)
  {
    _mesh = reference_to_no_delete_pointer(mesh);
    this->__discrete_primal_solution = __discrete_primal_solution;

    _ufc_form = boost::shared_ptr<const ufc::form>(new adaptivepoisson_form_10());
  }

  // Constructor
  Form_10(const dolfin::Mesh& mesh, boost::shared_ptr<const dolfin::GenericFunction> __discrete_primal_solution):
    dolfin::GoalFunctional(0, 1), __discrete_primal_solution(*this, 0)
  {
    _mesh = reference_to_no_delete_pointer(mesh);
    this->__discrete_primal_solution = *__discrete_primal_solution;

    _ufc_form = boost::shared_ptr<const ufc::form>(new adaptivepoisson_form_10());
  }

  // Constructor
  Form_10(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::GoalFunctional(0, 1), __discrete_primal_solution(*this, 0)
  {
    _mesh = mesh;
    _ufc_form = boost::shared_ptr<const ufc::form>(new adaptivepoisson_form_10());
  }

  // Constructor
  Form_10(boost::shared_ptr<const dolfin::Mesh> mesh, const dolfin::GenericFunction& __discrete_primal_solution):
    dolfin::GoalFunctional(0, 1), __discrete_primal_solution(*this, 0)
  {
    _mesh = mesh;
    this->__discrete_primal_solution = __discrete_primal_solution;

    _ufc_form = boost::shared_ptr<const ufc::form>(new adaptivepoisson_form_10());
  }

  // Constructor
  Form_10(boost::shared_ptr<const dolfin::Mesh> mesh, boost::shared_ptr<const dolfin::GenericFunction> __discrete_primal_solution):
    dolfin::GoalFunctional(0, 1), __discrete_primal_solution(*this, 0)
  {
    _mesh = mesh;
    this->__discrete_primal_solution = *__discrete_primal_solution;

    _ufc_form = boost::shared_ptr<const ufc::form>(new adaptivepoisson_form_10());
  }

  // Destructor
  ~Form_10()
  {}

  /// Return the number of the coefficient with this name
  virtual dolfin::uint coefficient_number(const std::string& name) const
  {
    if (name == "__discrete_primal_solution")
      return 0;

    dolfin::dolfin_error("generated code for class GoalFunctional",
                         "access coeficient data",
                         "Invalid coeficient");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(dolfin::uint i) const
  {
    switch (i)
    {
    case 0:
      return "__discrete_primal_solution";
    }

    dolfin::dolfin_error("generated code for class GoalFunctional",
                         "access coeficient data",
                         "Invalid coeficient");
    return "unnamed";
  }

  // Typedefs
  typedef Form_10_FunctionSpace_0 CoefficientSpace___discrete_primal_solution;

  // Coefficients
  dolfin::CoefficientAssigner __discrete_primal_solution;

  /// Initialize all error control forms, attach coefficients and
  /// (re-)set error control
  virtual void update_ec(const dolfin::Form& a, const dolfin::Form& L)
  {
    // This stuff is created here and shipped elsewhere
    boost::shared_ptr<dolfin::Form> a_star;           // Dual lhs
    boost::shared_ptr<dolfin::Form> L_star;           // Dual rhs
    boost::shared_ptr<dolfin::FunctionSpace> V_Ez_h;  // Extrapolation space
    boost::shared_ptr<dolfin::Function> Ez_h;         // Extrapolated dual
    boost::shared_ptr<dolfin::Form> residual;         // Residual (as functional)
    boost::shared_ptr<dolfin::FunctionSpace> V_R_T;   // Trial space for cell residual
    boost::shared_ptr<dolfin::Form> a_R_T;            // Cell residual lhs
    boost::shared_ptr<dolfin::Form> L_R_T;            // Cell residual rhs
    boost::shared_ptr<dolfin::FunctionSpace> V_b_T;   // Function space for cell bubble
    boost::shared_ptr<dolfin::Function> b_T;          // Cell bubble
    boost::shared_ptr<dolfin::FunctionSpace> V_R_dT;  // Trial space for facet residual
    boost::shared_ptr<dolfin::Form> a_R_dT;           // Facet residual lhs
    boost::shared_ptr<dolfin::Form> L_R_dT;           // Facet residual rhs
    boost::shared_ptr<dolfin::FunctionSpace> V_b_e;   // Function space for cell cone
    boost::shared_ptr<dolfin::Function> b_e;          // Cell cone
    boost::shared_ptr<dolfin::FunctionSpace> V_eta_T; // Function space for indicators
    boost::shared_ptr<dolfin::Form> eta_T;            // Indicator form

    // Some handy views
    const dolfin::FunctionSpace& Vhat(*(a.function_space(0))); // Primal test
    const dolfin::FunctionSpace& V(*(a.function_space(1)));    // Primal trial
    assert(V.mesh());
    const dolfin::Mesh& mesh(*V.mesh());
    std::string name;

    // Initialize dual forms
    a_star.reset(new Form_0(V, Vhat));
    L_star.reset(new Form_1(V));

    
    // Attach coefficients from a to a_star
    for (dolfin::uint i = 0; i < a.num_coefficients(); i++)
    {
      name = a.coefficient_name(i);
      // Don't attach discrete primal solution here (not computed).
      if (name == "__discrete_primal_solution")
        continue;

      // Test whether a_star has coefficient named 'name'
      try {
        a_star->coefficient_number(name);
      } catch (...) {
        std::cout << "Attaching coefficient named: " << name << " to a_star";
        std::cout << " failed! But this might be expected." << std::endl;
        continue;
      }
      a_star->set_coefficient(name, a.coefficient(i));
    }
    
    // Attach subdomains from a to a_star
    a_star->dx = a.cell_domains_shared_ptr();
    a_star->ds = a.exterior_facet_domains_shared_ptr();
    a_star->dS = a.interior_facet_domains_shared_ptr();

    
    // Attach coefficients from (*this) to L_star
    for (dolfin::uint i = 0; i < (*this).num_coefficients(); i++)
    {
      name = (*this).coefficient_name(i);
      // Don't attach discrete primal solution here (not computed).
      if (name == "__discrete_primal_solution")
        continue;

      // Test whether L_star has coefficient named 'name'
      try {
        L_star->coefficient_number(name);
      } catch (...) {
        std::cout << "Attaching coefficient named: " << name << " to L_star";
        std::cout << " failed! But this might be expected." << std::endl;
        continue;
      }
      L_star->set_coefficient(name, (*this).coefficient(i));
    }
    
    // Attach subdomains from (*this) to L_star
    L_star->dx = (*this).cell_domains_shared_ptr();
    L_star->ds = (*this).exterior_facet_domains_shared_ptr();
    L_star->dS = (*this).interior_facet_domains_shared_ptr();


    // Initialize residual
    residual.reset(new Form_2(mesh));
    
    // Attach coefficients from a to residual
    for (dolfin::uint i = 0; i < a.num_coefficients(); i++)
    {
      name = a.coefficient_name(i);
      // Don't attach discrete primal solution here (not computed).
      if (name == "__discrete_primal_solution")
        continue;

      // Test whether residual has coefficient named 'name'
      try {
        residual->coefficient_number(name);
      } catch (...) {
        std::cout << "Attaching coefficient named: " << name << " to residual";
        std::cout << " failed! But this might be expected." << std::endl;
        continue;
      }
      residual->set_coefficient(name, a.coefficient(i));
    }
    

    // Attach coefficients from L to residual
    for (dolfin::uint i = 0; i < L.num_coefficients(); i++)
    {
      name = L.coefficient_name(i);
      // Don't attach discrete primal solution here (not computed).
      if (name == "__discrete_primal_solution")
        continue;

      // Test whether residual has coefficient named 'name'
      try {
        residual->coefficient_number(name);
      } catch (...) {
        std::cout << "Attaching coefficient named: " << name << " to residual";
        std::cout << " failed! But this might be expected." << std::endl;
        continue;
      }
      residual->set_coefficient(name, L.coefficient(i));
    }
    
    // Attach subdomains from L to residual
    residual->dx = L.cell_domains_shared_ptr();
    residual->ds = L.exterior_facet_domains_shared_ptr();
    residual->dS = L.interior_facet_domains_shared_ptr();


    // Initialize extrapolation space and (fake) extrapolation
    V_Ez_h.reset(new CoefficientSpace___improved_dual(mesh));
    Ez_h.reset(new dolfin::Function(V_Ez_h));
    residual->set_coefficient("__improved_dual", Ez_h);

    // Create bilinear and linear form for computing cell residual R_T
    V_R_T.reset(new Form_4::TestSpace(mesh));
    a_R_T.reset(new Form_3(V_R_T, V_R_T));
    L_R_T.reset(new Form_4(V_R_T));

    // Initialize bubble and attach to a_R_T and L_R_T
    V_b_T.reset(new CoefficientSpace___cell_bubble(mesh));
    b_T.reset(new dolfin::Function(V_b_T));
    *b_T->vector() = 1.0;
    
    // Attach coefficients from a to L_R_T
    for (dolfin::uint i = 0; i < a.num_coefficients(); i++)
    {
      name = a.coefficient_name(i);
      // Don't attach discrete primal solution here (not computed).
      if (name == "__discrete_primal_solution")
        continue;

      // Test whether L_R_T has coefficient named 'name'
      try {
        L_R_T->coefficient_number(name);
      } catch (...) {
        std::cout << "Attaching coefficient named: " << name << " to L_R_T";
        std::cout << " failed! But this might be expected." << std::endl;
        continue;
      }
      L_R_T->set_coefficient(name, a.coefficient(i));
    }
    

    // Attach coefficients from L to L_R_T
    for (dolfin::uint i = 0; i < L.num_coefficients(); i++)
    {
      name = L.coefficient_name(i);
      // Don't attach discrete primal solution here (not computed).
      if (name == "__discrete_primal_solution")
        continue;

      // Test whether L_R_T has coefficient named 'name'
      try {
        L_R_T->coefficient_number(name);
      } catch (...) {
        std::cout << "Attaching coefficient named: " << name << " to L_R_T";
        std::cout << " failed! But this might be expected." << std::endl;
        continue;
      }
      L_R_T->set_coefficient(name, L.coefficient(i));
    }
    
    // Attach subdomains from L to L_R_T
    L_R_T->dx = L.cell_domains_shared_ptr();
    L_R_T->ds = L.exterior_facet_domains_shared_ptr();
    L_R_T->dS = L.interior_facet_domains_shared_ptr();


    // Attach bubble function to _a_R_T and _L_R_T
    a_R_T->set_coefficient("__cell_bubble", b_T);
    L_R_T->set_coefficient("__cell_bubble", b_T);

    // Create bilinear and linear form for computing facet residual R_dT
    V_R_dT.reset(new Form_6::TestSpace(mesh));
    a_R_dT.reset(new Form_5(V_R_dT, V_R_dT));
    L_R_dT.reset(new Form_6(V_R_dT));
    
    // Attach coefficients from a to L_R_dT
    for (dolfin::uint i = 0; i < a.num_coefficients(); i++)
    {
      name = a.coefficient_name(i);
      // Don't attach discrete primal solution here (not computed).
      if (name == "__discrete_primal_solution")
        continue;

      // Test whether L_R_dT has coefficient named 'name'
      try {
        L_R_dT->coefficient_number(name);
      } catch (...) {
        std::cout << "Attaching coefficient named: " << name << " to L_R_dT";
        std::cout << " failed! But this might be expected." << std::endl;
        continue;
      }
      L_R_dT->set_coefficient(name, a.coefficient(i));
    }
    

    // Attach coefficients from L to L_R_dT
    for (dolfin::uint i = 0; i < L.num_coefficients(); i++)
    {
      name = L.coefficient_name(i);
      // Don't attach discrete primal solution here (not computed).
      if (name == "__discrete_primal_solution")
        continue;

      // Test whether L_R_dT has coefficient named 'name'
      try {
        L_R_dT->coefficient_number(name);
      } catch (...) {
        std::cout << "Attaching coefficient named: " << name << " to L_R_dT";
        std::cout << " failed! But this might be expected." << std::endl;
        continue;
      }
      L_R_dT->set_coefficient(name, L.coefficient(i));
    }
    
    // Attach subdomains from L to L_R_dT
    L_R_dT->dx = L.cell_domains_shared_ptr();
    L_R_dT->ds = L.exterior_facet_domains_shared_ptr();
    L_R_dT->dS = L.interior_facet_domains_shared_ptr();


    // Initialize (fake) cone and attach to a_R_dT and L_R_dT
    V_b_e.reset(new CoefficientSpace___cell_cone(mesh));
    b_e.reset(new dolfin::Function(V_b_e));
    a_R_dT->set_coefficient("__cell_cone", b_e);
    L_R_dT->set_coefficient("__cell_cone", b_e);

    // Create error indicator form
    V_eta_T.reset(new Form_7::TestSpace(mesh));
    eta_T.reset(new Form_7(V_eta_T));

    // Update error control
    _ec.reset(new dolfin::ErrorControl(a_star, L_star, residual,
                                       a_R_T, L_R_T, a_R_dT, L_R_dT, eta_T,
                                       true));

  }

};

// Class typedefs
typedef Form_8 BilinearForm;
typedef Form_9 LinearForm;
typedef Form_10 GoalFunctional;

}

#endif
