// This code conforms with the UFC specification version 2016.2.0
// and was automatically generated by FFC version 2016.2.0.
//
// This code was generated with the option '-l dolfin' and
// contains DOLFIN-specific wrappers that depend on DOLFIN.
// 
// This code was generated with the following parameters:
// 
//   convert_exceptions_to_warnings: False
//   cpp_optimize:                   True
//   cpp_optimize_flags:             '-O2'
//   epsilon:                        1e-14
//   error_control:                  False
//   form_postfix:                   True
//   format:                         'dolfin'
//   max_signature_length:           0
//   optimize:                       True
//   precision:                      15
//   quadrature_degree:              -1
//   quadrature_rule:                'auto'
//   representation:                 'uflacs'
//   split:                          False

#ifndef __HYPERELASTICITY_H
#define __HYPERELASTICITY_H
#include <cmath>
#include <cstring>
#include <stdexcept>
#include <ufc.h>

class hyperelasticity_finite_element_0: public ufc::finite_element
{
public:

  hyperelasticity_finite_element_0() : ufc::finite_element()
  {
    // Do nothing
  }

  ~hyperelasticity_finite_element_0() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "FiniteElement('Lagrange', triangle, 1)";
  }

  ufc::shape cell_shape() const final override
  {
    return ufc::shape::triangle;
  }

  std::size_t topological_dimension() const final override
  {
    return 2;
  }

  std::size_t geometric_dimension() const final override
  {
    return 2;
  }

  std::size_t space_dimension() const final override
  {
    return 3;
  }

  std::size_t value_rank() const final override
  {
    return 0;
  }

  std::size_t value_dimension(std::size_t i) const final override
  {
    return 1;
  }

  std::size_t value_size() const final override
  {
    return 1;
  }

  std::size_t reference_value_rank() const final override
  {
    return 0;
  }

  std::size_t reference_value_dimension(std::size_t i) const final override
  {
    return 1;
  }

  std::size_t reference_value_size() const final override
  {
    return 1;
  }

  std::size_t degree() const final override
  {
    return 1;
  }

  const char * family() const final override
  {
    return "Lagrange";
  }

  static void _evaluate_basis(std::size_t i,
                              double * values,
                              const double * x,
                              const double * coordinate_dofs,
                              int cell_orientation)
  {
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = coordinate_dofs[2] + coordinate_dofs[4];
    const double C1 = coordinate_dofs[3] + coordinate_dofs[5];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J[1]*(C1 - 2.0*x[1]) + J[3]*(2.0*x[0] - C0)) / detJ;
    double Y = (J[0]*(2.0*x[1] - C1) + J[2]*(C0 - 2.0*x[0])) / detJ;
    
    // Reset values
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, -0.288675134594813, -0.166666666666667};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 3; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.288675134594813, -0.166666666666667};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 3; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.0, 0.333333333333333};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 3; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    }
    
  }

  void evaluate_basis(std::size_t i,
                      double * values,
                      const double * x,
                      const double * coordinate_dofs,
                      int cell_orientation) const final override
  {
    _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_all(double * values,
                                  const double * x,
                                  const double * coordinate_dofs,
                                  int cell_orientation)
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis
    for (unsigned int r = 0; r < 3; r++)
    {
      _evaluate_basis(r, &dof_values, x, coordinate_dofs, cell_orientation);
      values[r] = dof_values;
    } // end loop over 'r'
  }

  void evaluate_basis_all(double * values,
                          const double * x,
                          const double * coordinate_dofs,
                          int cell_orientation) const final override
  {
    _evaluate_basis_all(values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_derivatives(std::size_t i,
                                          std::size_t n,
                                          double * values,
                                          const double * x,
                                          const double * coordinate_dofs,
                                          int cell_orientation)
  {
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    } // end loop over 'r'
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    } // end loop over 'r'
    
    // Call evaluate_basis if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 1)
    {
    return ;
    }
    
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = coordinate_dofs[2] + coordinate_dofs[4];
    const double C1 = coordinate_dofs[3] + coordinate_dofs[5];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J[1]*(C1 - 2.0*x[1]) + J[3]*(2.0*x[0] - C0)) / detJ;
    double Y = (J[0]*(2.0*x[1] - C1) + J[2]*(C0 - 2.0*x[0])) / detJ;
    
    // Declare two dimensional array that holds combinations of derivatives and initialise
    unsigned int combinations[2][1];
    for (unsigned int row = 0; row < 2; row++)
    {
      for (unsigned int col = 0; col < 1; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K[0], K[1]}, {K[2], K[3]}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double transform[2][2];
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, -0.288675134594813, -0.166666666666667};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[2];
      for (unsigned int r = 0; r < 2; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.288675134594813, -0.166666666666667};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[2];
      for (unsigned int r = 0; r < 2; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.0, 0.333333333333333};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[2];
      for (unsigned int r = 0; r < 2; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    }
    
  }

  void evaluate_basis_derivatives(std::size_t i,
                                  std::size_t n,
                                  double * values,
                                  const double * x,
                                  const double * coordinate_dofs,
                                  int cell_orientation) const final override
  {
    _evaluate_basis_derivatives(i, n, values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_derivatives_all(std::size_t n,
                                              double * values,
                                              const double * x,
                                              const double * coordinate_dofs,
                                              int cell_orientation)
  {
    // Call evaluate_basis_all if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis_all(values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    } // end loop over 'r'
    
    // Set values equal to zero.
    for (unsigned int r = 0; r < 3; r++)
    {
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = 0.0;
      } // end loop over 's'
    } // end loop over 'r'
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 1)
    {
      return ;
    }
    
    // Helper variable to hold values of a single dof.
    double dof_values[2];
    for (unsigned int r = 0; r < 2; r++)
    {
      dof_values[r] = 0.0;
    } // end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 3; r++)
    {
      _evaluate_basis_derivatives(r, n, dof_values, x, coordinate_dofs, cell_orientation);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      } // end loop over 's'
    } // end loop over 'r'
  }

  void evaluate_basis_derivatives_all(std::size_t n,
                                      double * values,
                                      const double * x,
                                      const double * coordinate_dofs,
                                      int cell_orientation) const final override
  {
    _evaluate_basis_derivatives_all(n, values, x, coordinate_dofs, cell_orientation);
  }

  double evaluate_dof(std::size_t i,
                      const ufc::function& f,
                      const double * coordinate_dofs,
                      int cell_orientation,
                      const ufc::cell& c) const final override
  {
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[2];
    switch (i)
    {
    case 0:
      {
        y[0] = coordinate_dofs[0];
      y[1] = coordinate_dofs[1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = coordinate_dofs[2];
      y[1] = coordinate_dofs[3];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = coordinate_dofs[4];
      y[1] = coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  void evaluate_dofs(double * values,
                             const ufc::function& f,
                             const double * coordinate_dofs,
                             int cell_orientation,
                             const ufc::cell& c) const final override
  {
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[2];
    y[0] = coordinate_dofs[0];
    y[1] = coordinate_dofs[1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = coordinate_dofs[2];
    y[1] = coordinate_dofs[3];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = coordinate_dofs[4];
    y[1] = coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
  }

  void interpolate_vertex_values(double * vertex_values,
                                 const double * dof_values,
                                 const double * coordinate_dofs,
                                 int cell_orientation,
                                 const ufc::cell& c) const final override
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
  }

  void tabulate_dof_coordinates(double * dof_coordinates,
                                const double * coordinate_dofs) const final override
  {
    dof_coordinates[0] = coordinate_dofs[0];
    dof_coordinates[1] = coordinate_dofs[1];
    dof_coordinates[2] = coordinate_dofs[2];
    dof_coordinates[3] = coordinate_dofs[3];
    dof_coordinates[4] = coordinate_dofs[4];
    dof_coordinates[5] = coordinate_dofs[5];
  }

  std::size_t num_sub_elements() const final override
  {
    return 0;
  }

  ufc::finite_element * create_sub_element(std::size_t i) const final override
  {
    return 0;
  }

  ufc::finite_element * create() const final override
  {
    return new hyperelasticity_finite_element_0();
  }

};


class hyperelasticity_finite_element_1: public ufc::finite_element
{
public:

  hyperelasticity_finite_element_1() : ufc::finite_element()
  {
    // Do nothing
  }

  ~hyperelasticity_finite_element_1() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "VectorElement(FiniteElement('Lagrange', triangle, 1), dim=2)";
  }

  ufc::shape cell_shape() const final override
  {
    return ufc::shape::triangle;
  }

  std::size_t topological_dimension() const final override
  {
    return 2;
  }

  std::size_t geometric_dimension() const final override
  {
    return 2;
  }

  std::size_t space_dimension() const final override
  {
    return 6;
  }

  std::size_t value_rank() const final override
  {
    return 1;
  }

  std::size_t value_dimension(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return 2;
        break;
      }
    }
    
    return 0;
  }

  std::size_t value_size() const final override
  {
    return 2;
  }

  std::size_t reference_value_rank() const final override
  {
    return 1;
  }

  std::size_t reference_value_dimension(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return 2;
        break;
      }
    }
    
    return 0;
  }

  std::size_t reference_value_size() const final override
  {
    return 2;
  }

  std::size_t degree() const final override
  {
    return 1;
  }

  const char * family() const final override
  {
    return "Lagrange";
  }

  static void _evaluate_basis(std::size_t i,
                              double * values,
                              const double * x,
                              const double * coordinate_dofs,
                              int cell_orientation)
  {
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = coordinate_dofs[2] + coordinate_dofs[4];
    const double C1 = coordinate_dofs[3] + coordinate_dofs[5];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J[1]*(C1 - 2.0*x[1]) + J[3]*(2.0*x[0] - C0)) / detJ;
    double Y = (J[0]*(2.0*x[1] - C1) + J[2]*(C0 - 2.0*x[0])) / detJ;
    
    // Reset values
    values[0] = 0.0;
    values[1] = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, -0.288675134594813, -0.166666666666667};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 3; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.288675134594813, -0.166666666666667};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 3; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.0, 0.333333333333333};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 3; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, -0.288675134594813, -0.166666666666667};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 3; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.288675134594813, -0.166666666666667};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 3; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.0, 0.333333333333333};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 3; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    }
    
  }

  void evaluate_basis(std::size_t i,
                      double * values,
                      const double * x,
                      const double * coordinate_dofs,
                      int cell_orientation) const final override
  {
    _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_all(double * values,
                                  const double * x,
                                  const double * coordinate_dofs,
                                  int cell_orientation)
  {
    // Helper variable to hold values of a single dof.
    double dof_values[2] = {0.0, 0.0};
    
    // Loop dofs and call evaluate_basis
    for (unsigned int r = 0; r < 6; r++)
    {
      _evaluate_basis(r, dof_values, x, coordinate_dofs, cell_orientation);
      for (unsigned int s = 0; s < 2; s++)
      {
        values[r*2 + s] = dof_values[s];
      } // end loop over 's'
    } // end loop over 'r'
  }

  void evaluate_basis_all(double * values,
                          const double * x,
                          const double * coordinate_dofs,
                          int cell_orientation) const final override
  {
    _evaluate_basis_all(values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_derivatives(std::size_t i,
                                          std::size_t n,
                                          double * values,
                                          const double * x,
                                          const double * coordinate_dofs,
                                          int cell_orientation)
  {
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    } // end loop over 'r'
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < 2*num_derivatives; r++)
    {
      values[r] = 0.0;
    } // end loop over 'r'
    
    // Call evaluate_basis if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 1)
    {
    return ;
    }
    
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = coordinate_dofs[2] + coordinate_dofs[4];
    const double C1 = coordinate_dofs[3] + coordinate_dofs[5];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J[1]*(C1 - 2.0*x[1]) + J[3]*(2.0*x[0] - C0)) / detJ;
    double Y = (J[0]*(2.0*x[1] - C1) + J[2]*(C0 - 2.0*x[0])) / detJ;
    
    // Declare two dimensional array that holds combinations of derivatives and initialise
    unsigned int combinations[2][1];
    for (unsigned int row = 0; row < 2; row++)
    {
      for (unsigned int col = 0; col < 1; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K[0], K[1]}, {K[2], K[3]}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double transform[2][2];
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, -0.288675134594813, -0.166666666666667};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[2];
      for (unsigned int r = 0; r < 2; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.288675134594813, -0.166666666666667};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[2];
      for (unsigned int r = 0; r < 2; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.0, 0.333333333333333};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[2];
      for (unsigned int r = 0; r < 2; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, -0.288675134594813, -0.166666666666667};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[2];
      for (unsigned int r = 0; r < 2; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.288675134594813, -0.166666666666667};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[2];
      for (unsigned int r = 0; r < 2; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.0, 0.333333333333333};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[2];
      for (unsigned int r = 0; r < 2; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    }
    
  }

  void evaluate_basis_derivatives(std::size_t i,
                                  std::size_t n,
                                  double * values,
                                  const double * x,
                                  const double * coordinate_dofs,
                                  int cell_orientation) const final override
  {
    _evaluate_basis_derivatives(i, n, values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_derivatives_all(std::size_t n,
                                              double * values,
                                              const double * x,
                                              const double * coordinate_dofs,
                                              int cell_orientation)
  {
    // Call evaluate_basis_all if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis_all(values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    } // end loop over 'r'
    
    // Set values equal to zero.
    for (unsigned int r = 0; r < 6; r++)
    {
      for (unsigned int s = 0; s < 2*num_derivatives; s++)
      {
        values[r*2*num_derivatives + s] = 0.0;
      } // end loop over 's'
    } // end loop over 'r'
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 1)
    {
      return ;
    }
    
    // Helper variable to hold values of a single dof.
    double dof_values[4];
    for (unsigned int r = 0; r < 4; r++)
    {
      dof_values[r] = 0.0;
    } // end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 6; r++)
    {
      _evaluate_basis_derivatives(r, n, dof_values, x, coordinate_dofs, cell_orientation);
      for (unsigned int s = 0; s < 2*num_derivatives; s++)
      {
        values[r*2*num_derivatives + s] = dof_values[s];
      } // end loop over 's'
    } // end loop over 'r'
  }

  void evaluate_basis_derivatives_all(std::size_t n,
                                      double * values,
                                      const double * x,
                                      const double * coordinate_dofs,
                                      int cell_orientation) const final override
  {
    _evaluate_basis_derivatives_all(n, values, x, coordinate_dofs, cell_orientation);
  }

  double evaluate_dof(std::size_t i,
                      const ufc::function& f,
                      const double * coordinate_dofs,
                      int cell_orientation,
                      const ufc::cell& c) const final override
  {
    // Declare variables for result of evaluation
    double vals[2];
    
    // Declare variable for physical coordinates
    double y[2];
    switch (i)
    {
    case 0:
      {
        y[0] = coordinate_dofs[0];
      y[1] = coordinate_dofs[1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = coordinate_dofs[2];
      y[1] = coordinate_dofs[3];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = coordinate_dofs[4];
      y[1] = coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = coordinate_dofs[0];
      y[1] = coordinate_dofs[1];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 4:
      {
        y[0] = coordinate_dofs[2];
      y[1] = coordinate_dofs[3];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 5:
      {
        y[0] = coordinate_dofs[4];
      y[1] = coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    }
    
    return 0.0;
  }

  void evaluate_dofs(double * values,
                             const ufc::function& f,
                             const double * coordinate_dofs,
                             int cell_orientation,
                             const ufc::cell& c) const final override
  {
    // Declare variables for result of evaluation
    double vals[2];
    
    // Declare variable for physical coordinates
    double y[2];
    y[0] = coordinate_dofs[0];
    y[1] = coordinate_dofs[1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    values[3] = vals[1];
    y[0] = coordinate_dofs[2];
    y[1] = coordinate_dofs[3];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    values[4] = vals[1];
    y[0] = coordinate_dofs[4];
    y[1] = coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    values[5] = vals[1];
  }

  void interpolate_vertex_values(double * vertex_values,
                                 const double * dof_values,
                                 const double * coordinate_dofs,
                                 int cell_orientation,
                                 const ufc::cell& c) const final override
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[2] = dof_values[1];
    vertex_values[4] = dof_values[2];
    // Evaluate function and change variables
    vertex_values[1] = dof_values[3];
    vertex_values[3] = dof_values[4];
    vertex_values[5] = dof_values[5];
  }

  void tabulate_dof_coordinates(double * dof_coordinates,
                                const double * coordinate_dofs) const final override
  {
    dof_coordinates[0] = coordinate_dofs[0];
    dof_coordinates[1] = coordinate_dofs[1];
    dof_coordinates[2] = coordinate_dofs[2];
    dof_coordinates[3] = coordinate_dofs[3];
    dof_coordinates[4] = coordinate_dofs[4];
    dof_coordinates[5] = coordinate_dofs[5];
    dof_coordinates[6] = coordinate_dofs[0];
    dof_coordinates[7] = coordinate_dofs[1];
    dof_coordinates[8] = coordinate_dofs[2];
    dof_coordinates[9] = coordinate_dofs[3];
    dof_coordinates[10] = coordinate_dofs[4];
    dof_coordinates[11] = coordinate_dofs[5];
  }

  std::size_t num_sub_elements() const final override
  {
    return 2;
  }

  ufc::finite_element * create_sub_element(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return new hyperelasticity_finite_element_0();
        break;
      }
    case 1:
      {
        return new hyperelasticity_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  ufc::finite_element * create() const final override
  {
    return new hyperelasticity_finite_element_1();
  }

};


class hyperelasticity_finite_element_2: public ufc::finite_element
{
public:

  hyperelasticity_finite_element_2() : ufc::finite_element()
  {
    // Do nothing
  }

  ~hyperelasticity_finite_element_2() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "FiniteElement('Real', triangle, 0)";
  }

  ufc::shape cell_shape() const final override
  {
    return ufc::shape::triangle;
  }

  std::size_t topological_dimension() const final override
  {
    return 2;
  }

  std::size_t geometric_dimension() const final override
  {
    return 2;
  }

  std::size_t space_dimension() const final override
  {
    return 1;
  }

  std::size_t value_rank() const final override
  {
    return 0;
  }

  std::size_t value_dimension(std::size_t i) const final override
  {
    return 1;
  }

  std::size_t value_size() const final override
  {
    return 1;
  }

  std::size_t reference_value_rank() const final override
  {
    return 0;
  }

  std::size_t reference_value_dimension(std::size_t i) const final override
  {
    return 1;
  }

  std::size_t reference_value_size() const final override
  {
    return 1;
  }

  std::size_t degree() const final override
  {
    return 0;
  }

  const char * family() const final override
  {
    return "Real";
  }

  static void _evaluate_basis(std::size_t i,
                              double * values,
                              const double * x,
                              const double * coordinate_dofs,
                              int cell_orientation)
  {
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    
    // Compute constants
    
    // Get coordinates and map to the reference (FIAT) element
    
    // Reset values
    *values = 0.0;
    
    // Array of basisvalues
    double basisvalues[1] = {0.0};
    
    // Declare helper variables
    
    // Compute basisvalues
    basisvalues[0] = 1.0;
    
    // Table(s) of coefficients
    static const double coefficients0[1] = \
    {1.0};
    
    // Compute value(s)
    for (unsigned int r = 0; r < 1; r++)
    {
      *values += coefficients0[r]*basisvalues[r];
    } // end loop over 'r'
  }

  void evaluate_basis(std::size_t i,
                      double * values,
                      const double * x,
                      const double * coordinate_dofs,
                      int cell_orientation) const final override
  {
    _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_all(double * values,
                                  const double * x,
                                  const double * coordinate_dofs,
                                  int cell_orientation)
  {
    // Element is constant, calling evaluate_basis.
    _evaluate_basis(0, values, x, coordinate_dofs, cell_orientation);
  }

  void evaluate_basis_all(double * values,
                          const double * x,
                          const double * coordinate_dofs,
                          int cell_orientation) const final override
  {
    _evaluate_basis_all(values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_derivatives(std::size_t i,
                                          std::size_t n,
                                          double * values,
                                          const double * x,
                                          const double * coordinate_dofs,
                                          int cell_orientation)
  {
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    } // end loop over 'r'
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    } // end loop over 'r'
    
    // Call evaluate_basis if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 0)
    {
    return ;
    }
    
  }

  void evaluate_basis_derivatives(std::size_t i,
                                  std::size_t n,
                                  double * values,
                                  const double * x,
                                  const double * coordinate_dofs,
                                  int cell_orientation) const final override
  {
    _evaluate_basis_derivatives(i, n, values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_derivatives_all(std::size_t n,
                                              double * values,
                                              const double * x,
                                              const double * coordinate_dofs,
                                              int cell_orientation)
  {
    // Element is constant, calling evaluate_basis_derivatives.
    _evaluate_basis_derivatives(0, n, values, x, coordinate_dofs, cell_orientation);
  }

  void evaluate_basis_derivatives_all(std::size_t n,
                                      double * values,
                                      const double * x,
                                      const double * coordinate_dofs,
                                      int cell_orientation) const final override
  {
    _evaluate_basis_derivatives_all(n, values, x, coordinate_dofs, cell_orientation);
  }

  double evaluate_dof(std::size_t i,
                      const ufc::function& f,
                      const double * coordinate_dofs,
                      int cell_orientation,
                      const ufc::cell& c) const final override
  {
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[2];
    switch (i)
    {
    case 0:
      {
        y[0] = 0.333333333333333*coordinate_dofs[0] + 0.333333333333333*coordinate_dofs[2] + 0.333333333333333*coordinate_dofs[4];
      y[1] = 0.333333333333333*coordinate_dofs[1] + 0.333333333333333*coordinate_dofs[3] + 0.333333333333333*coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  void evaluate_dofs(double * values,
                             const ufc::function& f,
                             const double * coordinate_dofs,
                             int cell_orientation,
                             const ufc::cell& c) const final override
  {
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[2];
    y[0] = 0.333333333333333*coordinate_dofs[0] + 0.333333333333333*coordinate_dofs[2] + 0.333333333333333*coordinate_dofs[4];
    y[1] = 0.333333333333333*coordinate_dofs[1] + 0.333333333333333*coordinate_dofs[3] + 0.333333333333333*coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
  }

  void interpolate_vertex_values(double * vertex_values,
                                 const double * dof_values,
                                 const double * coordinate_dofs,
                                 int cell_orientation,
                                 const ufc::cell& c) const final override
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[0];
    vertex_values[2] = dof_values[0];
  }

  void tabulate_dof_coordinates(double * dof_coordinates,
                                const double * coordinate_dofs) const final override
  {
    dof_coordinates[0] = 0.333333333333333*coordinate_dofs[0] + 0.333333333333333*coordinate_dofs[2] + 0.333333333333333*coordinate_dofs[4];
    dof_coordinates[1] = 0.333333333333333*coordinate_dofs[1] + 0.333333333333333*coordinate_dofs[3] + 0.333333333333333*coordinate_dofs[5];
  }

  std::size_t num_sub_elements() const final override
  {
    return 0;
  }

  ufc::finite_element * create_sub_element(std::size_t i) const final override
  {
    return 0;
  }

  ufc::finite_element * create() const final override
  {
    return new hyperelasticity_finite_element_2();
  }

};


class hyperelasticity_dofmap_0: public ufc::dofmap
{
public:

  hyperelasticity_dofmap_0() : ufc::dofmap()
  {
    // Do nothing
  }

  ~hyperelasticity_dofmap_0() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "FFC dofmap for FiniteElement('Lagrange', triangle, 1)";
  }

  bool needs_mesh_entities(std::size_t d) const final override
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  std::size_t topological_dimension() const final override
  {
    return 2;
  }

  std::size_t global_dimension(const std::vector<std::size_t>&
                               num_global_entities) const final override
  {
    return num_global_entities[0];
  }

  std::size_t num_element_dofs() const final override
  {
    return 3;
  }

  std::size_t num_facet_dofs() const final override
  {
    return 2;
  }

  std::size_t num_entity_dofs(std::size_t d) const final override
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    }
    
    return 0;
  }

  std::size_t num_entity_closure_dofs(std::size_t d) const final override
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 2;
        break;
      }
    case 2:
      {
        return 3;
        break;
      }
    }
    
    return 0;
  }

  void tabulate_dofs(std::size_t * dofs,
                     const std::vector<std::size_t>& num_global_entities,
                     const std::vector<std::vector<std::size_t>>& entity_indices) const final override
  {
    dofs[0] = entity_indices[0][0];
    dofs[1] = entity_indices[0][1];
    dofs[2] = entity_indices[0][2];
  }

  void tabulate_facet_dofs(std::size_t * dofs,
                           std::size_t facet) const final override
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
        break;
      }
    }
    
  }

  void tabulate_entity_dofs(std::size_t * dofs,
                            std::size_t d, std::size_t i) const final override
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    }
    
  }

  void tabulate_entity_closure_dofs(std::size_t * dofs,
                                    std::size_t d, std::size_t i) const final override
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 1;
        dofs[1] = 2;
          break;
        }
      case 1:
        {
          dofs[0] = 0;
        dofs[1] = 2;
          break;
        }
      case 2:
        {
          dofs[0] = 0;
        dofs[1] = 1;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
        break;
      }
    }
    
  }


  std::size_t num_sub_dofmaps() const final override
  {
    return 0;
  }

  ufc::dofmap * create_sub_dofmap(std::size_t i) const final override
  {
    return 0;
  }

  ufc::dofmap * create() const final override
  {
    return new hyperelasticity_dofmap_0();
  }

};


class hyperelasticity_dofmap_1: public ufc::dofmap
{
public:

  hyperelasticity_dofmap_1() : ufc::dofmap()
  {
    // Do nothing
  }

  ~hyperelasticity_dofmap_1() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "FFC dofmap for VectorElement(FiniteElement('Lagrange', triangle, 1), dim=2)";
  }

  bool needs_mesh_entities(std::size_t d) const final override
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  std::size_t topological_dimension() const final override
  {
    return 2;
  }

  std::size_t global_dimension(const std::vector<std::size_t>&
                               num_global_entities) const final override
  {
    return 2*num_global_entities[0];
  }

  std::size_t num_element_dofs() const final override
  {
    return 6;
  }

  std::size_t num_facet_dofs() const final override
  {
    return 4;
  }

  std::size_t num_entity_dofs(std::size_t d) const final override
  {
    switch (d)
    {
    case 0:
      {
        return 2;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    }
    
    return 0;
  }

  std::size_t num_entity_closure_dofs(std::size_t d) const final override
  {
    switch (d)
    {
    case 0:
      {
        return 2;
        break;
      }
    case 1:
      {
        return 4;
        break;
      }
    case 2:
      {
        return 6;
        break;
      }
    }
    
    return 0;
  }

  void tabulate_dofs(std::size_t * dofs,
                     const std::vector<std::size_t>& num_global_entities,
                     const std::vector<std::vector<std::size_t>>& entity_indices) const final override
  {
    unsigned int offset = 0;
    dofs[0] = offset + entity_indices[0][0];
    dofs[1] = offset + entity_indices[0][1];
    dofs[2] = offset + entity_indices[0][2];
    offset += num_global_entities[0];
    dofs[3] = offset + entity_indices[0][0];
    dofs[4] = offset + entity_indices[0][1];
    dofs[5] = offset + entity_indices[0][2];
    offset += num_global_entities[0];
  }

  void tabulate_facet_dofs(std::size_t * dofs,
                           std::size_t facet) const final override
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 4;
      dofs[3] = 5;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 5;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 3;
      dofs[3] = 4;
        break;
      }
    }
    
  }

  void tabulate_entity_dofs(std::size_t * dofs,
                            std::size_t d, std::size_t i) const final override
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
        dofs[1] = 3;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
        dofs[1] = 4;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
        dofs[1] = 5;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    }
    
  }

  void tabulate_entity_closure_dofs(std::size_t * dofs,
                                    std::size_t d, std::size_t i) const final override
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
        dofs[1] = 3;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
        dofs[1] = 4;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
        dofs[1] = 5;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 1;
        dofs[1] = 2;
        dofs[2] = 4;
        dofs[3] = 5;
          break;
        }
      case 1:
        {
          dofs[0] = 0;
        dofs[1] = 2;
        dofs[2] = 3;
        dofs[3] = 5;
          break;
        }
      case 2:
        {
          dofs[0] = 0;
        dofs[1] = 1;
        dofs[2] = 3;
        dofs[3] = 4;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
      dofs[3] = 3;
      dofs[4] = 4;
      dofs[5] = 5;
        break;
      }
    }
    
  }


  std::size_t num_sub_dofmaps() const final override
  {
    return 2;
  }

  ufc::dofmap * create_sub_dofmap(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return new hyperelasticity_dofmap_0();
        break;
      }
    case 1:
      {
        return new hyperelasticity_dofmap_0();
        break;
      }
    }
    
    return 0;
  }

  ufc::dofmap * create() const final override
  {
    return new hyperelasticity_dofmap_1();
  }

};


class hyperelasticity_dofmap_2: public ufc::dofmap
{
public:

  hyperelasticity_dofmap_2() : ufc::dofmap()
  {
    // Do nothing
  }

  ~hyperelasticity_dofmap_2() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "FFC dofmap for FiniteElement('Real', triangle, 0)";
  }

  bool needs_mesh_entities(std::size_t d) const final override
  {
    switch (d)
    {
    case 0:
      {
        return false;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  std::size_t topological_dimension() const final override
  {
    return 2;
  }

  std::size_t global_dimension(const std::vector<std::size_t>&
                               num_global_entities) const final override
  {
    return 1;
  }

  std::size_t num_element_dofs() const final override
  {
    return 1;
  }

  std::size_t num_facet_dofs() const final override
  {
    return 0;
  }

  std::size_t num_entity_dofs(std::size_t d) const final override
  {
    switch (d)
    {
    case 0:
      {
        return 0;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 1;
        break;
      }
    }
    
    return 0;
  }

  std::size_t num_entity_closure_dofs(std::size_t d) const final override
  {
    switch (d)
    {
    case 0:
      {
        return 0;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 1;
        break;
      }
    }
    
    return 0;
  }

  void tabulate_dofs(std::size_t * dofs,
                     const std::vector<std::size_t>& num_global_entities,
                     const std::vector<std::vector<std::size_t>>& entity_indices) const final override
  {
    dofs[0] = 0;
  }

  void tabulate_facet_dofs(std::size_t * dofs,
                           std::size_t facet) const final override
  {
    switch (facet)
    {
    case 0:
      {
        
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    }
    
  }

  void tabulate_entity_dofs(std::size_t * dofs,
                            std::size_t d, std::size_t i) const final override
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 0;
        break;
      }
    }
    
  }

  void tabulate_entity_closure_dofs(std::size_t * dofs,
                                    std::size_t d, std::size_t i) const final override
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          
          break;
        }
      case 1:
        {
          
          break;
        }
      case 2:
        {
          
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          
          break;
        }
      case 1:
        {
          
          break;
        }
      case 2:
        {
          
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 0;
        break;
      }
    }
    
  }


  std::size_t num_sub_dofmaps() const final override
  {
    return 0;
  }

  ufc::dofmap * create_sub_dofmap(std::size_t i) const final override
  {
    return 0;
  }

  ufc::dofmap * create() const final override
  {
    return new hyperelasticity_dofmap_2();
  }

};


class hyperelasticity_cell_integral_0_otherwise: public ufc::cell_integral
{
public:

  hyperelasticity_cell_integral_0_otherwise() : ufc::cell_integral()
  {

  }

  ~hyperelasticity_cell_integral_0_otherwise() override
  {

  }

  const std::vector<bool> & enabled_coefficients() const final override
  {
static const std::vector<bool> enabled({true, true, true, true});
return enabled;
  }

  void tabulate_tensor(double * A,
                       const double * const * w,
                       const double * coordinate_dofs,
                       int cell_orientation) const final override
  {
    // This function was generated using 'uflacs' representation
    // with the following integrals metadata:
    // 
    //   num_cells:         None
    //   quadrature_degree: 2
    //   quadrature_rule:   'default'
    //   representation:    'uflacs'
    // 
    // and the following integral 0 metadata:
    // 
    //   estimated_polynomial_degree: 2
    //   quadrature_degree:           2
    //   quadrature_rule:             'default'
    //   representation:              'uflacs'
    
    // Section for quadrature weights and points
    alignas(32) static const double weights3[3] = { 0.166666666666667, 0.166666666666667, 0.166666666666667 };
    // Section for precomputed element basis function values
    // Table dimensions: num_entities, num_points, num_dofs
    // Definitions of 3 tables for 3 quadrature points
    alignas(32) static const double FE16_C0_D01_Q3[1][1][3] = { { { -1.0, 0.0, 1.0 } } };
    alignas(32) static const double FE16_C0_D10_Q3[1][1][2] = { { { -1.0, 1.0 } } };
    alignas(32) static const double FE16_C0_Q3[1][3][3] =
        { { { 0.666666666666667, 0.166666666666667, 0.166666666666667 },
            { 0.166666666666667, 0.166666666666667, 0.666666666666667 },
            { 0.166666666666667, 0.666666666666667, 0.166666666666667 } } };
    // Reset element tensor
    memset(A, 0, 6 * sizeof(*A));
    // Unstructured piecewise computations
    double w0_d0_c0 = 0.0;
    for (int ic = 0; ic < 2; ++ic)
    {
        w0_d0_c0 += w[0][ic] * FE16_C0_D10_Q3[0][0][ic - 0];
    }
    const double J_c3 = coordinate_dofs[1] * FE16_C0_D01_Q3[0][0][0] + coordinate_dofs[3] * FE16_C0_D01_Q3[0][0][1] + coordinate_dofs[5] * FE16_C0_D01_Q3[0][0][2];
    const double J_c0 = coordinate_dofs[0] * FE16_C0_D10_Q3[0][0][0] + coordinate_dofs[2] * FE16_C0_D10_Q3[0][0][1];
    const double J_c1 = coordinate_dofs[0] * FE16_C0_D01_Q3[0][0][0] + coordinate_dofs[2] * FE16_C0_D01_Q3[0][0][1] + coordinate_dofs[4] * FE16_C0_D01_Q3[0][0][2];
    const double J_c2 = coordinate_dofs[1] * FE16_C0_D10_Q3[0][0][0] + coordinate_dofs[3] * FE16_C0_D10_Q3[0][0][1];
    double w0_d1_c0 = 0.0;
    for (int ic = 0; ic < 3; ++ic)
    {
        w0_d1_c0 += w[0][ic] * FE16_C0_D01_Q3[0][0][ic - 0];
    }
    double w0_d1_c1 = 0.0;
    for (int ic = 3; ic < 6; ++ic)
    {
        w0_d1_c1 += w[0][ic] * FE16_C0_D01_Q3[0][0][ic - 3];
    }
    double w0_d0_c1 = 0.0;
    for (int ic = 3; ic < 5; ++ic)
    {
        w0_d0_c1 += w[0][ic] * FE16_C0_D10_Q3[0][0][ic - 3];
    }
    alignas(32) double sp3[104];
    sp3[0] = J_c0 * J_c3;
    sp3[1] = J_c1 * J_c2;
    sp3[2] = -1 * sp3[1];
    sp3[3] = sp3[0] + sp3[2];
    sp3[4] = J_c3 / sp3[3];
    sp3[5] = w0_d0_c0 * sp3[4];
    sp3[6] = -1 * J_c2;
    sp3[7] = sp3[6] / sp3[3];
    sp3[8] = w0_d1_c0 * sp3[7];
    sp3[9] = sp3[5] + sp3[8];
    sp3[10] = 1 + sp3[9];
    sp3[11] = J_c0 / sp3[3];
    sp3[12] = -1 * J_c1;
    sp3[13] = sp3[12] / sp3[3];
    sp3[14] = sp3[10] * sp3[11];
    sp3[15] = sp3[10] * sp3[13];
    sp3[16] = w0_d1_c1 * sp3[11];
    sp3[17] = w0_d0_c1 * sp3[13];
    sp3[18] = sp3[16] + sp3[17];
    sp3[19] = 1 + sp3[18];
    sp3[20] = sp3[19] * sp3[4];
    sp3[21] = sp3[19] * sp3[7];
    sp3[22] = w0_d1_c0 * sp3[11];
    sp3[23] = w0_d0_c0 * sp3[13];
    sp3[24] = sp3[22] + sp3[23];
    sp3[25] = sp3[24] * sp3[7];
    sp3[26] = sp3[24] * sp3[4];
    sp3[27] = w0_d0_c1 * sp3[4];
    sp3[28] = w0_d1_c1 * sp3[7];
    sp3[29] = sp3[27] + sp3[28];
    sp3[30] = sp3[29] * sp3[13];
    sp3[31] = sp3[29] * sp3[11];
    sp3[32] = -1 * sp3[25];
    sp3[33] = -1 * sp3[26];
    sp3[34] = -1 * sp3[30];
    sp3[35] = -1 * sp3[31];
    sp3[36] = sp3[32] + sp3[14];
    sp3[37] = sp3[33] + sp3[15];
    sp3[38] = sp3[34] + sp3[20];
    sp3[39] = sp3[35] + sp3[21];
    sp3[40] = sp3[19] * sp3[10];
    sp3[41] = sp3[24] * sp3[29];
    sp3[42] = -1 * sp3[41];
    sp3[43] = sp3[40] + sp3[42];
    sp3[44] = sp3[36] / sp3[43];
    sp3[45] = sp3[37] / sp3[43];
    sp3[46] = sp3[38] / sp3[43];
    sp3[47] = sp3[39] / sp3[43];
    sp3[48] = sp3[44] * w[2][0];
    sp3[49] = sp3[45] * w[2][0];
    sp3[50] = sp3[46] * w[2][0];
    sp3[51] = sp3[47] * w[2][0];
    sp3[52] = -1 * sp3[48];
    sp3[53] = -1 * sp3[49];
    sp3[54] = -1 * sp3[50];
    sp3[55] = -1 * sp3[51];
    sp3[56] = sp3[24] * sp3[13];
    sp3[57] = sp3[24] * sp3[11];
    sp3[58] = sp3[56] + sp3[56];
    sp3[59] = sp3[57] + sp3[57];
    sp3[60] = sp3[19] * sp3[11];
    sp3[61] = sp3[19] * sp3[13];
    sp3[62] = sp3[60] + sp3[60];
    sp3[63] = sp3[61] + sp3[61];
    sp3[64] = sp3[10] * sp3[4];
    sp3[65] = sp3[10] * sp3[7];
    sp3[66] = sp3[64] + sp3[64];
    sp3[67] = sp3[65] + sp3[65];
    sp3[68] = sp3[29] * sp3[7];
    sp3[69] = sp3[29] * sp3[4];
    sp3[70] = sp3[68] + sp3[68];
    sp3[71] = sp3[69] + sp3[69];
    sp3[72] = sp3[62] + sp3[70];
    sp3[73] = sp3[71] + sp3[63];
    sp3[74] = sp3[66] + sp3[58];
    sp3[75] = sp3[59] + sp3[67];
    sp3[76] = w[2][0] / 2;
    sp3[77] = sp3[72] * sp3[76];
    sp3[78] = sp3[73] * sp3[76];
    sp3[79] = sp3[74] * sp3[76];
    sp3[80] = sp3[75] * sp3[76];
    sp3[81] = sp3[52] + sp3[77];
    sp3[82] = sp3[53] + sp3[78];
    sp3[83] = sp3[54] + sp3[79];
    sp3[84] = sp3[55] + sp3[80];
    sp3[85] = 2 * sp3[44];
    sp3[86] = 2 * sp3[45];
    sp3[87] = 2 * sp3[46];
    sp3[88] = 2 * sp3[47];
    sp3[89] = std::log(sp3[43]);
    sp3[90] = sp3[85] * sp3[89];
    sp3[91] = sp3[86] * sp3[89];
    sp3[92] = sp3[87] * sp3[89];
    sp3[93] = sp3[88] * sp3[89];
    sp3[94] = w[3][0] / 2;
    sp3[95] = sp3[90] * sp3[94];
    sp3[96] = sp3[91] * sp3[94];
    sp3[97] = sp3[92] * sp3[94];
    sp3[98] = sp3[93] * sp3[94];
    sp3[99] = sp3[81] + sp3[95];
    sp3[100] = sp3[82] + sp3[96];
    sp3[101] = sp3[83] + sp3[97];
    sp3[102] = sp3[84] + sp3[98];
    sp3[103] = std::abs(sp3[3]);
    for (int iq3 = 0; iq3 < 3; ++iq3)
    {
        // Quadrature loop body setup (num_points=3)
        // Unstructured varying computations
        double w1_c0 = 0.0;
        for (int ic = 0; ic < 3; ++ic)
        {
            w1_c0 += w[1][ic] * FE16_C0_Q3[0][iq3][ic - 0];
        }
        double w1_c1 = 0.0;
        for (int ic = 3; ic < 6; ++ic)
        {
            w1_c1 += w[1][ic] * FE16_C0_Q3[0][iq3][ic - 3];
        }
        alignas(32) double sv3[9];
        sv3[0] = -1 * w1_c0;
        sv3[1] = -1 * w1_c1;
        sv3[2] = weights3[iq3] * sp3[103];
        sv3[3] = sp3[99] * sv3[2];
        sv3[4] = sp3[100] * sv3[2];
        sv3[5] = sp3[101] * sv3[2];
        sv3[6] = sp3[102] * sv3[2];
        sv3[7] = sv3[0] * sv3[2];
        sv3[8] = sv3[1] * sv3[2];
        for (int ia0 = 0; ia0 < 2; ++ia0)
        {
            A[ia0] += sv3[5] * FE16_C0_D10_Q3[0][0][ia0 - 0];
        }
        for (int ia0 = 0; ia0 < 3; ++ia0)
        {
            A[ia0] += sv3[7] * FE16_C0_Q3[0][iq3][ia0 - 0];
        }
        for (int ia0 = 0; ia0 < 3; ++ia0)
        {
            A[ia0] += sv3[6] * FE16_C0_D01_Q3[0][0][ia0 - 0];
        }
        for (int ia0 = 3; ia0 < 5; ++ia0)
        {
            A[ia0] += sv3[4] * FE16_C0_D10_Q3[0][0][ia0 - 3];
        }
        for (int ia0 = 3; ia0 < 6; ++ia0)
        {
            A[ia0] += sv3[8] * FE16_C0_Q3[0][iq3][ia0 - 3];
        }
        for (int ia0 = 3; ia0 < 6; ++ia0)
        {
            A[ia0] += sv3[3] * FE16_C0_D01_Q3[0][0][ia0 - 3];
        }
    }
  }

};


class hyperelasticity_cell_integral_1_otherwise: public ufc::cell_integral
{
public:

  hyperelasticity_cell_integral_1_otherwise() : ufc::cell_integral()
  {

  }

  ~hyperelasticity_cell_integral_1_otherwise() override
  {

  }

  const std::vector<bool> & enabled_coefficients() const final override
  {
static const std::vector<bool> enabled({true, true, true});
return enabled;
  }

  void tabulate_tensor(double * A,
                       const double * const * w,
                       const double * coordinate_dofs,
                       int cell_orientation) const final override
  {
    // This function was generated using 'uflacs' representation
    // with the following integrals metadata:
    // 
    //   num_cells:         None
    //   quadrature_degree: 0
    //   quadrature_rule:   'default'
    //   representation:    'uflacs'
    // 
    // and the following integral 0 metadata:
    // 
    //   estimated_polynomial_degree: 0
    //   quadrature_degree:           0
    //   quadrature_rule:             'default'
    //   representation:              'uflacs'
    
    // Section for quadrature weights and points
    alignas(32) static const double weights1[1] = { 0.5 };
    // Section for precomputed element basis function values
    // Table dimensions: num_entities, num_points, num_dofs
    // Definitions of 2 tables for 1 quadrature points
    alignas(32) static const double FE16_C0_D01_Q1[1][1][3] = { { { -1.0, 0.0, 1.0 } } };
    alignas(32) static const double FE16_C0_D10_Q1[1][1][2] = { { { -1.0, 1.0 } } };
    // Reset element tensor
    memset(A, 0, 36 * sizeof(*A));
    // Unstructured piecewise computations
    const double J_c0 = coordinate_dofs[0] * FE16_C0_D10_Q1[0][0][0] + coordinate_dofs[2] * FE16_C0_D10_Q1[0][0][1];
    const double J_c3 = coordinate_dofs[1] * FE16_C0_D01_Q1[0][0][0] + coordinate_dofs[3] * FE16_C0_D01_Q1[0][0][1] + coordinate_dofs[5] * FE16_C0_D01_Q1[0][0][2];
    const double J_c1 = coordinate_dofs[0] * FE16_C0_D01_Q1[0][0][0] + coordinate_dofs[2] * FE16_C0_D01_Q1[0][0][1] + coordinate_dofs[4] * FE16_C0_D01_Q1[0][0][2];
    const double J_c2 = coordinate_dofs[1] * FE16_C0_D10_Q1[0][0][0] + coordinate_dofs[3] * FE16_C0_D10_Q1[0][0][1];
    double w0_d0_c0 = 0.0;
    for (int ic = 0; ic < 2; ++ic)
    {
        w0_d0_c0 += w[0][ic] * FE16_C0_D10_Q1[0][0][ic - 0];
    }
    double w0_d1_c0 = 0.0;
    for (int ic = 0; ic < 3; ++ic)
    {
        w0_d1_c0 += w[0][ic] * FE16_C0_D01_Q1[0][0][ic - 0];
    }
    double w0_d1_c1 = 0.0;
    for (int ic = 3; ic < 6; ++ic)
    {
        w0_d1_c1 += w[0][ic] * FE16_C0_D01_Q1[0][0][ic - 3];
    }
    double w0_d0_c1 = 0.0;
    for (int ic = 3; ic < 5; ++ic)
    {
        w0_d0_c1 += w[0][ic] * FE16_C0_D10_Q1[0][0][ic - 3];
    }
    alignas(32) double sp1[278];
    sp1[0] = J_c0 * J_c3;
    sp1[1] = J_c1 * J_c2;
    sp1[2] = -1 * sp1[1];
    sp1[3] = sp1[0] + sp1[2];
    sp1[4] = J_c0 / sp1[3];
    sp1[5] = -1 * J_c1;
    sp1[6] = sp1[5] / sp1[3];
    sp1[7] = J_c3 / sp1[3];
    sp1[8] = -1 * J_c2;
    sp1[9] = sp1[8] / sp1[3];
    sp1[10] = sp1[4] * sp1[7];
    sp1[11] = sp1[4] * sp1[9];
    sp1[12] = sp1[7] * sp1[6];
    sp1[13] = sp1[6] * sp1[9];
    sp1[14] = -1 * sp1[13];
    sp1[15] = -1 * sp1[11];
    sp1[16] = -1 * sp1[12];
    sp1[17] = -1 * sp1[10];
    sp1[18] = sp1[14] + sp1[10];
    sp1[19] = sp1[15] + sp1[11];
    sp1[20] = sp1[16] + sp1[12];
    sp1[21] = sp1[17] + sp1[13];
    sp1[22] = w0_d0_c0 * sp1[7];
    sp1[23] = w0_d1_c0 * sp1[9];
    sp1[24] = sp1[22] + sp1[23];
    sp1[25] = 1 + sp1[24];
    sp1[26] = sp1[25] * sp1[4];
    sp1[27] = sp1[25] * sp1[6];
    sp1[28] = w0_d1_c1 * sp1[4];
    sp1[29] = w0_d0_c1 * sp1[6];
    sp1[30] = sp1[28] + sp1[29];
    sp1[31] = 1 + sp1[30];
    sp1[32] = sp1[31] * sp1[7];
    sp1[33] = sp1[31] * sp1[9];
    sp1[34] = w0_d1_c0 * sp1[4];
    sp1[35] = w0_d0_c0 * sp1[6];
    sp1[36] = sp1[34] + sp1[35];
    sp1[37] = sp1[36] * sp1[9];
    sp1[38] = sp1[36] * sp1[7];
    sp1[39] = w0_d0_c1 * sp1[7];
    sp1[40] = w0_d1_c1 * sp1[9];
    sp1[41] = sp1[39] + sp1[40];
    sp1[42] = sp1[41] * sp1[6];
    sp1[43] = sp1[41] * sp1[4];
    sp1[44] = -1 * sp1[37];
    sp1[45] = -1 * sp1[38];
    sp1[46] = -1 * sp1[42];
    sp1[47] = -1 * sp1[43];
    sp1[48] = sp1[44] + sp1[26];
    sp1[49] = sp1[45] + sp1[27];
    sp1[50] = sp1[46] + sp1[32];
    sp1[51] = sp1[47] + sp1[33];
    sp1[52] = sp1[31] * sp1[25];
    sp1[53] = sp1[36] * sp1[41];
    sp1[54] = -1 * sp1[53];
    sp1[55] = sp1[52] + sp1[54];
    sp1[56] = sp1[50] / sp1[55];
    sp1[57] = sp1[51] / sp1[55];
    sp1[58] = sp1[48] / sp1[55];
    sp1[59] = sp1[49] / sp1[55];
    sp1[60] = sp1[48] * sp1[56];
    sp1[61] = sp1[48] * sp1[57];
    sp1[62] = sp1[48] * sp1[58];
    sp1[63] = sp1[48] * sp1[59];
    sp1[64] = sp1[49] * sp1[56];
    sp1[65] = sp1[49] * sp1[57];
    sp1[66] = sp1[49] * sp1[58];
    sp1[67] = sp1[49] * sp1[59];
    sp1[68] = sp1[50] * sp1[56];
    sp1[69] = sp1[50] * sp1[57];
    sp1[70] = sp1[50] * sp1[58];
    sp1[71] = sp1[50] * sp1[59];
    sp1[72] = sp1[51] * sp1[56];
    sp1[73] = sp1[51] * sp1[57];
    sp1[74] = sp1[51] * sp1[58];
    sp1[75] = sp1[51] * sp1[59];
    sp1[76] = -1 * sp1[60];
    sp1[77] = -1 * sp1[61];
    sp1[78] = -1 * sp1[62];
    sp1[79] = -1 * sp1[63];
    sp1[80] = -1 * sp1[64];
    sp1[81] = -1 * sp1[65];
    sp1[82] = -1 * sp1[66];
    sp1[83] = -1 * sp1[67];
    sp1[84] = -1 * sp1[68];
    sp1[85] = -1 * sp1[72];
    sp1[86] = -1 * sp1[69];
    sp1[87] = -1 * sp1[73];
    sp1[88] = -1 * sp1[70];
    sp1[89] = -1 * sp1[74];
    sp1[90] = -1 * sp1[71];
    sp1[91] = -1 * sp1[75];
    sp1[92] = sp1[18] + sp1[76];
    sp1[93] = sp1[19] + sp1[77];
    sp1[94] = sp1[20] + sp1[80];
    sp1[95] = sp1[21] + sp1[81];
    sp1[96] = sp1[18] + sp1[88];
    sp1[97] = sp1[19] + sp1[89];
    sp1[98] = sp1[20] + sp1[90];
    sp1[99] = sp1[21] + sp1[91];
    sp1[100] = sp1[92] / sp1[55];
    sp1[101] = sp1[93] / sp1[55];
    sp1[102] = sp1[78] / sp1[55];
    sp1[103] = sp1[79] / sp1[55];
    sp1[104] = sp1[94] / sp1[55];
    sp1[105] = sp1[95] / sp1[55];
    sp1[106] = sp1[82] / sp1[55];
    sp1[107] = sp1[83] / sp1[55];
    sp1[108] = sp1[84] / sp1[55];
    sp1[109] = sp1[85] / sp1[55];
    sp1[110] = sp1[86] / sp1[55];
    sp1[111] = sp1[87] / sp1[55];
    sp1[112] = sp1[96] / sp1[55];
    sp1[113] = sp1[97] / sp1[55];
    sp1[114] = sp1[98] / sp1[55];
    sp1[115] = sp1[99] / sp1[55];
    sp1[116] = sp1[100] * w[1][0];
    sp1[117] = sp1[101] * w[1][0];
    sp1[118] = sp1[102] * w[1][0];
    sp1[119] = sp1[103] * w[1][0];
    sp1[120] = sp1[104] * w[1][0];
    sp1[121] = sp1[105] * w[1][0];
    sp1[122] = sp1[106] * w[1][0];
    sp1[123] = sp1[107] * w[1][0];
    sp1[124] = sp1[108] * w[1][0];
    sp1[125] = sp1[109] * w[1][0];
    sp1[126] = sp1[110] * w[1][0];
    sp1[127] = sp1[111] * w[1][0];
    sp1[128] = sp1[112] * w[1][0];
    sp1[129] = sp1[113] * w[1][0];
    sp1[130] = sp1[114] * w[1][0];
    sp1[131] = sp1[115] * w[1][0];
    sp1[132] = -1 * sp1[116];
    sp1[133] = -1 * sp1[117];
    sp1[134] = -1 * sp1[118];
    sp1[135] = -1 * sp1[119];
    sp1[136] = -1 * sp1[120];
    sp1[137] = -1 * sp1[121];
    sp1[138] = -1 * sp1[122];
    sp1[139] = -1 * sp1[123];
    sp1[140] = -1 * sp1[124];
    sp1[141] = -1 * sp1[125];
    sp1[142] = -1 * sp1[126];
    sp1[143] = -1 * sp1[127];
    sp1[144] = -1 * sp1[128];
    sp1[145] = -1 * sp1[129];
    sp1[146] = -1 * sp1[130];
    sp1[147] = -1 * sp1[131];
    sp1[148] = sp1[6] * sp1[6];
    sp1[149] = sp1[4] * sp1[6];
    sp1[150] = sp1[4] * sp1[4];
    sp1[151] = sp1[148] + sp1[148];
    sp1[152] = sp1[149] + sp1[149];
    sp1[153] = sp1[150] + sp1[150];
    sp1[154] = sp1[7] * sp1[7];
    sp1[155] = sp1[7] * sp1[9];
    sp1[156] = sp1[9] * sp1[9];
    sp1[157] = sp1[154] + sp1[154];
    sp1[158] = sp1[155] + sp1[155];
    sp1[159] = sp1[156] + sp1[156];
    sp1[160] = sp1[153] + sp1[159];
    sp1[161] = sp1[152] + sp1[158];
    sp1[162] = sp1[157] + sp1[151];
    sp1[163] = w[1][0] / 2;
    sp1[164] = sp1[160] * sp1[163];
    sp1[165] = sp1[161] * sp1[163];
    sp1[166] = sp1[162] * sp1[163];
    sp1[167] = sp1[134] + sp1[164];
    sp1[168] = sp1[135] + sp1[165];
    sp1[169] = sp1[138] + sp1[165];
    sp1[170] = sp1[139] + sp1[166];
    sp1[171] = sp1[140] + sp1[166];
    sp1[172] = sp1[141] + sp1[165];
    sp1[173] = sp1[142] + sp1[165];
    sp1[174] = sp1[143] + sp1[164];
    sp1[175] = 2 * sp1[56];
    sp1[176] = 2 * sp1[57];
    sp1[177] = 2 * sp1[58];
    sp1[178] = 2 * sp1[59];
    sp1[179] = sp1[175] * sp1[58];
    sp1[180] = sp1[175] * sp1[59];
    sp1[181] = sp1[175] * sp1[56];
    sp1[182] = sp1[175] * sp1[57];
    sp1[183] = sp1[176] * sp1[58];
    sp1[184] = sp1[176] * sp1[59];
    sp1[185] = sp1[176] * sp1[56];
    sp1[186] = sp1[176] * sp1[57];
    sp1[187] = sp1[177] * sp1[58];
    sp1[188] = sp1[177] * sp1[59];
    sp1[189] = sp1[177] * sp1[56];
    sp1[190] = sp1[177] * sp1[57];
    sp1[191] = sp1[178] * sp1[58];
    sp1[192] = sp1[178] * sp1[59];
    sp1[193] = sp1[178] * sp1[56];
    sp1[194] = sp1[178] * sp1[57];
    sp1[195] = 2 * sp1[100];
    sp1[196] = 2 * sp1[101];
    sp1[197] = 2 * sp1[102];
    sp1[198] = 2 * sp1[103];
    sp1[199] = 2 * sp1[104];
    sp1[200] = 2 * sp1[105];
    sp1[201] = 2 * sp1[106];
    sp1[202] = 2 * sp1[107];
    sp1[203] = 2 * sp1[108];
    sp1[204] = 2 * sp1[109];
    sp1[205] = 2 * sp1[110];
    sp1[206] = 2 * sp1[111];
    sp1[207] = 2 * sp1[112];
    sp1[208] = 2 * sp1[113];
    sp1[209] = 2 * sp1[114];
    sp1[210] = 2 * sp1[115];
    sp1[211] = std::log(sp1[55]);
    sp1[212] = sp1[195] * sp1[211];
    sp1[213] = sp1[196] * sp1[211];
    sp1[214] = sp1[197] * sp1[211];
    sp1[215] = sp1[198] * sp1[211];
    sp1[216] = sp1[199] * sp1[211];
    sp1[217] = sp1[200] * sp1[211];
    sp1[218] = sp1[201] * sp1[211];
    sp1[219] = sp1[202] * sp1[211];
    sp1[220] = sp1[203] * sp1[211];
    sp1[221] = sp1[204] * sp1[211];
    sp1[222] = sp1[205] * sp1[211];
    sp1[223] = sp1[206] * sp1[211];
    sp1[224] = sp1[207] * sp1[211];
    sp1[225] = sp1[208] * sp1[211];
    sp1[226] = sp1[209] * sp1[211];
    sp1[227] = sp1[210] * sp1[211];
    sp1[228] = sp1[179] + sp1[212];
    sp1[229] = sp1[183] + sp1[213];
    sp1[230] = sp1[187] + sp1[214];
    sp1[231] = sp1[191] + sp1[215];
    sp1[232] = sp1[180] + sp1[216];
    sp1[233] = sp1[184] + sp1[217];
    sp1[234] = sp1[188] + sp1[218];
    sp1[235] = sp1[192] + sp1[219];
    sp1[236] = sp1[181] + sp1[220];
    sp1[237] = sp1[182] + sp1[221];
    sp1[238] = sp1[185] + sp1[222];
    sp1[239] = sp1[186] + sp1[223];
    sp1[240] = sp1[189] + sp1[224];
    sp1[241] = sp1[190] + sp1[225];
    sp1[242] = sp1[193] + sp1[226];
    sp1[243] = sp1[194] + sp1[227];
    sp1[244] = w[2][0] / 2;
    sp1[245] = sp1[228] * sp1[244];
    sp1[246] = sp1[229] * sp1[244];
    sp1[247] = sp1[230] * sp1[244];
    sp1[248] = sp1[231] * sp1[244];
    sp1[249] = sp1[232] * sp1[244];
    sp1[250] = sp1[233] * sp1[244];
    sp1[251] = sp1[234] * sp1[244];
    sp1[252] = sp1[235] * sp1[244];
    sp1[253] = sp1[236] * sp1[244];
    sp1[254] = sp1[237] * sp1[244];
    sp1[255] = sp1[238] * sp1[244];
    sp1[256] = sp1[239] * sp1[244];
    sp1[257] = sp1[240] * sp1[244];
    sp1[258] = sp1[241] * sp1[244];
    sp1[259] = sp1[242] * sp1[244];
    sp1[260] = sp1[243] * sp1[244];
    sp1[261] = sp1[132] + sp1[245];
    sp1[262] = sp1[133] + sp1[246];
    sp1[263] = sp1[167] + sp1[247];
    sp1[264] = sp1[168] + sp1[248];
    sp1[265] = sp1[136] + sp1[249];
    sp1[266] = sp1[137] + sp1[250];
    sp1[267] = sp1[169] + sp1[251];
    sp1[268] = sp1[170] + sp1[252];
    sp1[269] = sp1[171] + sp1[253];
    sp1[270] = sp1[172] + sp1[254];
    sp1[271] = sp1[173] + sp1[255];
    sp1[272] = sp1[174] + sp1[256];
    sp1[273] = sp1[144] + sp1[257];
    sp1[274] = sp1[145] + sp1[258];
    sp1[275] = sp1[146] + sp1[259];
    sp1[276] = sp1[147] + sp1[260];
    sp1[277] = std::abs(sp1[3]);
    // Only 1 quadrature point, no loop
    {
        // Quadrature loop body setup (num_points=1)
        // Unstructured varying computations
        alignas(32) double sv1[17];
        sv1[0] = weights1[0] * sp1[277];
        sv1[1] = sp1[261] * sv1[0];
        sv1[2] = sp1[262] * sv1[0];
        sv1[3] = sp1[263] * sv1[0];
        sv1[4] = sp1[264] * sv1[0];
        sv1[5] = sp1[265] * sv1[0];
        sv1[6] = sp1[266] * sv1[0];
        sv1[7] = sp1[267] * sv1[0];
        sv1[8] = sp1[268] * sv1[0];
        sv1[9] = sp1[269] * sv1[0];
        sv1[10] = sp1[270] * sv1[0];
        sv1[11] = sp1[271] * sv1[0];
        sv1[12] = sp1[272] * sv1[0];
        sv1[13] = sp1[273] * sv1[0];
        sv1[14] = sp1[274] * sv1[0];
        sv1[15] = sp1[275] * sv1[0];
        sv1[16] = sp1[276] * sv1[0];
        for (int ia0 = 0; ia0 < 2; ++ia0)
        {
            for (int ia1 = 0; ia1 < 2; ++ia1)
            {
                A[6 * ia0 + ia1] += sv1[9] * FE16_C0_D10_Q1[0][0][ia0 - 0] * FE16_C0_D10_Q1[0][0][ia1 - 0];
            }
        }
        for (int ia0 = 0; ia0 < 2; ++ia0)
        {
            for (int ia1 = 0; ia1 < 3; ++ia1)
            {
                A[6 * ia0 + ia1] += sv1[10] * FE16_C0_D10_Q1[0][0][ia0 - 0] * FE16_C0_D01_Q1[0][0][ia1 - 0];
            }
        }
        for (int ia0 = 0; ia0 < 2; ++ia0)
        {
            for (int ia1 = 3; ia1 < 5; ++ia1)
            {
                A[6 * ia0 + ia1] += sv1[5] * FE16_C0_D10_Q1[0][0][ia0 - 0] * FE16_C0_D10_Q1[0][0][ia1 - 3];
            }
        }
        for (int ia0 = 0; ia0 < 2; ++ia0)
        {
            for (int ia1 = 3; ia1 < 6; ++ia1)
            {
                A[6 * ia0 + ia1] += sv1[1] * FE16_C0_D10_Q1[0][0][ia0 - 0] * FE16_C0_D01_Q1[0][0][ia1 - 3];
            }
        }
        for (int ia0 = 0; ia0 < 3; ++ia0)
        {
            for (int ia1 = 0; ia1 < 2; ++ia1)
            {
                A[6 * ia0 + ia1] += sv1[11] * FE16_C0_D01_Q1[0][0][ia0 - 0] * FE16_C0_D10_Q1[0][0][ia1 - 0];
            }
        }
        for (int ia0 = 0; ia0 < 3; ++ia0)
        {
            for (int ia1 = 0; ia1 < 3; ++ia1)
            {
                A[6 * ia0 + ia1] += sv1[12] * FE16_C0_D01_Q1[0][0][ia0 - 0] * FE16_C0_D01_Q1[0][0][ia1 - 0];
            }
        }
        for (int ia0 = 0; ia0 < 3; ++ia0)
        {
            for (int ia1 = 3; ia1 < 5; ++ia1)
            {
                A[6 * ia0 + ia1] += sv1[6] * FE16_C0_D01_Q1[0][0][ia0 - 0] * FE16_C0_D10_Q1[0][0][ia1 - 3];
            }
        }
        for (int ia0 = 0; ia0 < 3; ++ia0)
        {
            for (int ia1 = 3; ia1 < 6; ++ia1)
            {
                A[6 * ia0 + ia1] += sv1[2] * FE16_C0_D01_Q1[0][0][ia0 - 0] * FE16_C0_D01_Q1[0][0][ia1 - 3];
            }
        }
        for (int ia0 = 3; ia0 < 5; ++ia0)
        {
            for (int ia1 = 0; ia1 < 2; ++ia1)
            {
                A[6 * ia0 + ia1] += sv1[15] * FE16_C0_D10_Q1[0][0][ia0 - 3] * FE16_C0_D10_Q1[0][0][ia1 - 0];
            }
        }
        for (int ia0 = 3; ia0 < 5; ++ia0)
        {
            for (int ia1 = 0; ia1 < 3; ++ia1)
            {
                A[6 * ia0 + ia1] += sv1[16] * FE16_C0_D10_Q1[0][0][ia0 - 3] * FE16_C0_D01_Q1[0][0][ia1 - 0];
            }
        }
        for (int ia0 = 3; ia0 < 5; ++ia0)
        {
            for (int ia1 = 3; ia1 < 5; ++ia1)
            {
                A[6 * ia0 + ia1] += sv1[8] * FE16_C0_D10_Q1[0][0][ia0 - 3] * FE16_C0_D10_Q1[0][0][ia1 - 3];
            }
        }
        for (int ia0 = 3; ia0 < 5; ++ia0)
        {
            for (int ia1 = 3; ia1 < 6; ++ia1)
            {
                A[6 * ia0 + ia1] += sv1[4] * FE16_C0_D10_Q1[0][0][ia0 - 3] * FE16_C0_D01_Q1[0][0][ia1 - 3];
            }
        }
        for (int ia0 = 3; ia0 < 6; ++ia0)
        {
            for (int ia1 = 0; ia1 < 2; ++ia1)
            {
                A[6 * ia0 + ia1] += sv1[13] * FE16_C0_D01_Q1[0][0][ia0 - 3] * FE16_C0_D10_Q1[0][0][ia1 - 0];
            }
        }
        for (int ia0 = 3; ia0 < 6; ++ia0)
        {
            for (int ia1 = 0; ia1 < 3; ++ia1)
            {
                A[6 * ia0 + ia1] += sv1[14] * FE16_C0_D01_Q1[0][0][ia0 - 3] * FE16_C0_D01_Q1[0][0][ia1 - 0];
            }
        }
        for (int ia0 = 3; ia0 < 6; ++ia0)
        {
            for (int ia1 = 3; ia1 < 5; ++ia1)
            {
                A[6 * ia0 + ia1] += sv1[7] * FE16_C0_D01_Q1[0][0][ia0 - 3] * FE16_C0_D10_Q1[0][0][ia1 - 3];
            }
        }
        for (int ia0 = 3; ia0 < 6; ++ia0)
        {
            for (int ia1 = 3; ia1 < 6; ++ia1)
            {
                A[6 * ia0 + ia1] += sv1[3] * FE16_C0_D01_Q1[0][0][ia0 - 3] * FE16_C0_D01_Q1[0][0][ia1 - 3];
            }
        }
    }
  }

};


class hyperelasticity_form_0: public ufc::form
{
public:

  hyperelasticity_form_0() : ufc::form()
  {
    // Do nothing
  }

  ~hyperelasticity_form_0() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "192e48d745b685fae7715e811e3b5dd44533406a034de857b2de110616e6c3afc4f296ce443f930109edb459a8edbedc0114c596e120190a8b11df83169006cd";
  }

  std::size_t rank() const final override
  {
    return 1;
  }

  std::size_t num_coefficients() const final override
  {
    return 4;
  }

  std::size_t original_coefficient_position(std::size_t i) const final override
  {
    static const std::vector<std::size_t> position({0, 1, 2, 3});
    return position[i];
  }

  ufc::finite_element * create_coordinate_finite_element() const final override
  {
    return new hyperelasticity_finite_element_1();
  }

  ufc::dofmap * create_coordinate_dofmap() const final override
  {
    return new hyperelasticity_dofmap_1();
   }

  ufc::coordinate_mapping * create_coordinate_mapping() const final override
  {
    return nullptr;
  }

  ufc::finite_element * create_finite_element(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return new hyperelasticity_finite_element_1();
        break;
      }
    case 1:
      {
        return new hyperelasticity_finite_element_1();
        break;
      }
    case 2:
      {
        return new hyperelasticity_finite_element_1();
        break;
      }
    case 3:
      {
        return new hyperelasticity_finite_element_2();
        break;
      }
    case 4:
      {
        return new hyperelasticity_finite_element_2();
        break;
      }
    }
    
    return 0;
  }

  ufc::dofmap * create_dofmap(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return new hyperelasticity_dofmap_1();
        break;
      }
    case 1:
      {
        return new hyperelasticity_dofmap_1();
        break;
      }
    case 2:
      {
        return new hyperelasticity_dofmap_1();
        break;
      }
    case 3:
      {
        return new hyperelasticity_dofmap_2();
        break;
      }
    case 4:
      {
        return new hyperelasticity_dofmap_2();
        break;
      }
    }
    
    return 0;
  }

  std::size_t max_cell_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_exterior_facet_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_interior_facet_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_vertex_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_custom_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_cutcell_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_interface_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_overlap_subdomain_id() const final override
  {
    return 0;
  }

  bool has_cell_integrals() const final override
  {
    return true;
  }

  bool has_exterior_facet_integrals() const final override
  {
    return false;
  }

  bool has_interior_facet_integrals() const final override
  {
    return false;
  }

  bool has_vertex_integrals() const final override
  {
    return false;
  }

  bool has_custom_integrals() const final override
  {
    return false;
  }

  bool has_cutcell_integrals() const final override
  {
    return false;
  }

  bool has_interface_integrals() const final override
  {
    return false;
  }

  bool has_overlap_integrals() const final override
  {
    return false;
  }

  ufc::cell_integral * create_cell_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::exterior_facet_integral * create_exterior_facet_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::interior_facet_integral * create_interior_facet_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::vertex_integral * create_vertex_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::custom_integral * create_custom_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::cutcell_integral * create_cutcell_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::interface_integral * create_interface_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::overlap_integral * create_overlap_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::cell_integral * create_default_cell_integral() const final override
  {
    return new hyperelasticity_cell_integral_0_otherwise();
  }

  ufc::exterior_facet_integral * create_default_exterior_facet_integral() const final override
  {
    return 0;
  }

  ufc::interior_facet_integral * create_default_interior_facet_integral() const final override
  {
    return 0;
  }

  ufc::vertex_integral * create_default_vertex_integral() const final override
  {
    return 0;
  }

  ufc::custom_integral * create_default_custom_integral() const final override
  {
    return 0;
  }

  ufc::cutcell_integral * create_default_cutcell_integral() const final override
  {
    return 0;
  }

  ufc::interface_integral * create_default_interface_integral() const final override
  {
    return 0;
  }

  ufc::overlap_integral * create_default_overlap_integral() const final override
  {
    return 0;
  }

};


class hyperelasticity_form_1: public ufc::form
{
public:

  hyperelasticity_form_1() : ufc::form()
  {
    // Do nothing
  }

  ~hyperelasticity_form_1() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "0031ae9281bf2229d3faaf5fe618b38aeafad9ffe40cc440550d2d1133b3c7edfdd6dbcdc6c9ae960b6107075cad7526a7b5d39369d96c007bf6b670e89eaa70";
  }

  std::size_t rank() const final override
  {
    return 2;
  }

  std::size_t num_coefficients() const final override
  {
    return 3;
  }

  std::size_t original_coefficient_position(std::size_t i) const final override
  {
    static const std::vector<std::size_t> position({0, 2, 3});
    return position[i];
  }

  ufc::finite_element * create_coordinate_finite_element() const final override
  {
    return new hyperelasticity_finite_element_1();
  }

  ufc::dofmap * create_coordinate_dofmap() const final override
  {
    return new hyperelasticity_dofmap_1();
   }

  ufc::coordinate_mapping * create_coordinate_mapping() const final override
  {
    return nullptr;
  }

  ufc::finite_element * create_finite_element(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return new hyperelasticity_finite_element_1();
        break;
      }
    case 1:
      {
        return new hyperelasticity_finite_element_1();
        break;
      }
    case 2:
      {
        return new hyperelasticity_finite_element_1();
        break;
      }
    case 3:
      {
        return new hyperelasticity_finite_element_2();
        break;
      }
    case 4:
      {
        return new hyperelasticity_finite_element_2();
        break;
      }
    }
    
    return 0;
  }

  ufc::dofmap * create_dofmap(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return new hyperelasticity_dofmap_1();
        break;
      }
    case 1:
      {
        return new hyperelasticity_dofmap_1();
        break;
      }
    case 2:
      {
        return new hyperelasticity_dofmap_1();
        break;
      }
    case 3:
      {
        return new hyperelasticity_dofmap_2();
        break;
      }
    case 4:
      {
        return new hyperelasticity_dofmap_2();
        break;
      }
    }
    
    return 0;
  }

  std::size_t max_cell_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_exterior_facet_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_interior_facet_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_vertex_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_custom_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_cutcell_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_interface_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_overlap_subdomain_id() const final override
  {
    return 0;
  }

  bool has_cell_integrals() const final override
  {
    return true;
  }

  bool has_exterior_facet_integrals() const final override
  {
    return false;
  }

  bool has_interior_facet_integrals() const final override
  {
    return false;
  }

  bool has_vertex_integrals() const final override
  {
    return false;
  }

  bool has_custom_integrals() const final override
  {
    return false;
  }

  bool has_cutcell_integrals() const final override
  {
    return false;
  }

  bool has_interface_integrals() const final override
  {
    return false;
  }

  bool has_overlap_integrals() const final override
  {
    return false;
  }

  ufc::cell_integral * create_cell_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::exterior_facet_integral * create_exterior_facet_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::interior_facet_integral * create_interior_facet_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::vertex_integral * create_vertex_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::custom_integral * create_custom_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::cutcell_integral * create_cutcell_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::interface_integral * create_interface_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::overlap_integral * create_overlap_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::cell_integral * create_default_cell_integral() const final override
  {
    return new hyperelasticity_cell_integral_1_otherwise();
  }

  ufc::exterior_facet_integral * create_default_exterior_facet_integral() const final override
  {
    return 0;
  }

  ufc::interior_facet_integral * create_default_interior_facet_integral() const final override
  {
    return 0;
  }

  ufc::vertex_integral * create_default_vertex_integral() const final override
  {
    return 0;
  }

  ufc::custom_integral * create_default_custom_integral() const final override
  {
    return 0;
  }

  ufc::cutcell_integral * create_default_cutcell_integral() const final override
  {
    return 0;
  }

  ufc::interface_integral * create_default_interface_integral() const final override
  {
    return 0;
  }

  ufc::overlap_integral * create_default_overlap_integral() const final override
  {
    return 0;
  }

};

// DOLFIN wrappers

// Standard library includes
#include <string>

// DOLFIN includes
#include <dolfin/common/NoDeleter.h>
#include <dolfin/mesh/Mesh.h>
#include <dolfin/mesh/MultiMesh.h>
#include <dolfin/fem/FiniteElement.h>
#include <dolfin/fem/DofMap.h>
#include <dolfin/fem/Form.h>
#include <dolfin/fem/MultiMeshForm.h>
#include <dolfin/function/FunctionSpace.h>
#include <dolfin/function/MultiMeshFunctionSpace.h>
#include <dolfin/function/GenericFunction.h>
#include <dolfin/function/CoefficientAssigner.h>
#include <dolfin/function/MultiMeshCoefficientAssigner.h>
#include <dolfin/adaptivity/ErrorControl.h>
#include <dolfin/adaptivity/GoalFunctional.h>
#include <dolfin/la/GenericVector.h>

namespace HyperElasticity
{

class CoefficientSpace_B: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  CoefficientSpace_B(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<hyperelasticity_finite_element_1>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<hyperelasticity_dofmap_1>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  CoefficientSpace_B(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<hyperelasticity_finite_element_1>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<hyperelasticity_dofmap_1>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class CoefficientSpace_lmbda: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  CoefficientSpace_lmbda(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<hyperelasticity_finite_element_2>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<hyperelasticity_dofmap_2>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  CoefficientSpace_lmbda(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<hyperelasticity_finite_element_2>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<hyperelasticity_dofmap_2>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class CoefficientSpace_mu: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  CoefficientSpace_mu(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<hyperelasticity_finite_element_2>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<hyperelasticity_dofmap_2>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  CoefficientSpace_mu(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<hyperelasticity_finite_element_2>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<hyperelasticity_dofmap_2>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class CoefficientSpace_u: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  CoefficientSpace_u(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<hyperelasticity_finite_element_1>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<hyperelasticity_dofmap_1>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  CoefficientSpace_u(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<hyperelasticity_finite_element_1>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<hyperelasticity_dofmap_1>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class Form_F_FunctionSpace_0: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  Form_F_FunctionSpace_0(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<hyperelasticity_finite_element_1>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<hyperelasticity_dofmap_1>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  Form_F_FunctionSpace_0(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<hyperelasticity_finite_element_1>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<hyperelasticity_dofmap_1>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class Form_F_MultiMeshFunctionSpace_0: public dolfin::MultiMeshFunctionSpace
{
public:

  // Constructor for multimesh function space
  Form_F_MultiMeshFunctionSpace_0(std::shared_ptr<const dolfin::MultiMesh> multimesh): dolfin::MultiMeshFunctionSpace(multimesh)
  {
    // Create and add standard function spaces
    for (std::size_t part = 0; part < multimesh->num_parts(); part++)
    {
      std::shared_ptr<const dolfin::FunctionSpace> V(new Form_F_FunctionSpace_0(multimesh->part(part)));
      add(V);
    }

    // Build multimesh function space
    build();
  }

};

typedef CoefficientSpace_u Form_F_FunctionSpace_1;

typedef CoefficientSpace_B Form_F_FunctionSpace_2;

typedef CoefficientSpace_mu Form_F_FunctionSpace_3;

typedef CoefficientSpace_lmbda Form_F_FunctionSpace_4;

class Form_F: public dolfin::Form
{
public:

  // Constructor
  Form_F(std::shared_ptr<const dolfin::FunctionSpace> V0):
    dolfin::Form(1, 4), u(*this, 0), B(*this, 1), mu(*this, 2), lmbda(*this, 3)
  {
    _function_spaces[0] = V0;

    _ufc_form = std::make_shared<const hyperelasticity_form_0>();
  }

  // Constructor
  Form_F(std::shared_ptr<const dolfin::FunctionSpace> V0, std::shared_ptr<const dolfin::GenericFunction> u, std::shared_ptr<const dolfin::GenericFunction> B, std::shared_ptr<const dolfin::GenericFunction> mu, std::shared_ptr<const dolfin::GenericFunction> lmbda):
    dolfin::Form(1, 4), u(*this, 0), B(*this, 1), mu(*this, 2), lmbda(*this, 3)
  {
    _function_spaces[0] = V0;

    this->u = u;
    this->B = B;
    this->mu = mu;
    this->lmbda = lmbda;

    _ufc_form = std::make_shared<const hyperelasticity_form_0>();
  }

  // Destructor
  ~Form_F()
  {}

  /// Return the number of the coefficient with this name
  virtual std::size_t coefficient_number(const std::string& name) const
  {
    if (name == "u")
      return 0;
    else if (name == "B")
      return 1;
    else if (name == "mu")
      return 2;
    else if (name == "lmbda")
      return 3;

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      return "u";
    case 1:
      return "B";
    case 2:
      return "mu";
    case 3:
      return "lmbda";
    }

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return "unnamed";
  }

  // Typedefs
  typedef Form_F_FunctionSpace_0 TestSpace;
  typedef Form_F_MultiMeshFunctionSpace_0 MultiMeshTestSpace;
  typedef Form_F_FunctionSpace_1 CoefficientSpace_u;
  typedef Form_F_FunctionSpace_2 CoefficientSpace_B;
  typedef Form_F_FunctionSpace_3 CoefficientSpace_mu;
  typedef Form_F_FunctionSpace_4 CoefficientSpace_lmbda;

  // Coefficients
  dolfin::CoefficientAssigner u;
  dolfin::CoefficientAssigner B;
  dolfin::CoefficientAssigner mu;
  dolfin::CoefficientAssigner lmbda;
};

class MultiMeshForm_F: public dolfin::MultiMeshForm
{
public:

  // Constructor
  MultiMeshForm_F(std::shared_ptr<const dolfin::MultiMeshFunctionSpace> V0):
    dolfin::MultiMeshForm(V0), u(*this, 0), B(*this, 1), mu(*this, 2), lmbda(*this, 3)
  {
    // Create and add standard forms
    std::size_t num_parts = V0->num_parts(); // assume all equal and pick first
    for (std::size_t part = 0; part < num_parts; part++)
    {
      std::shared_ptr<dolfin::Form> a(new Form_F(V0->part(part)));
    add(a);

    }
    // Build multimesh form
    build();

    /// Assign coefficients

  }

  // Constructor
  MultiMeshForm_F(std::shared_ptr<const dolfin::MultiMeshFunctionSpace> V0, std::shared_ptr<const dolfin::GenericFunction> u, std::shared_ptr<const dolfin::GenericFunction> B, std::shared_ptr<const dolfin::GenericFunction> mu, std::shared_ptr<const dolfin::GenericFunction> lmbda):
    dolfin::MultiMeshForm(V0), u(*this, 0), B(*this, 1), mu(*this, 2), lmbda(*this, 3)
  {
    // Create and add standard forms
    std::size_t num_parts = V0->num_parts(); // assume all equal and pick first
    for (std::size_t part = 0; part < num_parts; part++)
    {
      std::shared_ptr<dolfin::Form> a(new Form_F(V0->part(part)));
    add(a);

    }
    // Build multimesh form
    build();

    /// Assign coefficients
    this->u = u;
    this->B = B;
    this->mu = mu;
    this->lmbda = lmbda;

  }

  // Destructor
  ~MultiMeshForm_F()
  {}

  /// Return the number of the coefficient with this name
  virtual std::size_t coefficient_number(const std::string& name) const
  {
    if (name == "u")
      return 0;
    else if (name == "B")
      return 1;
    else if (name == "mu")
      return 2;
    else if (name == "lmbda")
      return 3;

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      return "u";
    case 1:
      return "B";
    case 2:
      return "mu";
    case 3:
      return "lmbda";
    }

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return "unnamed";
  }

  // Typedefs
  typedef Form_F_FunctionSpace_0 TestSpace;
  typedef Form_F_MultiMeshFunctionSpace_0 MultiMeshTestSpace;
  typedef Form_F_FunctionSpace_1 CoefficientSpace_u;
  typedef Form_F_FunctionSpace_2 CoefficientSpace_B;
  typedef Form_F_FunctionSpace_3 CoefficientSpace_mu;
  typedef Form_F_FunctionSpace_4 CoefficientSpace_lmbda;

  // Coefficients
  dolfin::MultiMeshCoefficientAssigner u;
  dolfin::MultiMeshCoefficientAssigner B;
  dolfin::MultiMeshCoefficientAssigner mu;
  dolfin::MultiMeshCoefficientAssigner lmbda;
};

class Form_J_FunctionSpace_0: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  Form_J_FunctionSpace_0(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<hyperelasticity_finite_element_1>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<hyperelasticity_dofmap_1>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  Form_J_FunctionSpace_0(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<hyperelasticity_finite_element_1>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<hyperelasticity_dofmap_1>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class Form_J_FunctionSpace_1: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  Form_J_FunctionSpace_1(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<hyperelasticity_finite_element_1>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<hyperelasticity_dofmap_1>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  Form_J_FunctionSpace_1(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<hyperelasticity_finite_element_1>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<hyperelasticity_dofmap_1>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class Form_J_MultiMeshFunctionSpace_0: public dolfin::MultiMeshFunctionSpace
{
public:

  // Constructor for multimesh function space
  Form_J_MultiMeshFunctionSpace_0(std::shared_ptr<const dolfin::MultiMesh> multimesh): dolfin::MultiMeshFunctionSpace(multimesh)
  {
    // Create and add standard function spaces
    for (std::size_t part = 0; part < multimesh->num_parts(); part++)
    {
      std::shared_ptr<const dolfin::FunctionSpace> V(new Form_J_FunctionSpace_0(multimesh->part(part)));
      add(V);
    }

    // Build multimesh function space
    build();
  }

};

class Form_J_MultiMeshFunctionSpace_1: public dolfin::MultiMeshFunctionSpace
{
public:

  // Constructor for multimesh function space
  Form_J_MultiMeshFunctionSpace_1(std::shared_ptr<const dolfin::MultiMesh> multimesh): dolfin::MultiMeshFunctionSpace(multimesh)
  {
    // Create and add standard function spaces
    for (std::size_t part = 0; part < multimesh->num_parts(); part++)
    {
      std::shared_ptr<const dolfin::FunctionSpace> V(new Form_J_FunctionSpace_1(multimesh->part(part)));
      add(V);
    }

    // Build multimesh function space
    build();
  }

};

typedef CoefficientSpace_u Form_J_FunctionSpace_2;

typedef CoefficientSpace_mu Form_J_FunctionSpace_3;

typedef CoefficientSpace_lmbda Form_J_FunctionSpace_4;

class Form_J: public dolfin::Form
{
public:

  // Constructor
  Form_J(std::shared_ptr<const dolfin::FunctionSpace> V1, std::shared_ptr<const dolfin::FunctionSpace> V0):
    dolfin::Form(2, 3), u(*this, 0), mu(*this, 1), lmbda(*this, 2)
  {
    _function_spaces[0] = V0;
    _function_spaces[1] = V1;

    _ufc_form = std::make_shared<const hyperelasticity_form_1>();
  }

  // Constructor
  Form_J(std::shared_ptr<const dolfin::FunctionSpace> V1, std::shared_ptr<const dolfin::FunctionSpace> V0, std::shared_ptr<const dolfin::GenericFunction> u, std::shared_ptr<const dolfin::GenericFunction> mu, std::shared_ptr<const dolfin::GenericFunction> lmbda):
    dolfin::Form(2, 3), u(*this, 0), mu(*this, 1), lmbda(*this, 2)
  {
    _function_spaces[0] = V0;
    _function_spaces[1] = V1;

    this->u = u;
    this->mu = mu;
    this->lmbda = lmbda;

    _ufc_form = std::make_shared<const hyperelasticity_form_1>();
  }

  // Destructor
  ~Form_J()
  {}

  /// Return the number of the coefficient with this name
  virtual std::size_t coefficient_number(const std::string& name) const
  {
    if (name == "u")
      return 0;
    else if (name == "mu")
      return 1;
    else if (name == "lmbda")
      return 2;

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      return "u";
    case 1:
      return "mu";
    case 2:
      return "lmbda";
    }

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return "unnamed";
  }

  // Typedefs
  typedef Form_J_FunctionSpace_0 TestSpace;
  typedef Form_J_FunctionSpace_1 TrialSpace;
  typedef Form_J_MultiMeshFunctionSpace_0 MultiMeshTestSpace;
  typedef Form_J_MultiMeshFunctionSpace_1 MultiMeshTrialSpace;
  typedef Form_J_FunctionSpace_2 CoefficientSpace_u;
  typedef Form_J_FunctionSpace_3 CoefficientSpace_mu;
  typedef Form_J_FunctionSpace_4 CoefficientSpace_lmbda;

  // Coefficients
  dolfin::CoefficientAssigner u;
  dolfin::CoefficientAssigner mu;
  dolfin::CoefficientAssigner lmbda;
};

class MultiMeshForm_J: public dolfin::MultiMeshForm
{
public:

  // Constructor
  MultiMeshForm_J(std::shared_ptr<const dolfin::MultiMeshFunctionSpace> V1, std::shared_ptr<const dolfin::MultiMeshFunctionSpace> V0):
    dolfin::MultiMeshForm(V1, V0), u(*this, 0), mu(*this, 1), lmbda(*this, 2)
  {
    // Create and add standard forms
    std::size_t num_parts = V0->num_parts(); // assume all equal and pick first
    for (std::size_t part = 0; part < num_parts; part++)
    {
      std::shared_ptr<dolfin::Form> a(new Form_J(V1->part(part), V0->part(part)));
    add(a);

    }
    // Build multimesh form
    build();

    /// Assign coefficients

  }

  // Constructor
  MultiMeshForm_J(std::shared_ptr<const dolfin::MultiMeshFunctionSpace> V1, std::shared_ptr<const dolfin::MultiMeshFunctionSpace> V0, std::shared_ptr<const dolfin::GenericFunction> u, std::shared_ptr<const dolfin::GenericFunction> mu, std::shared_ptr<const dolfin::GenericFunction> lmbda):
    dolfin::MultiMeshForm(V1, V0), u(*this, 0), mu(*this, 1), lmbda(*this, 2)
  {
    // Create and add standard forms
    std::size_t num_parts = V0->num_parts(); // assume all equal and pick first
    for (std::size_t part = 0; part < num_parts; part++)
    {
      std::shared_ptr<dolfin::Form> a(new Form_J(V1->part(part), V0->part(part)));
    add(a);

    }
    // Build multimesh form
    build();

    /// Assign coefficients
    this->u = u;
    this->mu = mu;
    this->lmbda = lmbda;

  }

  // Destructor
  ~MultiMeshForm_J()
  {}

  /// Return the number of the coefficient with this name
  virtual std::size_t coefficient_number(const std::string& name) const
  {
    if (name == "u")
      return 0;
    else if (name == "mu")
      return 1;
    else if (name == "lmbda")
      return 2;

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      return "u";
    case 1:
      return "mu";
    case 2:
      return "lmbda";
    }

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return "unnamed";
  }

  // Typedefs
  typedef Form_J_FunctionSpace_0 TestSpace;
  typedef Form_J_FunctionSpace_1 TrialSpace;
  typedef Form_J_MultiMeshFunctionSpace_0 MultiMeshTestSpace;
  typedef Form_J_MultiMeshFunctionSpace_1 MultiMeshTrialSpace;
  typedef Form_J_FunctionSpace_2 CoefficientSpace_u;
  typedef Form_J_FunctionSpace_3 CoefficientSpace_mu;
  typedef Form_J_FunctionSpace_4 CoefficientSpace_lmbda;

  // Coefficients
  dolfin::MultiMeshCoefficientAssigner u;
  dolfin::MultiMeshCoefficientAssigner mu;
  dolfin::MultiMeshCoefficientAssigner lmbda;
};

// Class typedefs
typedef Form_J BilinearForm;
typedef MultiMeshForm_J MultiMeshBilinearForm;
typedef Form_J JacobianForm;
typedef MultiMeshForm_J MultiMeshJacobianForm;
typedef Form_F LinearForm;
typedef MultiMeshForm_F MultiMeshLinearForm;
typedef Form_F ResidualForm;
typedef MultiMeshForm_F MultiMeshResidualForm;
typedef Form_F::TestSpace FunctionSpace;
typedef Form_F::MultiMeshTestSpace MultiMeshFunctionSpace;

}

#endif
