// Auto generated SWIG file for Python interface of DOLFIN
//
// Copyright (C) 2012-2016 Kristian B. Oelgaard
//
// This file is part of DOLFIN.
//
// DOLFIN is free software: you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// DOLFIN is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License
// along with DOLFIN. If not, see <http://www.gnu.org/licenses/>.
//

// Autogenerated docstrings file, extracted from the DOLFIN source C++ files.

// Documentation extracted from: (module=la, header=LinearAlgebraObject.h)
%feature("docstring")  dolfin::LinearAlgebraObject "
This is a common base class for all DOLFIN linear algebra
objects. In particular, it provides casting mechanisms between
different types.
";

%feature("docstring")  dolfin::LinearAlgebraObject::down_cast "
**Overloaded versions**

* down_cast\ ()

  Cast object to its derived class, if possible (const version).
  An error is thrown if the cast is unsuccessful.

* down_cast\ ()

  Cast object to its derived class, if possible (non-const version).
  An error is thrown if the cast is unsuccessful.

* down_cast\ (A)

  Cast shared pointer object to its derived class, if possible.
  Caller must check for success (returns null if cast fails).
";

%feature("docstring")  dolfin::LinearAlgebraObject::instance "
**Overloaded versions**

* instance\ ()

  Return concrete instance / unwrap (const version)

* instance\ ()

  Return concrete instance / unwrap (non-const version)
";

%feature("docstring")  dolfin::LinearAlgebraObject::shared_instance "
**Overloaded versions**

* shared_instance\ ()

  Return concrete shared ptr instance / unwrap (const version)

* shared_instance\ ()

  Return concrete shared ptr instance / unwrap (non-const version)
";

%feature("docstring")  dolfin::LinearAlgebraObject::mpi_comm "
Return MPI communicator
";

%feature("docstring")  dolfin::LinearAlgebraObject::as_type "
**Overloaded versions**

* as_type\ (x)

  Cast object to its derived class, if possible (non-const version).
  An error is thrown if the cast is unsuccessful.

* as_type\ (x)

  Cast shared pointer object to its derived class, if possible.
  Caller must check for success (returns null if cast fails).
";

%feature("docstring")  dolfin::LinearAlgebraObject::has_type "
Check whether the object matches a specific type
";

// Documentation extracted from: (module=la, header=GenericLinearOperator.h)
%feature("docstring")  dolfin::GenericLinearOperator "
This class defines a common interface for linear operators,
including actual matrices (class :py:class:`GenericMatrix`) and linear
operators only defined in terms of their action on vectors.

This class is used internally by DOLFIN to define a class
hierarchy of backend independent linear operators and solvers.
Users should not interface to this class directly but instead
use the :py:class:`LinearOperator` class.
";

%feature("docstring")  dolfin::GenericLinearOperator::size "
Return size of given dimension
";

%feature("docstring")  dolfin::GenericLinearOperator::mult "
Compute matrix-vector product y = Ax
";

%feature("docstring")  dolfin::GenericLinearOperator::str "
Return informal string representation (pretty-print)
";

// Documentation extracted from: (module=la, header=GenericTensor.h)
%feature("docstring")  dolfin::GenericTensor "
This class defines a common interface for arbitrary rank tensors.
";

%feature("docstring")  dolfin::GenericTensor::init "
Initialize zero tensor using tensor layout
";

%feature("docstring")  dolfin::GenericTensor::empty "
Return true if empty
";

%feature("docstring")  dolfin::GenericTensor::rank "
Return tensor rank (number of dimensions)
";

%feature("docstring")  dolfin::GenericTensor::size "
Return size of given dimension
";

%feature("docstring")  dolfin::GenericTensor::local_range "
Return local ownership range
";

%feature("docstring")  dolfin::GenericTensor::get "
Get block of values
";

%feature("docstring")  dolfin::GenericTensor::set "
Set block of values using global indices
";

%feature("docstring")  dolfin::GenericTensor::set_local "
Set block of values using local indices
";

%feature("docstring")  dolfin::GenericTensor::add "
**Overloaded versions**

* add\ (block, rows)

  Add block of values using global indices

* add\ (block, num_rows, rows)

  Add block of values using global indices
";

%feature("docstring")  dolfin::GenericTensor::add_local "
**Overloaded versions**

* add_local\ (block, rows)

  Add block of values using local indices

* add_local\ (block, num_rows, rows)

  Add block of values using local indices
";

%feature("docstring")  dolfin::GenericTensor::zero "
Set all entries to zero and keep any sparse structure
";

%feature("docstring")  dolfin::GenericTensor::apply "
Finalize assembly of tensor
";

%feature("docstring")  dolfin::GenericTensor::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::GenericTensor::factory "
Return linear algebra backend factory
";

// Documentation extracted from: (module=la, header=GenericMatrix.h)
%feature("docstring")  dolfin::GenericMatrix "
This class defines a common interface for matrices.
";

%feature("docstring")  dolfin::GenericMatrix::rank "
Return tensor rank (number of dimensions)
";

%feature("docstring")  dolfin::GenericMatrix::size "
Return size of given dimension
";

%feature("docstring")  dolfin::GenericMatrix::local_range "
Return local ownership range
";

%feature("docstring")  dolfin::GenericMatrix::nnz "
Return number of non-zero entries in matrix (collective)
";

%feature("docstring")  dolfin::GenericMatrix::get "
**Overloaded versions**

* get\ (block, num_rows, rows)

  Get block of values

* get\ (block, m, rows, n, cols)

  Get block of values
";

%feature("docstring")  dolfin::GenericMatrix::set "
**Overloaded versions**

* set\ (block, num_rows, rows)

  Set block of values using global indices

* set\ (block, m, rows, n, cols)

  Set block of values using global indices
";

%feature("docstring")  dolfin::GenericMatrix::set_local "
**Overloaded versions**

* set_local\ (block, num_rows, rows)

  Set block of values using local indices

* set_local\ (block, m, rows, n, cols)

  Set block of values using local indices
";

%feature("docstring")  dolfin::GenericMatrix::add "
**Overloaded versions**

* add\ (block, num_rows, rows)

  Add block of values using global indices

* add\ (block, rows)

  Add block of values using global indices

* add\ (block, m, rows, n, cols)

  Add block of values using global indices
";

%feature("docstring")  dolfin::GenericMatrix::add_local "
**Overloaded versions**

* add_local\ (block, num_rows, rows)

  Add block of values using local indices

* add_local\ (block, rows)

  Add block of values using local indices

* add_local\ (block, m, rows, n, cols)

  Add block of values using local indices
";

%feature("docstring")  dolfin::GenericMatrix::zero "
**Overloaded versions**

* zero\ ()

  Set all entries to zero and keep any sparse structure

* zero\ (m, rows)

  Set given rows (global row indices) to zero
";

%feature("docstring")  dolfin::GenericMatrix::apply "
Finalize assembly of tensor
";

%feature("docstring")  dolfin::GenericMatrix::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::GenericMatrix::copy "
Return copy of matrix
";

%feature("docstring")  dolfin::GenericMatrix::init_vector "
Initialize vector z to be compatible with the matrix-vector
product y = Ax. In the parallel case, both size and layout are
important.

*Arguments*
    dim (int)
        The dimension (axis): dim = 0 --> z = y, dim = 1 --> z = x
";

%feature("docstring")  dolfin::GenericMatrix::axpy "
Add multiple of given matrix (AXPY operation)
";

%feature("docstring")  dolfin::GenericMatrix::norm "
Return norm of matrix
";

%feature("docstring")  dolfin::GenericMatrix::getrow "
Get non-zero values of given row (global index) on local process
";

%feature("docstring")  dolfin::GenericMatrix::setrow "
Set values for given row (global index) on local process
";

%feature("docstring")  dolfin::GenericMatrix::zero_local "
Set given rows (local row indices) to zero
";

%feature("docstring")  dolfin::GenericMatrix::ident "
Set given rows (global row indices) to identity matrix
";

%feature("docstring")  dolfin::GenericMatrix::ident_local "
Set given rows (local row indices) to identity matrix
";

%feature("docstring")  dolfin::GenericMatrix::transpmult "
Matrix-vector product, y = A^T x. The y vector must either be
zero-sized or have correct size and parallel layout.
";

%feature("docstring")  dolfin::GenericMatrix::get_diagonal "
Get diagonal of a matrix
";

%feature("docstring")  dolfin::GenericMatrix::set_diagonal "
Set diagonal of a matrix
";

%feature("docstring")  dolfin::GenericMatrix::operator*= "
Multiply matrix by given number
";

%feature("docstring")  dolfin::GenericMatrix::operator/= "
Divide matrix by given number
";

%feature("docstring")  dolfin::GenericMatrix::operator+= "
Add given matrix
";

%feature("docstring")  dolfin::GenericMatrix::operator-= "
Subtract given matrix
";

%feature("docstring")  dolfin::GenericMatrix::is_symmetric "
Test if matrix is symmetric
";

%feature("docstring")  dolfin::GenericMatrix::operator= "
Assignment operator
";

%feature("docstring")  dolfin::GenericMatrix::operator "
Get value of given entry
";

%feature("docstring")  dolfin::GenericMatrix::getitem "
Get value of given entry
";

%feature("docstring")  dolfin::GenericMatrix::setitem "
Set given entry to value. apply(\"insert\") must be called
before using using the object.
";

%feature("docstring")  dolfin::GenericMatrix::ident_zeros "
Insert one on the diagonal for all zero rows
";

// Documentation extracted from: (module=la, header=GenericVector.h)
%feature("docstring")  dolfin::GenericVector "
This class defines a common interface for vectors.
";

%feature("docstring")  dolfin::GenericVector::init "
**Overloaded versions**

* init\ (tensor_layout)

  Initialize zero tensor using sparsity pattern
  FIXME: This needs to be implemented on backend side! Remove it!

* init\ (comm, N)

  Initialize vector to global size N

* init\ (comm, range)

  Initialize vector with given local ownership range

* init\ (comm, range, local_to_global_map, ghost_indices)

  Initialise vector with given ownership range and with ghost
  values
  FIXME: Reimplement using init(const TensorLayout&) and deprecate
";

%feature("docstring")  dolfin::GenericVector::rank "
Return tensor rank (number of dimensions)
";

%feature("docstring")  dolfin::GenericVector::size "
**Overloaded versions**

* size\ (dim)

  Return size of given dimension

* size\ ()

  Return global size of vector
";

%feature("docstring")  dolfin::GenericVector::local_range "
**Overloaded versions**

* local_range\ (dim)

  Return local ownership range

* local_range\ ()

  Return local ownership range of a vector
";

%feature("docstring")  dolfin::GenericVector::get "
**Overloaded versions**

* get\ (block, num_rows, rows)

  Get block of values using global indices

* get\ (block, m, rows)

  Get block of values using global indices (values must all live
  on the local process, ghosts cannot be accessed)
";

%feature("docstring")  dolfin::GenericVector::get_local "
**Overloaded versions**

* get_local\ (block, num_rows, rows)

  Get block of values using local indices

* get_local\ (block, m, rows)

  Get block of values using local indices (values must all live
  on the local process, ghost are accessible)

* get_local\ (values)

  Get all values on local process
";

%feature("docstring")  dolfin::GenericVector::set "
**Overloaded versions**

* set\ (block, num_rows, rows)

  Set block of values using global indices

* set\ (block, m, rows)

  Set block of values using global indices
";

%feature("docstring")  dolfin::GenericVector::set_local "
**Overloaded versions**

* set_local\ (block, num_rows, rows)

  Set block of values using local indices

* set_local\ (block, m, rows)

  Set block of values using local indices

* set_local\ (values)

  Set all values on local process
";

%feature("docstring")  dolfin::GenericVector::add "
**Overloaded versions**

* add\ (block, num_rows, rows)

  Add block of values using global indices

* add\ (block, rows)

  Add block of values using global indices

* add\ (block, m, rows)

  Add block of values using global indices
";

%feature("docstring")  dolfin::GenericVector::add_local "
**Overloaded versions**

* add_local\ (block, num_rows, rows)

  Add block of values using local indices

* add_local\ (block, rows)

  Add block of values using local indices

* add_local\ (block, m, rows)

  Add block of values using local indices

* add_local\ (values)

  Add values to each entry on local process
";

%feature("docstring")  dolfin::GenericVector::zero "
Set all entries to zero and keep any sparse structure
";

%feature("docstring")  dolfin::GenericVector::apply "
Finalize assembly of tensor
";

%feature("docstring")  dolfin::GenericVector::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::GenericVector::copy "
Return copy of vector
";

%feature("docstring")  dolfin::GenericVector::local_size "
Return local size of vector
";

%feature("docstring")  dolfin::GenericVector::owns_index "
Determine whether global vector index is owned by this process
";

%feature("docstring")  dolfin::GenericVector::gather "
**Overloaded versions**

* gather\ (x, indices)

  Gather entries into local vector x

* gather\ (x, indices)

  Gather entries into x
";

%feature("docstring")  dolfin::GenericVector::gather_on_zero "
Gather all entries into x on process 0
";

%feature("docstring")  dolfin::GenericVector::axpy "
Add multiple of given vector (AXPY operation)
";

%feature("docstring")  dolfin::GenericVector::abs "
Replace all entries in the vector by their absolute values
";

%feature("docstring")  dolfin::GenericVector::inner "
Return inner product with given vector
";

%feature("docstring")  dolfin::GenericVector::norm "
Return norm of vector
";

%feature("docstring")  dolfin::GenericVector::min "
Return minimum value of vector
";

%feature("docstring")  dolfin::GenericVector::max "
Return maximum value of vector
";

%feature("docstring")  dolfin::GenericVector::sum "
**Overloaded versions**

* sum\ ()

  Return sum of vector

* sum\ (rows)

  Return sum of selected rows in vector. Repeated entries are
  only summed once.
";

%feature("docstring")  dolfin::GenericVector::operator*= "
**Overloaded versions**

* operator*=\ (a)

  Multiply vector by given number

* operator*=\ (x)

  Multiply vector by another vector pointwise
";

%feature("docstring")  dolfin::GenericVector::operator/= "
Divide vector by given number
";

%feature("docstring")  dolfin::GenericVector::operator+= "
**Overloaded versions**

* operator+=\ (x)

  Add given vector

* operator+=\ (a)

  Add number to all components of a vector
";

%feature("docstring")  dolfin::GenericVector::operator-= "
**Overloaded versions**

* operator-=\ (x)

  Subtract given vector

* operator-=\ (a)

  Subtract number from all components of a vector
";

%feature("docstring")  dolfin::GenericVector::operator= "
**Overloaded versions**

* operator=\ (x)

  Assignment operator

* operator=\ (a)

  Assignment operator
";

%feature("docstring")  dolfin::GenericVector::operator[] "
Get value of given entry
";

%feature("docstring")  dolfin::GenericVector::getitem "
Get value of given entry
";

%feature("docstring")  dolfin::GenericVector::setitem "
Set given entry to value. apply(\"insert\") should be called
before using using the object.
";

// Documentation extracted from: (module=la, header=VectorSpaceBasis.h)
%feature("docstring")  dolfin::VectorSpaceBasis "
This class defines a basis for vector spaces,
typically used for expressing nullspaces, transpose nullspaces
and near nullspaces of singular operators
";

%feature("docstring")  dolfin::VectorSpaceBasis::VectorSpaceBasis "
Constructor
";

%feature("docstring")  dolfin::VectorSpaceBasis::orthonormalize "
Apply the Gram-Schmidt process to orthonormalize the
basis. Throws an error if a (near) linear dependency is
detected. Error is thrown if <x_i, x_i> < tol.
";

%feature("docstring")  dolfin::VectorSpaceBasis::is_orthonormal "
Test if basis is orthonormal
";

%feature("docstring")  dolfin::VectorSpaceBasis::is_orthogonal "
Test if basis is orthogonal
";

%feature("docstring")  dolfin::VectorSpaceBasis::orthogonalize "
Orthogonalize x with respect to basis
";

%feature("docstring")  dolfin::VectorSpaceBasis::dim "
Number of vectors in the basis
";

%feature("docstring")  dolfin::VectorSpaceBasis::operator[] "
Get a particular basis vector
";

// Documentation extracted from: (module=la, header=GenericLinearSolver.h)
%feature("docstring")  dolfin::GenericLinearSolver "
This class provides a general solver for linear systems Ax = b.
";

%feature("docstring")  dolfin::GenericLinearSolver::set_operator "
Set operator (matrix)
";

%feature("docstring")  dolfin::GenericLinearSolver::set_operators "
Set operator (matrix) and preconditioner matrix
";

%feature("docstring")  dolfin::GenericLinearSolver::solve "
**Overloaded versions**

* solve\ (A, x, b)

  Solve linear system Ax = b

* solve\ (x, b)

  Solve linear system Ax = b
";

%feature("docstring")  dolfin::GenericLinearSolver::solve_transpose "
**Overloaded versions**

* solve_transpose\ (A, x, b)

  Solve linear system A^Tx = b

* solve_transpose\ (x, b)

  Solve linear system A^Tx = b
";

%feature("docstring")  dolfin::GenericLinearSolver::parameter_type "
Return parameter type: \"krylov_solver\" or \"lu_solver\"
";

%feature("docstring")  dolfin::GenericLinearSolver::update_parameters "
Update solver parameters (useful for LinearSolver wrapper)
";

// Documentation extracted from: (module=la, header=GenericLUSolver.h)
%feature("docstring")  dolfin::GenericLUSolver "
This a base class for LU solvers
";

%feature("docstring")  dolfin::GenericLUSolver::set_operator "
Set operator (matrix)
";

%feature("docstring")  dolfin::GenericLUSolver::solve "
**Overloaded versions**

* solve\ (x, b)

  Solve linear system Ax = b

* solve\ (A, x, b)

  Solve linear system Ax = b
";

%feature("docstring")  dolfin::GenericLUSolver::solve_transpose "
**Overloaded versions**

* solve_transpose\ (x, b)

  Solve linear system A^Tx = b

* solve_transpose\ (A, x, b)

  Solve linear system A^Tx = b
";

%feature("docstring")  dolfin::GenericLUSolver::parameter_type "
Return parameter type: \"krylov_solver\" or \"lu_solver\"
";

// Documentation extracted from: (module=la, header=PETScOptions.h)
%feature("docstring")  dolfin::PETScOptions "
These class provides static functions that permit users to set
and retrieve PETSc options via the PETSc option/parameter
system. The option must not be prefixed by '-', e.g.

    PETScOptions::set(\"mat_mumps_icntl_14\", 40);
";

%feature("docstring")  dolfin::PETScOptions::set "
**Overloaded versions**

* set\ (option)

  Set PETSc option that takes no value

* set\ (option, value)

  Set PETSc boolean option

* set\ (option, value)

  Set PETSc integer option

* set\ (option, value)

  Set PETSc double option

* set\ (option, value)

  Set PETSc string option

* set\ (option, value)

  Genetic function for setting PETSc option
";

%feature("docstring")  dolfin::PETScOptions::clear "
Clear PETSc option
";

// Documentation extracted from: (module=la, header=PETScObject.h)
%feature("docstring")  dolfin::PETScObject "
This class calls SubSystemsManager to initialise PETSc.

All PETSc objects must be derived from this class.
";

%feature("docstring")  dolfin::PETScObject::PETScObject "
Constructor. Ensures that PETSc has been initialised.
";

%feature("docstring")  dolfin::PETScObject::petsc_error "
Print error message for PETSc calls that return an error
";

// Documentation extracted from: (module=la, header=PETScBaseMatrix.h)
%feature("docstring")  dolfin::PETScBaseMatrix "
This class is a base class for matrices that can be used in
PETScKrylovSolver.
";

%feature("docstring")  dolfin::PETScBaseMatrix::PETScBaseMatrix "
**Overloaded versions**

* PETScBaseMatrix\ ()

  Constructor

* PETScBaseMatrix\ (A)

  Constructor

* PETScBaseMatrix\ (A)

  Copy constructor
";

%feature("docstring")  dolfin::PETScBaseMatrix::size "
**Overloaded versions**

* size\ (dim)

  Return number of rows (dim = 0) or columns (dim = 1)

* size\ ()

  Return number of rows and columns (num_rows, num_cols). PETSc
  returns -1 if size has not been set.
";

%feature("docstring")  dolfin::PETScBaseMatrix::local_range "
Return local range along dimension dim
";

%feature("docstring")  dolfin::PETScBaseMatrix::init_vector "
Initialize vector to be compatible with the matrix-vector product
y = Ax. In the parallel case, both size and layout are
important.

*Arguments*
    dim (int)
        The dimension (axis): dim = 0 --> z = y, dim = 1 --> z = x
";

%feature("docstring")  dolfin::PETScBaseMatrix::mat "
Return PETSc Mat pointer
";

%feature("docstring")  dolfin::PETScBaseMatrix::mpi_comm "
Return the MPI communicator
";

%feature("docstring")  dolfin::PETScBaseMatrix::str "
Return informal string representation (pretty-print)
";

// Documentation extracted from: (module=la, header=EigenMatrix.h)
%feature("docstring")  dolfin::EigenMatrix "
This class provides a sparse matrix class based on Eigen.  It is
a simple wrapper for Eigen::SparseMatrix implementing the
GenericMatrix interface.

The interface is intentionally simple. For advanced usage,
access the underlying Eigen matrix and use the standard Eigen
interface which is documented at http://eigen.tuxfamily.org
";

%feature("docstring")  dolfin::EigenMatrix::EigenMatrix "
**Overloaded versions**

* EigenMatrix\ ()

  Create empty matrix

* EigenMatrix\ (M, N)

  Create M x N matrix

* EigenMatrix\ (A)

  Copy constructor
";

%feature("docstring")  dolfin::EigenMatrix::init "
Initialize zero tensor using tenor layout
";

%feature("docstring")  dolfin::EigenMatrix::empty "
Return true if empty
";

%feature("docstring")  dolfin::EigenMatrix::size "
Return size of given dimension
";

%feature("docstring")  dolfin::EigenMatrix::local_range "
Return local ownership range
";

%feature("docstring")  dolfin::EigenMatrix::nnz "
Return number of non-zero entries in matrix
";

%feature("docstring")  dolfin::EigenMatrix::zero "
**Overloaded versions**

* zero\ ()

  Set all entries to zero and keep any sparse structure

* zero\ (m, rows)

  Set given rows (global row indices) to zero
";

%feature("docstring")  dolfin::EigenMatrix::apply "
Finalize assembly of tensor
";

%feature("docstring")  dolfin::EigenMatrix::mpi_comm "
Return MPI communicator
";

%feature("docstring")  dolfin::EigenMatrix::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::EigenMatrix::copy "
Return copy of matrix
";

%feature("docstring")  dolfin::EigenMatrix::resize "
Resize matrix to M x N
";

%feature("docstring")  dolfin::EigenMatrix::init_vector "
Initialise vector z to be compatible with the matrix-vector product
y = Ax.

*Arguments*
    dim (int)
        The dimension (axis): dim = 0 --> z = y, dim = 1 --> z = x
";

%feature("docstring")  dolfin::EigenMatrix::get "
Get block of values
";

%feature("docstring")  dolfin::EigenMatrix::set "
Set block of values using global indices
";

%feature("docstring")  dolfin::EigenMatrix::set_local "
Set block of values using local indices
";

%feature("docstring")  dolfin::EigenMatrix::add "
Add block of values using global indices
";

%feature("docstring")  dolfin::EigenMatrix::add_local "
Add block of values using local indices
";

%feature("docstring")  dolfin::EigenMatrix::axpy "
Add multiple of given matrix (AXPY operation)
";

%feature("docstring")  dolfin::EigenMatrix::norm "
Return norm of matrix
";

%feature("docstring")  dolfin::EigenMatrix::getrow "
Get non-zero values of given row
";

%feature("docstring")  dolfin::EigenMatrix::setrow "
Set values for given row
";

%feature("docstring")  dolfin::EigenMatrix::zero_local "
Set given rows (local row indices) to zero
";

%feature("docstring")  dolfin::EigenMatrix::ident "
Set given rows to identity matrix
";

%feature("docstring")  dolfin::EigenMatrix::ident_local "
Set given rows to identity matrix
";

%feature("docstring")  dolfin::EigenMatrix::mult "
Matrix-vector product, y = Ax
";

%feature("docstring")  dolfin::EigenMatrix::transpmult "
Matrix-vector product, y = A^T x
";

%feature("docstring")  dolfin::EigenMatrix::get_diagonal "
Get diagonal of a matrix
";

%feature("docstring")  dolfin::EigenMatrix::set_diagonal "
Set diagonal of a matrix
";

%feature("docstring")  dolfin::EigenMatrix::operator*= "
Multiply matrix by given number
";

%feature("docstring")  dolfin::EigenMatrix::operator/= "
Divide matrix by given number
";

%feature("docstring")  dolfin::EigenMatrix::operator= "
**Overloaded versions**

* operator=\ (A)

  Assignment operator

* operator=\ (A)

  Assignment operator
";

%feature("docstring")  dolfin::EigenMatrix::data "
Return pointers to underlying compressed storage data See
GenericMatrix for documentation.
";

%feature("docstring")  dolfin::EigenMatrix::factory "
Return linear algebra backend factory
";

%feature("docstring")  dolfin::EigenMatrix::mat "
**Overloaded versions**

* mat\ ()

  Return reference to Eigen matrix (const version)

* mat\ ()

  Return reference to Eigen matrix (non-const version)
";

%feature("docstring")  dolfin::EigenMatrix::compress "
Compress matrix (eliminate all zeros from a sparse matrix)
";

%feature("docstring")  dolfin::EigenMatrix::operator "
Access value of given entry
";

// Documentation extracted from: (module=la, header=PETScMatrix.h)
%feature("docstring")  dolfin::PETScMatrix "
This class provides a simple matrix class based on PETSc.
It is a wrapper for a PETSc matrix pointer (Mat)
implementing the GenericMatrix interface.

The interface is intentionally simple. For advanced usage,
access the PETSc Mat pointer using the function mat() and
use the standard PETSc interface.
";

%feature("docstring")  dolfin::PETScMatrix::PETScMatrix "
**Overloaded versions**

* PETScMatrix\ ()

  Create empty matrix (on MPI_COMM_WORLD)

* PETScMatrix\ (comm)

  Create empty matrix

* PETScMatrix\ (A)

  Create a wrapper around a PETSc Mat pointer. The Mat object
  should have been created, e.g. via PETSc MatrCreate.

* PETScMatrix\ (A)

  Copy constructor
";

%feature("docstring")  dolfin::PETScMatrix::init "
Initialize zero tensor using tensor layout
";

%feature("docstring")  dolfin::PETScMatrix::empty "
Return true if empty
";

%feature("docstring")  dolfin::PETScMatrix::size "
Return size of given dimension
";

%feature("docstring")  dolfin::PETScMatrix::local_range "
Return local ownership range
";

%feature("docstring")  dolfin::PETScMatrix::nnz "
Return number of non-zero entries in matrix (collective)
";

%feature("docstring")  dolfin::PETScMatrix::zero "
**Overloaded versions**

* zero\ ()

  Set all entries to zero and keep any sparse structure

* zero\ (m, rows)

  Set given rows (global row indices) to zero
";

%feature("docstring")  dolfin::PETScMatrix::apply "
Finalize assembly of tensor. The following values are recognized
for the mode parameter:

  add    - corresponds to PETSc MatAssemblyBegin+End(MAT_FINAL_ASSEMBLY)
  insert - corresponds to PETSc MatAssemblyBegin+End(MAT_FINAL_ASSEMBLY)
  flush  - corresponds to PETSc MatAssemblyBegin+End(MAT_FLUSH_ASSEMBLY)
";

%feature("docstring")  dolfin::PETScMatrix::mpi_comm "
Return MPI communicator
";

%feature("docstring")  dolfin::PETScMatrix::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::PETScMatrix::copy "
Return copy of matrix
";

%feature("docstring")  dolfin::PETScMatrix::init_vector "
Initialize vector z to be compatible with the matrix-vector product
y = Ax. In the parallel case, both size and layout are
important.

*Arguments*
    dim (int)
        The dimension (axis): dim = 0 --> z = y, dim = 1 --> z = x
";

%feature("docstring")  dolfin::PETScMatrix::get "
Get block of values
";

%feature("docstring")  dolfin::PETScMatrix::set "
Set block of values using global indices
";

%feature("docstring")  dolfin::PETScMatrix::set_local "
Set block of values using local indices
";

%feature("docstring")  dolfin::PETScMatrix::add "
Add block of values using global indices
";

%feature("docstring")  dolfin::PETScMatrix::add_local "
Add block of values using local indices
";

%feature("docstring")  dolfin::PETScMatrix::axpy "
Add multiple of given matrix (AXPY operation)
";

%feature("docstring")  dolfin::PETScMatrix::norm "
Return norm of matrix
";

%feature("docstring")  dolfin::PETScMatrix::getrow "
Get non-zero values of given row
";

%feature("docstring")  dolfin::PETScMatrix::setrow "
Set values for given row
";

%feature("docstring")  dolfin::PETScMatrix::zero_local "
Set given rows (local row indices) to zero
";

%feature("docstring")  dolfin::PETScMatrix::ident "
Set given rows (global row indices) to identity matrix
";

%feature("docstring")  dolfin::PETScMatrix::ident_local "
Set given rows (local row indices) to identity matrix
";

%feature("docstring")  dolfin::PETScMatrix::get_diagonal "
Get diagonal of a matrix
";

%feature("docstring")  dolfin::PETScMatrix::set_diagonal "
Set diagonal of a matrix
";

%feature("docstring")  dolfin::PETScMatrix::operator*= "
Multiply matrix by given number
";

%feature("docstring")  dolfin::PETScMatrix::operator/= "
Divide matrix by given number
";

%feature("docstring")  dolfin::PETScMatrix::operator= "
**Overloaded versions**

* operator=\ (A)

  Assignment operator

* operator=\ (A)

  Assignment operator
";

%feature("docstring")  dolfin::PETScMatrix::is_symmetric "
Test if matrix is symmetric
";

%feature("docstring")  dolfin::PETScMatrix::factory "
Return linear algebra backend factory
";

%feature("docstring")  dolfin::PETScMatrix::set_options_prefix "
Sets the prefix used by PETSc when searching the options
database
";

%feature("docstring")  dolfin::PETScMatrix::get_options_prefix "
Returns the prefix used by PETSc when searching the options
database
";

%feature("docstring")  dolfin::PETScMatrix::set_from_options "
Call PETSc function MatSetFromOptions on the PETSc Mat object
";

%feature("docstring")  dolfin::PETScMatrix::set_nullspace "
Attach nullspace to matrix (typically used by Krylov solvers
when solving singular systems)
";

%feature("docstring")  dolfin::PETScMatrix::set_near_nullspace "
Attach near nullspace to matrix (used by preconditioners, such
as smoothed aggregation algerbraic multigrid)
";

%feature("docstring")  dolfin::PETScMatrix::binary_dump "
Dump matrix to PETSc binary format
";

// Documentation extracted from: (module=la, header=PETScLinearOperator.h)
%feature("docstring")  dolfin::PETScLinearOperator::PETScLinearOperator "
Constructor
";

%feature("docstring")  dolfin::PETScLinearOperator::size "
Return size of given dimension
";

%feature("docstring")  dolfin::PETScLinearOperator::mult "
Compute matrix-vector product y = Ax
";

%feature("docstring")  dolfin::PETScLinearOperator::mpi_comm "
Return MPI communicator
";

%feature("docstring")  dolfin::PETScLinearOperator::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::PETScLinearOperator::wrapper "
**Overloaded versions**

* wrapper\ ()

  Return pointer to wrapper (const version)

* wrapper\ ()

  Return pointer to wrapper (const version)
";

// Documentation extracted from: (module=la, header=PETScPreconditioner.h)
%feature("docstring")  dolfin::PETScPreconditioner "
This class is a wrapper for configuring PETSc
preconditioners. It does not own a preconditioner. It can take a
PETScKrylovSolver and set the preconditioner type and
parameters.
";

%feature("docstring")  dolfin::PETScPreconditioner::PETScPreconditioner "
Create a particular preconditioner object
";

%feature("docstring")  dolfin::PETScPreconditioner::set "
Set the preconditioner type and parameters
";

%feature("docstring")  dolfin::PETScPreconditioner::set_coordinates "
Set the coordinates of the operator (matrix) rows and
geometric dimension d. This is can be used by required for
certain preconditioners, e.g. ML. The input for this function
can be generated using GenericDofMap::tabulate_all_dofs.
";

%feature("docstring")  dolfin::PETScPreconditioner::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::PETScPreconditioner::preconditioners "
Return a list of available preconditioners
";

// Documentation extracted from: (module=la, header=TpetraMatrix.h)
%feature("docstring")  dolfin::TpetraMatrix "
This class provides a simple matrix class based on Tpetra.  It
is a wrapper for a Tpetra matrix pointer
(Teuchos::RCP<matrix_type>) implementing the GenericMatrix
interface.

The interface is intentionally simple. For advanced usage,
access the Tpetra::RCP<matrix_type> pointer using the function
mat() and use the standard Tpetra interface.
";

%feature("docstring")  dolfin::TpetraMatrix::TpetraMatrix "
**Overloaded versions**

* TpetraMatrix\ ()

  Create empty matrix

* TpetraMatrix\ (A)

  Create a wrapper around a Teuchos::RCP<matrix_type> pointer

* TpetraMatrix\ (A)

  Copy constructor
";

%feature("docstring")  dolfin::TpetraMatrix::init "
Initialize zero tensor using tensor layout
";

%feature("docstring")  dolfin::TpetraMatrix::empty "
Return true if empty
";

%feature("docstring")  dolfin::TpetraMatrix::size "
Return size of given dimension
";

%feature("docstring")  dolfin::TpetraMatrix::local_range "
Return local ownership range
";

%feature("docstring")  dolfin::TpetraMatrix::zero "
**Overloaded versions**

* zero\ ()

  Set all entries to zero and keep any sparse structure

* zero\ (m, rows)

  Set given rows (global row indices) to zero
";

%feature("docstring")  dolfin::TpetraMatrix::apply "
Finalize assembly of tensor. The mode parameter is ignored.
";

%feature("docstring")  dolfin::TpetraMatrix::mpi_comm "
Return MPI communicator
";

%feature("docstring")  dolfin::TpetraMatrix::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::TpetraMatrix::copy "
Return copy of matrix
";

%feature("docstring")  dolfin::TpetraMatrix::init_vector "
Initialize vector z to be compatible with the matrix-vector
product y = Ax. In the parallel case, both size and layout are
important.

*Arguments*
    dim (int)
        The dimension (axis): dim = 0 --> z = y, dim = 1 --> z = x
";

%feature("docstring")  dolfin::TpetraMatrix::get "
Get block of values
";

%feature("docstring")  dolfin::TpetraMatrix::set "
Set block of values using global indices
";

%feature("docstring")  dolfin::TpetraMatrix::set_local "
Set block of values using local indices
";

%feature("docstring")  dolfin::TpetraMatrix::add "
Add block of values using global indices
";

%feature("docstring")  dolfin::TpetraMatrix::add_local "
Add block of values using local indices
";

%feature("docstring")  dolfin::TpetraMatrix::axpy "
Add multiple of given matrix (AXPY operation)
";

%feature("docstring")  dolfin::TpetraMatrix::getrow "
Get non-zero values of given row
";

%feature("docstring")  dolfin::TpetraMatrix::setrow "
Set values for given row
";

%feature("docstring")  dolfin::TpetraMatrix::zero_local "
Set given rows (local row indices) to zero
";

%feature("docstring")  dolfin::TpetraMatrix::ident "
Set given rows (global row indices) to identity matrix
";

%feature("docstring")  dolfin::TpetraMatrix::ident_local "
Set given rows (local row indices) to identity matrix
";

%feature("docstring")  dolfin::TpetraMatrix::get_diagonal "
Get diagonal of a matrix
";

%feature("docstring")  dolfin::TpetraMatrix::set_diagonal "
Set diagonal of a matrix
";

%feature("docstring")  dolfin::TpetraMatrix::operator*= "
Multiply matrix by given number
";

%feature("docstring")  dolfin::TpetraMatrix::operator/= "
Divide matrix by given number
";

%feature("docstring")  dolfin::TpetraMatrix::operator= "
**Overloaded versions**

* operator=\ (A)

  Assignment operator

* operator=\ (A)

  Assignment operator
";

%feature("docstring")  dolfin::TpetraMatrix::is_symmetric "
Test if matrix is symmetric
";

%feature("docstring")  dolfin::TpetraMatrix::factory "
Return linear algebra backend factory
";

%feature("docstring")  dolfin::TpetraMatrix::norm "
Return norm of matrix
";

// Documentation extracted from: (module=la, header=EigenKrylovSolver.h)
%feature("docstring")  dolfin::EigenKrylovSolver "
This class implements Krylov methods for linear systems of the
form Ax = b. It is a wrapper for the Krylov solvers of Eigen.
";

%feature("docstring")  dolfin::EigenKrylovSolver::EigenKrylovSolver "
Create Krylov solver for a particular method and names
preconditioner
";

%feature("docstring")  dolfin::EigenKrylovSolver::set_operator "
**Overloaded versions**

* set_operator\ (A)

  Set operator (matrix)

* set_operator\ (A)

  Set operator (matrix)
";

%feature("docstring")  dolfin::EigenKrylovSolver::set_operators "
**Overloaded versions**

* set_operators\ (A, P)

  Set operator (matrix) and preconditioner matrix

* set_operators\ (A, P)

  Set operator (matrix) and preconditioner matrix
";

%feature("docstring")  dolfin::EigenKrylovSolver::get_operator "
Get operator (matrix)
";

%feature("docstring")  dolfin::EigenKrylovSolver::solve "
**Overloaded versions**

* solve\ (x, b)

  Solve linear system Ax = b and return number of iterations

* solve\ (x, b)

  Solve linear system Ax = b and return number of iterations

* solve\ (A, x, b)

  Solve linear system Ax = b and return number of iterations

* solve\ (A, x, b)

  Solve linear system Ax = b and return number of iterations
";

%feature("docstring")  dolfin::EigenKrylovSolver::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::EigenKrylovSolver::methods "
Return a list of available solver methods
";

%feature("docstring")  dolfin::EigenKrylovSolver::preconditioners "
Return a list of available preconditioners
";

%feature("docstring")  dolfin::EigenKrylovSolver::default_parameters "
Default parameter values
";

%feature("docstring")  dolfin::EigenKrylovSolver::parameter_type "
Return parameter type: \"krylov_solver\" or \"lu_solver\"
";

// Documentation extracted from: (module=la, header=EigenLUSolver.h)
%feature("docstring")  dolfin::EigenLUSolver "
This class implements the direct solution (LU factorization) for
linear systems of the form Ax = b.
";

%feature("docstring")  dolfin::EigenLUSolver::EigenLUSolver "
**Overloaded versions**

* EigenLUSolver\ (method=\"default\")

  Constructor

* EigenLUSolver\ (A, method=\"default\")

  Constructor
";

%feature("docstring")  dolfin::EigenLUSolver::set_operator "
**Overloaded versions**

* set_operator\ (A)

  Set operator (matrix)

* set_operator\ (A)

  Set operator (matrix)
";

%feature("docstring")  dolfin::EigenLUSolver::get_operator "
Get operator (matrix)
";

%feature("docstring")  dolfin::EigenLUSolver::solve "
**Overloaded versions**

* solve\ (x, b)

  Solve linear system Ax = b

* solve\ (x, b, transpose)

  Solve linear system Ax = b

* solve\ (A, x, b)

  Solve linear system Ax = b

* solve\ (A, x, b)

  Solve linear system Ax = b
";

%feature("docstring")  dolfin::EigenLUSolver::solve_transpose "
**Overloaded versions**

* solve_transpose\ (x, b)

  Solve linear system A^Tx = b

* solve_transpose\ (A, x, b)

  Solve linear system A^Tx = b

* solve_transpose\ (A, x, b)

  Solve linear system A^Tx = b
";

%feature("docstring")  dolfin::EigenLUSolver::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::EigenLUSolver::methods "
Return a list of available solver methods
";

%feature("docstring")  dolfin::EigenLUSolver::default_parameters "
Default parameter values
";

// Documentation extracted from: (module=la, header=PETScKrylovSolver.h)
%feature("docstring")  dolfin::PETScKrylovSolver "
This class implements Krylov methods for linear systems of the
form Ax = b. It is a wrapper for the Krylov solvers of PETSc.
";

%feature("docstring")  dolfin::PETScKrylovSolver::norm_type "
Norm types used in convergence testing. Not all solvers types
support all norm types (see
http://www.mcs.anl.gov/petsc/petsc-current/docs/manualpages/KSP/KSPSetNormType.html). Note
that 'default' is a reserved keyword, so we use 'default_norm'
";

%feature("docstring")  dolfin::PETScKrylovSolver::PETScKrylovSolver "
**Overloaded versions**

* PETScKrylovSolver\ (comm, method=\"default\", preconditioner=\"default\")

  Create Krylov solver for a particular method and named
  preconditioner

* PETScKrylovSolver\ (method=\"default\", preconditioner=\"default\")

  Create Krylov solver for a particular method and named
  preconditioner

* PETScKrylovSolver\ (comm, method, preconditioner)

  Create Krylov solver for a particular method and
  PETScPreconditioner (shared_ptr version)

* PETScKrylovSolver\ (method, preconditioner)

  Create Krylov solver for a particular method and
  PETScPreconditioner (shared_ptr version)

* PETScKrylovSolver\ (comm, method, preconditioner)

  Create Krylov solver for a particular method and
  PETScPreconditioner (shared_ptr version)

* PETScKrylovSolver\ (method, preconditioner)

  Create Krylov solver for a particular method and
  PETScPreconditioner (shared_ptr version)

* PETScKrylovSolver\ (ksp)

  Create solver wrapper of a PETSc KSP object
";

%feature("docstring")  dolfin::PETScKrylovSolver::set_operator "
Set operator (matrix)
";

%feature("docstring")  dolfin::PETScKrylovSolver::set_operators "
Set operator (matrix) and preconditioner matrix
";

%feature("docstring")  dolfin::PETScKrylovSolver::solve "
**Overloaded versions**

* solve\ (x, b)

  Solve linear system Ax = b and return number of iterations

* solve\ (x, b)

  Solve linear system Ax = b and return number of iterations

* solve\ (A, x, b)

  Solve linear system Ax = b and return number of iterations
";

%feature("docstring")  dolfin::PETScKrylovSolver::set_nonzero_guess "
Use nonzero intial guess for solution function
(nonzero_guess=true, the solution vector x will not be zeroed
before the solver starts)
";

%feature("docstring")  dolfin::PETScKrylovSolver::set_reuse_preconditioner "
Reuse preconditioner if true, even if matrix operator changes
(by default preconditioner will be re-built if the matrix
changes)
";

%feature("docstring")  dolfin::PETScKrylovSolver::set_tolerances "
Set tolerances (relative residual, alsolute residial, maximum
number of iterations)
";

%feature("docstring")  dolfin::PETScKrylovSolver::set_norm_type "
Set norm type used in convergence testing - not all solvers
types support all norm types
";

%feature("docstring")  dolfin::PETScKrylovSolver::get_norm_type "
Get norm type used in convergence testing
";

%feature("docstring")  dolfin::PETScKrylovSolver::monitor "
Monitor residual at each iteration
";

%feature("docstring")  dolfin::PETScKrylovSolver::set_options_prefix "
Sets the prefix used by PETSc when searching the PETSc options
database
";

%feature("docstring")  dolfin::PETScKrylovSolver::get_options_prefix "
Returns the prefix used by PETSc when searching the PETSc
options database
";

%feature("docstring")  dolfin::PETScKrylovSolver::set_from_options "
Set options from PETSc options database
";

%feature("docstring")  dolfin::PETScKrylovSolver::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::PETScKrylovSolver::mpi_comm "
Return MPI communicator
";

%feature("docstring")  dolfin::PETScKrylovSolver::ksp "
Return PETSc KSP pointer
";

%feature("docstring")  dolfin::PETScKrylovSolver::methods "
Return a list of available solver methods
";

%feature("docstring")  dolfin::PETScKrylovSolver::preconditioners "
Return a list of available named preconditioners
";

%feature("docstring")  dolfin::PETScKrylovSolver::default_parameters "
Default parameter values
";

%feature("docstring")  dolfin::PETScKrylovSolver::parameter_type "
Return parameter type: \"krylov_solver\" or \"lu_solver\"
";

// Documentation extracted from: (module=la, header=PETScLUSolver.h)
%feature("docstring")  dolfin::PETScLUSolver "
This class implements the direct solution (LU factorization) for
linear systems of the form Ax = b. It is a wrapper for the LU
solver of PETSc.
";

%feature("docstring")  dolfin::PETScLUSolver::PETScLUSolver "
**Overloaded versions**

* PETScLUSolver\ (comm, method=\"default\")

  Constructor

* PETScLUSolver\ (method=\"default\")

  Constructor

* PETScLUSolver\ (comm, A, method=\"default\")

  Constructor

* PETScLUSolver\ (A, method=\"default\")

  Constructor
";

%feature("docstring")  dolfin::PETScLUSolver::set_operator "
**Overloaded versions**

* set_operator\ (A)

  Set operator (matrix)

* set_operator\ (A)

  Set operator (matrix)
";

%feature("docstring")  dolfin::PETScLUSolver::get_operator "
Get operator (matrix)
";

%feature("docstring")  dolfin::PETScLUSolver::solve "
**Overloaded versions**

* solve\ (x, b)

  Solve linear system Ax = b

* solve\ (x, b, transpose)

  Solve linear system Ax = b

* solve\ (A, x, b)

  Solve linear system Ax = b

* solve\ (A, x, b)

  Solve linear system Ax = b
";

%feature("docstring")  dolfin::PETScLUSolver::solve_transpose "
**Overloaded versions**

* solve_transpose\ (x, b)

  Solve linear system A^Tx = b

* solve_transpose\ (A, x, b)

  Solve linear system A^Tx = b

* solve_transpose\ (A, x, b)

  Solve linear system A^Tx = b
";

%feature("docstring")  dolfin::PETScLUSolver::set_options_prefix "
Sets the prefix used by PETSc when searching the options
database
";

%feature("docstring")  dolfin::PETScLUSolver::get_options_prefix "
Returns the prefix used by PETSc when searching the options
database
";

%feature("docstring")  dolfin::PETScLUSolver::set_from_options "
Set options from the PETSc options database
";

%feature("docstring")  dolfin::PETScLUSolver::mpi_comm "
Returns the MPI communicator
";

%feature("docstring")  dolfin::PETScLUSolver::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::PETScLUSolver::ksp "
Return PETSc KSP pointer
";

%feature("docstring")  dolfin::PETScLUSolver::methods "
Return a list of available solver methods
";

%feature("docstring")  dolfin::PETScLUSolver::default_parameters "
Default parameter values
";

// Documentation extracted from: (module=la, header=BelosKrylovSolver.h)
%feature("docstring")  dolfin::BelosKrylovSolver "
This class implements Krylov methods for linear systems
of the form Ax = b. It is a wrapper for the Belos iterative solver
from Trilinos
";

%feature("docstring")  dolfin::BelosKrylovSolver::BelosKrylovSolver "
**Overloaded versions**

* BelosKrylovSolver\ (\"default\", \"default\")

  Create Krylov solver for a particular method and names
  preconditioner

* BelosKrylovSolver\ (method, preconditioner)

  Create Krylov solver for a particular method and TrilinosPreconditioner
";

%feature("docstring")  dolfin::BelosKrylovSolver::set_operator "
Set operator (matrix)
";

%feature("docstring")  dolfin::BelosKrylovSolver::set_operators "
Set operator (matrix) and preconditioner matrix
";

%feature("docstring")  dolfin::BelosKrylovSolver::get_operator "
Get operator (matrix)
";

%feature("docstring")  dolfin::BelosKrylovSolver::solve "
**Overloaded versions**

* solve\ (x, b)

  Solve linear system Ax = b and return number of iterations

* solve\ (A, x, b)

  Solve linear system Ax = b and return number of iterations
";

%feature("docstring")  dolfin::BelosKrylovSolver::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::BelosKrylovSolver::methods "
Return a list of available solver methods
";

%feature("docstring")  dolfin::BelosKrylovSolver::preconditioners "
Return a list of available preconditioners
";

%feature("docstring")  dolfin::BelosKrylovSolver::default_parameters "
Default parameter values
";

%feature("docstring")  dolfin::BelosKrylovSolver::parameter_type "
Return parameter type: \"krylov_solver\" or \"lu_solver\"
";

// Documentation extracted from: (module=la, header=TrilinosPreconditioner.h)
%feature("docstring")  dolfin::TrilinosPreconditioner "
This class provides a common base for Trilinos preconditioners.
";

// Documentation extracted from: (module=la, header=MueluPreconditioner.h)
%feature("docstring")  dolfin::MueluPreconditioner "
Implements Muelu preconditioner from Trilinos
";

%feature("docstring")  dolfin::MueluPreconditioner::MueluPreconditioner "
Create a particular preconditioner object
";

%feature("docstring")  dolfin::MueluPreconditioner::set "
Set the preconditioner on a solver
";

%feature("docstring")  dolfin::MueluPreconditioner::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::MueluPreconditioner::init "
Initialise preconditioner based on Operator P
";

%feature("docstring")  dolfin::MueluPreconditioner::default_parameters "
Default parameter values
";

// Documentation extracted from: (module=la, header=Ifpack2Preconditioner.h)
%feature("docstring")  dolfin::Ifpack2Preconditioner "
Implements preconditioners using Ifpack2 from Trilinos
";

%feature("docstring")  dolfin::Ifpack2Preconditioner::Ifpack2Preconditioner "
Create a particular preconditioner object
";

%feature("docstring")  dolfin::Ifpack2Preconditioner::set "
Set the preconditioner type on a solver
";

%feature("docstring")  dolfin::Ifpack2Preconditioner::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::Ifpack2Preconditioner::init "
Initialise preconditioner based on Operator P
";

%feature("docstring")  dolfin::Ifpack2Preconditioner::preconditioners "
Return a list of available preconditioners
";

%feature("docstring")  dolfin::Ifpack2Preconditioner::default_parameters "
Default parameter values
";

// Documentation extracted from: (module=la, header=CoordinateMatrix.h)
%feature("docstring")  dolfin::CoordinateMatrix "
Coordinate sparse matrix.
";

%feature("docstring")  dolfin::CoordinateMatrix::CoordinateMatrix "
Constructor
";

%feature("docstring")  dolfin::CoordinateMatrix::norm "
Return norm of matrix
";

// Documentation extracted from: (module=la, header=EigenVector.h)
%feature("docstring")  dolfin::EigenVector "
This class provides a simple vector class based on Eigen.
It is a simple wrapper for a Eigen vector implementing the
GenericVector interface.

The interface is intentionally simple. For advanced usage,
access the underlying Eigen vector and use the standard Eigen
interface which is documented at http://eigen.tuxfamily.org
";

%feature("docstring")  dolfin::EigenVector::EigenVector "
**Overloaded versions**

* EigenVector\ ()

  Create empty vector (on MPI_COMM_SELF)

* EigenVector\ (comm)

  Create empty vector

* EigenVector\ (comm, N)

  Create vector of size N

* EigenVector\ (x)

  Copy constructor

* EigenVector\ (x)

  Construct vector from an Eigen shared_ptr
";

%feature("docstring")  dolfin::EigenVector::zero "
Set all entries to zero and keep any sparse structure
";

%feature("docstring")  dolfin::EigenVector::apply "
Finalize assembly of tensor
";

%feature("docstring")  dolfin::EigenVector::mpi_comm "
Return MPI communicator
";

%feature("docstring")  dolfin::EigenVector::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::EigenVector::copy "
Create copy of tensor
";

%feature("docstring")  dolfin::EigenVector::init "
**Overloaded versions**

* init\ (comm, N)

  Initialize vector to size N

* init\ (comm, range)

  Resize vector with given ownership range

* init\ (comm, range, local_to_global_map, ghost_indices)

  Resize vector with given ownership range and with ghost values
";

%feature("docstring")  dolfin::EigenVector::empty "
Return true if vector is empty
";

%feature("docstring")  dolfin::EigenVector::size "
Return true if vector is empty
";

%feature("docstring")  dolfin::EigenVector::local_size "
Return local size of vector
";

%feature("docstring")  dolfin::EigenVector::local_range "
Return local ownership range of a vector
";

%feature("docstring")  dolfin::EigenVector::owns_index "
Determine whether global vector index is owned by this process
";

%feature("docstring")  dolfin::EigenVector::get "
Get block of values using global indices
";

%feature("docstring")  dolfin::EigenVector::get_local "
**Overloaded versions**

* get_local\ (block, m, rows)

  Get block of values using local indices

* get_local\ (values)

  Get all values on local process
";

%feature("docstring")  dolfin::EigenVector::set "
Set block of values using global indices
";

%feature("docstring")  dolfin::EigenVector::set_local "
**Overloaded versions**

* set_local\ (block, m, rows)

  Set block of values using local indices

* set_local\ (values)

  Set all values on local process
";

%feature("docstring")  dolfin::EigenVector::add "
Add block of values using global indices
";

%feature("docstring")  dolfin::EigenVector::add_local "
**Overloaded versions**

* add_local\ (block, m, rows)

  Add block of values using local indices

* add_local\ (values)

  Add values to each entry on local process
";

%feature("docstring")  dolfin::EigenVector::gather "
**Overloaded versions**

* gather\ (x, indices)

  Gather entries into local vector x

* gather\ (x, indices)

  Gather entries into x
";

%feature("docstring")  dolfin::EigenVector::gather_on_zero "
Gather all entries into x on process 0
";

%feature("docstring")  dolfin::EigenVector::axpy "
Add multiple of given vector (AXPY operation)
";

%feature("docstring")  dolfin::EigenVector::abs "
Replace all entries in the vector by their absolute values
";

%feature("docstring")  dolfin::EigenVector::inner "
Return inner product with given vector
";

%feature("docstring")  dolfin::EigenVector::norm "
Compute norm of vector
";

%feature("docstring")  dolfin::EigenVector::min "
Return minimum value of vector
";

%feature("docstring")  dolfin::EigenVector::max "
Return maximum value of vector
";

%feature("docstring")  dolfin::EigenVector::sum "
**Overloaded versions**

* sum\ ()

  Return sum of values of vector

* sum\ (rows)

  Return sum of selected rows in vector. Repeated entries are
  only summed once.
";

%feature("docstring")  dolfin::EigenVector::operator*= "
**Overloaded versions**

* operator*=\ (a)

  Multiply vector by given number

* operator*=\ (x)

  Multiply vector by another vector pointwise
";

%feature("docstring")  dolfin::EigenVector::operator/= "
Divide vector by given number
";

%feature("docstring")  dolfin::EigenVector::operator+= "
**Overloaded versions**

* operator+=\ (x)

  Add given vector

* operator+=\ (a)

  Add number to all components of a vector
";

%feature("docstring")  dolfin::EigenVector::operator-= "
**Overloaded versions**

* operator-=\ (x)

  Subtract given vector

* operator-=\ (a)

  Subtract number from all components of a vector
";

%feature("docstring")  dolfin::EigenVector::operator= "
**Overloaded versions**

* operator=\ (x)

  Assignment operator

* operator=\ (a)

  Assignment operator

* operator=\ (x)

  Assignment operator
";

%feature("docstring")  dolfin::EigenVector::factory "
Return linear algebra backend factory
";

%feature("docstring")  dolfin::EigenVector::resize "
Resize vector to size N
";

%feature("docstring")  dolfin::EigenVector::vec "
**Overloaded versions**

* vec\ ()

  Return reference to Eigen vector (const version)

* vec\ ()

  Return reference to Eigen vector (non-const version)
";

%feature("docstring")  dolfin::EigenVector::operator[] "
**Overloaded versions**

* operator[]\ (i)

  Access value of given entry (const version)

* operator[]\ (i)

  Access value of given entry (non-const version)
";

%feature("docstring")  dolfin::EigenVector::data "
**Overloaded versions**

* data\ ()

  Return pointer to underlying data

* data\ ()

  Return pointer to underlying data (const version)
";

// Documentation extracted from: (module=la, header=PETScVector.h)
%feature("docstring")  dolfin::PETScVector "
This class provides a simple vector class based on PETSc.
It is a simple wrapper for a PETSc vector pointer (Vec)
implementing the GenericVector interface.

The interface is intentionally simple. For advanced usage,
access the PETSc Vec pointer using the function vec() and
use the standard PETSc interface.
";

%feature("docstring")  dolfin::PETScVector::PETScVector "
**Overloaded versions**

* PETScVector\ ()

  Create empty vector (on MPI_COMM_WORLD)

* PETScVector\ (comm)

  Create empty vector on an MPI communicator

* PETScVector\ (comm, N)

  Create vector of size N

* PETScVector\ (sparsity_pattern)

  Create vector

* PETScVector\ (x)

  Copy constructor

* PETScVector\ (x)

  Create vector wrapper of PETSc Vec pointer. The reference
  counter of the Vec will be increased, and decreased upon
  destruction of this object.
";

%feature("docstring")  dolfin::PETScVector::zero "
Set all entries to zero and keep any sparse structure
";

%feature("docstring")  dolfin::PETScVector::apply "
Finalize assembly of tensor
";

%feature("docstring")  dolfin::PETScVector::mpi_comm "
Return MPI communicator
";

%feature("docstring")  dolfin::PETScVector::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::PETScVector::copy "
Return copy of vector
";

%feature("docstring")  dolfin::PETScVector::init "
**Overloaded versions**

* init\ (comm, N)

  Initialize vector to global size N

* init\ (comm, range)

  Initialize vector with given ownership range

* init\ (comm, range, local_to_global_map, ghost_indices)

  Initialize vector with given ownership range and with ghost
  values
";

%feature("docstring")  dolfin::PETScVector::empty "
Return true if vector is empty
";

%feature("docstring")  dolfin::PETScVector::size "
Return size of vector
";

%feature("docstring")  dolfin::PETScVector::local_size "
Return local size of vector
";

%feature("docstring")  dolfin::PETScVector::local_range "
Return ownership range of a vector
";

%feature("docstring")  dolfin::PETScVector::owns_index "
Determine whether global vector index is owned by this process
";

%feature("docstring")  dolfin::PETScVector::get "
Get block of values using global indices (all values must be
owned by local process, ghosts cannot be accessed)
";

%feature("docstring")  dolfin::PETScVector::get_local "
**Overloaded versions**

* get_local\ (block, m, rows)

  Get block of values using local indices

* get_local\ (values)

  Get all values on local process
";

%feature("docstring")  dolfin::PETScVector::set "
Set block of values using global indices
";

%feature("docstring")  dolfin::PETScVector::set_local "
**Overloaded versions**

* set_local\ (block, m, rows)

  Set block of values using local indices

* set_local\ (values)

  Set all values on local process
";

%feature("docstring")  dolfin::PETScVector::add "
Add block of values using global indices
";

%feature("docstring")  dolfin::PETScVector::add_local "
**Overloaded versions**

* add_local\ (block, m, rows)

  Add block of values using local indices

* add_local\ (values)

  Add values to each entry on local process
";

%feature("docstring")  dolfin::PETScVector::gather "
**Overloaded versions**

* gather\ (y, indices)

  Gather vector entries into a local vector

* gather\ (x, indices)

  Gather entries into x
";

%feature("docstring")  dolfin::PETScVector::gather_on_zero "
Gather all entries into x on process 0
";

%feature("docstring")  dolfin::PETScVector::axpy "
Add multiple of given vector (AXPY operation)
";

%feature("docstring")  dolfin::PETScVector::abs "
Replace all entries in the vector by their absolute values
";

%feature("docstring")  dolfin::PETScVector::inner "
Return inner product with given vector
";

%feature("docstring")  dolfin::PETScVector::norm "
Return norm of vector
";

%feature("docstring")  dolfin::PETScVector::min "
Return minimum value of vector
";

%feature("docstring")  dolfin::PETScVector::max "
Return maximum value of vector
";

%feature("docstring")  dolfin::PETScVector::sum "
**Overloaded versions**

* sum\ ()

  Return sum of values of vector

* sum\ (rows)

  Return sum of selected rows in vector
";

%feature("docstring")  dolfin::PETScVector::operator*= "
**Overloaded versions**

* operator*=\ (a)

  Multiply vector by given number

* operator*=\ (x)

  Multiply vector by another vector pointwise
";

%feature("docstring")  dolfin::PETScVector::operator/= "
Divide vector by given number
";

%feature("docstring")  dolfin::PETScVector::operator+= "
**Overloaded versions**

* operator+=\ (x)

  Add given vector

* operator+=\ (a)

  Add number to all components of a vector
";

%feature("docstring")  dolfin::PETScVector::operator-= "
**Overloaded versions**

* operator-=\ (x)

  Subtract given vector

* operator-=\ (a)

  Subtract number from all components of a vector
";

%feature("docstring")  dolfin::PETScVector::operator= "
**Overloaded versions**

* operator=\ (x)

  Assignment operator

* operator=\ (a)

  Assignment operator

* operator=\ (x)

  Assignment operator
";

%feature("docstring")  dolfin::PETScVector::factory "
Return linear algebra backend factory
";

%feature("docstring")  dolfin::PETScVector::set_options_prefix "
Sets the prefix used by PETSc when searching the options
database
";

%feature("docstring")  dolfin::PETScVector::get_options_prefix "
Returns the prefix used by PETSc when searching the options
database
";

%feature("docstring")  dolfin::PETScVector::set_from_options "
Call PETSc function VecSetFromOptions on the underlying Vec
object
";

%feature("docstring")  dolfin::PETScVector::vec "
Return pointer to PETSc Vec object
";

%feature("docstring")  dolfin::PETScVector::reset "
Switch underlying PETSc object. Intended for internal library
usage.
";

// Documentation extracted from: (module=la, header=TpetraVector.h)
%feature("docstring")  dolfin::TpetraVector "
This class provides a simple vector class based on Tpetra.  It
is a wrapper for Teuchos::RCP<Tpetra::MultiVector> implementing
the GenericVector interface.

The interface is intentionally simple. For advanced usage,
access the Teuchos::RCP<Tpetra::MultiVector> using the function
vec() and use the standard Tpetra interface.
";

%feature("docstring")  dolfin::TpetraVector::TpetraVector "
**Overloaded versions**

* TpetraVector\ (comm=MPI_COMM_WORLD)

  Create empty vector

* TpetraVector\ (comm, N)

  Create vector of size N

* TpetraVector\ (x)

  Copy constructor
";

%feature("docstring")  dolfin::TpetraVector::zero "
Set all entries to zero and keep any sparse structure
";

%feature("docstring")  dolfin::TpetraVector::apply "
Finalize assembly of tensor
";

%feature("docstring")  dolfin::TpetraVector::mpi_comm "
Return MPI communicator
";

%feature("docstring")  dolfin::TpetraVector::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::TpetraVector::copy "
Return copy of vector
";

%feature("docstring")  dolfin::TpetraVector::init "
**Overloaded versions**

* init\ (comm, N)

  Initialize vector to global size N

* init\ (comm, range)

  Initialize vector with given ownership range

* init\ (comm, range, local_to_global_map, ghost_indices)

  Initialize vector with given ownership range and with ghost
  values
";

%feature("docstring")  dolfin::TpetraVector::empty "
Return true if vector is empty
";

%feature("docstring")  dolfin::TpetraVector::size "
Return size of vector
";

%feature("docstring")  dolfin::TpetraVector::local_size "
Return local size of vector
";

%feature("docstring")  dolfin::TpetraVector::local_range "
Return ownership range of a vector
";

%feature("docstring")  dolfin::TpetraVector::owns_index "
Determine whether global vector index is owned by this process
";

%feature("docstring")  dolfin::TpetraVector::get "
Get block of values using global indices (all values must be
owned by local process, ghosts cannot be accessed)
";

%feature("docstring")  dolfin::TpetraVector::get_local "
**Overloaded versions**

* get_local\ (block, m, rows)

  Get block of values using local indices

* get_local\ (values)

  Get all values on local process
";

%feature("docstring")  dolfin::TpetraVector::set "
Set block of values using global indices
";

%feature("docstring")  dolfin::TpetraVector::set_local "
**Overloaded versions**

* set_local\ (block, m, rows)

  Set block of values using local indices

* set_local\ (values)

  Set all values on local process
";

%feature("docstring")  dolfin::TpetraVector::add "
Add block of values using global indices
";

%feature("docstring")  dolfin::TpetraVector::add_local "
**Overloaded versions**

* add_local\ (block, m, rows)

  Add block of values using local indices

* add_local\ (values)

  Add values to each entry on local process
";

%feature("docstring")  dolfin::TpetraVector::gather "
**Overloaded versions**

* gather\ (y, indices)

  Gather vector entries into a local vector

* gather\ (x, indices)

  Gather entries into x
";

%feature("docstring")  dolfin::TpetraVector::gather_on_zero "
Gather all entries into x on process 0
";

%feature("docstring")  dolfin::TpetraVector::axpy "
Add multiple of given vector (AXPY operation)
";

%feature("docstring")  dolfin::TpetraVector::abs "
Replace all entries in the vector by their absolute values
";

%feature("docstring")  dolfin::TpetraVector::inner "
Return inner product with given vector
";

%feature("docstring")  dolfin::TpetraVector::norm "
Return norm of vector
";

%feature("docstring")  dolfin::TpetraVector::min "
Return minimum value of vector
";

%feature("docstring")  dolfin::TpetraVector::max "
Return maximum value of vector
";

%feature("docstring")  dolfin::TpetraVector::sum "
**Overloaded versions**

* sum\ ()

  Return sum of values of vector

* sum\ (rows)

  Return sum of selected rows in vector
";

%feature("docstring")  dolfin::TpetraVector::operator*= "
**Overloaded versions**

* operator*=\ (a)

  Multiply vector by given number

* operator*=\ (x)

  Multiply vector by another vector pointwise
";

%feature("docstring")  dolfin::TpetraVector::operator/= "
Divide vector by given number
";

%feature("docstring")  dolfin::TpetraVector::operator+= "
**Overloaded versions**

* operator+=\ (x)

  Add given vector

* operator+=\ (a)

  Add number to all components of a vector
";

%feature("docstring")  dolfin::TpetraVector::operator-= "
**Overloaded versions**

* operator-=\ (x)

  Subtract given vector

* operator-=\ (a)

  Subtract number from all components of a vector
";

%feature("docstring")  dolfin::TpetraVector::operator= "
**Overloaded versions**

* operator=\ (x)

  Assignment operator

* operator=\ (a)

  Assignment operator

* operator=\ (x)

  Assignment operator
";

%feature("docstring")  dolfin::TpetraVector::factory "
Return linear algebra backend factory
";

%feature("docstring")  dolfin::TpetraVector::vec "
Return pointer to Tpetra vector object
";

%feature("docstring")  dolfin::TpetraVector::mapdump "
output map
";

// Documentation extracted from: (module=la, header=TensorLayout.h)
%feature("docstring")  dolfin::TensorLayout "
This class described the size and possibly the sparsity of a
(sparse) tensor. It is used by the linear algebra backends to
initialise tensors.
";

%feature("docstring")  dolfin::TensorLayout::TensorLayout "
**Overloaded versions**

* TensorLayout\ (primary_dim, sparsity_pattern)

  Create empty tensor layout

* TensorLayout\ (mpi_comm, index_maps, primary_dim, sparsity_pattern, ghosted)

  Create a tensor layout
";

%feature("docstring")  dolfin::TensorLayout::init "
Initialize tensor layout
";

%feature("docstring")  dolfin::TensorLayout::rank "
Return rank
";

%feature("docstring")  dolfin::TensorLayout::size "
Return global size for dimension i (size of tensor, includes
non-zeroes)
";

%feature("docstring")  dolfin::TensorLayout::local_range "
Return local range for dimension dim
";

%feature("docstring")  dolfin::TensorLayout::sparsity_pattern "
**Overloaded versions**

* sparsity_pattern\ ()

  Return sparsity pattern (possibly null)

* sparsity_pattern\ ()

  Return sparsity pattern (possibly null), const version
";

%feature("docstring")  dolfin::TensorLayout::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::TensorLayout::mpi_comm "
Return MPI communicator
";

%feature("docstring")  dolfin::TensorLayout::index_map "
Return IndexMap for dimension
";

%feature("docstring")  dolfin::TensorLayout::is_ghosted "
Require ghosts
";

// Documentation extracted from: (module=la, header=SparsityPattern.h)
%feature("docstring")  dolfin::SparsityPattern "
This class implements a sparsity pattern data structure.  It is
used by most linear algebra backends.
";

%feature("docstring")  dolfin::SparsityPattern::SparsityPattern "
**Overloaded versions**

* SparsityPattern\ (primary_dim)

  Create empty sparsity pattern

* SparsityPattern\ (mpi_comm, index_maps, primary_dim)

  Create sparsity pattern for a generic tensor
";

%feature("docstring")  dolfin::SparsityPattern::init "
Initialize sparsity pattern for a generic tensor
";

%feature("docstring")  dolfin::SparsityPattern::insert_global "
**Overloaded versions**

* insert_global\ (i, j)

  Insert a global entry - will be fixed by apply()

* insert_global\ (entries)

  Insert non-zero entries using global indices
";

%feature("docstring")  dolfin::SparsityPattern::insert_local "
Insert non-zero entries using local (process-wise) indices
";

%feature("docstring")  dolfin::SparsityPattern::insert_full_rows_local "
Insert full rows (or columns, according to primary dimension)
using local (process-wise) indices. This must be called before
any other sparse insertion occurs to avoid quadratic complexity
of dense rows insertion
";

%feature("docstring")  dolfin::SparsityPattern::rank "
Return rank
";

%feature("docstring")  dolfin::SparsityPattern::primary_dim "
Return primary dimension (e.g., 0=row partition, 1=column
partition)
";

%feature("docstring")  dolfin::SparsityPattern::local_range "
Return local range for dimension dim
";

%feature("docstring")  dolfin::SparsityPattern::num_nonzeros "
Return number of local nonzeros
";

%feature("docstring")  dolfin::SparsityPattern::num_nonzeros_diagonal "
Fill array with number of nonzeros for diagonal block in
local_range for dimension 0. For matrices, fill array with
number of nonzeros per local row for diagonal block
";

%feature("docstring")  dolfin::SparsityPattern::num_nonzeros_off_diagonal "
Fill array with number of nonzeros for off-diagonal block in
local_range for dimension 0. For matrices, fill array with
number of nonzeros per local row for off-diagonal block. If
there is no off-diagonal pattern, the vector is resized to
zero-length
";

%feature("docstring")  dolfin::SparsityPattern::num_local_nonzeros "
Fill vector with number of nonzeros in local_range for
dimension 0
";

%feature("docstring")  dolfin::SparsityPattern::apply "
Finalize sparsity pattern
";

%feature("docstring")  dolfin::SparsityPattern::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::SparsityPattern::diagonal_pattern "
Return underlying sparsity pattern (diagonal). Options are
'sorted' and 'unsorted'.
";

%feature("docstring")  dolfin::SparsityPattern::off_diagonal_pattern "
Return underlying sparsity pattern (off-diagonal). Options are
'sorted' and 'unsorted'. Empty vector is returned if there is no
off-diagonal contribution.
";

// Documentation extracted from: (module=la, header=IndexMap.h)
%feature("docstring")  dolfin::IndexMap "
This class represents the distribution index arrays across
processes. An index array is a contiguous collection of N+1
indices [0, 1, . . ., N] that are distributed across processes M
processes. On a given process, the IndexMap stores a portion of
the index set using local indices [0, 1, . . . , n], and a map
from the local indices to a unique global index.
";

%feature("docstring")  dolfin::MapSize::IndexMap "
**Overloaded versions**

* IndexMap\ ()

  Constructor

* IndexMap\ (mpi_comm)

  Index map with no data

* IndexMap\ (mpi_comm, local_size, block_size)

  Index map with local size on each process. This constructor
  is collective
";

%feature("docstring")  dolfin::MapSize::init "
Initialise with number of local entries and block size. This
function is collective
";

%feature("docstring")  dolfin::MapSize::local_range "
Local range of indices
";

%feature("docstring")  dolfin::MapSize::size "
Get number of local indices of type MapSize::OWNED,
MapSize::UNOWNED, MapSize::ALL or MapSize::GLOBAL
";

%feature("docstring")  dolfin::MapSize::local_to_global_unowned "
Get local to global map for unowned indices
(local indexing beyond end of local range)
";

%feature("docstring")  dolfin::MapSize::local_to_global "
Get global index of local index i
";

%feature("docstring")  dolfin::MapSize::set_local_to_global "
Set local_to_global map for unowned indices (beyond end of local
range). Computes and stores off-process owner array.
";

%feature("docstring")  dolfin::MapSize::off_process_owner "
Get off process owner for unowned indices
";

%feature("docstring")  dolfin::MapSize::block_size "
Get block size
";

%feature("docstring")  dolfin::MapSize::mpi_comm "
Return MPI communicator
";

// Documentation extracted from: (module=la, header=GenericLinearAlgebraFactory.h)
%feature("docstring")  dolfin::GenericLinearAlgebraFactory::GenericLinearAlgebraFactory "
Constructor
";

%feature("docstring")  dolfin::GenericLinearAlgebraFactory::create_matrix "
Create empty matrix
";

%feature("docstring")  dolfin::GenericLinearAlgebraFactory::create_vector "
Create empty vector
";

%feature("docstring")  dolfin::GenericLinearAlgebraFactory::create_layout "
Create empty tensor layout
";

%feature("docstring")  dolfin::GenericLinearAlgebraFactory::create_linear_operator "
Create empty linear operator
";

%feature("docstring")  dolfin::GenericLinearAlgebraFactory::create_lu_solver "
Create LU solver
";

%feature("docstring")  dolfin::GenericLinearAlgebraFactory::create_krylov_solver "
Create Krylov solver
";

%feature("docstring")  dolfin::GenericLinearAlgebraFactory::lu_solver_methods "
Return a list of available LU solver methods.  This function
should be overloaded by subclass if non-empty.
";

%feature("docstring")  dolfin::GenericLinearAlgebraFactory::krylov_solver_methods "
Return a list of available Krylov solver methods.  This
function should be overloaded by subclass if non-empty.
";

%feature("docstring")  dolfin::GenericLinearAlgebraFactory::krylov_solver_preconditioners "
Return a list of available preconditioners.
This function should be overloaded by subclass if non-empty.
";

// Documentation extracted from: (module=la, header=DefaultFactory.h)
%feature("docstring")  dolfin::DefaultFactory::DefaultFactory "
Constructor
";

%feature("docstring")  dolfin::DefaultFactory::create_matrix "
Create empty matrix
";

%feature("docstring")  dolfin::DefaultFactory::create_vector "
Create empty vector
";

%feature("docstring")  dolfin::DefaultFactory::create_layout "
Create empty tensor layout
";

%feature("docstring")  dolfin::DefaultFactory::create_linear_operator "
Create empty linear operator
";

%feature("docstring")  dolfin::DefaultFactory::create_lu_solver "
Create LU solver
";

%feature("docstring")  dolfin::DefaultFactory::create_krylov_solver "
Create Krylov solver
";

%feature("docstring")  dolfin::DefaultFactory::lu_solver_methods "
Return a list of available LU solver methods
";

%feature("docstring")  dolfin::DefaultFactory::krylov_solver_methods "
Return a list of available Krylov solver methods
";

%feature("docstring")  dolfin::DefaultFactory::krylov_solver_preconditioners "
Return a list of available preconditioners
";

%feature("docstring")  dolfin::DefaultFactory::factory "
Return instance of default backend
";

// Documentation extracted from: (module=la, header=EigenFactory.h)
%feature("docstring")  dolfin::EigenFactory::create_matrix "
Create empty matrix
";

%feature("docstring")  dolfin::EigenFactory::create_vector "
Create empty vector
";

%feature("docstring")  dolfin::EigenFactory::create_layout "
Create empty tensor layout
";

%feature("docstring")  dolfin::EigenFactory::create_linear_operator "
Create empty linear operator
";

%feature("docstring")  dolfin::EigenFactory::create_lu_solver "
Create LU solver
";

%feature("docstring")  dolfin::EigenFactory::create_krylov_solver "
Create Krylov solver
";

%feature("docstring")  dolfin::EigenFactory::lu_solver_methods "
Return a list of available LU solver methods
";

%feature("docstring")  dolfin::EigenFactory::krylov_solver_methods "
Return a list of available Krylov solver methods
";

%feature("docstring")  dolfin::EigenFactory::krylov_solver_preconditioners "
Return a list of available preconditioners
";

%feature("docstring")  dolfin::EigenFactory::instance "
Return singleton instance
";

// Documentation extracted from: (module=la, header=PETScUserPreconditioner.h)
%feature("docstring")  dolfin::PETScUserPreconditioner "
This class specifies the interface for user-defined Krylov
method PETScPreconditioners. A user wishing to implement her own
PETScPreconditioner needs only supply a function that approximately
solves the linear system given a right-hand side.
";

%feature("docstring")  dolfin::PETScUserPreconditioner::PETScUserPreconditioner "
Constructor
";

%feature("docstring")  dolfin::PETScUserPreconditioner::solve "
Solve linear system approximately for given right-hand side b
";

// Documentation extracted from: (module=la, header=PETScFactory.h)
%feature("docstring")  dolfin::PETScFactory::create_matrix "
Create empty matrix
";

%feature("docstring")  dolfin::PETScFactory::create_vector "
Create empty vector
";

%feature("docstring")  dolfin::PETScFactory::create_layout "
Create empty tensor layout
";

%feature("docstring")  dolfin::PETScFactory::create_linear_operator "
Create empty linear operator
";

%feature("docstring")  dolfin::PETScFactory::create_lu_solver "
Create LU solver
";

%feature("docstring")  dolfin::PETScFactory::create_krylov_solver "
Create Krylov solver
";

%feature("docstring")  dolfin::PETScFactory::lu_solver_methods "
Return a list of available LU solver methods
";

%feature("docstring")  dolfin::PETScFactory::krylov_solver_methods "
Return a list of available Krylov solver methods
";

%feature("docstring")  dolfin::PETScFactory::krylov_solver_preconditioners "
Return a list of available preconditioners
";

%feature("docstring")  dolfin::PETScFactory::instance "
Return singleton instance
";

%feature("docstring")  dolfin::PETScFactory::PETScFactory "
Private constructor
";

// Documentation extracted from: (module=la, header=TpetraFactory.h)
%feature("docstring")  dolfin::TpetraFactory::create_matrix "
Create empty matrix
";

%feature("docstring")  dolfin::TpetraFactory::create_vector "
Create empty vector
";

%feature("docstring")  dolfin::TpetraFactory::create_layout "
Create empty tensor layout
";

%feature("docstring")  dolfin::TpetraFactory::create_linear_operator "
Create empty linear operator
";

%feature("docstring")  dolfin::TpetraFactory::create_lu_solver "
Create LU solver
";

%feature("docstring")  dolfin::TpetraFactory::create_krylov_solver "
Create Krylov solver
";

%feature("docstring")  dolfin::TpetraFactory::lu_solver_methods "
Return a list of available LU solver methods
";

%feature("docstring")  dolfin::TpetraFactory::krylov_solver_methods "
Return a list of available Krylov solver methods
";

%feature("docstring")  dolfin::TpetraFactory::krylov_solver_preconditioners "
Return a list of available preconditioners
";

%feature("docstring")  dolfin::TpetraFactory::instance "
Return singleton instance
";

%feature("docstring")  dolfin::TpetraFactory::TpetraFactory "
Private constructor
";

// Documentation extracted from: (module=la, header=SLEPcEigenSolver.h)
%feature("docstring")  dolfin::SLEPcEigenSolver "
This class provides an eigenvalue solver for PETSc matrices. It
is a wrapper for the SLEPc eigenvalue solver.

The following parameters may be specified to control the solver.

1. \"spectrum\"

This parameter controls which part of the spectrum to compute.
Possible values are

  \"largest magnitude\"   (eigenvalues with largest magnitude)
  \"smallest magnitude\"  (eigenvalues with smallest magnitude)
  \"largest real\"        (eigenvalues with largest double part)
  \"smallest real\"       (eigenvalues with smallest double part)
  \"largest imaginary\"   (eigenvalues with largest imaginary part)
  \"smallest imaginary\"  (eigenvalues with smallest imaginary part)
  \"target magnitude\"    (eigenvalues closest to target in magnitude)
  \"target real\"         (eigenvalues closest to target in real part)
  \"target imaginary\"    (eigenvalues closest to target in imaginary part)

2. \"solver\"

This parameter controls which algorithm is used by SLEPc.
Possible values are

  \"power\"               (power iteration)
  \"subspace\"            (subspace iteration)
  \"arnoldi\"             (Arnoldi)
  \"lanczos\"             (Lanczos)
  \"krylov-schur\"        (Krylov-Schur)
  \"lapack\"              (LAPACK, all values, direct, small systems only)
  \"arpack\"              (ARPACK)

3. \"tolerance\"

This parameter controls the tolerance used by SLEPc.  Possible
values are positive double numbers.

4. \"maximum_iterations\"

This parameter controls the maximum number of iterations used by SLEPc.
Possible values are positive integers.

Note that both the tolerance and the number of iterations must be
specified if either one is specified.

5. \"problem_type\"

This parameter can be used to give extra information about the
type of the eigenvalue problem. Some solver types require this
extra piece of information. Possible values are:

  \"hermitian\"               (Hermitian)
  \"non_hermitian\"           (Non-Hermitian)
  \"gen_hermitian\"           (Generalized Hermitian)
  \"gen_non_hermitian\"       (Generalized Non-Hermitian)
  \"pos_gen_non_hermitian\"   (Generalized Non-Hermitian with positive semidefinite B)

6. \"spectral_transform\"

This parameter controls the application of a spectral
transform. A spectral transform can be used to enhance the
convergence of the eigensolver and in particular to only compute
eigenvalues in the interior of the spectrum. Possible values
are:

  \"shift-and-invert\"      (A shift-and-invert transform)

Note that if a spectral transform is given, then also a non-zero
spectral shift parameter has to be provided.

The default is no spectral transform.

7. \"spectral_shift\"

This parameter controls the spectral shift used by the spectral
transform and must be provided if a spectral transform is
given. The possible values are real numbers.
";

%feature("docstring")  dolfin::SLEPcEigenSolver::SLEPcEigenSolver "
**Overloaded versions**

* SLEPcEigenSolver\ (comm)

  Create eigenvalue solver

* SLEPcEigenSolver\ (eps)

  Create eigenvalue solver from EPS object

* SLEPcEigenSolver\ (A)

  Create eigenvalue solver for Ax = \lambda

* SLEPcEigenSolver\ (comm, A)

  Create eigenvalue solver for Ax = \lambda x

* SLEPcEigenSolver\ (A, B)

  Create eigenvalue solver for Ax = \lambda x on MPI_COMM_WORLD

* SLEPcEigenSolver\ (comm, A, B)

  Create eigenvalue solver for Ax = \lambda x
";

%feature("docstring")  dolfin::SLEPcEigenSolver::set_operators "
Set opeartors (B may be nullptr for regular eigenvalues
problems)
";

%feature("docstring")  dolfin::SLEPcEigenSolver::solve "
**Overloaded versions**

* solve\ ()

  Compute all eigenpairs of the matrix A (solve Ax = \lambda x)

* solve\ (n)

  Compute the n first eigenpairs of the matrix A (solve Ax = \lambda x)
";

%feature("docstring")  dolfin::SLEPcEigenSolver::get_eigenvalue "
**Overloaded versions**

* get_eigenvalue\ (lr, lc)

  Get the first eigenvalue

* get_eigenvalue\ (lr, lc, i)

  Get eigenvalue i
";

%feature("docstring")  dolfin::SLEPcEigenSolver::get_eigenpair "
**Overloaded versions**

* get_eigenpair\ (lr, lc, r, c)

  Get the first eigenpair

* get_eigenpair\ (lr, lc, r, c)

  Get the first eigenpair

* get_eigenpair\ (lr, lc, r, c, i)

  Get eigenpair i

* get_eigenpair\ (lr, lc, r, c, i)

  Get eigenpair i
";

%feature("docstring")  dolfin::SLEPcEigenSolver::get_iteration_number "
Get the number of iterations used by the solver
";

%feature("docstring")  dolfin::SLEPcEigenSolver::get_number_converged "
Get the number of converged eigenvalues
";

%feature("docstring")  dolfin::SLEPcEigenSolver::set_deflation_space "
Set deflation space
";

%feature("docstring")  dolfin::SLEPcEigenSolver::set_options_prefix "
Sets the prefix used by PETSc when searching the PETSc options
database
";

%feature("docstring")  dolfin::SLEPcEigenSolver::get_options_prefix "
Returns the prefix used by PETSc when searching the PETSc
options database
";

%feature("docstring")  dolfin::SLEPcEigenSolver::eps "
Return SLEPc EPS pointer
";

%feature("docstring")  dolfin::SLEPcEigenSolver::default_parameters "
Default parameter values
";

%feature("docstring")  dolfin::SLEPcEigenSolver::read_parameters "
Callback for changes in parameter values
";

// Documentation extracted from: (module=la, header=Vector.h)
%feature("docstring")  dolfin::Vector "
This class provides the default DOLFIN vector class,
based on the default DOLFIN linear algebra backend.
";

%feature("docstring")  dolfin::Vector::Vector "
**Overloaded versions**

* Vector\ (comm=MPI_COMM_WORLD)

  Create empty vector

* Vector\ (comm, N)

  Create vector of size N

* Vector\ (x)

  Copy constructor

* Vector\ (x)

  Create a Vector from a GenericVector
";

%feature("docstring")  dolfin::Vector::copy "
Return copy of vector
";

%feature("docstring")  dolfin::Vector::zero "
Set all entries to zero and keep any sparse structure
";

%feature("docstring")  dolfin::Vector::apply "
Finalize assembly of tensor
";

%feature("docstring")  dolfin::Vector::mpi_comm "
Return MPI communicator
";

%feature("docstring")  dolfin::Vector::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::Vector::init "
**Overloaded versions**

* init\ (comm, N)

  Initialize vector to size N

* init\ (comm, range)

  Initialize vector with given ownership range

* init\ (comm, range, local_to_global_map, ghost_indices)

  Initialize vector with given ownership range and with ghost
  values
";

%feature("docstring")  dolfin::Vector::empty "
Return true if vector is empty
";

%feature("docstring")  dolfin::Vector::size "
Return size of vector
";

%feature("docstring")  dolfin::Vector::local_size "
Return local size of vector
";

%feature("docstring")  dolfin::Vector::local_range "
Return local ownership range of a vector
";

%feature("docstring")  dolfin::Vector::owns_index "
Determine whether global vector index is owned by this process
";

%feature("docstring")  dolfin::Vector::get "
Get block of values using global indices (values must all live
on the local process, ghosts are no accessible)
";

%feature("docstring")  dolfin::Vector::get_local "
**Overloaded versions**

* get_local\ (block, m, rows)

  Get block of values using local indices (values must all live
  on the local process)

* get_local\ (values)

  Get all values on local process
";

%feature("docstring")  dolfin::Vector::set "
Set block of values using global indices
";

%feature("docstring")  dolfin::Vector::set_local "
**Overloaded versions**

* set_local\ (block, m, rows)

  Set block of values using local indices

* set_local\ (values)

  Set all values on local process
";

%feature("docstring")  dolfin::Vector::add "
Add block of values using global indices
";

%feature("docstring")  dolfin::Vector::add_local "
**Overloaded versions**

* add_local\ (block, m, rows)

  Add block of values using local indices

* add_local\ (values)

  Add values to each entry on local process
";

%feature("docstring")  dolfin::Vector::gather "
**Overloaded versions**

* gather\ (x, indices)

  Gather entries into local vector x

* gather\ (x, indices)

  Gather entries into x
";

%feature("docstring")  dolfin::Vector::gather_on_zero "
Gather all entries into x on process 0
";

%feature("docstring")  dolfin::Vector::axpy "
Add multiple of given vector (AXPY operation)
";

%feature("docstring")  dolfin::Vector::abs "
Replace all entries in the vector by their absolute values
";

%feature("docstring")  dolfin::Vector::inner "
Return inner product with given vector
";

%feature("docstring")  dolfin::Vector::norm "
Return norm of vector
";

%feature("docstring")  dolfin::Vector::min "
Return minimum value of vector
";

%feature("docstring")  dolfin::Vector::max "
Return maximum value of vector
";

%feature("docstring")  dolfin::Vector::sum "
Return sum of values of vector
";

%feature("docstring")  dolfin::Vector::operator*= "
**Overloaded versions**

* operator*=\ (a)

  Multiply vector by given number

* operator*=\ (x)

  Multiply vector by another vector pointwise
";

%feature("docstring")  dolfin::Vector::operator/= "
Divide vector by given number
";

%feature("docstring")  dolfin::Vector::operator+= "
**Overloaded versions**

* operator+=\ (x)

  Add given vector

* operator+=\ (a)

  Add number to all components of a vector
";

%feature("docstring")  dolfin::Vector::operator-= "
**Overloaded versions**

* operator-=\ (x)

  Subtract given vector

* operator-=\ (a)

  Subtract number from all components of a vector
";

%feature("docstring")  dolfin::Vector::operator= "
**Overloaded versions**

* operator=\ (x)

  Assignment operator

* operator=\ (a)

  Assignment operator

* operator=\ (x)

  Assignment operator
";

%feature("docstring")  dolfin::Vector::factory "
Return linear algebra backend factory
";

%feature("docstring")  dolfin::Vector::instance "
**Overloaded versions**

* instance\ ()

  Return concrete instance / unwrap (const version)

* instance\ ()

  Return concrete instance / unwrap (non-const version)
";

// Documentation extracted from: (module=la, header=Matrix.h)
%feature("docstring")  dolfin::Matrix "
This class provides the default DOLFIN matrix class,
based on the default DOLFIN linear algebra backend.
";

%feature("docstring")  dolfin::Matrix::Matrix "
**Overloaded versions**

* Matrix\ (comm=MPI_COMM_WORLD)

  Create empty matrix

* Matrix\ (A)

  Copy constructor

* Matrix\ (A)

  Create a Vector from a GenericVector
";

%feature("docstring")  dolfin::Matrix::init "
Initialize zero tensor using tensor layout
";

%feature("docstring")  dolfin::Matrix::empty "
Return true if matrix is empty
";

%feature("docstring")  dolfin::Matrix::size "
Return size of given dimension
";

%feature("docstring")  dolfin::Matrix::local_range "
Return local ownership range
";

%feature("docstring")  dolfin::Matrix::nnz "
Return number of non-zero entries in matrix (collective)
";

%feature("docstring")  dolfin::Matrix::zero "
**Overloaded versions**

* zero\ ()

  Set all entries to zero and keep any sparse structure

* zero\ (m, rows)

  Set given rows to zero
";

%feature("docstring")  dolfin::Matrix::apply "
Finalize assembly of tensor
";

%feature("docstring")  dolfin::Matrix::mpi_comm "
Return MPI communicator
";

%feature("docstring")  dolfin::Matrix::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::Matrix::copy "
Return copy of matrix
";

%feature("docstring")  dolfin::Matrix::init_vector "
Resize vector y such that is it compatible with matrix for
multiplication Ax = b (dim = 0 -> b, dim = 1 -> x) In parallel
case, size and layout are important.
";

%feature("docstring")  dolfin::Matrix::get "
Get block of values
";

%feature("docstring")  dolfin::Matrix::set "
Set block of values using global indices
";

%feature("docstring")  dolfin::Matrix::set_local "
Set block of values using local indices
";

%feature("docstring")  dolfin::Matrix::add "
Add block of values using global indices
";

%feature("docstring")  dolfin::Matrix::add_local "
Add block of values using local indices
";

%feature("docstring")  dolfin::Matrix::axpy "
Add multiple of given matrix (AXPY operation)
";

%feature("docstring")  dolfin::Matrix::norm "
Return norm of matrix
";

%feature("docstring")  dolfin::Matrix::getrow "
Get non-zero values of given row
";

%feature("docstring")  dolfin::Matrix::setrow "
Set values for given row
";

%feature("docstring")  dolfin::Matrix::zero_local "
Set given rows (local row indices) to zero
";

%feature("docstring")  dolfin::Matrix::ident "
Set given rows (global row indices) to identity matrix
";

%feature("docstring")  dolfin::Matrix::ident_local "
Set given rows (local row indices) to identity matrix
";

%feature("docstring")  dolfin::Matrix::get_diagonal "
Get diagonal of a matrix
";

%feature("docstring")  dolfin::Matrix::set_diagonal "
Set diagonal of a matrix
";

%feature("docstring")  dolfin::Matrix::operator*= "
Multiply matrix by given number
";

%feature("docstring")  dolfin::Matrix::operator/= "
Divide matrix by given number
";

%feature("docstring")  dolfin::Matrix::operator= "
**Overloaded versions**

* operator=\ (A)

  Assignment operator

* operator=\ (A)

  Assignment operator
";

%feature("docstring")  dolfin::Matrix::is_symmetric "
Test if matrix is symmetric
";

%feature("docstring")  dolfin::Matrix::factory "
Return linear algebra backend factory
";

%feature("docstring")  dolfin::Matrix::instance "
**Overloaded versions**

* instance\ ()

  Return concrete instance / unwrap (const version)

* instance\ ()

  Return concrete instance / unwrap (non-const version)
";

// Documentation extracted from: (module=la, header=Scalar.h)
%feature("docstring")  dolfin::Scalar "
This class represents a real-valued scalar quantity and
implements the GenericTensor interface for scalars.
";

%feature("docstring")  dolfin::Scalar::Scalar "
**Overloaded versions**

* Scalar\ ()

  Create zero scalar

* Scalar\ (comm)

  Create zero scalar
";

%feature("docstring")  dolfin::Scalar::init "
Initialize zero tensor using sparsity pattern
";

%feature("docstring")  dolfin::Scalar::empty "
Return true if empty
";

%feature("docstring")  dolfin::Scalar::rank "
Return tensor rank (number of dimensions)
";

%feature("docstring")  dolfin::Scalar::size "
Return size of given dimension
";

%feature("docstring")  dolfin::Scalar::local_range "
Return local ownership range
";

%feature("docstring")  dolfin::Scalar::get "
Get block of values
";

%feature("docstring")  dolfin::Scalar::set "
Set block of values using global indices
";

%feature("docstring")  dolfin::Scalar::set_local "
Set block of values using local indices
";

%feature("docstring")  dolfin::Scalar::add "
**Overloaded versions**

* add\ (block, num_rows, rows)

  Add block of values using global indices

* add\ (block, rows)

  Add block of values using global indices
";

%feature("docstring")  dolfin::Scalar::add_local "
**Overloaded versions**

* add_local\ (block, num_rows, rows)

  Add block of values using local indices

* add_local\ (block, rows)

  Add block of values using local indices
";

%feature("docstring")  dolfin::Scalar::zero "
Set all entries to zero and keep any sparse structure
";

%feature("docstring")  dolfin::Scalar::apply "
Finalize assembly of tensor
";

%feature("docstring")  dolfin::Scalar::mpi_comm "
Return MPI communicator
";

%feature("docstring")  dolfin::Scalar::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::Scalar::copy "
Return copy of scalar
";

%feature("docstring")  dolfin::Scalar::factory "
Return a factory for the default linear algebra backend
";

%feature("docstring")  dolfin::Scalar::get_scalar_value "
Get final value (assumes prior apply(), not part of
GenericTensor interface)
";

%feature("docstring")  dolfin::Scalar::add_local_value "
Add to local increment (added for testing, remove if we add a
better way from python)
";

// Documentation extracted from: (module=la, header=LinearSolver.h)
%feature("docstring")  dolfin::LinearSolver "
This class provides a general solver for linear systems Ax = b.
";

%feature("docstring")  dolfin::LinearSolver::LinearSolver "
**Overloaded versions**

* LinearSolver\ (method=\"default\", preconditioner=\"default\")

  Create linear solver

* LinearSolver\ (comm, method=\"default\", preconditioner=\"default\")

  Create linear solver
";

%feature("docstring")  dolfin::LinearSolver::set_operator "
Set the operator (matrix)
";

%feature("docstring")  dolfin::LinearSolver::set_operators "
Set the operator (matrix) and preconditioner matrix
";

%feature("docstring")  dolfin::LinearSolver::solve "
**Overloaded versions**

* solve\ (A, x, b)

  Solve linear system Ax = b

* solve\ (x, b)

  Solve linear system Ax = b
";

%feature("docstring")  dolfin::LinearSolver::default_parameters "
Default parameter values
";

%feature("docstring")  dolfin::LinearSolver::update_parameters "
Update solver parameters (pass parameters down to wrapped
implementation)
";

%feature("docstring")  dolfin::LinearSolver::parameter_type "
Return parameter type: \"krylov_solver\" or \"lu_solver\"
";

// Documentation extracted from: (module=la, header=KrylovSolver.h)
%feature("docstring")  dolfin::KrylovSolver "
This class defines an interface for a Krylov solver. The
appropriate solver is chosen on the basis of the matrix/vector
type.
";

%feature("docstring")  dolfin::KrylovSolver::KrylovSolver "
**Overloaded versions**

* KrylovSolver\ (comm, method=\"default\", preconditioner=\"default\")

  Constructor

* KrylovSolver\ (method=\"default\", preconditioner=\"default\")

  Constructor

* KrylovSolver\ (comm, A, method=\"default\", preconditioner=\"default\")

  Constructor

* KrylovSolver\ (A, method=\"default\", preconditioner=\"default\")

  Constructor
";

%feature("docstring")  dolfin::KrylovSolver::set_operator "
Set operator (matrix)
";

%feature("docstring")  dolfin::KrylovSolver::set_operators "
Set operator (matrix) and preconditioner matrix
";

%feature("docstring")  dolfin::KrylovSolver::solve "
**Overloaded versions**

* solve\ (x, b)

  Solve linear system Ax = b

* solve\ (A, x, b)

  Solve linear system Ax = b
";

%feature("docstring")  dolfin::KrylovSolver::default_parameters "
Default parameter values
";

%feature("docstring")  dolfin::KrylovSolver::update_parameters "
Update solver parameters (pass parameters down to wrapped implementation)
";

%feature("docstring")  dolfin::KrylovSolver::parameter_type "
Return parameter type: \"krylov_solver\" or \"lu_solver\"
";

// Documentation extracted from: (module=la, header=LUSolver.h)
%feature("docstring")  dolfin::LUSolver "
LU solver for the built-in LA backends.
";

%feature("docstring")  dolfin::LUSolver::LUSolver "
**Overloaded versions**

* LUSolver\ (comm, \"default\")

  Constructor

* LUSolver\ (\"default\")

  Constructor

* LUSolver\ (comm, A, method=\"default\")

  Constructor

* LUSolver\ (A, method=\"default\")

  Constructor
";

%feature("docstring")  dolfin::LUSolver::set_operator "
Set operator (matrix)
";

%feature("docstring")  dolfin::LUSolver::solve "
**Overloaded versions**

* solve\ (x, b)

  Solve linear system Ax = b

* solve\ (A, x, b)

  Solve linear system
";

%feature("docstring")  dolfin::LUSolver::solve_transpose "
**Overloaded versions**

* solve_transpose\ (x, b)

  Solve linear system A^Tx = b

* solve_transpose\ (A, x, b)

  Solve linear system
";

%feature("docstring")  dolfin::LUSolver::default_parameters "
Default parameter values
";

%feature("docstring")  dolfin::LUSolver::update_parameters "
Update solver parameters (pass parameters down to wrapped
implementation)
";

// Documentation extracted from: (module=la, header=solve.h)
%feature("docstring")  dolfin::solve "
Solve linear system Ax = b
";

%feature("docstring")  dolfin::list_linear_algebra_backends "
List available linear algebra backends
";

%feature("docstring")  dolfin::list_linear_solver_methods "
List available solver methods for current linear algebra backend
";

%feature("docstring")  dolfin::list_lu_solver_methods "
List available LU methods for current linear algebra backend
";

%feature("docstring")  dolfin::list_krylov_solver_methods "
List available Krylov methods for current linear algebra backend
";

%feature("docstring")  dolfin::list_krylov_solver_preconditioners "
List available preconditioners for current linear algebra
backend
";

%feature("docstring")  dolfin::has_lu_solver_method "
Return true if LU method for the current linear algebra backend is
available
";

%feature("docstring")  dolfin::has_krylov_solver_method "
Return true if Krylov method for the current linear algebra
backend is available
";

%feature("docstring")  dolfin::has_krylov_solver_preconditioner "
Return true if Preconditioner for the current linear algebra
backend is available
";

%feature("docstring")  dolfin::linear_algebra_backends "
Return available linear algebra backends
";

%feature("docstring")  dolfin::linear_solver_methods "
Return a list of available solver methods for current linear
algebra backend
";

%feature("docstring")  dolfin::lu_solver_methods "
Return a list of available LU methods for current linear algebra
backend
";

%feature("docstring")  dolfin::krylov_solver_methods "
Return a list of available Krylov methods for current linear
algebra backend
";

%feature("docstring")  dolfin::krylov_solver_preconditioners "
Return a list of available preconditioners for current linear
algebra backend
";

%feature("docstring")  dolfin::residual "
Compute residual ||Ax - b||
";

%feature("docstring")  dolfin::norm "
Compute norm of vector. Valid norm types are \"l2\", \"l1\" and
\"linf\".
";

%feature("docstring")  dolfin::normalize "
Normalize vector according to given normalization type
";

// Documentation extracted from: (module=la, header=test_nullspace.h)
%feature("docstring")  dolfin::in_nullspace "
Check whether a vector space basis is in the nullspace of a
given operator. The string option 'type' can be \"right\" for the
right nullspace (Ax=0) or \"left\" for the left nullspace (A^Tx =
0). To test the left nullspace, A must also be of type
GenericMatrix.
";

// Documentation extracted from: (module=la, header=BlockVector.h)
%feature("docstring")  dolfin::BlockVector::BlockVector "
Constructor
";

%feature("docstring")  dolfin::BlockVector::copy "
Return copy of tensor
";

%feature("docstring")  dolfin::BlockVector::set_block "
Set function
";

%feature("docstring")  dolfin::BlockVector::get_block "
**Overloaded versions**

* get_block\ (i)

  Get sub-vector (const)

* get_block\ ()

  Get sub-vector (non-const)
";

%feature("docstring")  dolfin::BlockVector::axpy "
Add multiple of given vector (AXPY operation)
";

%feature("docstring")  dolfin::BlockVector::inner "
Return inner product with given vector
";

%feature("docstring")  dolfin::BlockVector::norm "
Return norm of vector
";

%feature("docstring")  dolfin::BlockVector::min "
Return minimum value of vector
";

%feature("docstring")  dolfin::BlockVector::max "
Return maximum value of vector
";

%feature("docstring")  dolfin::BlockVector::operator*= "
Multiply vector by given number
";

%feature("docstring")  dolfin::BlockVector::operator/= "
Divide vector by given number
";

%feature("docstring")  dolfin::BlockVector::operator+= "
Add given vector
";

%feature("docstring")  dolfin::BlockVector::operator-= "
Subtract given vector
";

%feature("docstring")  dolfin::BlockVector::operator= "
**Overloaded versions**

* operator=\ (x)

  Assignment operator

* operator=\ (a)

  Assignment operator
";

%feature("docstring")  dolfin::BlockVector::empty "
Return true if empty
";

%feature("docstring")  dolfin::BlockVector::size "
Number of vectors
";

%feature("docstring")  dolfin::BlockVector::str "
Return informal string representation (pretty-print)
";

// Documentation extracted from: (module=la, header=BlockMatrix.h)
%feature("docstring")  dolfin::BlockMatrix::set_block "
Set block
";

%feature("docstring")  dolfin::BlockMatrix::get_block "
**Overloaded versions**

* get_block\ (i, j)

  Get block (const version)

* get_block\ (i, j)

  Get block
";

%feature("docstring")  dolfin::BlockMatrix::size "
Return size of given dimension
";

%feature("docstring")  dolfin::BlockMatrix::zero "
Set all entries to zero and keep any sparse structure
";

%feature("docstring")  dolfin::BlockMatrix::apply "
Finalize assembly of tensor
";

%feature("docstring")  dolfin::BlockMatrix::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::BlockMatrix::mult "
Matrix-vector product, y = Ax
";

%feature("docstring")  dolfin::BlockMatrix::schur_approximation "
Create a crude explicit Schur approximation  of S = D - C A^-1
B of  (A B; C  D) If symmetry !=  0, then the  caller promises
that B = symmetry * transpose(C).
";

// Documentation extracted from: (module=la, header=LinearOperator.h)
%feature("docstring")  dolfin::LinearOperator "
This class defines an interface for linear operators defined
only in terms of their action (matrix-vector product) and can be
used for matrix-free solution of linear systems. The linear
algebra backend is decided at run-time based on the present
value of the \"linear_algebra_backend\" parameter.

To define a linear operator, users need to inherit from this
class and overload the function mult(x, y) which defines the
action of the matrix on the vector x as y = Ax.
";

%feature("docstring")  dolfin::LinearOperator::LinearOperator "
Create linear operator
";

%feature("docstring")  dolfin::LinearOperator::size "
Return size of given dimension
";

%feature("docstring")  dolfin::LinearOperator::mult "
Compute matrix-vector product y = Ax
";

%feature("docstring")  dolfin::LinearOperator::mpi_comm "
Return the MPI communicator
";

%feature("docstring")  dolfin::LinearOperator::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::LinearOperator::instance "
**Overloaded versions**

* instance\ ()

  Return concrete instance / unwrap (const version)

* instance\ ()

  Return concrete instance / unwrap (non-const version)
";

%feature("docstring")  dolfin::LinearOperator::shared_instance "
**Overloaded versions**

* shared_instance\ ()

  Return concrete instance / unwrap (const shared pointer version)

* shared_instance\ ()

  Return concrete instance / unwrap (shared pointer version)
";

