/*
 * Copyright (C) 2004-2005 by CERN/IT/GD/CT & CNRS/IN2P3/LAL
 * All rights reserved
 */

// $Id: srm2_testPut.c,v 1.14 2006/01/27 09:37:00 grodid Exp $

//Humm...#include "u64subr.h"
#include "srmv2H.h"
#include "srmSoapBinding.nsmap"
#define DEFPOLLINT 10

#define SRM_EP_PATH "/v2_1_1/srm"
#ifdef GFAL_SECURE
#include "cgsi_plugin.h"
#endif

#include "parsesurl.ic"
#include "soapcallns1.ic"

main(argc, argv)
int argc;
char **argv;
{
	int flags;
	int i;
	int nbfiles;
	int nbproto = 0;
	static char *protocols[] = {
#if GFAL_ENABLE_RFIO
		"rfio",
#endif
#if GFAL_ENABLE_DCAP
		"gsidcap",
#endif
		""
	};
	int r = 0;

	//OLD enum ns1__TRequestType f_type; // = 0;
	enum ns1__TStorageType {Volatile=0, Durable=1, Permanent=2};
	static enum ns1__TStorageType ftypes[] = {Volatile, Durable, Permanent};

	//struct ns1__TSizeInBytes f_size;
	//struct ns1__TLifeTimeInSeconds f_lifet;
	char *r_token;
	struct ns1__srmPrepareToPutResponse_ rep;
	struct ns1__ArrayOfTPutRequestFileStatus *repfs;
	struct ns1__srmPrepareToPutRequest req;
	struct ns1__TPutFileRequest *reqfilep;
	struct ns1__TReturnStatus *reqstatp;
	char *sfn;
	struct soap soap;
	struct ns1__srmStatusOfPutRequestResponse_ srep;
	struct ns1__srmStatusOfPutRequestRequest sreq;
	char *srm_endpoint;

	struct ns1__TSURL *sreqfilep;

	char *special_token = "049672c4-0f64-471b-a393-c8fbeac9101c";

	//userRequestDescription
	//char *u_token;
	enum ns1__TOverwriteMode iovw;

	char *ct;

	// Below, overW is overwriteOption flag, (0|1|2) or (Never|Always|WhenFilesAreDifferent)
	if (argc < 8) {
		fprintf (stderr, "usage: %s u_token nbSURLs overW SURL1 life1 type1 size1 [SURL2 life2 type2 size2] [ ... ] \n", argv[0]);
		exit (1);
	}
	//nbfiles = argc - 3;
	nbfiles = atoi(argv[2]);
	if (argc < (4+nbfiles*4)) {
		fprintf (stderr, "usage: %s u_token nbSURLs overW SURL1 life1 type1 size1 [SURL2 life2 type2 size2] [ ... ] \n", argv[0]);
		exit (1);
	}

	if (parsesurl (argv[4], &srm_endpoint, &sfn) < 0) {
		perror ("parsesurl");
		exit (1);
	}

	while (*protocols[nbproto]) nbproto++;

	soap_init (&soap);
#ifdef GFAL_SECURE
	flags = CGSI_OPT_DISABLE_NAME_CHECK;
	soap_register_plugin_arg (&soap, client_cgsi_plugin, &flags);
#endif

	if ( (ct = getenv ("CRASH_TEST")) )
	//ct = getenv ("CRASH_TEST");
	  printf ( " CRASH_TEST value: %s \n", ct);
	else
	  ct = NULL;
	  //ct = strdup(" ");

	memset (&req, 0, sizeof(req));
	if ((req.arrayOfFileRequests =
		soap_malloc (&soap, sizeof(struct ns1__ArrayOfTPutFileRequest))) == NULL ||
	    (req.arrayOfFileRequests->putRequestArray =
		soap_malloc (&soap, nbfiles * sizeof(struct ns1__TPutFileRequest *))) == NULL ||
	    (req.arrayOfTransferProtocols =
		soap_malloc (&soap, sizeof(struct ns1__ArrayOf_USCORExsd_USCOREstring))) == NULL) {
		perror ("malloc");
		soap_end (&soap);
		exit (1);
	}

	for (i = 0; i < nbfiles; i++) {
		if ((req.arrayOfFileRequests->putRequestArray[i] =
		    soap_malloc (&soap, sizeof(struct ns1__TPutFileRequest))) == NULL) {
			perror ("malloc");
			soap_end (&soap);
			exit (1);
		}
	}
	req.arrayOfFileRequests->__sizeputRequestArray = nbfiles;
	req.arrayOfTransferProtocols->stringArray = protocols;
	req.arrayOfTransferProtocols->__sizestringArray = nbproto;
	if ( strcmp(argv[1], "-") )
	  req.userRequestDescription = argv[1];
	iovw = (enum ns1__TOverwriteMode) atoi(argv[3]);
	req.overwriteOption = &iovw; 

	for (i = 0; i < nbfiles; i++) {
		reqfilep = req.arrayOfFileRequests->putRequestArray[i];
		memset (reqfilep, 0, sizeof(*reqfilep));
		if ((reqfilep->toSURLInfo =
		    soap_malloc (&soap, sizeof(struct ns1__TSURLInfo))) == NULL ||
		    (reqfilep->toSURLInfo->SURLOrStFN =
		    soap_malloc (&soap, sizeof(struct ns1__TSURL))) == NULL) {
			perror ("malloc");
			soap_end (&soap);
			exit (1);
		}
		reqfilep->toSURLInfo->SURLOrStFN->value = argv[i*4+4];
		reqfilep->toSURLInfo->storageSystemInfo = NULL;

	if ((reqfilep->lifetime =
		soap_malloc (&soap, sizeof(struct ns1__TLifeTimeInSeconds))) == NULL) {
		perror ("malloc");
		soap_end (&soap);
		exit (1);
	}
		//f_lifet = (ns1__TLifeTimeInSeconds) atoi(argv[i*4+4]);
		//f_lifet = atoul(argv[i*4+4]);
		reqfilep->lifetime->value = atol(argv[i*4+5]);

		/* OLD
		f_type = (enum ns1__TRequestType) atoi(argv[i*4+5]);
		reqfilep->fileStorageType = &f_type;
		*/
		reqfilep->fileStorageType = &ftypes[atoi(argv[i*4+6])];

	if ((reqfilep->knownSizeOfThisFile =
		soap_malloc (&soap, sizeof(struct ns1__TSizeInBytes))) == NULL) {
		perror ("malloc");
		soap_end (&soap);
		exit (1);
	}
	        //f_size = (ns1__TSizeInBytes) atoul(argv[i*4+6]);
	//2Gb		reqfilep->knownSizeOfThisFile->value = atol(argv[i*4+7]);
	//Humm...		reqfilep->knownSizeOfThisFile->value = strtou64(argv[i*4+7]);
		reqfilep->knownSizeOfThisFile->value = atoll(argv[i*4+7]);
	}

	// Special for tests ...
	////memset (&req, 0, sizeof(req));             //  CRASHes as well
	// Special for tests ...

	//req.arrayOfFileRequests->putRequestArray = 0;          //  Diag: Too many errors, NO CRASH0
	//req.arrayOfFileRequests->putRequestArray[0] = 0;       //  CRASH1
	//req.arrayOfFileRequests = 0;                 //  CRASH2
	//req.arrayOfTransferProtocols->stringArray = 0;     //  CRASH3
	//req.arrayOfTransferProtocols->stringArray[0] = 0;  //  CRASH4
	// If '&req' replaced with 0 below ==>             CRASH5
	//req.arrayOfTransferProtocols = 0;            //  CRASH6

	if ( ct ) {
	switch (ct[0]) {
	case 'a':
	  printf (" Case a \n");
	  req.arrayOfFileRequests->putRequestArray[0] = NULL;
	  //req.arrayOfFileRequests->putRequestArray = NULL;
	  break;
	case 'b':
	  printf (" Case b \n");
	  req.arrayOfFileRequests = NULL;
	  break;
	case 'c':
	  printf (" Case c \n");
	  req.arrayOfTransferProtocols->stringArray = NULL;
	  break;
	case 'd':
	  printf (" Case d \n");
	  req.arrayOfTransferProtocols->stringArray[0] = NULL;
	  break;
	case 'f':
	  printf (" Case f \n");
	  req.arrayOfTransferProtocols = NULL;
	  break;
	case 'g':
	  /* Weird, this one does not crash ... */
	  printf (" Case g \n");
	  memset (&req, 0, sizeof(req));
	  break;
	default:
	  printf (" NO Action1 Case >%c< \n", ct[0]);
	  break;
	}
	}

#if 1

	//if ( ct[0] == 'e' )	  
	if ( ct && ! strncmp(ct, "e", 1) ) {  
	  printf (" Case e \n");
	  /* normal test */
	  if (soap_call_ns1__srmPrepareToPut (&soap, srm_endpoint, "PrepareToPut",
	    0, &rep)) {
		soap_print_fault (&soap, stderr);
		soap_print_fault_location (&soap, stderr);
		soap_end (&soap);
		exit (1);
	}
	  /* special JPB value */
	  /*
	  if (soap_call_ns1__srmPrepareToPut (&soap, srm_endpoint, "PrepareToPut",
	    &req, 0)) {
		soap_print_fault (&soap, stderr);
		soap_print_fault_location (&soap, stderr);
		soap_end (&soap);
		exit (1);
	}
	  */
	}
	else
	  if (soap_call_ns1__srmPrepareToPut (&soap, srm_endpoint, "PrepareToPut",
	    &req, &rep)) {
		soap_print_fault (&soap, stderr);
		soap_print_fault_location (&soap, stderr);
		soap_end (&soap);
		exit (1);
	}
#else
	SOAP_CALL_NS1(PrepareToPut);
#endif

	reqstatp = rep.srmPrepareToPutResponse->returnStatus;
	repfs = rep.srmPrepareToPutResponse->arrayOfFileStatuses;
	if (rep.srmPrepareToPutResponse->requestToken) {
		r_token = rep.srmPrepareToPutResponse->requestToken->value;
		printf ("soap_call_ns1__srmPrepareToPut returned r_token %s\n",
		    r_token);
		printf("request state 00 %d\n", reqstatp->statusCode);
	}

	memset (&sreq, 0, sizeof(sreq));
	if ((sreq.arrayOfToSURLs =
		soap_malloc (&soap, sizeof(struct ns1__ArrayOfTSURL))) == NULL ||
	    (sreq.arrayOfToSURLs->surlArray =
		soap_malloc (&soap, nbfiles * sizeof(struct ns1__TSURL*))) == NULL) {
		perror ("malloc");
		soap_end (&soap);
		exit (1);
	}

	for (i = 0; i < nbfiles; i++) {
		if ((sreq.arrayOfToSURLs->surlArray[i] =
		    soap_malloc (&soap, sizeof(struct ns1__TSURL))) == NULL) {
			perror ("malloc");
			soap_end (&soap);
			exit (1);
		}
	}
	sreq.arrayOfToSURLs->__sizesurlArray = nbfiles;

	for (i = 0; i < nbfiles; i++) {
		sreqfilep = sreq.arrayOfToSURLs->surlArray[i];
		reqfilep = req.arrayOfFileRequests->putRequestArray[i];
		sreqfilep->value = reqfilep->toSURLInfo->SURLOrStFN->value;
		/* GG special tests */
		/*
		if ( i == 0 )
		  //GOODsreq.arrayOfToSURLs = NULL;
		  //GOODsreq.arrayOfToSURLs->surlArray[i] = NULL;
		  //CRASHsreqfilep->value = NULL;
		  */
	}

	/* GG special tests */
	//GOODsreq.requestToken = NULL;
	/* Good token = 049672c4-0f64-471b-a393-c8fbeac9101c */
	//BADstrcpy(sreq.requestToken, special_token);
	//BADsreq.requestToken = strdup(special_token);
	//GOODstrcat(rep.srmPrepareToPutResponse->requestToken->value, "uu");
	//CRASHrep.srmPrepareToPutResponse->requestToken->value = NULL;
	//GOODstrcpy(rep.srmPrepareToPutResponse->requestToken->value, r_token);
	//GOODstrcpy(rep.srmPrepareToPutResponse->requestToken->value, strfry(r_token));

	//sreq.requestToken = rep.srmPrepareToPutResponse->requestToken;

	if (ct) {
	switch (ct[0]) {
	case 'h':
	  printf (" Case h \n");
	  sreq.requestToken = NULL;
	  break;
	case 'i':
	  printf (" Case i \n");
	  strcat(rep.srmPrepareToPutResponse->requestToken->value, "uu");
	  sreq.requestToken = rep.srmPrepareToPutResponse->requestToken;
	  break;
	case 'j':
	  printf (" Case j \n");
	  rep.srmPrepareToPutResponse->requestToken->value = NULL;
	  sreq.requestToken = rep.srmPrepareToPutResponse->requestToken;
	  break;
	case 'k':
	  printf (" Case k \n");
	  /* in fact the standard case ... for double-checking ... */
	  strcpy(rep.srmPrepareToPutResponse->requestToken->value, r_token);
	  sreq.requestToken = rep.srmPrepareToPutResponse->requestToken;
	  break;
	case 'l':
	  printf (" Case l \n");
	  strcpy(rep.srmPrepareToPutResponse->requestToken->value, strfry(r_token));
	  sreq.requestToken = rep.srmPrepareToPutResponse->requestToken;
	  break;
#if 0
	case 'i':
	  printf (" Case i \n");
	  sreq.requestToken = rep.srmPrepareToPutResponse->requestToken;
	  break;
	case 'i':
	  printf (" Case i \n");
	  sreq.requestToken = rep.srmPrepareToPutResponse->requestToken;
	  break;
#endif
	default:
	  printf (" NO Action2 Case >%c< \n", ct[0]);
	  sreq.requestToken = rep.srmPrepareToPutResponse->requestToken;
	  break;
	}
	} else 
	  sreq.requestToken = rep.srmPrepareToPutResponse->requestToken;

	/* wait for file "ready" */

	while (reqstatp->statusCode == SRM_USCOREREQUEST_USCOREQUEUED ||
		reqstatp->statusCode == SRM_USCOREREQUEST_USCOREINPROGRESS ||
		reqstatp->statusCode == SRM_USCOREREQUEST_USCORESUSPENDED) {
		printf("request state 0 %d\n", reqstatp->statusCode);
		sleep ((r++ == 0) ? 1 : DEFPOLLINT);

#if 1
		if (soap_call_ns1__srmStatusOfPutRequest (&soap, srm_endpoint,
		    "StatusOfPutRequest", &sreq, &srep)) {
			soap_print_fault (&soap, stderr);
			soap_end (&soap);
			exit (1);
		}
#else
	SOAP_CALL_NS1R(StatusOfPutRequest);
#endif

		reqstatp = srep.srmStatusOfPutRequestResponse->returnStatus;
		printf("request state 2 %d\n", reqstatp->statusCode);
		repfs = srep.srmStatusOfPutRequestResponse->arrayOfFileStatuses;
	}
	printf ( " After the srmStatusOfPutRequest Call ... \n");
	printf ("request state %d\n", reqstatp->statusCode);
	if (reqstatp->statusCode != SRM_USCORESUCCESS &&
	    reqstatp->statusCode != SRM_USCOREDONE) {
		if (reqstatp->explanation)
			printf ("explanation: %s\n", reqstatp->explanation);
		soap_end (&soap);
		exit (1);
	}
	if (! repfs) {
		printf ("arrayOfFileStatuses is NULL\n");
		soap_end (&soap);
		exit (1);
	}

	for (i = 0; i < repfs->__sizeputStatusArray; i++) {
		if (repfs->putStatusArray[i]->transferURL)
			printf ("state[%d] = %d, TURL = %s\n", i,
			    (repfs->putStatusArray[i])->status->statusCode,
			    (repfs->putStatusArray[i])->transferURL->value);
		else if ((repfs->putStatusArray[i])->status->explanation)
			printf ("state[%d] = %d, explanation = %s\n", i,
			    (repfs->putStatusArray[i])->status->statusCode,
			    (repfs->putStatusArray[i])->status->explanation);
		else
			printf ("state[%d] = %d\n", i,
			    (repfs->putStatusArray[i])->status->statusCode);
	}
	soap_end (&soap);
	exit (0);
}
