# wrap spawnv with error output
import os, sys

def spawnv(mode, file, args):
  ret = os.spawnv(mode,file,args)
  if ret == 127:
    print "Error: Failed to execute '"+file+"'."
    print "       The file may not exist or not be executable."
  elif ret != 0:
    print "Warning: The execution of '"+file+"' as"
    print "  '"+" ".join(args)+"'"
    print "  returned a nonzero exit code."
  return ret

class FileWithProgress:
  # FileWithProgress(f, args)
  # mimics a file (passed as f, an open file), but with progress.
  # args: ptype = 1,2 is the type ("|/-\" or numeric), default 0 (no progress)
  #       progressf = file to output progress to (defualt sys.stdout)
  #       size = size of file (or -1, the default, to ignore)
  #              for numeric output
  #       step = stepsize (default 1024)
  def __init__ (self, f, ptype=0, progressf=sys.stdout, size=-1, step=1024):
    self.f = f
    self.count = 0
    self.lastupdate = 0
    self.ptype = ptype
    self.ppos = 0
    self.progresschars = ['|','/','-','\\']
    self.progressf = progressf
    self.size=size
    self.step=step
    self.closed=0
  def __getattr__(self, name):
    return getattr(self.f, name)
  def read(self, size=-1):
    a = self.f.read(size)
    self.count = self.count + len(a)
    if (self.count-self.lastupdate)>1024:
      if self.ptype == 1:
	self.ppos = (self.ppos+1)%len(self.progresschars)
	self.progressf.write((self.lastupdate!=0)*"\b"+
			     self.progresschars[self.ppos])
	self.progressf.flush()
	self.lastupdate = self.count
      elif self.ptype == 2:
	s = str(self.count/self.step)+"k"
	if self.size >= 0:
	  s += '/'+str((self.size+self.step-1)/self.step)+'k'
	s += min(self.ppos-len(s),0)*' '
	self.progressf.write(self.ppos*"\b"+s)
	self.progressf.flush()
	self.ppos = len(s)
    return a
  def close(self):
    if not self.closed:
      self.f.close()
      if self.ptype==1:
	if self.lastupdate:
	  self.progressf.write("\b \b")
	  self.progressf.flush()
      elif self.ptype==2:
	self.progressf.write(self.ppos*"\b"+self.ppos*" "+self.ppos*"\b")
	self.progressf.flush()
  def __del__(self):
    self.close()

if __name__ == '__main__':
  import time
  for i in range(1,3):
    sys.stdout.write("Reading dput ")
    sys.stdout.flush()
    a=FileWithProgress(open('/usr/bin/dput'),ptype=i,size=os.stat('/usr/bin/dput').st_size)
    b=' '
    while b:
      b=a.read(4096)
      time.sleep(1)
    a.close()
    print
