/*
    main.c - Belegloser Datentrgeraustausch mit einer Bank
    Copyright (c) 1996,8,2001  Martin Schulze <joey@infodrom.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111, USA.

    $Id: main.c,v 1.9 2001/11/18 20:19:31 joey Exp $
 */

static char version[] = "0.5";

#include <stdio.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include "dtaus.h"

void help ()
{
  printf ("dtaus - Belegloser Datentrgeraustausch mit einer Bank\n\n");
  printf ("  -dtaus        Erzeugt eine Bankdatei\n");
  printf ("  -control      Liest eine Bankdatei und erzeugt die Kontrolldatei\n");
  printf ("\n");
  printf ("  -d <dtaus>    Bankdatei [dtaus0.txt]\n");
  printf ("  -c <control>  Steuerdatei [dtaus0.ctl]\n");
  printf ("  -b <begleit>  Begleitzettel fr die Bank dtaus0.doc]\n");
  printf ("  -o <kontroll> Kontrolldatei zum Abheften [dtaus0.sik]\n");
}

#define DTAUS   1
#define CONTROL 2

int main (int argc, char **argv)
{
  char *dtaus[60];
  char *control[60];
  char *beleg[60];
  char *check[60];
  int action = 0;
  int i = 0;
  struct stat sbuf;

  strcpy ((char *)dtaus, "dtaus0.txt");
  strcpy ((char *)control, "dtaus0.ctl");
  strcpy ((char *)beleg, "dtaus0.doc");
  strcpy ((char *)check, "dtaus0.sik");

  while (argc - i > 1) {
    i++;
    if ( !strcmp(argv[i], "-h") ) {
      help(); exit(0);
    } else if ( !strcmp(argv[i], "-v") ) {
      printf ("dtaus version %s - Copyright (c) 1997,8,2001 by Martin Schulze <joey@infodrom.org>\n", version);
      exit (0);
    } else if ( !strcmp(argv[i], "-d") ) {
      if (argc - i > 1) {
	i++;
	strcpy ((char *)dtaus, argv[i]);
      }
    } else if ( !strcmp(argv[i], "-c") ) {
      if (argc - i > 1) {
	i++;
	strcpy ((char *)control, argv[i]);
      }
    } else if ( !strcmp(argv[i], "-b") ) {
      if (argc - i > 1) {
	i++;
	strcpy ((char *)beleg, argv[i]);
      }
    } else if ( !strcmp(argv[i], "-o") ) {
      if (argc - i > 1) {
	i++;
	strcpy ((char *)check, argv[i]);
      }
    } else if ( !strcmp(argv[i], "-dtaus") ) {
      action = DTAUS;
    } else if ( !strcmp(argv[i], "-control") ) {
      action = CONTROL;
    } 
  }

  if (action == DTAUS) {
    if (!stat((char *)control, &sbuf)) {
      if (control2dtaus ((char *)control, (char *)dtaus, (char *)beleg, (char *)check) == 0)
	exit (1);
    }
    else exit (1);
  } else if (action == CONTROL) {
    if (!stat((char *)dtaus, &sbuf))
      dtaus2control ((char *)dtaus, (char *)control);
    else exit (1);
  } else {
    printf ("Keine Routine angegeben (-dtaus bzw. -control vergessen).\n");
    exit (1);
  }
  exit (0);
}
